/*
 * Decompiled with CFR 0.152.
 */
package org.simondean.vertx.async.internal;

import java.util.function.Consumer;
import org.simondean.vertx.async.DefaultAsyncResult;
import org.simondean.vertx.async.FunctionWrapper;
import org.simondean.vertx.async.ObjectWrapper;
import org.simondean.vertx.async.Retry;
import org.vertx.java.core.AsyncResultHandler;

public class RetryImpl<T>
implements Retry<T> {
    private final Consumer<AsyncResultHandler<T>> task;
    private final int times;

    public RetryImpl(Consumer<AsyncResultHandler<T>> task, int times) {
        this.task = task;
        this.times = times;
    }

    @Override
    public void run(AsyncResultHandler<T> handler) {
        ObjectWrapper<Integer> count = new ObjectWrapper<Integer>(0);
        FunctionWrapper<Runnable> visitor = new FunctionWrapper<Runnable>();
        visitor.wrap(() -> this.task.accept(result -> {
            if (result.failed()) {
                count.setObject((Integer)count.getObject() + 1);
                if ((Integer)count.getObject() > this.times) {
                    handler.handle(DefaultAsyncResult.fail(result));
                    return;
                }
                ((Runnable)visitor.f()).run();
                return;
            }
            handler.handle(DefaultAsyncResult.succeed(result.result()));
        }));
        ((Runnable)visitor.f()).run();
    }
}

