/*
 * Decompiled with CFR 0.152.
 */
package org.simondean.vertx.async.internal;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.simondean.vertx.async.DefaultAsyncResult;
import org.simondean.vertx.async.EachBuilder;
import org.simondean.vertx.async.ObjectWrapper;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Vertx;

public class EachBuilderImpl<T>
implements EachBuilder {
    private final Iterable<T> iterable;
    private final BiConsumer<T, AsyncResultHandler<Void>> each;

    public EachBuilderImpl(Iterable<T> iterable, BiConsumer<T, AsyncResultHandler<Void>> each) {
        this.iterable = iterable;
        this.each = each;
    }

    @Override
    public void run(Vertx vertx, AsyncResultHandler<Void> handler) {
        ObjectWrapper<Boolean> failed = new ObjectWrapper<Boolean>(false);
        ObjectWrapper<Integer> finishedCount = new ObjectWrapper<Integer>(0);
        ArrayList items = new ArrayList();
        for (Object item : this.iterable) {
            items.add(item);
        }
        if (items.size() == 0) {
            handler.handle(DefaultAsyncResult.succeed());
            return;
        }
        for (Object item : items) {
            vertx.runOnContext(aVoid -> this.each.accept(item, (AsyncResultHandler<Void>)((AsyncResultHandler)result -> {
                finishedCount.setObject((Integer)finishedCount.getObject() + 1);
                if (result.failed()) {
                    if (!((Boolean)failed.getObject()).booleanValue()) {
                        handler.handle(DefaultAsyncResult.fail(result));
                        failed.setObject(true);
                    }
                    return;
                }
                if (((Integer)finishedCount.getObject()).intValue() == items.size()) {
                    handler.handle(DefaultAsyncResult.succeed());
                }
            })));
            if (!failed.getObject().booleanValue()) continue;
            return;
        }
    }
}

