/*
 * Decompiled with CFR 0.152.
 */
package org.simondean.vertx.async;

import org.vertx.java.core.AsyncResult;

public class DefaultAsyncResult<T>
implements AsyncResult<T> {
    private Throwable cause;
    private T result;

    public DefaultAsyncResult(Throwable cause, T result) {
        this.cause = cause;
        this.result = result;
    }

    public static <T> AsyncResult<T> succeed(T result) {
        return new DefaultAsyncResult<T>(null, result);
    }

    public static AsyncResult<Void> succeed() {
        return DefaultAsyncResult.succeed(null);
    }

    public static <T> AsyncResult<T> fail(Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("cause argument cannot be null");
        }
        return new DefaultAsyncResult<Object>(cause, null);
    }

    public static <T> AsyncResult<T> fail(AsyncResult<?> result) {
        return DefaultAsyncResult.fail(result.cause());
    }

    public T result() {
        return this.result;
    }

    public Throwable cause() {
        return this.cause;
    }

    public boolean succeeded() {
        return this.cause == null;
    }

    public boolean failed() {
        return this.cause != null;
    }
}

