/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.simpleicons.icons;

import org.silentsoft.simpleicons.Icon;

public class ElsevierIcon
extends Icon {
    public ElsevierIcon() {
        this.setTitle("Elsevier");
        this.setSlug("elsevier");
        this.setHex("FF6C00");
        this.setSource("https://www.elsevier.com");
        this.setSvg("<svg role=\"img\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>Elsevier</title><path d=\"M6.687 11.326c.256-.137.405-.303.43-.497.042-.174-.116-.157-.153-.124-.145.116-.33.294-.509.414a1.862 1.862 0 00-.248.033c-.02-.009-.046-.042-.033-.054.161-.104.34-.207.455-.344.074-.086.041-.165-.103-.182-.162-.024-.352.042-.501.174-.253.215-.373.691-.397.993-.054.05-.07.05-.125.075a1.258 1.258 0 01.133-.98c.025-.063.008-.162-.083-.191-.054-.02-.079-.009-.103.05-.124.355-.34.508-.642.732-.029.025-.302.174-.372.215-.24-.074-.51-.521-.737-.857a.207.207 0 00-.198-.086c-.497.053-.865.016-1.13-.373-.12-.161-.174-.19-.323-.05-.165.174-.33.307-.496.447-.087.054-.15.038-.186-.074A3.132 3.132 0 011.2 9.604c0-.149.017-.372.02-.517a1.274 1.274 0 00-.314-.211C.488 8.677.004 8.214 0 8.077c0-.033.025-.116.14-.182.609-.269 1.08-.041 1.263-.07.153-.013.203-.124.178-.344a1.2 1.2 0 01.389-1.075c.207-.22.19-.464.14-.733-.024-.124-.053-.157-.178-.145-.33.075-.314.083-.376.373a1.476 1.476 0 01-.207.53c-.132.21-.31.388-.468.575-.053.074-.115.074-.194.024A1.084 1.084 0 01.26 5.66c.053-.144.132-.297.219-.376l.041.017c0 .025 0 .058-.008.082l-.1.307C.29 6.05.31 6.389.55 6.695c.079.1.15.128.19.083.154-.153.311-.298.443-.464.166-.186.211-.413.166-.65a4.121 4.121 0 00-.046-.268c-.024-.128-.078-.12-.14-.042-.15.15-.22.27-.29.547A.215.215 0 01.803 6a.29.29 0 01-.033-.145c.041-.248.099-.467.256-.629.104-.112.079-.174-.02-.203-.356-.099-.663-.198-.932-.53A.298.298 0 010 4.313c0-.07.037-.124.116-.182.314-.216.629-.439.94-.505.123-.025.19-.033.252-.042-.141-.438-.29-.964-.373-1.452 0-.1.07-.372.108-.451a.56.56 0 01.277.037c.145.05.277.14.41.224.128.074.165.074.248-.042.145-.21.31-.397.53-.509.074-.037.124-.062.173-.062.07 0 .125.042.195.15.12.194.223.417.33.62.125.211.257.223.448.087.21-.14.401-.277.596-.439.182-.14.231-.14.43-.004.178.124.372.352.468.55.02.038.434-.186.446-.285.017-.178.067-.306.133-.451.087-.178.21-.228.323-.228.103 0 .298.116.442.207l.315.182c.165.091.174.091.273-.062.112-.174.207-.207.439-.207.455 0 .869.116 1.183.493.058.074.112.082.182.012.128-.132.248-.182.488-.182h.422c.096 0 .158.008.245-.116.115-.165.248-.327.434-.327.298 0 .687.418.886.778l-.104.054a2.119 2.119 0 00-.778-.488c-.182-.075-.26 0-.236.186.025.22.083.443.137.662a.8.8 0 00.439.468l.012.074c-.033-.008-.075-.02-.124-.025a.906.906 0 00-.39.013c-.247.062-.475.17-.698.264-.112.054-.112.083-.017.174.124.116.24.249.38.352.402.302.8.24 1.242.07l.207-.07c.186-.033.385.041.538.182l.447.401c.14.137.174.257.083.427-.145.285-.307.575-.468.852a.277.277 0 01-.103.108c-.054-.042-.104-.145-.05-.236.198-.248.323-.596.364-.832.041-.232-.083-.34-.302-.281l-.186.07c-.079.029-.108 0-.124-.083-.03-.07-.067-.116-.091-.19-.05-.124-.125-.166-.228-.083a1.214 1.214 0 00-.43.414 1.568 1.568 0 00-.174.964c.004.041.037.07.062.095a.178.178 0 00.083-.082c.058-.145.095-.29.12-.447.012-.087.024-.245.053-.323.021-.042.087-.025.125-.013.095.038.132.083.144.15-.186.235-.302.587-.426.901-.02.042-.1.096-.149.096-.058-.004-.136-.054-.153-.104-.074-.198-.207-.393-.26-.592-.137-.674-.178-.711-.207-.753A4.146 4.146 0 009.095 3.34c-.033-.033-.05-.07-.074-.099.037-.017.066-.05.103-.062.128-.054.26-.104.393-.149a.616.616 0 00.356-.319c.046-.087.108-.173.157-.26.07-.124.062-.19-.029-.298a.641.641 0 00-.653-.203c-.253.062-.41.244-.489.484a.733.733 0 00-.041.27c0 .136.041.165.153.094.186-.153.393-.277.592-.41a1.093 1.093 0 01-.406.497c-.124.079-.248.145-.372.215-.104.075-.14.042-.174-.082-.029-.133-.017-.27-.017-.402a.877.877 0 00-.587-.881l-.327-.137a.314.314 0 00-.124.286c.025.36.078.62.14.927.058.124.195.173.336.198.082-.041.149-.157.037-.339l-.161-.319c-.017-.041-.038-.078-.05-.124-.004-.016-.012-.045 0-.066.02.008.041.008.083.05.207.223.372.476.48.79.041.124.004.174-.116.186-.273.025-.55.042-.815.1-.435.09-.58.248-.737.537-.066.125-.1.203-.103.278.153.012.327.004.575-.042a1.647 1.647 0 00.596-.194c.116-.137.207-.273.38-.397.05-.038.166-.05.211-.025A2.276 2.276 0 019.55 4.56c.017.05.067.1.091.14.05.059.03.08-.041.075-.1-.029-.207-.054-.298-.09-.037-.017-.066-.075-.083-.117l-.09-.256c-.05-.104-.075-.104-.179-.066-.053.02-.111.04-.198.082-.075.03-.112.042-.129-.041-.024-.124-.057-.248-.086-.36-.05-.137-.104-.166-.236-.1-.249.129-.43.32-.555.567-.116.24-.161.406-.054 1.043.025.124.125.277.24.315l1.076.33c.054 0 .087.063.021.104-.132.091-.277.17-.414.257-.07.041-.107.02-.14-.042a.844.844 0 00-.443-.405c-.07-.033-.108-.02-.137.054-.05.116-.103.285-.149.405-.025.062-.054.087-.124.042-.306-.257-.629-.27-1.005-.22-.187.025-.274.075-.228.26.103.518.554.758.94.924a.26.26 0 00.132-.104c.058-.083.041-.165-.042-.24-.149-.128-.463-.277-.62-.418-.025-.082.153-.157.248-.095.281.128.496.36.72.58.116.111.17.099.207-.063.041-.124.083-.314.12-.455.02-.074.066-.05.083-.004.029.108.062.248.062.372 0 .133-.046.249-.083.373-.025.124-.12.19-.224.165-.475-.045-.835.178-1.13.187a.894.894 0 01-.276-.075c-.104-.083.05-.09.082-.09.124 0 .31 0 .41-.055a.596.596 0 00-.128-.12c-.265-.215-.563.013-.79.129-.129.07-.137.086-.083.223.082.207.231.286.434.286.116 0 .228.016.348.012a.414.414 0 00.165-.041c.153-.058.29-.133.43-.195.174-.025.17.062.092.15l-.352.214c-.037.02-.079.033-.104.058-.05.037-.111.1-.103.124a.262.262 0 00.132.116c.166.05.331.075.489.112.256.05.364-.02.434-.273.037-.14.083-.273.149-.402.041-.082.091-.09.14-.008.175.323.357.637.543.952.033.07 0 .103-.066.095a23.741 23.741 0 01-1.2-.149c-.137-.02-.27-.108-.406-.165-.207-.096-.414-.183-.65-.174-.202.004-.318.124-.248.318.091.278.195.563.306.84.079.19.265.261.468.278.095.012.062-.054.037-.1l-.33-.716c-.042-.12-.01-.136.057-.037.182.273.372.534.538.811.1.174-.025.224-.149.228-.418-.042-.799-.186-1.2-.34-.041-.016-.1-.103-.087-.14.075-.07.166 0 .248 0 .096.016.137-.025.1-.1a.38.38 0 00-.203-.186 2.47 2.47 0 00-.596-.215c-.124-.025-.207.03-.182.14.033.146.1.274.174.423.02.041.02.1.008.14-.074-.004-.165.021-.476-.111-.31-.128-.314-.215-.314-.596 0-.083 0-.244.016-.319.033-.103.042-.124.137-.107.323.066.65.153.968.306.095.041.186.124.286.161.082.03.124 0 .111-.082a.29.29 0 00-.182-.249c-.339-.144-.678-.306-1.018-.442-.082-.034-.111-.07-.066-.158.137-.223.207-.484.15-.765 0-.02.024-.05.049-.075a.207.207 0 01.153.19c.025.24.186.406.343.568.319.33.319.33.766.223.058-.008.1-.05.149-.083-.042-.033-.083-.09-.14-.116-.084-.041-.175-.066-.266-.103-.298-.112-.385-.323-.285-.637a10.759 10.759 0 00.277-.865c.033-.137.041-.281.05-.426 0-.083.062-.083.111-.091l.65-.042c.166-.012.352-.207.418-.318l.215-.352a.451.451 0 00-.443-.066c.05-.162.116-.315.116-.468 0-.1-.025-.22-.066-.323-.041-.099-.112-.115-.194-.053-.158.132-.29.29-.34.504-.05.216-.14.609-.095.679.1-.074.232-.174.319-.199a.19.19 0 01.149.025 2.12 2.12 0 01-.48.331c-.12.054-.166-.016-.145-.132.14-.538.054-.58.008-.844a3.103 3.103 0 00-.401-.927c-.058-.075-.15-.05-.273.1-.199.24-.249.442-.352.856l-.025.082-.14.125-.063-.07c.054-.191.112-.303.112-.456a.525.525 0 00-.207-.422c-.153.1-.294.223-.33.29a.41.41 0 00.007.471c.158.278.133.555.083.882l-.041-.013a3.674 3.674 0 00-.116-.629c-.033-.132-.12-.244-.19-.36-.07-.103-.133-.327-.075-.418.083-.144.344-.219.443-.351.103-.158.054-.224.186-.364.079-.096.248-.29.372-.224.373.186.77.228 1.188.174.178-.025.215-.02.265-.199.041-.149.062-.05.21-.099.253-.083.386-.31.386-.58 0-.148.008-.301-.009-.454-.012-.133-.062-.261-.103-.381-.033-.079-.087-.062-.124-.004-.104.136-.277.405-.373.554-.053.087-.099.174-.144.265-.025.07-.058.087-.12.02a1.349 1.349 0 00-.22-.19c-.136-.087-.149-.36-.095-.533.058.033.1.099.137.186.05.116.074.248.165.29.12.061.24-.187.224-.356a.27.27 0 00-.042-.125c-.132-.235-.434-.426-.62-.426-.216 0-.352.265-.265.517.025.067.05.116.083.178-.51.27-.646.439-.849.675-.025.029-.05.112-.025.153.096.182.058.244-.136.352-.087.05-.207.095-.298.124-.012.008-.037-.013-.062-.017a.124.124 0 01.025-.05c.124-.277.26-.541.376-.823.124-.302-.149-.583-.393-.678-.161-.063-.29-.025-.397.12-.27.322-.327.848.05 1.344.058.083.04.116-.054.125-.215.016-.43.04-.654.053a.869.869 0 00-.662.352c-.05.075-.116.091-.186.041-.17-.103-.315-.078-.493.025-.29.153-.629.273-.815.273-.029 0-.066-.024-.09-.05.016-.024.04-.061.103-.082.177-.041.322-.087.48-.132.029-.03.04-.1.057-.129-.028-.041-.09-.095-.136-.1a2.185 2.185 0 00-.451 0c-.393.038-.683.22-.931.452-.116.116-.124.236 0 .331.29.207.6.414.993.31.273-.087.443-.29.62-.488.15-.157.332-.343.505-.145.253.29.303.592.716.538.158-.016.224-.07.265-.22l.033-.177c.013-.116-.05-.174-.161-.128-.075.024-.14.066-.215.082-.042.013-.087-.004-.137-.016.004-.042.013-.1.042-.124.074-.05.165-.091.248-.129.31-.082.604-.144.91-.206a.265.265 0 01.095 0l-.029.086c-.111.257-.26.336-.463.385a.479.479 0 00-.112.199c-.128.414-.054.844.224 1.142.099.112.223.203.351.281.216.124.273.331.352.55.05.137.104.274.166.41a1.386 1.386 0 00-.418.447c-.042.042-.075.025-.1-.025l-.12-.293c-.107-.261-.29-.427-.579-.451-.103-.009-.207-.025-.306-.038-.12-.012-.199.042-.24.178-.162.497-.008.927.467 1.192-.38.095-.695.248-.89.513.021.075.137.174.286.236.373.153.753.137 1.105.017.207-.075.215-.025.253.124l.103.463c.025.112-.037.174-.14.137-.568-.166-1.242-.439-1.73-.766a2.566 2.566 0 00-.642-.19c-.074.041-.136.095-.202.083a3.629 3.629 0 01-.613-.216c-.1-.058-.103-.087.02-.103.191 0 .539.083.717.083.173-.054.173-.083.066-.158-.418-.33-.89-.252-1.357-.173-.166.033-.178.111-.083.244.604.683 1.05.678 1.787.592.48.306.96.579 1.52.757l.011.083a8.155 8.155 0 00-1.142.165c-.182.037-.219.149-.12.315.15.24.385.351.654.417a.848.848 0 00.58-.037c.223-.103.368-.29.579-.405.124-.067.33.008.455.041.19.062.372.145.567.174.77.103 1.589.174 2.305.116a3.697 3.697 0 00-.207.484c-.037.1-.004.124.1.116a.436.436 0 00.36-.207c.012-.116.012-.22.036-.335.013-.062.03-.15.07-.158.03-.004.208.025.187.075a7.213 7.213 0 01-.19.496c.066.013.136.025.206.025.29 0 .336-.041.323-.33a1.2 1.2 0 00-.037-.245c-.037-.215.008-.364.194-.463.183-.091.373-.062.555-.042a3.393 3.393 0 011.568.708c.228.182.03.434.03.778 0 .215-.042.438-.038.55.008.178.083.273.149.323.199.153.418.306.629.443.215.14.323.227.58.314a.556.556 0 00.181.013.662.662 0 00-.012-.265c-.124-.083-.298-.124-.497-.19-.037-.013-.074-.063-.095-.108a.372.372 0 01.145-.083l.323-.07a.19.19 0 00.082-.07c-.016-.03-.04-.067-.066-.071-.132-.041-.306-.07-.418-.1-.041-.012-.062-.049-.095-.086a.406.406 0 01.157-.083l.331-.041a.174.174 0 00.087-.054c-.012-.033-.029-.075-.053-.087-.07-.033-.41-.157-.447-.195-.03-.028-.038-.07-.05-.124a.317.317 0 01.157-.033l.277.004a.178.178 0 00.112-.053.248.248 0 00-.074-.087c-.133-.083-.182-.141-.331-.207-.07-.042-.104-.083-.116-.17a.461.461 0 01.186-.008c.1.025.153.058.26.074a.284.284 0 00.117-.012.116.116 0 00-.03-.083c-.04-.041-.095-.062-.144-.1-.075-.049-.203-.173-.277-.235-.025-.02-.013-.083-.017-.104l.083.005c.1.02.248.062.33.074.15.029.13.008.067-.1-.091-.082-.186-.136-.273-.231-.025-.033-.017-.087-.013-.132.141.008.286.074.414.074.013-.025.021-.041.021-.074a2.11 2.11 0 00-.103-.249c-.038-.095.012-.132.082-.103.1.041.257.124.364.149.042.012.096 0 .15-.02-.05-.1-.108-.179-.174-.278-.013-.025 0-.062.02-.091.17.05.344.166.497.207.07.029.116 0 .132-.033.013-.042-.111-.166-.103-.215.004-.033.012-.042.029-.062l.29.09c.21.054.33.075.364.025.04-.012-.005-.111-.067-.227.166-.013.187.066.48.124.112.029 1.664-.19 2.293-.385.248-.083.538-.207.77-.314l.074.016c.178.455.554.596.94.637.11.013.23.021.35.025.113 0 .137-.029.104-.14a1.986 1.986 0 00-.575-.977l-.248-.153c-.108-.112-.095-.24.02-.331.2-.133.464-.26.663-.385.29-.186.389-.472.372-.774a.257.257 0 00-.107-.202.323.323 0 00-.15.103c-.078.165-.157.302-.227.447-.054.029-.112.041-.161.062-.013-.05-.042-.1-.03-.149.088-.257.315-.463.464-.629.062-.103-.029-.145-.074-.137-.166.038-.348.1-.472.24a3.335 3.335 0 00-.654 1.354c-.029.128-.083.173-.124.293-.054.182-.05.224.108.336.227.148.525.285.74.438.087.095.042.133-.05.128a.857.857 0 01-.62-.277c-.083-.09-.153-.149-.248-.161-.224.058-.534.149-.766.182-.132.025-.236.078-.306.203-.046.103-.14.124-.248.082-.166-.045-.331-.103-.497-.14a1.862 1.862 0 00-.828.058c-.111.016-.136-.009-.103-.116.029-.137.074-.27.1-.402.003-.058.012-.144-.042-.173-.054.024-.132.037-.157.074-.087.128-.153.265-.236.406-.054.111-.075.111-.19.062a2.11 2.11 0 01-.468-.286c-.112-.178-.232-.327-.29-.48-.02-.041.042-.074.095-.074.125.099.273.223.385.33.075.083.1.166.15.274.012.025.132.02.152-.025.017-.041.038-.103.054-.19a.587.587 0 00-.136-.542c-.183-.187-.307-.224-.56-.398-.314-.215-.36-.202-.475.009a1.232 1.232 0 00-.153.579c.083.505.203.712.815 1.026a.17.17 0 01-.05.083c-.04.033-.062.054-.132.054-.215-.009-.517-.013-.753-.033-.066-.005-.108-.025-.124-.063a3.103 3.103 0 01.273-2.234.372.372 0 01.149-.161c.128-.067.33-.153.455-.207.075-.033.112-.009.145.066.054.199.074.34.09.509.01.103.013.207.055.227.099.042.186-.04.236-.124a1.1 1.1 0 00.099-1.005c-.013-.033.016-.1.054-.12.422-.17.815-.344 1.241-.51.24-.012.546.013.972.084.07.008.22.132.373.219-.195.1-.48.306-.679.496-.054.058-.124.133-.074.29.165-.008.248-.054.372-.09.19-.055.31-.084.464-.084a.828.828 0 01.124.017.228.228 0 01-.058.128c-.054.05-.14.042-.203.075-.062.041-.124.103-.083.178.03.05.112.107.17.099.199-.013.38-.037.588-.1.09-.074.438-.53.24-.57-.112-.025-.352-.042-.456-.096a.207.207 0 01.125-.14c.107.016.231.05.397.066a2.441 2.441 0 00.815-.037c.112-.042.149-.083.112-.153a1.283 1.283 0 00-.758-.663c-.149-.04-.33-.008-.484-.008l-1.332-.012c-.03 0-.062-.025-.091-.042.025-.02.05-.045.074-.058.124-.074.27-.136.393-.223a.87.87 0 00.365-.55.228.228 0 000-.129c-.125-.455-.373-.786-.89-.844l-.257-.041c-.095-.008-.132.033-.132.12 0 .161.008.248 0 .414 0 .082.041.111.137.124a3.186 3.186 0 01.703.203c.137.053.165.136 0 .277l-.372.265c-.067.041-.096.008-.104-.054-.008-.1-.008-.207-.025-.302a.207.207 0 00-.054-.095.273.273 0 00-.198.165c-.05.133-.083.257-.104.385a.406.406 0 01-.285.331c-.075.02-.14-.008-.128-.079.012-.082.029-.165.053-.248.12-.29.182-.538.158-.81a5.834 5.834 0 01-.042-.572.17.17 0 01.124-.182c.224-.087.435-.174.67-.248.08-.03.146.004.208.082l.471.555c.125.132.158.128.265-.02.1-.141.207-.27.364-.357.083-.041.083-.12-.012-.157-.178-.066-.356-.103-.542-.165-.042-.013-.087-.013-.133-.03-.029-.012-.066-.049-.066-.074 0-.025.037-.062.066-.074.34-.12.621-.232.923-.348.083-.037.124-.103.112-.19-.008-.112-.041-.207-.058-.315-.017-.099-.083-.174-.186-.186-.414-.041-.662.075-.944.364a.257.257 0 00-.066.228c.05.008.091.008.128-.004a1.69 1.69 0 00.443-.187c.075-.082.133-.165.174-.165.025 0 .07.103.083.14-.042.05-.083.1-.41.24a9.447 9.447 0 01-1.812.625c-.083.009-.079-.045-.058-.082.116-.203.248-.414.376-.63.124-.074.158-.04.112.075a2.223 2.223 0 01-.137.257c-.012.083.025.103.075.095a.695.695 0 00.513-.617c0-.103-.05-.14-.157-.136-.157.012-.331.025-.484.07-.29.075-.464.277-.559.542a2.934 2.934 0 00-.091.377c-.025.136-.14.186-.26.252-.203.124-.307.1-.48.133a2.855 2.855 0 00-.435.099c0-.05-.013-.095 0-.124.1-.157.186-.31.29-.455.144-.211.107-.331-.125-.414a.86.86 0 00-.993.347c-.124.199-.215.435-.302.65-.054.128 0 .207.137.236.21.037.463-.041.654-.095-.013.062-.017.302-.038.351l-.124.27c-.078.132-.165.177-.31.107a6.538 6.538 0 01-.65-.352c-.248-.145-.488-.248-.765-.248a.372.372 0 01-.083-.008c-.091-.02-.095-.05-.042-.108.07-.07.075-.14.034-.227l-.286-.53a1.448 1.448 0 01-.136-.31c.07-.013.33.074.33.124.021.29.108.496.261.678.116.116.224.042.236-.074.02-.153-.186-.402.083-.973.116-.256.472-.695.703-.695.124 0 .228.054.302.236.042.083.07.282.108.364.033.083.074.124.165.116.224-.029.534-.165.787-.198.161-.025.285.376.364.52.124.216.182.402.323.17.24-.33.351-.703.608-.819a1.792 1.792 0 011.043-.178c.111.013.144.054.12.166-.021.066-.025.136-.042.207-.025.078.046.107.133.041.12-.07.207-.165.29-.273.214-.232.43-.348.852-.348.198 0 .351.042.53.104.136.05.157.07.12.207l-.12.397c-.042.182-.013.207.148.298.141.083.253.14.34.248a.29.29 0 00.178-.062 2.14 2.14 0 01.765-.865c.133-.074.166-.066.22.062.111.282.173.526.194.79.149-.173.323-.36.447-.496.447-.422.89-.418 1.49-.269.148.042.033.19-.054.306l-.116.174c-.037.062-.066.066-.116.013-.075-.087-.149-.24-.224-.315-.136-.136-.376-.058-.542.042a2.222 2.222 0 00-.802.823 4.345 4.345 0 01-.704.832c-.107.041-.107.037-.083-.075a2.959 2.959 0 00.489-1.535.368.368 0 00-.286.062c-.414.232-.62 1.055-.678 1.606-.013.115-.013.207-.116.264-.174.1-.24.141-.414.22-.041.008-.066 0-.104-.004.083-.365.025-.621-.186-.965-.037-.066-.083-.099-.161-.074-.041.025-.083.058-.178.132a1.56 1.56 0 00-.488 1.196c0 .083.082.083.14.042a.624.624 0 00.158-.19c.103-.174.19-.357.29-.53.016-.042.065-.07.103-.083.02.041.02.087.012.124l-.074.331a1.034 1.034 0 01-.331.455c-.03.042-.05.116.033.124.356.017.562-.024.869-.186.322-.165.538-.302.678-.285.095.012.58.153.621.186-.025.05-.062.066-.091.1-.05.04-.286.169-.389.256-.166.136-.223.198-.19.476.016.124.037.24.066.36.012.037.041.09.066.099.041 0 .083-.033.108-.062.136-.166.264-.348.401-.513a.314.314 0 01.083-.05c0 .033.008.062 0 .083-.03.203-.133.356-.257.505l-.083.103c-.107.153-.115.178-.008.331a.73.73 0 01.104.58c-.03.144-.075.36-.104.57-.26.12-.525.29-.745.44-.14.123-.165.223-.165.252.066.082.128.095.256.148.182.058.522-.012.584-.206a.577.577 0 00.041-.211c.066.012.124.012.14.066.067.207.125.347.257.484a.682.682 0 01-.099.182c-.078.128-.145.24-.256.215-.042-.004-.087-.016-.137-.016-.083 0-.165 0-.153.149.016.19.041.277 0 .471-.025.108-.058.224-.166.22-.26-.021-.43-.211-.682-.207a.981.981 0 01-.476-.083c-.133-.07-.228-.145-.29-.182a69.39 69.39 0 00-3.1.58c-.094.02-.09.082-.107.181-.05.228-.136.451-.174.679-.008.037.042.083.067.116.024-.025.062-.042.087-.075.053-.078.09-.17.153-.248.107-.116.389.008.438.165.042.096-.09.141-.082.249.008.09.14.174.14.29 0 .103-.041.17-.058.223.39.248.484.455.497.778.012.1.012.149.066.207.054.053.14.132.178.182.182.21.348.546.472.58.062.02.219.032.339.02l.025.066a.492.492 0 01-.248.244c-.286.091-.427-.335-.58-.58a2.069 2.069 0 00-.24-.318c-.124.137-.33.687-.314.948.083.351.29.7.426.951.095.158.281.212.463.282.154.054.265.083.422.037.083-.02.112-.025.15-.054l-.005-.318c.042-.58.133-1.159.17-1.655 0-.133.1-.356.269-.472a.539.539 0 00.24-.5.393.393 0 01.041-.208c.058-.116-.053-.116-.165-.132-.124-.02-.153-.066-.091-.178.116-.195.281-.36.414-.546.082-.133.124-.228.153-.307-.033-.16-.021-.4.14-.41.526-.061.745-.016 1.08.237.021.033.025.082.025.124 0 .041.095.074.273.252.137.128.27.488.038 1.043.115.07.111.178.099.302-.008.108.025.124.124.161.124.042.19.116.294.373.09.248.36.898.517 2.49-.029.502-.116.87-.215 1.28.107.765.227 1.704.323 2.991.078 1.217.099 1.842.124 2.342.215.017.281.062.327-.12l.041-.17c.041-.12.161-.078.166-.012l.132.39c.029.11.062.181.103.289.145.198.207.025.207-.12.017-.124.017-.228.017-.34.025-.144.1-.153.153-.053l.19.45c.07.158.145.2.174.104.025-.128.03-.356.025-.538-.029-.103-.075-.215-.091-.306 0-.124.1-.1.124-.062a14.441 14.441 0 01.675.881c.124.075.198-.053.165-.103-.008-.05-.07-.112-.07-.211.016-.157.165-.087.198-.03.137.137.228.315.307.46a.29.29 0 00.124.062.238.238 0 00.037-.145c-.008-.05-.066-.165-.083-.219.058-.095.174.025.211.062.042.042.083.112.137.199.074.116.198.215.471.252.005.025.017.058.017.083-.037.025-.1.054-.265.083a3.38 3.38 0 01-1.034.02 1.2 1.2 0 00-.762.166c-.165.095-.33.083-.525.074-.373-.016-.745-.016-1.126-.024-.786-.021-1.179.136-2.069.182-.29 0-.893-.15-.893-.335 0-.129.074-.236.074-.303 0-.082-.017-.103-.091-.124-.633-.111-1.258.033-1.833.141-.488.075-.745-.004-1.002-.207a1.295 1.295 0 01-.355-.376 5.057 5.057 0 00-.99-.94c-.413-.33-.939-.93-1.266-1.345-.074-.086-.202-.509-.248-.629a1.266 1.266 0 01-.058-.546c.05-.041.112-.09.157-.095.278-.008.621-.14.634-.223.029-.062-.017-.116-.07-.1a1.61 1.61 0 01-.489 0c-.083-.012-.182-.05-.22-.09.05-.063.083-.108.137-.137a1.452 1.452 0 00.646-.249.157.157 0 00-.017-.082c-.182-.009-.323-.009-.525-.058a.468.468 0 01-.199-.116.322.322 0 01.149-.124c.232-.075.401-.186.559-.331l-.004-.091a3.157 3.157 0 01-.63-.066c-.095-.05-.103-.058.005-.174.149-.038.422-.062.57-.112.112-.058.092-.153-.02-.186a3.393 3.393 0 01-.538-.058c-.112-.1-.124-.108.02-.174l.477-.1c.182-.061.153-.177 0-.223-.145-.016-.245-.05-.39-.074-.19-.095-.186-.104-.032-.166l.302-.082c.082-.021.165-.054.182-.116a.091.091 0 00-.009-.062c-.128-.038-.389-.013-.504-.05-.042-.008-.083-.054-.108-.108l.112-.062a1.72 1.72 0 00.41-.157.36.36 0 00.045-.103.269.269 0 00-.083-.042 3.53 3.53 0 01-.385-.132c-.082-.104-.078-.124.033-.17l.216-.058a1.378 1.378 0 00-.108-.215.215.215 0 00-.074-.074c-.125-.075-.303-.15-.435-.236-.248-.153-.509-.302-.703-.497a1.614 1.614 0 01-.522-.852 1.784 1.784 0 01-.004-.63c.025-.156.112-.322.195-.47.033-.055.057-.104.024-.15a3.26 3.26 0 00-.384-.414.654.654 0 00-.245-.124c-.492-.087-.794-.186-1.018-.157a.786.786 0 00-.19.285c.042.166.124.423.128.634.182.02.398.082.621.206.178.116.22.178.29.398.153.496.194 1.13.302 1.808.095.645-.244 1.18-.898 1.204-.356.017-.646-.054-.74-.294-.117-.339-.204-.625-.315-.964a7.437 7.437 0 00-1.449.513c-.434.207-.79.406-1.25.592-.872.36-1.836.58-2.701.58-.455 0-.964-.092-1.316-.232-.315-.125-.426-.253-.497-.65a3.77 3.77 0 01-.016-1.018c.041-.331.095-.563.323-1.183.099-.274.227-.402.438-.51a2.317 2.317 0 011.142-.227c.137.008.315.029.439.083.248.09.285.29.294.538 0 .145.008.29-.005.434-.012.116-.008.162-.008.207.315.046.973.029 1.283-.041.256-.054.36-.095.828-.315.322-.145.76-.472 1.27-.736zm9.906 5.532c.03.062.1.372.1.48 0 .252-.021.484-.05.877-.042.513.012 1.035-.058 1.54-.03.248-.091.633-.07.972.004.136.024.174.103.19.248.058.414.083.538.083.38 0 .629-.174.596-.385a5.172 5.172 0 01-.178-1.423l.1-.009c.14.58.26.865.301 1.167.05.273 0 .741.054.981.637.07 1.399.008 1.63-.041.058-.522.042-1.056-.186-1.254a6.44 6.44 0 00-.505-.385 2.851 2.851 0 01-.678-.753c-.273-.43-.348-.567-.588-.985-.223-.389-.372-.724-.525-.952a1.684 1.684 0 00-.22-.29 2.926 2.926 0 00-.58-.107c-.268-.029-.446-.058-.6-.227-.131-.133-.185-.24-.107-.418.042-.096-.012-.162-.082-.24-.08-.1-.058-.207.04-.282.237-.231.456-.347.766-.43l-.05-.215c-.123.016-.26.054-.508.054-.344 0-.654-.141-.778-.592-.046-.162-.248-.617-.306-.82-.042-.124.004-.277.062-.455-.108-.132-.199-.281-.29-.405-.186-.079-.41-.157-.559-.34-.062-.074-.09-.078-.144-.04-.05.036-.062.09-.133.152-.066.058-.203.062-.33.008-.125-.05-.187-.177-.183-.302.013-.165.095-.31.02-.376-.127-.137-.247-.29-.094-.397.041-.038.136-.03.194-.058a.414.414 0 00.199-.464c-.033-.136-.108-.198-.244-.21-.195-.013-.282-.113-.282-.24 0-.166.145-.237.278-.208a.421.421 0 01.173.083c.013.062.042.149.091.14.224-.024.398-.256.398-.475 0-.075-.05-.112-.195-.079-.265.042-.596.141-.923.253-.182.062-.207.207-.107.372.033.037.058.083.082.124.042.066.025.116-.04.153l-.084.062c-.099.075-.111.158-.05.27.017.04.042.07.075.099.075.066.075.124.004.207a.314.314 0 00-.066.335c.029.095.104.633.104.736-.005.278.05.555.033.815-.013.19.082.356.264.563.2.22.344.418.613.679.318.302.492.662.521 1.105.013.207.112.281.31.389.419.116.563.351.613.67.083.567-.194 1.117-.703 1.068-.261-.025-.39-.182-.39-.319 0-.145.075-.29.195-.331.02-.008.095 0 .112 0a.248.248 0 01.012.091c0 .037-.05.058-.066.132-.012.05-.012.15.037.211.054.07.15.096.249.062.115-.037.194-.136.248-.24.236-.426.116-.93-.335-1.042-.145-.042-.352-.062-.485.016-.28.174-.52.273-.757.489a.182.182 0 00-.058.136 23.143 23.143 0 00.199 2.814c0 .203.149.455.207.488.165-.12.207-.24.352-.467.07-.042.103-.017.124.045-.004.211-.046.414-.021.596.012.054.074.103.116.14.1-.09.103-.227.145-.33.111-.116.136.012.14.045-.008.137 0 .26.013.331.004.054.054.066.1.079.12-.24.272-.455.467-.588.116-.083.19-.012.124.104a2.934 2.934 0 00-.265.699.414.414 0 00.116-.012c.025-.009.062-.017.074-.083.083-.207.129-.232.224-.083.041.14.103.24.186.281.124-.033.132-.182.182-.29.132.01.14.154.207.224.045.037.422.05.492.042l-.012-.22c-.008-.438 0-.79.029-1.225.033-.455.083-.922.108-1.324.016-.33.058-.836.082-1.229zM22.792 8.4a7.541 7.541 0 00-.625-.041c-.091 0-.34 0-.348.128 0 .037.05.103.108.14.302.207 1.146.245 1.49.187a.574.574 0 00-.03-.253c-.082-.252-.393-.475-.678-.567a2.338 2.338 0 00-.919-.033l-.058-.153c.1-.447.087-.86.025-1.187a.962.962 0 00-.182-.414c-.058-.083-.124-.079-.198-.017-.05.042-.1.096-.187.207-.285.348-.273.58-.223 1.1.033.026.07.05.165.05.091 0 .133-.04.145-.165.009-.174.05-.356.075-.517.041.012.116.062.124.09.016.27-.07.551-.137.804.017.029.215.115.186.198-.024.062-.33.14-.546.157a1.092 1.092 0 00-.509-.417c-.124-.05-.26-.091-.157-.174l.166-.066c.29-.12.194-.286.182-.567-.013-.108-.054-.137-.153-.133a.795.795 0 00-.36.083c-.216.132-.381.352-.538.53-.03.029-.091.016-.141.016.083-.26.19-.546.273-.778.029-.082.066-.165.157-.145.447.104.902.017 1.217-.297.132-.141.132-.207-.037-.327a1.051 1.051 0 00-.952-.207c-.137.054-.228.132-.248.273-.013.083.401-.033.546-.02.041.003.07.04.1.061-.266.116-.572.174-.828.248-.083.021-.116 0-.129-.082a.36.36 0 01.129-.364c.194-.166.347-.36.389-.621.024-.14-.092-.352-.154-.472-.008-.033.009-.058.013-.083a1.8 1.8 0 01.525.249 1.171 1.171 0 00.815.902c.145.05.294.103.452.149.14.041.248.004.24-.15l-.009-.206c.124-.054.265-.095.298-.091.236.033.476.149.72.227.166.083.083.141-.033.125-.182-.03-.36-.083-.534-.125-.111-.024-.202.025-.219.133.074.132.414.29.538.34.182.065.869.144.86-.042a2.425 2.425 0 00-.082-.546c-.042-.154-.174-.24-.319-.278a3.724 3.724 0 00-.918-.107.84.84 0 00-.331.107l-.038-.202c-.066-.278-.198-.344-.405-.414.012-.083.012-.137.012-.224.182-.103.406-.277.493-.422-.075-.07-.207-.107-.278-.132-.281-.1-.31-.207-.5-.29a1.241 1.241 0 00-.447-.112c-.14-.004-.331.034-.373.087-.02.038 0 .096.083.153.124.096.385.166.513.257.083.046.042.066-.012.074a1.279 1.279 0 01-.505-.144c-.095-.05-.124-.091-.194-.116-.125-.042-.145-.008-.228.136-.062.104.012.158.1.207.297.166.517.26.893.302.041.042.05.112.062.195-.372-.05-.496-.054-.728-.137-.368-.198-.662-.356-1.018-.471-.066-.03-.091-.07-.017-.116.373-.224.729-.497 1.105-.704.054-.029.14-.016.207-.004.182.033.244.091.426.145.108.041.211.07.232-.03.054-.272.14-.475.22-.59.165-.253.4-.386.711-.58.116-.393.497-.795.633-.795.373 0 .745.675.82.927.05.182-.249.34-.05.34.174 0 .335.029.335.178 0 .26-.074.525-.207.715-.14.19-.29.398-.48.526l.012.066c.323.24.675.414.675.778 0 .195-.054.331-.166.426-.086.075-.157.15-.148.261.012.252.028.393.012.641-.012.166-.517.199-.588.273a2.069 2.069 0 01-.14 1.258l.103.19c.513.36.58.688.654.969-.14.137-.373.252-.455.252-.331 0-1.064-.248-1.209-.269-.058.104-.024.2.05.406.066.186.19.314.19.488 0 .083-.012.215-.248.253a1.663 1.663 0 01-1.105-.302c-.066-.038-.124-.083-.19-.112-.112-.062-.252-.017-.29.112l-.074.248c-.042.136-.112.149-.298.112-.526-.112-.77-.679-.77-1.18.025-.103.108-.062.124-.012.033.244.141.48.22.678.099.19.223.294.43.32.041 0 .1-.08.149-.166.112-.236.215-.394.182-.67a.672.672 0 00-.112-.32c-.033-.04-.087-.07-.149-.124.03-.045.075-.095.112-.082.232.082.406.082.55.004.091-.05.133-.112.195-.19a8.19 8.19 0 01.799-.162c.372 0 .703.05.98.174zM8.628 17.479c.198 0 .438.099.434.314l-.041.108a.112.112 0 01-.05-.013c-.074-.161-.194-.252-.389-.215a.835.835 0 00-.455.257c-.079.082.083.132.182.186l.207.124c0 .108-.282.894-.14.919.355.062.827-.427.876-1.118-.012-.248.129-.372.402-.463.323-.124.476-.269.422-.62-.025-.175.074-.125.17-.27l.107-.116c.017.05.054.166.041.216-.074.285-.016.509.125.765l.264.687c.063.066.12.012.183.083.227.46.484 1.146.831 1.44.286.236.588.65.857.898.157.14.265.492.463.558.14.05.137.124.116.253-.025.157.041.186.1.186.095-.012.186-.037.285-.041.215.045.165.19.008.215-.107.012-.21-.009-.318-.009a.613.613 0 00-.112.042.226.226 0 00.058.107c.174.096.298.108.467.145.033 0 .058.025.096.037-.013.03-.05.096-.083.112a.729.729 0 01-.19 0c-.154-.033-.294-.1-.44-.165-.049-.017-.082-.07-.127-.104-.038-.016-.083-.025-.125-.037 0 .05-.016.095-.012.137.033.066.103.182.074.206-.012.021-.111.083-.14.067-.124-.058-.224-.199-.34-.265-.148-.095-.285-.095-.426.004-.145.1-.273.186-.41.265-.169.111-.351.29-.554.29-.112 0-.389-.17-.513-.208-.232-.074-.306-.082-.554-.136-.207-.05-.39.029-.6.1-.257.078-.538.111-.816.16-.157.03-.339 0-.504-.008-.249-.008-.489-.029-.733-.025-.165 0-.34.03-.496.083a.855.855 0 01-.22.033.558.558 0 01-.322-.099.472.472 0 00-.352-.066c-.116.025-.344.066-.439-.02-.116-.117-.393-.348-.55-.32-.493.083-.728.365-1.208.236-.34-.086-.563-.165-.894-.057-.083.033-.298-.017-.385-.005-.124.017-.166-.008-.15-.132l.013-.066c.021-.128-.103-.224-.227-.178-.137.041-.215.182-.344.248-.236.116-.455.083-.711-.016-.174-.075-.352-.042-.518.041-.107.058-.281.31-.397.31-.041 0-.103-.066-.124-.124v-.12a.828.828 0 01.273-.252 1.552 1.552 0 01.944-.124c.149.024.31.041.45-.017.112-.05.228-.058.332-.112.186-.099.347-.186.558-.111.153-.07.236-.12.315-.236.037-.186-.03-.38.016-.563.042-.166.112-.372.166-.53.033-.082.09-.074.145-.066.149.22.33.426.24.63-.062.14.26.24.207.38-.054.107-.03.174.078.186l.083.008c.095 0 .1-.062.095-.182.004-.678-.215-1.15-.447-1.684-.095-.207-.078-.414-.004-.62l.14-.423a.794.794 0 01.427-.447c.025-.004.095.025.112.058.302.427.413.944.264 1.457a5.45 5.45 0 00-.103.48c-.008.041.004.083.012.124.03-.025.067-.05.091-.083.15-.223.303-.442.423-.682.115-.232.306-.327.546-.373.26-.054.335-.02.269.232a5.27 5.27 0 01-.137.43.857.857 0 01-.438.534c-.15.083-.286.194-.414.29-.05.066-.062.062-.009.128.05.062.125.025.187-.013.244-.177.496-.318.744-.455.092-.041.12-.008.112.1-.012.124-.029.293-.153.339-.136.045-.319.066-.439.124A.828.828 0 004.88 21c-.083.124-.083.207-.15.34-.012.028 0 .078.005.123.041-.016.083-.016.111-.033.162-.116.249-.248.41-.372.124-.095.153-.083.203.07.016.05.054.091.103.137.05-.033.104-.062.141-.112.145-.215.236-.645.426-.93.033 0 .075.024.1.036.04.095-.013.422-.005.493.005.198.067.24.249.149.14-.07.269-.145.405-.22.15-.074.27-.016.182.1-.045.07-.116.124-.157.198-.025.042-.02.112-.025.166.042 0 .1.008.14-.013.113-.029.216-.078.324-.124.144-.066.293-.045.455 0 .153.054.31.091.455.133.12.029.252-.025.36-.075a3.84 3.84 0 01.654-.252 2.11 2.11 0 00.815-.468c.054-.058.137-.087.199-.145.05-.041.09-.235.095-.298.041-.165-.025-.554.008-.728.02-.041.054-.132.083-.178l.07.02c.02.063.05.158.05.208-.013.298-.017.96-.05 1.25 0 .066-.116.173-.182.198-.521.19-1.047.39-1.572.538-.236.066-.497.029-.745.033-.199 0-.393-.029-.588-.016-.153.012-.372.153-.53.178-.43.066-.802.037-1.228.115-.393.075-.77.182-1.147.286a.697.697 0 00-.235.116c-.03.025-.038.07-.05.1.041.02.083.049.124.04.095-.008.174.021.273.009.232-.037.464-.062.704-.083a.32.32 0 01.161.066.444.444 0 00.364.075c.14-.033.265.004.39.095.214.174.268.182.516.041.19-.103.402-.103.613-.09.471.024.91.094 1.336.173a.91.91 0 00.878-.34 5.94 5.94 0 00.33-.45c.08-.104.166-.174.29-.174.265-.004.538-.066.799-.05.149.013.22.15.22.236-.01.087-.042.14-.146.137a9.13 9.13 0 01-.596-.05c-.206-.017-.372.041-.496.199-.066.074-.05.124.05.149.041.004.095.024.14.029.108.012.158.062.186.16.021.063.15.125.365.137.277.017.422.017.662-.062.099-.033.165-.149.236-.235.157-.228.264-.286.546-.228.198.037.33-.174.509-.161.327.04-.042-.617-.249-.832-.285-.211-.513-.63-.76-.94-.183-.227-.402-.314-.56-.591-.302-.5-.55-1.113-.885-1.515-.132-.136-.418-.041-.559.033a.393.393 0 00-.165.116c.405.344.422.82.281 1.171-.041.112-.083.108-.198.062a4.264 4.264 0 01-.32-.128c-.07-.037-.131-.02-.206.025-.306.186-.683.439-.745.376-.124-.124-.323-.496-.31-.686a.764.764 0 01.12-.377 3.103 3.103 0 01-.397-.257l-.005-.136c.257-.248.605-.488.874-.488zm-7.747-3.6c.033.244.137.442.373.533.34.141.786.224 1.167.228.45.012.943-.025 1.473-.124a9.6 9.6 0 002.383-.832 6.596 6.596 0 011.449-.55 3.277 3.277 0 011.6-.042c.237.054.286.054.253-.115-.016-.112-.05-.224-.066-.34-.058-.397-.041-.77-.19-1.109a.46.46 0 00-.22-.202 1.308 1.308 0 00-.38-.116 2.69 2.69 0 00-.803 0 4.03 4.03 0 00-1.208.372c-.414.203-.828.43-1.138.617a3.269 3.269 0 01-1.68.484c-.393 0-.654-.013-1.047-.054a3.74 3.74 0 01-1.544-.426c-.107-.054-.165-.037-.206.074a3.463 3.463 0 00-.207 1.597zm18.41 4.344c-.137.021-.422.058-.588.067a.786.786 0 01-.16-.021c.024-.05.04-.066.07-.079.202-.103.417-.198.566-.314.083-.062.066-.124.042-.178-.278.124-.538.178-.832.228-.02 0-.033-.021-.041-.034.227-.17.53-.306.695-.455.111-.09.029-.116-.009-.153-.24.083-.48.162-.732.232a.29.29 0 01-.116-.013c0-.05.05-.07.091-.095a3.86 3.86 0 00.704-.463l-.013-.062-.083-.009c-.194.034-.624.096-.86.12-.116 0-.095-.066-.075-.082.187-.083.331-.182.468-.327.05-.054.041-.104.025-.128-.224.103-.48.107-.63.124-.028-.038.01-.083.026-.1.182-.07.219-.128.314-.19.062-.041.195-.132.224-.182.012-.017.008-.066-.005-.083a2.897 2.897 0 01-.55.133.277.277 0 01-.1-.017c.017-.041.026-.074.05-.087.257-.132.394-.186.576-.298a.446.446 0 00.124-.161l-.017-.025c-.207.066-.418.137-.633.194-.041-.008-.062-.033-.1-.062a.252.252 0 01.075-.074 3.38 3.38 0 001.171-.675.922.922 0 00.224-.252l-.03-.05c-.413.29-.814.542-1.29.729-.095-.009-.075-.067-.042-.091.042-.042.166-.182.265-.315a3.737 3.737 0 001.084-.625c.025-.025.038-.095.021-.14-.211.095-.534.277-.815.38l-.054-.016a.564.564 0 01.066-.145c.19-.124.464-.319.679-.555.008-.029.02-.066 0-.099a3.77 3.77 0 01-.559.228c-.062-.042.013-.15.02-.174.262-.215.386-.356.514-.538.025-.041.025-.079 0-.145-.145.104-.352.166-.513.228l-.046-.013c-.008-.053 0-.041.017-.082.19-.174.352-.31.468-.51.012-.02.008-.074-.013-.111-.157.054-.277.1-.447.14a.132.132 0 01-.058-.012c.009-.054 0-.066.021-.107.116-.1.232-.236.34-.398.028-.041.024-.082.003-.111-.082.02-.231.041-.306.05-.033.008-.074-.03-.095-.067l.29-.207a.248.248 0 00.05-.078c-.038-.017-.067-.038-.092-.03-.124.017-.24.03-.364.054-.273.058-.273.096-.298.174a6.054 6.054 0 01-.302.902c-.037.083-.083.162-.165.195-.116.058-.091.12-.124.231-.05.224-.083.207-.174.427a1.2 1.2 0 01-.257.413h-.062l-.02-.31c-.025-.207-.067-.161-.1-.372-.02-.186.025-.385.05-.546.02-.187.041-.51.041-.692-.016-.012-.033-.04-.058-.057a.174.174 0 00-.058.082c-.037.141-.103.364-.124.51-.045.339.025.665 0 1.009a3.848 3.848 0 00-.041 1.068c.112-.013.103-.025.26-.087.207-.083.356-.112.567-.298.15-.129.125-.381.178-.588.07-.248.166-.34.265-.38.03-.009.058.004.087.012-.058.14-.091.215-.145.364-.05.128-.1.34.042.364l.103.017c.008.024.008.062-.012.082-.133.129-.24.282-.849.456-.07.02-.223.206-.231.277-.013.095-.013.207.008.364.062.608.364 1.18.703 1.742.286.48.497.844.807 1.159.145.132.298.231.538.12.128-.062.29-.162.331-.199.02-.025.025-.066.02-.103zm-8.276-8.755c.017.24-.029.302-.335.223-.323-.1-.472-.066-.679-.302-.124-.145-.281-.145-.413-.008-.062.074-.108.149-.207.165-.017-.033-.038-.078-.025-.116a.46.46 0 01.252-.314c.095-.05.211-.083.31-.112.286-.112.427-.281.427-.616 0-.19.058-.381.058-.58 0-.14-.05-.186-.186-.14-.236.09-.456.182-.691.281a.283.283 0 00-.166.157c-.066.124-.108.248-.166.373-.053.07-.099.037-.115.008a7.545 7.545 0 00-.365-.517c-.103-.124-.103-.166.013-.253l.385-.335c.19-.178.265-.414.285-.679v-.36c-.008-.157.025-.202.182-.182a.868.868 0 01.315.091c.174.075.347.174.521.265.091.058.157.137.166.253.004.136-.083.223-.207.173a3.807 3.807 0 00-.584-.202c-.099-.025-.198.029-.215.124-.041.227.153.24.137.302-.05.161-.31.207-.348.356-.029.136-.029.223.091.198.327-.066.646-.269.898-.372.215-.091.327-.058.356.182.116.703.223 1.308.302 1.937zm5.09-2.235c.062.017.14.054.19.1.12.277.377.587.7.753a.796.796 0 00.29.082c.028-.124.082-.33.082-.558a.739.739 0 00-.22-.538 2.152 2.152 0 00-.496-.373.211.211 0 00-.244.021c-.004.041-.004.103.02.14.08.137.27.261.352.39.03.132.021.124-.087.082a2.09 2.09 0 01-.591-.517c-.095-.107-.158-.107-.224.008a2.003 2.003 0 00-.298.89.91.91 0 00.497.952c.153.066.265.05.34-.095.078-.145.132-.27.181-.43.025-.083.025-.117-.037-.191a2.735 2.735 0 00-.248-.277.36.36 0 00-.124-.1.166.166 0 00-.034.104c.005.128.025.26.03.389 0 .033-.005.083-.025.112a.252.252 0 01-.141-.166c-.083-.306-.07-.575.087-.778zm-14.3-4.506l.24.285c.098.187.152.356.202.505.041.15.103.15.199.083a.337.337 0 00.14-.29.964.964 0 00-.054-.26c-.082-.323-.024-.596.257-.799.095-.066.165-.174.128-.29-.041-.161-.078-.314-.14-.463-.025-.066-.116-.083-.178-.05-.315.166-.687.642-.402 1.039.013.025-.004.1-.025.14-.26-.26-.773-.79-.926-.777-.042.074-.075.227-.042.538.037.302.116.612.344 1.034a.765.765 0 00.194.22c.054.049.166.103.248.103a.457.457 0 00.017-.248 9.55 9.55 0 00-.248-.758zM22.7 3.919c.219-.042.397-.104.48-.137.356-.136.591-.364.67-.753.025-.103-.037-.161-.149-.19l-.232-.062c-.227-.067-.273.029-.36.248-.066.165-.136.356-.314.496-.054.046-.24-.09-.29-.124.348-.207.575-.538.745-.935.041-.074 0-.149-.079-.174a.844.844 0 00-.355-.037 1.783 1.783 0 00-1.283.956c-.017.041 0 .136.029.149.05.02.174.008.227-.013.033-.004.05-.05.07-.082.146-.257.39-.414.671-.538.083-.042.112-.013.066.083-.054.07-.558.426-.57.475-.067.145.032.166.115.166l.153-.041a.677.677 0 00.402.513zm-7.655-.042c-.009.124-.054.195-.166.153-.232-.099-.372-.351-.633-.438-.095-.033-.153.054-.166.14-.041.265-.082.501-.082.6 0 .365.194.563.389.758.057.05.057.082-.005.111l-.798.447c-.075.05-.166.062-.248 0-.08-.07-.104-.157-.08-.244.096-.401.162-.815.266-1.208.165-.62.434-.832.885-.89.162-.025.282-.025.406-.025.132 0 .19.025.207.145.016.083.02.174.02.451zm.604 2.744c0-.302-.244-.39-.348-.646-.1-.252-.19-.252-.393-.07-.232.22-.372.41-.455.724a1.738 1.738 0 00.008.869c.02.087.07.186.166.157a.166.166 0 00.12-.165c0-.257.024-.505.153-.67a.38.38 0 01.116-.112c.04.062.024.136.024.149-.037.19-.066.384-.107.575-.025.128-.025.198.041.314.075.116.137.128.186.05.236-.377.489-.919.489-1.175zM2.73 7.457a2.317 2.317 0 00-.165-.745c-.1-.236-.249-.373-.348-.373-.091 0-.302.249-.372.451-.183.51-.083.923.21 1.411.042.062.125.178.236.062.091-.103.162-.177.249-.29a.805.805 0 00.19-.516zm11.148 7.986c-.054-.426-.373-.84-.91-1.2-.112-.046-.125.029-.125.124.054.592.124 1.187.199 1.713.02.116.074.149.182.091.161-.074.314-.153.467-.24.141-.083.228-.161.187-.488zm4.87-4.842c-.083-.207-.223-.293-.43-.31-.207-.025-.381-.054-.6-.087-.125.017-.207.116-.278.282.004.033.017.074.042.082.07.025.198.05.215.062a.41.41 0 01.124.17c-.016.058-.091.12-.186.137-.124.024-.124.124-.104.252a.728.728 0 00.162.36c.083-.05.124-.07.186-.137a.281.281 0 00.083-.24c-.017-.269.132-.463.318-.641l.042.025c-.03.153-.112.265-.129.418-.04.314-.144.58-.455.79.095.124.331.033.406-.041a.947.947 0 00.281-.439l.05-.157a.124.124 0 01.041.012c.062.116-.025.352.017.522a.389.389 0 00.153-.124c.116-.274.174-.68.062-.931zm3.898-6.372c-.054 0-.27.004-.331.017-.05.012-.075.128-.05.148.062.042.1.075.15.092.194.02.28.02.504.057a.171.171 0 01.112.063c-.021.016-.042.045-.083.053-.414.05-.538.042-.828-.153-.078-.033-.107.025-.082.1.041.14.157.256.372.343.17.074.335.165.509.161.265-.008.455-.024.674-.062.116-.016.232-.082.249-.14.02-.058 0-.187-.066-.27l-.158-.157c-.248-.26-.41-.426-.778-.389-.05.005-.124.137-.194.137zm.256 2.756c0-.153-.02-.265-.062-.402a.703.703 0 00-.612-.504c-.153-.005-.228.024-.166.165.017.05.154.195.207.31.07.141.137.286.137.41a.414.414 0 01-.037.166c-.091-.05-.141-.162-.162-.216-.041-.132-.05-.21-.09-.285-.038-.066-.084-.083-.104-.083-.058 0-.083.02-.087.1a1.188 1.188 0 00.65 1.187c.115.041.144.013.182-.09a2.483 2.483 0 00.144-.754zM2.483 5.388c-.058.219-.07.364-.062.488.004.157.082.29.227.356a2.772 2.772 0 001.378.215c.017 0 .062-.03.062-.041-.012-.096-.062-.112-.149-.137-.194-.066-.716-.207-.786-.29-.054-.074-.029-.153.058-.165a.442.442 0 01.228.037c.128.062.24.145.372.22.041.024.091.07.14 0 .038-.063.075-.117-.008-.179l-.306-.24c-.265-.21-.662-.31-1.158-.264zm9.463 3.426c-.02.045-.062.09-.107.145-.05-.05-.1-.083-.125-.137a9.943 9.943 0 01-.496-1.655c-.008-.108.033-.145.124-.14.236.024.443.132.65.24.033.024.058.094.062.144.041.468-.017.993-.108 1.399zm-10.192.952l-.033-.017c.021-.281.166-.683.112-.786a.58.58 0 00-.285.029c-.1.041-.141.14-.162.306-.025.368.033.745.112 1.076.025.124.074.136.165.05.236-.216.46-.489.638-.7.124-.161.145-.314.095-.467-.042-.129-.128-.178-.224-.178-.103 0-.14.078-.165.157-.058.203-.153.347-.253.525zm19.11-.849c.186 0 .339.037.388.054.224.083.323.182.365.26a.259.259 0 01.04.15.401.401 0 01-.367-.075c-.199-.186-.489-.265-.662-.186.012.128.136.29.24.372.347.27.653.315 1.026.228.062-.025.087-.112.083-.186-.013-.24.004-.497-.224-.704-.248-.236-.604-.227-.848-.124-.042.02-.104.05-.133.083a.212.212 0 00.091.124zM12.256 2.36c.074-.017.04.016.02.082-.041.211-.165.377-.314.526-.083.074-.1.19-.042.248.108.1.232.013.315-.066.165-.186.269-.414.364-.637.116-.278.091-.621-.041-.853-.07-.099-.178-.111-.261-.037a1.436 1.436 0 00-.505.993c0 .054.004.153.041.174.19-.083.307-.29.414-.426zm5.048 10.013c.02-.016.054 0 .066.009 0 .223.054.492.083.57a.257.257 0 00.083-.057l.062-.302c.14-.426.037-.766-.141-1.155-.033-.074-.083-.082-.157-.05-.054.025-.1.063-.054.137.041.062.037.112 0 .174-.058.112-.1.232-.161.364-.025.083-.03.15-.038.248l-.062 1.531c.025.083.075.067.104.017.033-.083.058-.161.074-.248.042-.24.112-.249.124-.489.021-.248.021-.496.013-.744zM3.285 2.917a.227.227 0 01.009-.095l.256.041c.124.025.187.009.228-.086.07-.183.033-.348-.157-.385-.29-.054-.58.041-.828.099-.161.054-.199.223-.083.34.187.177.364.355.559.512a.614.614 0 00.525.125c.083-.021.154-.075.154-.15a.207.207 0 00-.062-.148.559.559 0 00-.145-.083zm-.26 11.144c-.017.082-.054.153-.19.145a1.705 1.705 0 01-.373-.054c-.132-.038-.17-.087-.178-.137a2.261 2.261 0 01.042-.82c.016-.04.157-.123.215-.156.178.02.318.05.447.082.05.03.149.178.157.199a.83.83 0 01.025.248c-.05.207-.112.385-.145.493zm13.82 7.469c.332.124.588.161.687.14a.198.198 0 00.154-.223c-.005-.091-.05-.166-.166-.199-.252-.054-.513-.09-.753-.178-.14-.041-.248-.037-.373.058-.19.145-.372.22-.608.265a.29.29 0 00-.153.054c-.066.087-.05.149.054.207.41.037.794-.042 1.158-.124zm1.362.81c.207 0 .36-.04.5-.132a1.241 1.241 0 01.6-.265c.092-.016.183-.111.19-.186 0-.103-.082-.116-.152-.14-.199-.063-.435-.054-.637-.104-.067-.012-.162-.012-.216.03-.426.43-.509.33-.711.541-.054.07-.054.157.095.195.116.029.265.053.33.062zM11.123 6.162c0-.107.19-.273.294-.256.02.008.04.02.057.041l.042.224c.012.087.041.165.087.165.215.017.467-.132.587-.318.129-.2.22-.427.327-.642.1-.236.253-.09.199.054-.137.41-.306.828-.439 1.229-.041.149-.062.157-.207.108l-.682-.245a.352.352 0 01-.265-.36zm5.238 10.213c.112.054.104.033.253-.05a.34.34 0 00.132-.24l-.041-.898c0-.029-.042-.074-.058-.074-.124 0-.273-.025-.373.029-.19.103-.351.252-.525.389-.066.066-.004.132.095.124.083-.033.178-.075.26-.12l.158-.083a.141.141 0 01-.016.075c-.15.165-.261.364-.464.471-.054.009-.041.14.037.145a.681.681 0 00.228-.108c.124-.099.178-.16.302-.264.041.062.07.111.008.165l-.33.298c-.05.05-.013.1.045.091a.652.652 0 00.236-.09c.082-.055.153-.13.227-.208.004.009.05.054.042.058a3.715 3.715 0 01-.216.29zM5.772 5.967c-.05.5-.173 1.005-.397 1.233-.182-.348-.306-.753-.43-1.109.1-.124.223-.31.277-.455.025-.07.066-.083.128-.033.15.136.278.248.422.364zm.592 7.134a.414.414 0 01-.227.285.913.913 0 01-.39.104c-.074 0-.128-.017-.14-.083-.041-.232-.095-.447-.133-.67-.004-.054.042-.125.087-.166.145-.137.331-.174.526-.186.041 0 .178.058.199.095.04.207.062.393.078.62zm-1.808-2.678c-.265.042-.497.278-.455.373.004.207.045.405.157.583.07.104.124.129.232.058a1.986 1.986 0 00.794-.81c.05-.1-.054-.13-.153-.179-.132-.062-.273-.062-.348-.025-.074.038-.103.116-.115.178-.083.302-.1.31-.19.414a.803.803 0 01.078-.592zm1.792 11.36c.016-.034.024-.059.053-.063a.623.623 0 01.178 0c.236.066.455-.103.675-.137.05-.004.103-.012.161-.004.145.004.29.009.451-.033.066-.025.153.009.228.042.252.111.496.173.74.029a3.8 3.8 0 01.394-.236c.227-.087.248.062.256.149a.215.215 0 01-.124.128c-.786.281-1.465.285-2.346.178a1.986 1.986 0 01-.666-.054zm-4.925-8.277a.455.455 0 00.104.356l.037.037-.02.067a1.862 1.862 0 01-.406-.054c-.058-.021.103-.108.116-.207.029-.203.083-.538.083-.782 0-.042-.104-.083-.104-.124a.149.149 0 01.05-.083c.29.07.33.066.389.203.058.124.111.33.198.48.017-.009.042-.017.054-.03.013-.136.008-.335.013-.426.008-.074.04-.111.12-.111.062 0 .215.004.277.016.008.013.008.025.008.042 0 .041-.05.053-.062.058-.137.05-.145.062-.207.442l-.066.439c-.008.033-.017.1-.037.145-.038.004-.104 0-.116-.033a6.296 6.296 0 00-.34-.691l-.04-.004c-.034.09-.034.177-.055.264zm9.104 2.04a.86.86 0 000-.252c-.05-.14-.112-.277-.091-.402.062-.215.107-.438.087-.662a2.789 2.789 0 01.025-.827c.074.025.132.074.149.124.02.087.04.174.04.252.03.236.01.464-.003.691-.037.447-.075.861-.062 1.3.008.066.02.153.041.215.058.136.03.277-.078.43l-.067-.029c-.05-.186-.173-.438-.227-.637-.009-.037 0-.066.05-.075.082-.016.136-.066.14-.124zm4.303-3.29c-.182-.016-.368-.177-.356-.467-.09.124-.202.248-.302.294.009.1.253.24.422.31.096.128.166.19.29.331.075-.19.166-.352.195-.455a1.469 1.469 0 00-.145-.675c-.137-.153-.352-.28-.563-.417-.103.111.029.351.286.496a.423.423 0 00.202.538zm-12.372-.442c.128-.009.265-.03.418-.05.1-.025.21-.05.215-.174.008-.111-.124-.173-.215-.198a1.97 1.97 0 00-1.304.128 1.183 1.183 0 00-.264.19c-.1.108-.08.174-.005.232a.984.984 0 00.356.166c.021-.091.042-.24.07-.331.141-.232.539-.274.816-.282.066.013.066.095.012.112-.078.062-.236.05-.277.116 0 .07.066.095.178.087zm.885 2.4c-.004-.05.054-.112.058-.145.013-.066.013-.157.013-.228.008-.178-.03-.467-.03-.641l.096-.062c.033-.012.058.008.095.041.083.083.27.29.356.369.008 0 .02-.021.025-.025v-.133a.974.974 0 00-.042-.256c-.033-.112-.111-.19-.024-.199l.339-.025c-.033.067-.058.116-.07.216-.017.136-.042.26-.046.388.017.2.058.398.075.563 0 .013-.025.03-.05.042a.31.31 0 01-.095-.062c-.166-.166-.282-.32-.497-.522a.182.182 0 00-.029.091c.042.128.095.273.182.393.054.075.067.1-.07.15a.648.648 0 01-.281.04zm6.05.037c.195-.12.273-.521.224-.716a.257.257 0 00-.067-.136c-.062-.062-.132-.042-.165.066-.037.153-.054.318-.075.463a1.448 1.448 0 00-.438-.012c-.15.02-.439.107-.439.285 0 .29.666.224.96.05zm1.167-2.003a.331.331 0 00.083.232c.298.31.707.633.968.695.232.062.426.199.567.385l.136.186c.1.124.228.207.402.232.029.008.066 0 .1 0-.026-.104-.026-.116-.1-.19-.613-.547-1.262-.973-1.895-1.416-.062-.037-.174-.111-.261-.124zm-6.397 7.035v-.009c-.062-.26-.133-.513-.199-.765-.05-.091-.14-.025-.132.012-.066.187-.133.373-.19.567a.273.273 0 000 .174c.099.273.19.542.297.815.017.037.067.062.095.083.025-.033.063-.07.07-.103zm1.084-6.489c.016.05.041.112.05.17.004.042.004.075-.009.1-.004.012-.029.008-.054-.005-.128-.058-.273-.14-.389-.062-.04.03-.024.104.03.129l.364.149c.165.062.206.136.173.33-.029.187-.165.261-.327.307-.066.016-.136.025-.227.016-.012.058.004.124-.037.15-.03.016-.038.012-.067.024a1.597 1.597 0 01-.124-.451c0-.037.013-.041.025-.054.054.017.104.091.186.17.1.033.27.062.294.033.05-.062.07-.1.07-.124 0-.042-.057-.083-.107-.104-.128-.07-.199-.095-.331-.149-.124-.05-.145-.16-.145-.264 0-.112.058-.232.236-.29.054-.02.153-.041.207-.058a.82.82 0 00.029-.186c.029-.004.083-.013.09.008zM2.665 5c-.248 0-.406-.067-.654-.042-.178.013-.352.091-.525.157-.104.05-.083.096.008.133a.483.483 0 00.24.062c.513-.041 1.088-.1 1.601-.149.03-.041.054-.074.083-.14-.195-.129-.447-.104-.683-.174zm5.892 7.659a.523.523 0 00-.12.108.323.323 0 01-.103.074l-.07-.041.111-.27c.042-.103.083-.115.182-.049l.091.074c.075.063.174.112.265.07.087-.04.041-.165-.05-.21-.132-.083-.231-.108-.393-.207-.099-.058-.14-.145-.14-.27 0-.103.07-.227.202-.24.05-.011.112-.011.182-.011.087 0 .145-.013.2-.087.04-.054.086-.087.098-.03a.756.756 0 01-.024.406c-.03-.008-.05-.008-.075-.02-.079-.125-.182-.183-.269-.17-.083.012-.124.074-.062.14.112.116.269.178.401.253.19.103.178.248.154.352a.269.269 0 01-.278.223.527.527 0 01-.302-.095zm-.376-.38c.016.318-.24.434-.422.43-.17 0-.27-.038-.327-.207-.03-.1-.062-.402-.083-.513-.033-.042-.091-.058-.178-.083-.041-.008-.045-.042-.054-.079.062-.029.174-.062.253-.074.182-.03.182-.017.21.149.026.19.054.389.092.579.062.186.26.145.26-.012 0-.15.009-.319 0-.476-.029-.038-.082-.116-.14-.17-.07-.083-.075-.108.025-.145.231-.09.248-.149.28.157.013.116.084.294.084.443zm.215 1.63l.58-.137c.152-.041.24-.207.227-.352-.017-.111-.083-.173-.199-.198a1.572 1.572 0 00-.745.103c-.02.199.05.414.137.58zM3.074 11.85a1.03 1.03 0 00-.248.037.913.913 0 01-.364.038c-.083-.009-.215-.063-.294-.083-.087.008-.174.087-.207.21-.016.125.058.212.195.237.277.062.538.111.794.111.1 0 .112-.012.116-.095.013-.157.008-.29.008-.455zm6.621-5.917a1.676 1.676 0 01-.36-.112c-.041-.012-.07-.112-.07-.165.012-.145-.025-.29 0-.443.012-.083.058-.108.136-.091.112.025.216.05.323.083.14.057.352.446.29.583-.062.124-.174.14-.315.149zm-2.387 6.782a.414.414 0 01-.116.112c-.137.09-.385.144-.555.256-.083.058-.041-.14-.05-.215l-.086-.463a.604.604 0 00-.15-.249c-.049-.058.092-.083.162-.103l.27-.083c.098-.033.123.037.094.058-.136.1-.124.145-.107.273.02.124.02.26.024.364.021.05.05.116.087.162.083-.025.174-.087.174-.112l.02-.265c.1-.124.117-.062.133-.008.042.099.062.161.1.273zm.41-2.938a7.687 7.687 0 01-.158-.55c-.012-.075.05-.116.12-.104.248.054.492.112.74.178.083.017.083.083.03.137a1.763 1.763 0 01-.555.405c-.112.062-.116.017-.178-.066zm10.72-6.563a1.82 1.82 0 00-.285-.687c-.112-.14-.248-.153-.372-.025a.96.96 0 00-.108.125c-.124.157-.112.206.075.298.28.082.442.248.645.455zM5.289 19.291a1.159 1.159 0 00-.372.331c-.083.153-.174.298-.257.447-.029.07-.078.24-.099.352l.05.05a2.069 2.069 0 00.364-.27c.21-.207.26-.401.376-.815l.021-.05zM23.524 2.276a4.63 4.63 0 00-.405-.654c-.112-.14-.166-.153-.29-.025a1.008 1.008 0 00-.112.124c-.124.153-.198.344.004.373.174.029.41 0 .522.078.103.067.194.137.24.162zM2.544 13.394c-.032.303-.024.303-.024.514 0 .115.054.115.157.124.095.004.124-.083.145-.195l.062-.418c.017-.136.025-.215-.058-.227-.153-.021-.269.074-.281.202zM4.16 7.8a1.597 1.597 0 01-.39-.137c-.206-.107-.405-.33-.372-.537.017-.096.07-.125.153-.08.158.117.29.29.406.415a.818.818 0 01.207.339zm1.551 4.916c.004.083.075.327.1.467.012.075.029.133.136.12.14-.02.19-.082.17-.194-.017-.128-.05-.257-.075-.389-.024-.124-.078-.194-.19-.19-.116.012-.153.053-.14.186zm6.15-7.808c-.088.157-.166.314-.27.45-.078.112-.202.183-.314.278-.108.029-.112.02-.075-.087.162-.265.315-.472.489-.7.124-.066.17-.012.165.059zm8.3 4.295c0 .1-.017.19-.05.285l-.025.013c-.128-.323-.438-.844-.417-.898-.009-.037.074-.058.111-.05l.141.058c.083.19.166.372.24.592zm.902-6.857c.017.004.066.017.104.05.062.05.07.107-.013.14-.194.092-.521.265-.732.344-.042.02-.087.025-.07-.05.04-.124.537-.484.711-.484zm-7.08 8.992c-.136 0-.252.108-.252.215.004.12.157.248.293.248.125 0 .211-.082.211-.207.009-.148-.099-.256-.252-.256zM3.074 21.778c-.028 0-.082.091-.128.095-.165.013-.223.03-.223.1 0 .095.05.144.128.12.248-.075.306-.067.629-.042l.112-.132c-.038-.033-.066-.075-.112-.087a1.85 1.85 0 00-.406-.054zM17.648 9.869c-.054.033-.099.066-.082.128l.04.1c.096-.017.204-.025.303-.017.132.041.356.091.497.116.033.008.074-.03.099-.062.008-.004-.017-.03-.03-.054-.19-.19-.508-.194-.827-.207zM8.532 5.686l-.339-.15c-.02-.012-.033-.074-.012-.099.074-.111.153-.215.231-.314.042-.042.075-.037.096.016l.17.422c.032.083-.005.116-.146.125zM4.08 9.844c.083-.016.124.033.112.108-.009.041-.021.058-.087.09a1.497 1.497 0 01-.753.026c-.083-.013-.137-.03-.15-.05a.157.157 0 01.096-.066zm2.375-6.641c-.025.008-.054.029-.07.016-.22-.124-.534-.29-.733-.418-.045-.066-.016-.09.046-.082.161.053.443.136.604.198.104.05.137.145.153.286zm3.373 4.833c.024.037.05.074-.021.186-.112.174-.14.352-.215.592a.645.645 0 01-.075.14c-.025.025-.062.034-.09.05-.01-.029-.026-.066-.021-.09l.223-.73c.033-.086.1-.132.199-.148zm8.081-2.442a4.014 4.014 0 01-.869-.306c-.095-.082-.079-.078.046-.082l.815.219c.157.12.124.116.008.165zm-3.364 5.181a.277.277 0 00-.124-.153c-.042-.025-.12-.012-.166.025a.857.857 0 00-.132.116c-.062.087-.025.174.074.244.083.058.174.054.228-.025.05-.062.095-.108.12-.207zM9.09 6.778c-.029.062-.037.124-.079.17-.111.132-.235.26-.355.389-.12.053-.125-.021-.112-.08.112-.206.269-.38.414-.55.016-.016.062-.028.082-.016.021.012.033.041.05.083zM4.415 5.64c-.029.02-.467-.662-.521-.803 0-.025.07-.074.107-.103a.195.195 0 01.075.066c.14.298.385.803.364.823zM4.23 8.367l-.186-.083c-.137.03-.249.091-.402.108-.161.012-.227-.021-.29-.062.026-.05.112-.1.24-.124.075-.013.402-.042.688-.017zM21.07 4.89l.48.36c.05.033.042.1.062.14l-.107-.012c-.207-.103-.422-.186-.559-.389-.116-.17.075-.149.124-.099zm-12.157.592l-.054.083c-.02-.025-.05-.05-.062-.083-.041-.083-.041-.178-.05-.265-.024-.207-.012-.319.112-.443.05-.058.091-.025.091.03.009.26-.004.421-.037.678zM5.834 4.73c.046.016.125.509.178.761a.562.562 0 010 .186c-.02.058-.041.07-.09.02-.083-.26-.125-.525-.166-.773-.017-.074-.017-.153.078-.194zM19.87 7.72c.199.112.43.31.526.427.025.024.012.09 0 .14-.033-.012-.07-.016-.095-.037-.166-.103-.319-.22-.472-.327-.02-.016-.025-.136-.041-.161a.174.174 0 01.082-.042zM10.82 3.46c.034.021.05.042.071.07a.174.174 0 01-.07.075c-.141.054-.468.054-.604-.025a.422.422 0 01-.07-.082l.094-.054a1.29 1.29 0 01.58.02zm3.725.795c.132.207.19.405.248.629 0 .012-.008.016-.008.05-.033-.021-.05-.025-.062-.042a1.159 1.159 0 01-.331-.546c-.017-.05-.009-.091.053-.128a.224.224 0 01.1.037zM11.97 18.418c.157-.091.203-.161.343-.248.058-.033.05-.042.021-.096-.033-.062-.062-.062-.145-.04-.153.053-.215.09-.372.152-.066.025-.091.054-.02.104zM7.126 3.745c.19-.133.397-.203.608-.282.033-.008.083.005.12.038l-.075.066c-.165.116-.33.207-.488.302a.983.983 0 01-.165-.029.124.124 0 010-.095zM2.18 7.8c-.046-.223-.108-.497-.07-.695a.285.285 0 01.086-.124c.042.037.083.066.087.103.042.232-.025.497-.041.712zm10.77-4.994a3.53 3.53 0 01.56-.327 2.09 2.09 0 01-.572.608c-.012-.083-.041-.232.013-.281zm-2.648 8.644c0 .09.042.19.116.26.042-.033.075-.095.075-.124.016-.174.029-.352.029-.534.02-.07-.083-.09-.108-.016-.041.136-.107.273-.112.414zm9.087 7.158l-.765.257c.178.203.695.037.765-.257zM8.12 4.705c.012.203-.025.455-.137.641-.012.025-.041.042-.074.066-.013-.037-.05-.066-.042-.09.042-.208.095-.456.145-.663.008-.012.041-.025.058-.029zm10.717 14.632c.165 0 .323-.005.447-.042.111-.07.107-.215.145-.314l-.042-.013-.182.166a2.579 2.579 0 01-.372.074.258.258 0 00-.058.075c.02.029.041.05.066.054zm-1.531-8.202c.054-.12.103-.227.145-.34.008-.024-.03-.086-.075-.127a.323.323 0 00-.09.041 1.655 1.655 0 00-.24.364c.016.03.098.03.256.062zM4.494 7.895l.161-.414c.03-.008.054-.008.075.005.024.124.004.322-.009.4-.024.113-.066.179-.165.228a.674.674 0 01-.062-.219zm9.34 3.037c-.113 0-.2.067-.208.166 0 .083.091.161.19.161.104-.008.183-.082.19-.173 0-.1-.061-.154-.173-.154zm-.1 1.018c0-.111-.066-.186-.186-.186-.096 0-.166.062-.166.15 0 .098.104.198.207.19.091 0 .145-.067.145-.154zm-.418-1.042c0 .09-.058.144-.145.144-.116 0-.203-.07-.203-.178 0-.082.083-.165.166-.165.087-.008.182.074.182.199zm.074.413c-.099 0-.165.062-.165.145 0 .087.09.166.186.166.074 0 .145-.079.145-.166.004-.078-.07-.145-.166-.145zm-1.088 7.399c-.128 0-.24.062-.236.132.008.07.108.166.186.166.083 0 .129-.087.129-.199-.004-.082 0-.099-.079-.099zM4.415 3.062c-.062-.248-.033-.472.03-.724.103.215.11.563-.03.724zm9.31 7.25c-.066.041-.124.107-.115.136.008.05.062.095.095.145a.27.27 0 00.112-.132c.012-.03-.05-.083-.096-.15z\"/></svg>");
        this.setPath("M6.687 11.326c.256-.137.405-.303.43-.497.042-.174-.116-.157-.153-.124-.145.116-.33.294-.509.414a1.862 1.862 0 00-.248.033c-.02-.009-.046-.042-.033-.054.161-.104.34-.207.455-.344.074-.086.041-.165-.103-.182-.162-.024-.352.042-.501.174-.253.215-.373.691-.397.993-.054.05-.07.05-.125.075a1.258 1.258 0 01.133-.98c.025-.063.008-.162-.083-.191-.054-.02-.079-.009-.103.05-.124.355-.34.508-.642.732-.029.025-.302.174-.372.215-.24-.074-.51-.521-.737-.857a.207.207 0 00-.198-.086c-.497.053-.865.016-1.13-.373-.12-.161-.174-.19-.323-.05-.165.174-.33.307-.496.447-.087.054-.15.038-.186-.074A3.132 3.132 0 011.2 9.604c0-.149.017-.372.02-.517a1.274 1.274 0 00-.314-.211C.488 8.677.004 8.214 0 8.077c0-.033.025-.116.14-.182.609-.269 1.08-.041 1.263-.07.153-.013.203-.124.178-.344a1.2 1.2 0 01.389-1.075c.207-.22.19-.464.14-.733-.024-.124-.053-.157-.178-.145-.33.075-.314.083-.376.373a1.476 1.476 0 01-.207.53c-.132.21-.31.388-.468.575-.053.074-.115.074-.194.024A1.084 1.084 0 01.26 5.66c.053-.144.132-.297.219-.376l.041.017c0 .025 0 .058-.008.082l-.1.307C.29 6.05.31 6.389.55 6.695c.079.1.15.128.19.083.154-.153.311-.298.443-.464.166-.186.211-.413.166-.65a4.121 4.121 0 00-.046-.268c-.024-.128-.078-.12-.14-.042-.15.15-.22.27-.29.547A.215.215 0 01.803 6a.29.29 0 01-.033-.145c.041-.248.099-.467.256-.629.104-.112.079-.174-.02-.203-.356-.099-.663-.198-.932-.53A.298.298 0 010 4.313c0-.07.037-.124.116-.182.314-.216.629-.439.94-.505.123-.025.19-.033.252-.042-.141-.438-.29-.964-.373-1.452 0-.1.07-.372.108-.451a.56.56 0 01.277.037c.145.05.277.14.41.224.128.074.165.074.248-.042.145-.21.31-.397.53-.509.074-.037.124-.062.173-.062.07 0 .125.042.195.15.12.194.223.417.33.62.125.211.257.223.448.087.21-.14.401-.277.596-.439.182-.14.231-.14.43-.004.178.124.372.352.468.55.02.038.434-.186.446-.285.017-.178.067-.306.133-.451.087-.178.21-.228.323-.228.103 0 .298.116.442.207l.315.182c.165.091.174.091.273-.062.112-.174.207-.207.439-.207.455 0 .869.116 1.183.493.058.074.112.082.182.012.128-.132.248-.182.488-.182h.422c.096 0 .158.008.245-.116.115-.165.248-.327.434-.327.298 0 .687.418.886.778l-.104.054a2.119 2.119 0 00-.778-.488c-.182-.075-.26 0-.236.186.025.22.083.443.137.662a.8.8 0 00.439.468l.012.074c-.033-.008-.075-.02-.124-.025a.906.906 0 00-.39.013c-.247.062-.475.17-.698.264-.112.054-.112.083-.017.174.124.116.24.249.38.352.402.302.8.24 1.242.07l.207-.07c.186-.033.385.041.538.182l.447.401c.14.137.174.257.083.427-.145.285-.307.575-.468.852a.277.277 0 01-.103.108c-.054-.042-.104-.145-.05-.236.198-.248.323-.596.364-.832.041-.232-.083-.34-.302-.281l-.186.07c-.079.029-.108 0-.124-.083-.03-.07-.067-.116-.091-.19-.05-.124-.125-.166-.228-.083a1.214 1.214 0 00-.43.414 1.568 1.568 0 00-.174.964c.004.041.037.07.062.095a.178.178 0 00.083-.082c.058-.145.095-.29.12-.447.012-.087.024-.245.053-.323.021-.042.087-.025.125-.013.095.038.132.083.144.15-.186.235-.302.587-.426.901-.02.042-.1.096-.149.096-.058-.004-.136-.054-.153-.104-.074-.198-.207-.393-.26-.592-.137-.674-.178-.711-.207-.753A4.146 4.146 0 009.095 3.34c-.033-.033-.05-.07-.074-.099.037-.017.066-.05.103-.062.128-.054.26-.104.393-.149a.616.616 0 00.356-.319c.046-.087.108-.173.157-.26.07-.124.062-.19-.029-.298a.641.641 0 00-.653-.203c-.253.062-.41.244-.489.484a.733.733 0 00-.041.27c0 .136.041.165.153.094.186-.153.393-.277.592-.41a1.093 1.093 0 01-.406.497c-.124.079-.248.145-.372.215-.104.075-.14.042-.174-.082-.029-.133-.017-.27-.017-.402a.877.877 0 00-.587-.881l-.327-.137a.314.314 0 00-.124.286c.025.36.078.62.14.927.058.124.195.173.336.198.082-.041.149-.157.037-.339l-.161-.319c-.017-.041-.038-.078-.05-.124-.004-.016-.012-.045 0-.066.02.008.041.008.083.05.207.223.372.476.48.79.041.124.004.174-.116.186-.273.025-.55.042-.815.1-.435.09-.58.248-.737.537-.066.125-.1.203-.103.278.153.012.327.004.575-.042a1.647 1.647 0 00.596-.194c.116-.137.207-.273.38-.397.05-.038.166-.05.211-.025A2.276 2.276 0 019.55 4.56c.017.05.067.1.091.14.05.059.03.08-.041.075-.1-.029-.207-.054-.298-.09-.037-.017-.066-.075-.083-.117l-.09-.256c-.05-.104-.075-.104-.179-.066-.053.02-.111.04-.198.082-.075.03-.112.042-.129-.041-.024-.124-.057-.248-.086-.36-.05-.137-.104-.166-.236-.1-.249.129-.43.32-.555.567-.116.24-.161.406-.054 1.043.025.124.125.277.24.315l1.076.33c.054 0 .087.063.021.104-.132.091-.277.17-.414.257-.07.041-.107.02-.14-.042a.844.844 0 00-.443-.405c-.07-.033-.108-.02-.137.054-.05.116-.103.285-.149.405-.025.062-.054.087-.124.042-.306-.257-.629-.27-1.005-.22-.187.025-.274.075-.228.26.103.518.554.758.94.924a.26.26 0 00.132-.104c.058-.083.041-.165-.042-.24-.149-.128-.463-.277-.62-.418-.025-.082.153-.157.248-.095.281.128.496.36.72.58.116.111.17.099.207-.063.041-.124.083-.314.12-.455.02-.074.066-.05.083-.004.029.108.062.248.062.372 0 .133-.046.249-.083.373-.025.124-.12.19-.224.165-.475-.045-.835.178-1.13.187a.894.894 0 01-.276-.075c-.104-.083.05-.09.082-.09.124 0 .31 0 .41-.055a.596.596 0 00-.128-.12c-.265-.215-.563.013-.79.129-.129.07-.137.086-.083.223.082.207.231.286.434.286.116 0 .228.016.348.012a.414.414 0 00.165-.041c.153-.058.29-.133.43-.195.174-.025.17.062.092.15l-.352.214c-.037.02-.079.033-.104.058-.05.037-.111.1-.103.124a.262.262 0 00.132.116c.166.05.331.075.489.112.256.05.364-.02.434-.273.037-.14.083-.273.149-.402.041-.082.091-.09.14-.008.175.323.357.637.543.952.033.07 0 .103-.066.095a23.741 23.741 0 01-1.2-.149c-.137-.02-.27-.108-.406-.165-.207-.096-.414-.183-.65-.174-.202.004-.318.124-.248.318.091.278.195.563.306.84.079.19.265.261.468.278.095.012.062-.054.037-.1l-.33-.716c-.042-.12-.01-.136.057-.037.182.273.372.534.538.811.1.174-.025.224-.149.228-.418-.042-.799-.186-1.2-.34-.041-.016-.1-.103-.087-.14.075-.07.166 0 .248 0 .096.016.137-.025.1-.1a.38.38 0 00-.203-.186 2.47 2.47 0 00-.596-.215c-.124-.025-.207.03-.182.14.033.146.1.274.174.423.02.041.02.1.008.14-.074-.004-.165.021-.476-.111-.31-.128-.314-.215-.314-.596 0-.083 0-.244.016-.319.033-.103.042-.124.137-.107.323.066.65.153.968.306.095.041.186.124.286.161.082.03.124 0 .111-.082a.29.29 0 00-.182-.249c-.339-.144-.678-.306-1.018-.442-.082-.034-.111-.07-.066-.158.137-.223.207-.484.15-.765 0-.02.024-.05.049-.075a.207.207 0 01.153.19c.025.24.186.406.343.568.319.33.319.33.766.223.058-.008.1-.05.149-.083-.042-.033-.083-.09-.14-.116-.084-.041-.175-.066-.266-.103-.298-.112-.385-.323-.285-.637a10.759 10.759 0 00.277-.865c.033-.137.041-.281.05-.426 0-.083.062-.083.111-.091l.65-.042c.166-.012.352-.207.418-.318l.215-.352a.451.451 0 00-.443-.066c.05-.162.116-.315.116-.468 0-.1-.025-.22-.066-.323-.041-.099-.112-.115-.194-.053-.158.132-.29.29-.34.504-.05.216-.14.609-.095.679.1-.074.232-.174.319-.199a.19.19 0 01.149.025 2.12 2.12 0 01-.48.331c-.12.054-.166-.016-.145-.132.14-.538.054-.58.008-.844a3.103 3.103 0 00-.401-.927c-.058-.075-.15-.05-.273.1-.199.24-.249.442-.352.856l-.025.082-.14.125-.063-.07c.054-.191.112-.303.112-.456a.525.525 0 00-.207-.422c-.153.1-.294.223-.33.29a.41.41 0 00.007.471c.158.278.133.555.083.882l-.041-.013a3.674 3.674 0 00-.116-.629c-.033-.132-.12-.244-.19-.36-.07-.103-.133-.327-.075-.418.083-.144.344-.219.443-.351.103-.158.054-.224.186-.364.079-.096.248-.29.372-.224.373.186.77.228 1.188.174.178-.025.215-.02.265-.199.041-.149.062-.05.21-.099.253-.083.386-.31.386-.58 0-.148.008-.301-.009-.454-.012-.133-.062-.261-.103-.381-.033-.079-.087-.062-.124-.004-.104.136-.277.405-.373.554-.053.087-.099.174-.144.265-.025.07-.058.087-.12.02a1.349 1.349 0 00-.22-.19c-.136-.087-.149-.36-.095-.533.058.033.1.099.137.186.05.116.074.248.165.29.12.061.24-.187.224-.356a.27.27 0 00-.042-.125c-.132-.235-.434-.426-.62-.426-.216 0-.352.265-.265.517.025.067.05.116.083.178-.51.27-.646.439-.849.675-.025.029-.05.112-.025.153.096.182.058.244-.136.352-.087.05-.207.095-.298.124-.012.008-.037-.013-.062-.017a.124.124 0 01.025-.05c.124-.277.26-.541.376-.823.124-.302-.149-.583-.393-.678-.161-.063-.29-.025-.397.12-.27.322-.327.848.05 1.344.058.083.04.116-.054.125-.215.016-.43.04-.654.053a.869.869 0 00-.662.352c-.05.075-.116.091-.186.041-.17-.103-.315-.078-.493.025-.29.153-.629.273-.815.273-.029 0-.066-.024-.09-.05.016-.024.04-.061.103-.082.177-.041.322-.087.48-.132.029-.03.04-.1.057-.129-.028-.041-.09-.095-.136-.1a2.185 2.185 0 00-.451 0c-.393.038-.683.22-.931.452-.116.116-.124.236 0 .331.29.207.6.414.993.31.273-.087.443-.29.62-.488.15-.157.332-.343.505-.145.253.29.303.592.716.538.158-.016.224-.07.265-.22l.033-.177c.013-.116-.05-.174-.161-.128-.075.024-.14.066-.215.082-.042.013-.087-.004-.137-.016.004-.042.013-.1.042-.124.074-.05.165-.091.248-.129.31-.082.604-.144.91-.206a.265.265 0 01.095 0l-.029.086c-.111.257-.26.336-.463.385a.479.479 0 00-.112.199c-.128.414-.054.844.224 1.142.099.112.223.203.351.281.216.124.273.331.352.55.05.137.104.274.166.41a1.386 1.386 0 00-.418.447c-.042.042-.075.025-.1-.025l-.12-.293c-.107-.261-.29-.427-.579-.451-.103-.009-.207-.025-.306-.038-.12-.012-.199.042-.24.178-.162.497-.008.927.467 1.192-.38.095-.695.248-.89.513.021.075.137.174.286.236.373.153.753.137 1.105.017.207-.075.215-.025.253.124l.103.463c.025.112-.037.174-.14.137-.568-.166-1.242-.439-1.73-.766a2.566 2.566 0 00-.642-.19c-.074.041-.136.095-.202.083a3.629 3.629 0 01-.613-.216c-.1-.058-.103-.087.02-.103.191 0 .539.083.717.083.173-.054.173-.083.066-.158-.418-.33-.89-.252-1.357-.173-.166.033-.178.111-.083.244.604.683 1.05.678 1.787.592.48.306.96.579 1.52.757l.011.083a8.155 8.155 0 00-1.142.165c-.182.037-.219.149-.12.315.15.24.385.351.654.417a.848.848 0 00.58-.037c.223-.103.368-.29.579-.405.124-.067.33.008.455.041.19.062.372.145.567.174.77.103 1.589.174 2.305.116a3.697 3.697 0 00-.207.484c-.037.1-.004.124.1.116a.436.436 0 00.36-.207c.012-.116.012-.22.036-.335.013-.062.03-.15.07-.158.03-.004.208.025.187.075a7.213 7.213 0 01-.19.496c.066.013.136.025.206.025.29 0 .336-.041.323-.33a1.2 1.2 0 00-.037-.245c-.037-.215.008-.364.194-.463.183-.091.373-.062.555-.042a3.393 3.393 0 011.568.708c.228.182.03.434.03.778 0 .215-.042.438-.038.55.008.178.083.273.149.323.199.153.418.306.629.443.215.14.323.227.58.314a.556.556 0 00.181.013.662.662 0 00-.012-.265c-.124-.083-.298-.124-.497-.19-.037-.013-.074-.063-.095-.108a.372.372 0 01.145-.083l.323-.07a.19.19 0 00.082-.07c-.016-.03-.04-.067-.066-.071-.132-.041-.306-.07-.418-.1-.041-.012-.062-.049-.095-.086a.406.406 0 01.157-.083l.331-.041a.174.174 0 00.087-.054c-.012-.033-.029-.075-.053-.087-.07-.033-.41-.157-.447-.195-.03-.028-.038-.07-.05-.124a.317.317 0 01.157-.033l.277.004a.178.178 0 00.112-.053.248.248 0 00-.074-.087c-.133-.083-.182-.141-.331-.207-.07-.042-.104-.083-.116-.17a.461.461 0 01.186-.008c.1.025.153.058.26.074a.284.284 0 00.117-.012.116.116 0 00-.03-.083c-.04-.041-.095-.062-.144-.1-.075-.049-.203-.173-.277-.235-.025-.02-.013-.083-.017-.104l.083.005c.1.02.248.062.33.074.15.029.13.008.067-.1-.091-.082-.186-.136-.273-.231-.025-.033-.017-.087-.013-.132.141.008.286.074.414.074.013-.025.021-.041.021-.074a2.11 2.11 0 00-.103-.249c-.038-.095.012-.132.082-.103.1.041.257.124.364.149.042.012.096 0 .15-.02-.05-.1-.108-.179-.174-.278-.013-.025 0-.062.02-.091.17.05.344.166.497.207.07.029.116 0 .132-.033.013-.042-.111-.166-.103-.215.004-.033.012-.042.029-.062l.29.09c.21.054.33.075.364.025.04-.012-.005-.111-.067-.227.166-.013.187.066.48.124.112.029 1.664-.19 2.293-.385.248-.083.538-.207.77-.314l.074.016c.178.455.554.596.94.637.11.013.23.021.35.025.113 0 .137-.029.104-.14a1.986 1.986 0 00-.575-.977l-.248-.153c-.108-.112-.095-.24.02-.331.2-.133.464-.26.663-.385.29-.186.389-.472.372-.774a.257.257 0 00-.107-.202.323.323 0 00-.15.103c-.078.165-.157.302-.227.447-.054.029-.112.041-.161.062-.013-.05-.042-.1-.03-.149.088-.257.315-.463.464-.629.062-.103-.029-.145-.074-.137-.166.038-.348.1-.472.24a3.335 3.335 0 00-.654 1.354c-.029.128-.083.173-.124.293-.054.182-.05.224.108.336.227.148.525.285.74.438.087.095.042.133-.05.128a.857.857 0 01-.62-.277c-.083-.09-.153-.149-.248-.161-.224.058-.534.149-.766.182-.132.025-.236.078-.306.203-.046.103-.14.124-.248.082-.166-.045-.331-.103-.497-.14a1.862 1.862 0 00-.828.058c-.111.016-.136-.009-.103-.116.029-.137.074-.27.1-.402.003-.058.012-.144-.042-.173-.054.024-.132.037-.157.074-.087.128-.153.265-.236.406-.054.111-.075.111-.19.062a2.11 2.11 0 01-.468-.286c-.112-.178-.232-.327-.29-.48-.02-.041.042-.074.095-.074.125.099.273.223.385.33.075.083.1.166.15.274.012.025.132.02.152-.025.017-.041.038-.103.054-.19a.587.587 0 00-.136-.542c-.183-.187-.307-.224-.56-.398-.314-.215-.36-.202-.475.009a1.232 1.232 0 00-.153.579c.083.505.203.712.815 1.026a.17.17 0 01-.05.083c-.04.033-.062.054-.132.054-.215-.009-.517-.013-.753-.033-.066-.005-.108-.025-.124-.063a3.103 3.103 0 01.273-2.234.372.372 0 01.149-.161c.128-.067.33-.153.455-.207.075-.033.112-.009.145.066.054.199.074.34.09.509.01.103.013.207.055.227.099.042.186-.04.236-.124a1.1 1.1 0 00.099-1.005c-.013-.033.016-.1.054-.12.422-.17.815-.344 1.241-.51.24-.012.546.013.972.084.07.008.22.132.373.219-.195.1-.48.306-.679.496-.054.058-.124.133-.074.29.165-.008.248-.054.372-.09.19-.055.31-.084.464-.084a.828.828 0 01.124.017.228.228 0 01-.058.128c-.054.05-.14.042-.203.075-.062.041-.124.103-.083.178.03.05.112.107.17.099.199-.013.38-.037.588-.1.09-.074.438-.53.24-.57-.112-.025-.352-.042-.456-.096a.207.207 0 01.125-.14c.107.016.231.05.397.066a2.441 2.441 0 00.815-.037c.112-.042.149-.083.112-.153a1.283 1.283 0 00-.758-.663c-.149-.04-.33-.008-.484-.008l-1.332-.012c-.03 0-.062-.025-.091-.042.025-.02.05-.045.074-.058.124-.074.27-.136.393-.223a.87.87 0 00.365-.55.228.228 0 000-.129c-.125-.455-.373-.786-.89-.844l-.257-.041c-.095-.008-.132.033-.132.12 0 .161.008.248 0 .414 0 .082.041.111.137.124a3.186 3.186 0 01.703.203c.137.053.165.136 0 .277l-.372.265c-.067.041-.096.008-.104-.054-.008-.1-.008-.207-.025-.302a.207.207 0 00-.054-.095.273.273 0 00-.198.165c-.05.133-.083.257-.104.385a.406.406 0 01-.285.331c-.075.02-.14-.008-.128-.079.012-.082.029-.165.053-.248.12-.29.182-.538.158-.81a5.834 5.834 0 01-.042-.572.17.17 0 01.124-.182c.224-.087.435-.174.67-.248.08-.03.146.004.208.082l.471.555c.125.132.158.128.265-.02.1-.141.207-.27.364-.357.083-.041.083-.12-.012-.157-.178-.066-.356-.103-.542-.165-.042-.013-.087-.013-.133-.03-.029-.012-.066-.049-.066-.074 0-.025.037-.062.066-.074.34-.12.621-.232.923-.348.083-.037.124-.103.112-.19-.008-.112-.041-.207-.058-.315-.017-.099-.083-.174-.186-.186-.414-.041-.662.075-.944.364a.257.257 0 00-.066.228c.05.008.091.008.128-.004a1.69 1.69 0 00.443-.187c.075-.082.133-.165.174-.165.025 0 .07.103.083.14-.042.05-.083.1-.41.24a9.447 9.447 0 01-1.812.625c-.083.009-.079-.045-.058-.082.116-.203.248-.414.376-.63.124-.074.158-.04.112.075a2.223 2.223 0 01-.137.257c-.012.083.025.103.075.095a.695.695 0 00.513-.617c0-.103-.05-.14-.157-.136-.157.012-.331.025-.484.07-.29.075-.464.277-.559.542a2.934 2.934 0 00-.091.377c-.025.136-.14.186-.26.252-.203.124-.307.1-.48.133a2.855 2.855 0 00-.435.099c0-.05-.013-.095 0-.124.1-.157.186-.31.29-.455.144-.211.107-.331-.125-.414a.86.86 0 00-.993.347c-.124.199-.215.435-.302.65-.054.128 0 .207.137.236.21.037.463-.041.654-.095-.013.062-.017.302-.038.351l-.124.27c-.078.132-.165.177-.31.107a6.538 6.538 0 01-.65-.352c-.248-.145-.488-.248-.765-.248a.372.372 0 01-.083-.008c-.091-.02-.095-.05-.042-.108.07-.07.075-.14.034-.227l-.286-.53a1.448 1.448 0 01-.136-.31c.07-.013.33.074.33.124.021.29.108.496.261.678.116.116.224.042.236-.074.02-.153-.186-.402.083-.973.116-.256.472-.695.703-.695.124 0 .228.054.302.236.042.083.07.282.108.364.033.083.074.124.165.116.224-.029.534-.165.787-.198.161-.025.285.376.364.52.124.216.182.402.323.17.24-.33.351-.703.608-.819a1.792 1.792 0 011.043-.178c.111.013.144.054.12.166-.021.066-.025.136-.042.207-.025.078.046.107.133.041.12-.07.207-.165.29-.273.214-.232.43-.348.852-.348.198 0 .351.042.53.104.136.05.157.07.12.207l-.12.397c-.042.182-.013.207.148.298.141.083.253.14.34.248a.29.29 0 00.178-.062 2.14 2.14 0 01.765-.865c.133-.074.166-.066.22.062.111.282.173.526.194.79.149-.173.323-.36.447-.496.447-.422.89-.418 1.49-.269.148.042.033.19-.054.306l-.116.174c-.037.062-.066.066-.116.013-.075-.087-.149-.24-.224-.315-.136-.136-.376-.058-.542.042a2.222 2.222 0 00-.802.823 4.345 4.345 0 01-.704.832c-.107.041-.107.037-.083-.075a2.959 2.959 0 00.489-1.535.368.368 0 00-.286.062c-.414.232-.62 1.055-.678 1.606-.013.115-.013.207-.116.264-.174.1-.24.141-.414.22-.041.008-.066 0-.104-.004.083-.365.025-.621-.186-.965-.037-.066-.083-.099-.161-.074-.041.025-.083.058-.178.132a1.56 1.56 0 00-.488 1.196c0 .083.082.083.14.042a.624.624 0 00.158-.19c.103-.174.19-.357.29-.53.016-.042.065-.07.103-.083.02.041.02.087.012.124l-.074.331a1.034 1.034 0 01-.331.455c-.03.042-.05.116.033.124.356.017.562-.024.869-.186.322-.165.538-.302.678-.285.095.012.58.153.621.186-.025.05-.062.066-.091.1-.05.04-.286.169-.389.256-.166.136-.223.198-.19.476.016.124.037.24.066.36.012.037.041.09.066.099.041 0 .083-.033.108-.062.136-.166.264-.348.401-.513a.314.314 0 01.083-.05c0 .033.008.062 0 .083-.03.203-.133.356-.257.505l-.083.103c-.107.153-.115.178-.008.331a.73.73 0 01.104.58c-.03.144-.075.36-.104.57-.26.12-.525.29-.745.44-.14.123-.165.223-.165.252.066.082.128.095.256.148.182.058.522-.012.584-.206a.577.577 0 00.041-.211c.066.012.124.012.14.066.067.207.125.347.257.484a.682.682 0 01-.099.182c-.078.128-.145.24-.256.215-.042-.004-.087-.016-.137-.016-.083 0-.165 0-.153.149.016.19.041.277 0 .471-.025.108-.058.224-.166.22-.26-.021-.43-.211-.682-.207a.981.981 0 01-.476-.083c-.133-.07-.228-.145-.29-.182a69.39 69.39 0 00-3.1.58c-.094.02-.09.082-.107.181-.05.228-.136.451-.174.679-.008.037.042.083.067.116.024-.025.062-.042.087-.075.053-.078.09-.17.153-.248.107-.116.389.008.438.165.042.096-.09.141-.082.249.008.09.14.174.14.29 0 .103-.041.17-.058.223.39.248.484.455.497.778.012.1.012.149.066.207.054.053.14.132.178.182.182.21.348.546.472.58.062.02.219.032.339.02l.025.066a.492.492 0 01-.248.244c-.286.091-.427-.335-.58-.58a2.069 2.069 0 00-.24-.318c-.124.137-.33.687-.314.948.083.351.29.7.426.951.095.158.281.212.463.282.154.054.265.083.422.037.083-.02.112-.025.15-.054l-.005-.318c.042-.58.133-1.159.17-1.655 0-.133.1-.356.269-.472a.539.539 0 00.24-.5.393.393 0 01.041-.208c.058-.116-.053-.116-.165-.132-.124-.02-.153-.066-.091-.178.116-.195.281-.36.414-.546.082-.133.124-.228.153-.307-.033-.16-.021-.4.14-.41.526-.061.745-.016 1.08.237.021.033.025.082.025.124 0 .041.095.074.273.252.137.128.27.488.038 1.043.115.07.111.178.099.302-.008.108.025.124.124.161.124.042.19.116.294.373.09.248.36.898.517 2.49-.029.502-.116.87-.215 1.28.107.765.227 1.704.323 2.991.078 1.217.099 1.842.124 2.342.215.017.281.062.327-.12l.041-.17c.041-.12.161-.078.166-.012l.132.39c.029.11.062.181.103.289.145.198.207.025.207-.12.017-.124.017-.228.017-.34.025-.144.1-.153.153-.053l.19.45c.07.158.145.2.174.104.025-.128.03-.356.025-.538-.029-.103-.075-.215-.091-.306 0-.124.1-.1.124-.062a14.441 14.441 0 01.675.881c.124.075.198-.053.165-.103-.008-.05-.07-.112-.07-.211.016-.157.165-.087.198-.03.137.137.228.315.307.46a.29.29 0 00.124.062.238.238 0 00.037-.145c-.008-.05-.066-.165-.083-.219.058-.095.174.025.211.062.042.042.083.112.137.199.074.116.198.215.471.252.005.025.017.058.017.083-.037.025-.1.054-.265.083a3.38 3.38 0 01-1.034.02 1.2 1.2 0 00-.762.166c-.165.095-.33.083-.525.074-.373-.016-.745-.016-1.126-.024-.786-.021-1.179.136-2.069.182-.29 0-.893-.15-.893-.335 0-.129.074-.236.074-.303 0-.082-.017-.103-.091-.124-.633-.111-1.258.033-1.833.141-.488.075-.745-.004-1.002-.207a1.295 1.295 0 01-.355-.376 5.057 5.057 0 00-.99-.94c-.413-.33-.939-.93-1.266-1.345-.074-.086-.202-.509-.248-.629a1.266 1.266 0 01-.058-.546c.05-.041.112-.09.157-.095.278-.008.621-.14.634-.223.029-.062-.017-.116-.07-.1a1.61 1.61 0 01-.489 0c-.083-.012-.182-.05-.22-.09.05-.063.083-.108.137-.137a1.452 1.452 0 00.646-.249.157.157 0 00-.017-.082c-.182-.009-.323-.009-.525-.058a.468.468 0 01-.199-.116.322.322 0 01.149-.124c.232-.075.401-.186.559-.331l-.004-.091a3.157 3.157 0 01-.63-.066c-.095-.05-.103-.058.005-.174.149-.038.422-.062.57-.112.112-.058.092-.153-.02-.186a3.393 3.393 0 01-.538-.058c-.112-.1-.124-.108.02-.174l.477-.1c.182-.061.153-.177 0-.223-.145-.016-.245-.05-.39-.074-.19-.095-.186-.104-.032-.166l.302-.082c.082-.021.165-.054.182-.116a.091.091 0 00-.009-.062c-.128-.038-.389-.013-.504-.05-.042-.008-.083-.054-.108-.108l.112-.062a1.72 1.72 0 00.41-.157.36.36 0 00.045-.103.269.269 0 00-.083-.042 3.53 3.53 0 01-.385-.132c-.082-.104-.078-.124.033-.17l.216-.058a1.378 1.378 0 00-.108-.215.215.215 0 00-.074-.074c-.125-.075-.303-.15-.435-.236-.248-.153-.509-.302-.703-.497a1.614 1.614 0 01-.522-.852 1.784 1.784 0 01-.004-.63c.025-.156.112-.322.195-.47.033-.055.057-.104.024-.15a3.26 3.26 0 00-.384-.414.654.654 0 00-.245-.124c-.492-.087-.794-.186-1.018-.157a.786.786 0 00-.19.285c.042.166.124.423.128.634.182.02.398.082.621.206.178.116.22.178.29.398.153.496.194 1.13.302 1.808.095.645-.244 1.18-.898 1.204-.356.017-.646-.054-.74-.294-.117-.339-.204-.625-.315-.964a7.437 7.437 0 00-1.449.513c-.434.207-.79.406-1.25.592-.872.36-1.836.58-2.701.58-.455 0-.964-.092-1.316-.232-.315-.125-.426-.253-.497-.65a3.77 3.77 0 01-.016-1.018c.041-.331.095-.563.323-1.183.099-.274.227-.402.438-.51a2.317 2.317 0 011.142-.227c.137.008.315.029.439.083.248.09.285.29.294.538 0 .145.008.29-.005.434-.012.116-.008.162-.008.207.315.046.973.029 1.283-.041.256-.054.36-.095.828-.315.322-.145.76-.472 1.27-.736zm9.906 5.532c.03.062.1.372.1.48 0 .252-.021.484-.05.877-.042.513.012 1.035-.058 1.54-.03.248-.091.633-.07.972.004.136.024.174.103.19.248.058.414.083.538.083.38 0 .629-.174.596-.385a5.172 5.172 0 01-.178-1.423l.1-.009c.14.58.26.865.301 1.167.05.273 0 .741.054.981.637.07 1.399.008 1.63-.041.058-.522.042-1.056-.186-1.254a6.44 6.44 0 00-.505-.385 2.851 2.851 0 01-.678-.753c-.273-.43-.348-.567-.588-.985-.223-.389-.372-.724-.525-.952a1.684 1.684 0 00-.22-.29 2.926 2.926 0 00-.58-.107c-.268-.029-.446-.058-.6-.227-.131-.133-.185-.24-.107-.418.042-.096-.012-.162-.082-.24-.08-.1-.058-.207.04-.282.237-.231.456-.347.766-.43l-.05-.215c-.123.016-.26.054-.508.054-.344 0-.654-.141-.778-.592-.046-.162-.248-.617-.306-.82-.042-.124.004-.277.062-.455-.108-.132-.199-.281-.29-.405-.186-.079-.41-.157-.559-.34-.062-.074-.09-.078-.144-.04-.05.036-.062.09-.133.152-.066.058-.203.062-.33.008-.125-.05-.187-.177-.183-.302.013-.165.095-.31.02-.376-.127-.137-.247-.29-.094-.397.041-.038.136-.03.194-.058a.414.414 0 00.199-.464c-.033-.136-.108-.198-.244-.21-.195-.013-.282-.113-.282-.24 0-.166.145-.237.278-.208a.421.421 0 01.173.083c.013.062.042.149.091.14.224-.024.398-.256.398-.475 0-.075-.05-.112-.195-.079-.265.042-.596.141-.923.253-.182.062-.207.207-.107.372.033.037.058.083.082.124.042.066.025.116-.04.153l-.084.062c-.099.075-.111.158-.05.27.017.04.042.07.075.099.075.066.075.124.004.207a.314.314 0 00-.066.335c.029.095.104.633.104.736-.005.278.05.555.033.815-.013.19.082.356.264.563.2.22.344.418.613.679.318.302.492.662.521 1.105.013.207.112.281.31.389.419.116.563.351.613.67.083.567-.194 1.117-.703 1.068-.261-.025-.39-.182-.39-.319 0-.145.075-.29.195-.331.02-.008.095 0 .112 0a.248.248 0 01.012.091c0 .037-.05.058-.066.132-.012.05-.012.15.037.211.054.07.15.096.249.062.115-.037.194-.136.248-.24.236-.426.116-.93-.335-1.042-.145-.042-.352-.062-.485.016-.28.174-.52.273-.757.489a.182.182 0 00-.058.136 23.143 23.143 0 00.199 2.814c0 .203.149.455.207.488.165-.12.207-.24.352-.467.07-.042.103-.017.124.045-.004.211-.046.414-.021.596.012.054.074.103.116.14.1-.09.103-.227.145-.33.111-.116.136.012.14.045-.008.137 0 .26.013.331.004.054.054.066.1.079.12-.24.272-.455.467-.588.116-.083.19-.012.124.104a2.934 2.934 0 00-.265.699.414.414 0 00.116-.012c.025-.009.062-.017.074-.083.083-.207.129-.232.224-.083.041.14.103.24.186.281.124-.033.132-.182.182-.29.132.01.14.154.207.224.045.037.422.05.492.042l-.012-.22c-.008-.438 0-.79.029-1.225.033-.455.083-.922.108-1.324.016-.33.058-.836.082-1.229zM22.792 8.4a7.541 7.541 0 00-.625-.041c-.091 0-.34 0-.348.128 0 .037.05.103.108.14.302.207 1.146.245 1.49.187a.574.574 0 00-.03-.253c-.082-.252-.393-.475-.678-.567a2.338 2.338 0 00-.919-.033l-.058-.153c.1-.447.087-.86.025-1.187a.962.962 0 00-.182-.414c-.058-.083-.124-.079-.198-.017-.05.042-.1.096-.187.207-.285.348-.273.58-.223 1.1.033.026.07.05.165.05.091 0 .133-.04.145-.165.009-.174.05-.356.075-.517.041.012.116.062.124.09.016.27-.07.551-.137.804.017.029.215.115.186.198-.024.062-.33.14-.546.157a1.092 1.092 0 00-.509-.417c-.124-.05-.26-.091-.157-.174l.166-.066c.29-.12.194-.286.182-.567-.013-.108-.054-.137-.153-.133a.795.795 0 00-.36.083c-.216.132-.381.352-.538.53-.03.029-.091.016-.141.016.083-.26.19-.546.273-.778.029-.082.066-.165.157-.145.447.104.902.017 1.217-.297.132-.141.132-.207-.037-.327a1.051 1.051 0 00-.952-.207c-.137.054-.228.132-.248.273-.013.083.401-.033.546-.02.041.003.07.04.1.061-.266.116-.572.174-.828.248-.083.021-.116 0-.129-.082a.36.36 0 01.129-.364c.194-.166.347-.36.389-.621.024-.14-.092-.352-.154-.472-.008-.033.009-.058.013-.083a1.8 1.8 0 01.525.249 1.171 1.171 0 00.815.902c.145.05.294.103.452.149.14.041.248.004.24-.15l-.009-.206c.124-.054.265-.095.298-.091.236.033.476.149.72.227.166.083.083.141-.033.125-.182-.03-.36-.083-.534-.125-.111-.024-.202.025-.219.133.074.132.414.29.538.34.182.065.869.144.86-.042a2.425 2.425 0 00-.082-.546c-.042-.154-.174-.24-.319-.278a3.724 3.724 0 00-.918-.107.84.84 0 00-.331.107l-.038-.202c-.066-.278-.198-.344-.405-.414.012-.083.012-.137.012-.224.182-.103.406-.277.493-.422-.075-.07-.207-.107-.278-.132-.281-.1-.31-.207-.5-.29a1.241 1.241 0 00-.447-.112c-.14-.004-.331.034-.373.087-.02.038 0 .096.083.153.124.096.385.166.513.257.083.046.042.066-.012.074a1.279 1.279 0 01-.505-.144c-.095-.05-.124-.091-.194-.116-.125-.042-.145-.008-.228.136-.062.104.012.158.1.207.297.166.517.26.893.302.041.042.05.112.062.195-.372-.05-.496-.054-.728-.137-.368-.198-.662-.356-1.018-.471-.066-.03-.091-.07-.017-.116.373-.224.729-.497 1.105-.704.054-.029.14-.016.207-.004.182.033.244.091.426.145.108.041.211.07.232-.03.054-.272.14-.475.22-.59.165-.253.4-.386.711-.58.116-.393.497-.795.633-.795.373 0 .745.675.82.927.05.182-.249.34-.05.34.174 0 .335.029.335.178 0 .26-.074.525-.207.715-.14.19-.29.398-.48.526l.012.066c.323.24.675.414.675.778 0 .195-.054.331-.166.426-.086.075-.157.15-.148.261.012.252.028.393.012.641-.012.166-.517.199-.588.273a2.069 2.069 0 01-.14 1.258l.103.19c.513.36.58.688.654.969-.14.137-.373.252-.455.252-.331 0-1.064-.248-1.209-.269-.058.104-.024.2.05.406.066.186.19.314.19.488 0 .083-.012.215-.248.253a1.663 1.663 0 01-1.105-.302c-.066-.038-.124-.083-.19-.112-.112-.062-.252-.017-.29.112l-.074.248c-.042.136-.112.149-.298.112-.526-.112-.77-.679-.77-1.18.025-.103.108-.062.124-.012.033.244.141.48.22.678.099.19.223.294.43.32.041 0 .1-.08.149-.166.112-.236.215-.394.182-.67a.672.672 0 00-.112-.32c-.033-.04-.087-.07-.149-.124.03-.045.075-.095.112-.082.232.082.406.082.55.004.091-.05.133-.112.195-.19a8.19 8.19 0 01.799-.162c.372 0 .703.05.98.174zM8.628 17.479c.198 0 .438.099.434.314l-.041.108a.112.112 0 01-.05-.013c-.074-.161-.194-.252-.389-.215a.835.835 0 00-.455.257c-.079.082.083.132.182.186l.207.124c0 .108-.282.894-.14.919.355.062.827-.427.876-1.118-.012-.248.129-.372.402-.463.323-.124.476-.269.422-.62-.025-.175.074-.125.17-.27l.107-.116c.017.05.054.166.041.216-.074.285-.016.509.125.765l.264.687c.063.066.12.012.183.083.227.46.484 1.146.831 1.44.286.236.588.65.857.898.157.14.265.492.463.558.14.05.137.124.116.253-.025.157.041.186.1.186.095-.012.186-.037.285-.041.215.045.165.19.008.215-.107.012-.21-.009-.318-.009a.613.613 0 00-.112.042.226.226 0 00.058.107c.174.096.298.108.467.145.033 0 .058.025.096.037-.013.03-.05.096-.083.112a.729.729 0 01-.19 0c-.154-.033-.294-.1-.44-.165-.049-.017-.082-.07-.127-.104-.038-.016-.083-.025-.125-.037 0 .05-.016.095-.012.137.033.066.103.182.074.206-.012.021-.111.083-.14.067-.124-.058-.224-.199-.34-.265-.148-.095-.285-.095-.426.004-.145.1-.273.186-.41.265-.169.111-.351.29-.554.29-.112 0-.389-.17-.513-.208-.232-.074-.306-.082-.554-.136-.207-.05-.39.029-.6.1-.257.078-.538.111-.816.16-.157.03-.339 0-.504-.008-.249-.008-.489-.029-.733-.025-.165 0-.34.03-.496.083a.855.855 0 01-.22.033.558.558 0 01-.322-.099.472.472 0 00-.352-.066c-.116.025-.344.066-.439-.02-.116-.117-.393-.348-.55-.32-.493.083-.728.365-1.208.236-.34-.086-.563-.165-.894-.057-.083.033-.298-.017-.385-.005-.124.017-.166-.008-.15-.132l.013-.066c.021-.128-.103-.224-.227-.178-.137.041-.215.182-.344.248-.236.116-.455.083-.711-.016-.174-.075-.352-.042-.518.041-.107.058-.281.31-.397.31-.041 0-.103-.066-.124-.124v-.12a.828.828 0 01.273-.252 1.552 1.552 0 01.944-.124c.149.024.31.041.45-.017.112-.05.228-.058.332-.112.186-.099.347-.186.558-.111.153-.07.236-.12.315-.236.037-.186-.03-.38.016-.563.042-.166.112-.372.166-.53.033-.082.09-.074.145-.066.149.22.33.426.24.63-.062.14.26.24.207.38-.054.107-.03.174.078.186l.083.008c.095 0 .1-.062.095-.182.004-.678-.215-1.15-.447-1.684-.095-.207-.078-.414-.004-.62l.14-.423a.794.794 0 01.427-.447c.025-.004.095.025.112.058.302.427.413.944.264 1.457a5.45 5.45 0 00-.103.48c-.008.041.004.083.012.124.03-.025.067-.05.091-.083.15-.223.303-.442.423-.682.115-.232.306-.327.546-.373.26-.054.335-.02.269.232a5.27 5.27 0 01-.137.43.857.857 0 01-.438.534c-.15.083-.286.194-.414.29-.05.066-.062.062-.009.128.05.062.125.025.187-.013.244-.177.496-.318.744-.455.092-.041.12-.008.112.1-.012.124-.029.293-.153.339-.136.045-.319.066-.439.124A.828.828 0 004.88 21c-.083.124-.083.207-.15.34-.012.028 0 .078.005.123.041-.016.083-.016.111-.033.162-.116.249-.248.41-.372.124-.095.153-.083.203.07.016.05.054.091.103.137.05-.033.104-.062.141-.112.145-.215.236-.645.426-.93.033 0 .075.024.1.036.04.095-.013.422-.005.493.005.198.067.24.249.149.14-.07.269-.145.405-.22.15-.074.27-.016.182.1-.045.07-.116.124-.157.198-.025.042-.02.112-.025.166.042 0 .1.008.14-.013.113-.029.216-.078.324-.124.144-.066.293-.045.455 0 .153.054.31.091.455.133.12.029.252-.025.36-.075a3.84 3.84 0 01.654-.252 2.11 2.11 0 00.815-.468c.054-.058.137-.087.199-.145.05-.041.09-.235.095-.298.041-.165-.025-.554.008-.728.02-.041.054-.132.083-.178l.07.02c.02.063.05.158.05.208-.013.298-.017.96-.05 1.25 0 .066-.116.173-.182.198-.521.19-1.047.39-1.572.538-.236.066-.497.029-.745.033-.199 0-.393-.029-.588-.016-.153.012-.372.153-.53.178-.43.066-.802.037-1.228.115-.393.075-.77.182-1.147.286a.697.697 0 00-.235.116c-.03.025-.038.07-.05.1.041.02.083.049.124.04.095-.008.174.021.273.009.232-.037.464-.062.704-.083a.32.32 0 01.161.066.444.444 0 00.364.075c.14-.033.265.004.39.095.214.174.268.182.516.041.19-.103.402-.103.613-.09.471.024.91.094 1.336.173a.91.91 0 00.878-.34 5.94 5.94 0 00.33-.45c.08-.104.166-.174.29-.174.265-.004.538-.066.799-.05.149.013.22.15.22.236-.01.087-.042.14-.146.137a9.13 9.13 0 01-.596-.05c-.206-.017-.372.041-.496.199-.066.074-.05.124.05.149.041.004.095.024.14.029.108.012.158.062.186.16.021.063.15.125.365.137.277.017.422.017.662-.062.099-.033.165-.149.236-.235.157-.228.264-.286.546-.228.198.037.33-.174.509-.161.327.04-.042-.617-.249-.832-.285-.211-.513-.63-.76-.94-.183-.227-.402-.314-.56-.591-.302-.5-.55-1.113-.885-1.515-.132-.136-.418-.041-.559.033a.393.393 0 00-.165.116c.405.344.422.82.281 1.171-.041.112-.083.108-.198.062a4.264 4.264 0 01-.32-.128c-.07-.037-.131-.02-.206.025-.306.186-.683.439-.745.376-.124-.124-.323-.496-.31-.686a.764.764 0 01.12-.377 3.103 3.103 0 01-.397-.257l-.005-.136c.257-.248.605-.488.874-.488zm-7.747-3.6c.033.244.137.442.373.533.34.141.786.224 1.167.228.45.012.943-.025 1.473-.124a9.6 9.6 0 002.383-.832 6.596 6.596 0 011.449-.55 3.277 3.277 0 011.6-.042c.237.054.286.054.253-.115-.016-.112-.05-.224-.066-.34-.058-.397-.041-.77-.19-1.109a.46.46 0 00-.22-.202 1.308 1.308 0 00-.38-.116 2.69 2.69 0 00-.803 0 4.03 4.03 0 00-1.208.372c-.414.203-.828.43-1.138.617a3.269 3.269 0 01-1.68.484c-.393 0-.654-.013-1.047-.054a3.74 3.74 0 01-1.544-.426c-.107-.054-.165-.037-.206.074a3.463 3.463 0 00-.207 1.597zm18.41 4.344c-.137.021-.422.058-.588.067a.786.786 0 01-.16-.021c.024-.05.04-.066.07-.079.202-.103.417-.198.566-.314.083-.062.066-.124.042-.178-.278.124-.538.178-.832.228-.02 0-.033-.021-.041-.034.227-.17.53-.306.695-.455.111-.09.029-.116-.009-.153-.24.083-.48.162-.732.232a.29.29 0 01-.116-.013c0-.05.05-.07.091-.095a3.86 3.86 0 00.704-.463l-.013-.062-.083-.009c-.194.034-.624.096-.86.12-.116 0-.095-.066-.075-.082.187-.083.331-.182.468-.327.05-.054.041-.104.025-.128-.224.103-.48.107-.63.124-.028-.038.01-.083.026-.1.182-.07.219-.128.314-.19.062-.041.195-.132.224-.182.012-.017.008-.066-.005-.083a2.897 2.897 0 01-.55.133.277.277 0 01-.1-.017c.017-.041.026-.074.05-.087.257-.132.394-.186.576-.298a.446.446 0 00.124-.161l-.017-.025c-.207.066-.418.137-.633.194-.041-.008-.062-.033-.1-.062a.252.252 0 01.075-.074 3.38 3.38 0 001.171-.675.922.922 0 00.224-.252l-.03-.05c-.413.29-.814.542-1.29.729-.095-.009-.075-.067-.042-.091.042-.042.166-.182.265-.315a3.737 3.737 0 001.084-.625c.025-.025.038-.095.021-.14-.211.095-.534.277-.815.38l-.054-.016a.564.564 0 01.066-.145c.19-.124.464-.319.679-.555.008-.029.02-.066 0-.099a3.77 3.77 0 01-.559.228c-.062-.042.013-.15.02-.174.262-.215.386-.356.514-.538.025-.041.025-.079 0-.145-.145.104-.352.166-.513.228l-.046-.013c-.008-.053 0-.041.017-.082.19-.174.352-.31.468-.51.012-.02.008-.074-.013-.111-.157.054-.277.1-.447.14a.132.132 0 01-.058-.012c.009-.054 0-.066.021-.107.116-.1.232-.236.34-.398.028-.041.024-.082.003-.111-.082.02-.231.041-.306.05-.033.008-.074-.03-.095-.067l.29-.207a.248.248 0 00.05-.078c-.038-.017-.067-.038-.092-.03-.124.017-.24.03-.364.054-.273.058-.273.096-.298.174a6.054 6.054 0 01-.302.902c-.037.083-.083.162-.165.195-.116.058-.091.12-.124.231-.05.224-.083.207-.174.427a1.2 1.2 0 01-.257.413h-.062l-.02-.31c-.025-.207-.067-.161-.1-.372-.02-.186.025-.385.05-.546.02-.187.041-.51.041-.692-.016-.012-.033-.04-.058-.057a.174.174 0 00-.058.082c-.037.141-.103.364-.124.51-.045.339.025.665 0 1.009a3.848 3.848 0 00-.041 1.068c.112-.013.103-.025.26-.087.207-.083.356-.112.567-.298.15-.129.125-.381.178-.588.07-.248.166-.34.265-.38.03-.009.058.004.087.012-.058.14-.091.215-.145.364-.05.128-.1.34.042.364l.103.017c.008.024.008.062-.012.082-.133.129-.24.282-.849.456-.07.02-.223.206-.231.277-.013.095-.013.207.008.364.062.608.364 1.18.703 1.742.286.48.497.844.807 1.159.145.132.298.231.538.12.128-.062.29-.162.331-.199.02-.025.025-.066.02-.103zm-8.276-8.755c.017.24-.029.302-.335.223-.323-.1-.472-.066-.679-.302-.124-.145-.281-.145-.413-.008-.062.074-.108.149-.207.165-.017-.033-.038-.078-.025-.116a.46.46 0 01.252-.314c.095-.05.211-.083.31-.112.286-.112.427-.281.427-.616 0-.19.058-.381.058-.58 0-.14-.05-.186-.186-.14-.236.09-.456.182-.691.281a.283.283 0 00-.166.157c-.066.124-.108.248-.166.373-.053.07-.099.037-.115.008a7.545 7.545 0 00-.365-.517c-.103-.124-.103-.166.013-.253l.385-.335c.19-.178.265-.414.285-.679v-.36c-.008-.157.025-.202.182-.182a.868.868 0 01.315.091c.174.075.347.174.521.265.091.058.157.137.166.253.004.136-.083.223-.207.173a3.807 3.807 0 00-.584-.202c-.099-.025-.198.029-.215.124-.041.227.153.24.137.302-.05.161-.31.207-.348.356-.029.136-.029.223.091.198.327-.066.646-.269.898-.372.215-.091.327-.058.356.182.116.703.223 1.308.302 1.937zm5.09-2.235c.062.017.14.054.19.1.12.277.377.587.7.753a.796.796 0 00.29.082c.028-.124.082-.33.082-.558a.739.739 0 00-.22-.538 2.152 2.152 0 00-.496-.373.211.211 0 00-.244.021c-.004.041-.004.103.02.14.08.137.27.261.352.39.03.132.021.124-.087.082a2.09 2.09 0 01-.591-.517c-.095-.107-.158-.107-.224.008a2.003 2.003 0 00-.298.89.91.91 0 00.497.952c.153.066.265.05.34-.095.078-.145.132-.27.181-.43.025-.083.025-.117-.037-.191a2.735 2.735 0 00-.248-.277.36.36 0 00-.124-.1.166.166 0 00-.034.104c.005.128.025.26.03.389 0 .033-.005.083-.025.112a.252.252 0 01-.141-.166c-.083-.306-.07-.575.087-.778zm-14.3-4.506l.24.285c.098.187.152.356.202.505.041.15.103.15.199.083a.337.337 0 00.14-.29.964.964 0 00-.054-.26c-.082-.323-.024-.596.257-.799.095-.066.165-.174.128-.29-.041-.161-.078-.314-.14-.463-.025-.066-.116-.083-.178-.05-.315.166-.687.642-.402 1.039.013.025-.004.1-.025.14-.26-.26-.773-.79-.926-.777-.042.074-.075.227-.042.538.037.302.116.612.344 1.034a.765.765 0 00.194.22c.054.049.166.103.248.103a.457.457 0 00.017-.248 9.55 9.55 0 00-.248-.758zM22.7 3.919c.219-.042.397-.104.48-.137.356-.136.591-.364.67-.753.025-.103-.037-.161-.149-.19l-.232-.062c-.227-.067-.273.029-.36.248-.066.165-.136.356-.314.496-.054.046-.24-.09-.29-.124.348-.207.575-.538.745-.935.041-.074 0-.149-.079-.174a.844.844 0 00-.355-.037 1.783 1.783 0 00-1.283.956c-.017.041 0 .136.029.149.05.02.174.008.227-.013.033-.004.05-.05.07-.082.146-.257.39-.414.671-.538.083-.042.112-.013.066.083-.054.07-.558.426-.57.475-.067.145.032.166.115.166l.153-.041a.677.677 0 00.402.513zm-7.655-.042c-.009.124-.054.195-.166.153-.232-.099-.372-.351-.633-.438-.095-.033-.153.054-.166.14-.041.265-.082.501-.082.6 0 .365.194.563.389.758.057.05.057.082-.005.111l-.798.447c-.075.05-.166.062-.248 0-.08-.07-.104-.157-.08-.244.096-.401.162-.815.266-1.208.165-.62.434-.832.885-.89.162-.025.282-.025.406-.025.132 0 .19.025.207.145.016.083.02.174.02.451zm.604 2.744c0-.302-.244-.39-.348-.646-.1-.252-.19-.252-.393-.07-.232.22-.372.41-.455.724a1.738 1.738 0 00.008.869c.02.087.07.186.166.157a.166.166 0 00.12-.165c0-.257.024-.505.153-.67a.38.38 0 01.116-.112c.04.062.024.136.024.149-.037.19-.066.384-.107.575-.025.128-.025.198.041.314.075.116.137.128.186.05.236-.377.489-.919.489-1.175zM2.73 7.457a2.317 2.317 0 00-.165-.745c-.1-.236-.249-.373-.348-.373-.091 0-.302.249-.372.451-.183.51-.083.923.21 1.411.042.062.125.178.236.062.091-.103.162-.177.249-.29a.805.805 0 00.19-.516zm11.148 7.986c-.054-.426-.373-.84-.91-1.2-.112-.046-.125.029-.125.124.054.592.124 1.187.199 1.713.02.116.074.149.182.091.161-.074.314-.153.467-.24.141-.083.228-.161.187-.488zm4.87-4.842c-.083-.207-.223-.293-.43-.31-.207-.025-.381-.054-.6-.087-.125.017-.207.116-.278.282.004.033.017.074.042.082.07.025.198.05.215.062a.41.41 0 01.124.17c-.016.058-.091.12-.186.137-.124.024-.124.124-.104.252a.728.728 0 00.162.36c.083-.05.124-.07.186-.137a.281.281 0 00.083-.24c-.017-.269.132-.463.318-.641l.042.025c-.03.153-.112.265-.129.418-.04.314-.144.58-.455.79.095.124.331.033.406-.041a.947.947 0 00.281-.439l.05-.157a.124.124 0 01.041.012c.062.116-.025.352.017.522a.389.389 0 00.153-.124c.116-.274.174-.68.062-.931zm3.898-6.372c-.054 0-.27.004-.331.017-.05.012-.075.128-.05.148.062.042.1.075.15.092.194.02.28.02.504.057a.171.171 0 01.112.063c-.021.016-.042.045-.083.053-.414.05-.538.042-.828-.153-.078-.033-.107.025-.082.1.041.14.157.256.372.343.17.074.335.165.509.161.265-.008.455-.024.674-.062.116-.016.232-.082.249-.14.02-.058 0-.187-.066-.27l-.158-.157c-.248-.26-.41-.426-.778-.389-.05.005-.124.137-.194.137zm.256 2.756c0-.153-.02-.265-.062-.402a.703.703 0 00-.612-.504c-.153-.005-.228.024-.166.165.017.05.154.195.207.31.07.141.137.286.137.41a.414.414 0 01-.037.166c-.091-.05-.141-.162-.162-.216-.041-.132-.05-.21-.09-.285-.038-.066-.084-.083-.104-.083-.058 0-.083.02-.087.1a1.188 1.188 0 00.65 1.187c.115.041.144.013.182-.09a2.483 2.483 0 00.144-.754zM2.483 5.388c-.058.219-.07.364-.062.488.004.157.082.29.227.356a2.772 2.772 0 001.378.215c.017 0 .062-.03.062-.041-.012-.096-.062-.112-.149-.137-.194-.066-.716-.207-.786-.29-.054-.074-.029-.153.058-.165a.442.442 0 01.228.037c.128.062.24.145.372.22.041.024.091.07.14 0 .038-.063.075-.117-.008-.179l-.306-.24c-.265-.21-.662-.31-1.158-.264zm9.463 3.426c-.02.045-.062.09-.107.145-.05-.05-.1-.083-.125-.137a9.943 9.943 0 01-.496-1.655c-.008-.108.033-.145.124-.14.236.024.443.132.65.24.033.024.058.094.062.144.041.468-.017.993-.108 1.399zm-10.192.952l-.033-.017c.021-.281.166-.683.112-.786a.58.58 0 00-.285.029c-.1.041-.141.14-.162.306-.025.368.033.745.112 1.076.025.124.074.136.165.05.236-.216.46-.489.638-.7.124-.161.145-.314.095-.467-.042-.129-.128-.178-.224-.178-.103 0-.14.078-.165.157-.058.203-.153.347-.253.525zm19.11-.849c.186 0 .339.037.388.054.224.083.323.182.365.26a.259.259 0 01.04.15.401.401 0 01-.367-.075c-.199-.186-.489-.265-.662-.186.012.128.136.29.24.372.347.27.653.315 1.026.228.062-.025.087-.112.083-.186-.013-.24.004-.497-.224-.704-.248-.236-.604-.227-.848-.124-.042.02-.104.05-.133.083a.212.212 0 00.091.124zM12.256 2.36c.074-.017.04.016.02.082-.041.211-.165.377-.314.526-.083.074-.1.19-.042.248.108.1.232.013.315-.066.165-.186.269-.414.364-.637.116-.278.091-.621-.041-.853-.07-.099-.178-.111-.261-.037a1.436 1.436 0 00-.505.993c0 .054.004.153.041.174.19-.083.307-.29.414-.426zm5.048 10.013c.02-.016.054 0 .066.009 0 .223.054.492.083.57a.257.257 0 00.083-.057l.062-.302c.14-.426.037-.766-.141-1.155-.033-.074-.083-.082-.157-.05-.054.025-.1.063-.054.137.041.062.037.112 0 .174-.058.112-.1.232-.161.364-.025.083-.03.15-.038.248l-.062 1.531c.025.083.075.067.104.017.033-.083.058-.161.074-.248.042-.24.112-.249.124-.489.021-.248.021-.496.013-.744zM3.285 2.917a.227.227 0 01.009-.095l.256.041c.124.025.187.009.228-.086.07-.183.033-.348-.157-.385-.29-.054-.58.041-.828.099-.161.054-.199.223-.083.34.187.177.364.355.559.512a.614.614 0 00.525.125c.083-.021.154-.075.154-.15a.207.207 0 00-.062-.148.559.559 0 00-.145-.083zm-.26 11.144c-.017.082-.054.153-.19.145a1.705 1.705 0 01-.373-.054c-.132-.038-.17-.087-.178-.137a2.261 2.261 0 01.042-.82c.016-.04.157-.123.215-.156.178.02.318.05.447.082.05.03.149.178.157.199a.83.83 0 01.025.248c-.05.207-.112.385-.145.493zm13.82 7.469c.332.124.588.161.687.14a.198.198 0 00.154-.223c-.005-.091-.05-.166-.166-.199-.252-.054-.513-.09-.753-.178-.14-.041-.248-.037-.373.058-.19.145-.372.22-.608.265a.29.29 0 00-.153.054c-.066.087-.05.149.054.207.41.037.794-.042 1.158-.124zm1.362.81c.207 0 .36-.04.5-.132a1.241 1.241 0 01.6-.265c.092-.016.183-.111.19-.186 0-.103-.082-.116-.152-.14-.199-.063-.435-.054-.637-.104-.067-.012-.162-.012-.216.03-.426.43-.509.33-.711.541-.054.07-.054.157.095.195.116.029.265.053.33.062zM11.123 6.162c0-.107.19-.273.294-.256.02.008.04.02.057.041l.042.224c.012.087.041.165.087.165.215.017.467-.132.587-.318.129-.2.22-.427.327-.642.1-.236.253-.09.199.054-.137.41-.306.828-.439 1.229-.041.149-.062.157-.207.108l-.682-.245a.352.352 0 01-.265-.36zm5.238 10.213c.112.054.104.033.253-.05a.34.34 0 00.132-.24l-.041-.898c0-.029-.042-.074-.058-.074-.124 0-.273-.025-.373.029-.19.103-.351.252-.525.389-.066.066-.004.132.095.124.083-.033.178-.075.26-.12l.158-.083a.141.141 0 01-.016.075c-.15.165-.261.364-.464.471-.054.009-.041.14.037.145a.681.681 0 00.228-.108c.124-.099.178-.16.302-.264.041.062.07.111.008.165l-.33.298c-.05.05-.013.1.045.091a.652.652 0 00.236-.09c.082-.055.153-.13.227-.208.004.009.05.054.042.058a3.715 3.715 0 01-.216.29zM5.772 5.967c-.05.5-.173 1.005-.397 1.233-.182-.348-.306-.753-.43-1.109.1-.124.223-.31.277-.455.025-.07.066-.083.128-.033.15.136.278.248.422.364zm.592 7.134a.414.414 0 01-.227.285.913.913 0 01-.39.104c-.074 0-.128-.017-.14-.083-.041-.232-.095-.447-.133-.67-.004-.054.042-.125.087-.166.145-.137.331-.174.526-.186.041 0 .178.058.199.095.04.207.062.393.078.62zm-1.808-2.678c-.265.042-.497.278-.455.373.004.207.045.405.157.583.07.104.124.129.232.058a1.986 1.986 0 00.794-.81c.05-.1-.054-.13-.153-.179-.132-.062-.273-.062-.348-.025-.074.038-.103.116-.115.178-.083.302-.1.31-.19.414a.803.803 0 01.078-.592zm1.792 11.36c.016-.034.024-.059.053-.063a.623.623 0 01.178 0c.236.066.455-.103.675-.137.05-.004.103-.012.161-.004.145.004.29.009.451-.033.066-.025.153.009.228.042.252.111.496.173.74.029a3.8 3.8 0 01.394-.236c.227-.087.248.062.256.149a.215.215 0 01-.124.128c-.786.281-1.465.285-2.346.178a1.986 1.986 0 01-.666-.054zm-4.925-8.277a.455.455 0 00.104.356l.037.037-.02.067a1.862 1.862 0 01-.406-.054c-.058-.021.103-.108.116-.207.029-.203.083-.538.083-.782 0-.042-.104-.083-.104-.124a.149.149 0 01.05-.083c.29.07.33.066.389.203.058.124.111.33.198.48.017-.009.042-.017.054-.03.013-.136.008-.335.013-.426.008-.074.04-.111.12-.111.062 0 .215.004.277.016.008.013.008.025.008.042 0 .041-.05.053-.062.058-.137.05-.145.062-.207.442l-.066.439c-.008.033-.017.1-.037.145-.038.004-.104 0-.116-.033a6.296 6.296 0 00-.34-.691l-.04-.004c-.034.09-.034.177-.055.264zm9.104 2.04a.86.86 0 000-.252c-.05-.14-.112-.277-.091-.402.062-.215.107-.438.087-.662a2.789 2.789 0 01.025-.827c.074.025.132.074.149.124.02.087.04.174.04.252.03.236.01.464-.003.691-.037.447-.075.861-.062 1.3.008.066.02.153.041.215.058.136.03.277-.078.43l-.067-.029c-.05-.186-.173-.438-.227-.637-.009-.037 0-.066.05-.075.082-.016.136-.066.14-.124zm4.303-3.29c-.182-.016-.368-.177-.356-.467-.09.124-.202.248-.302.294.009.1.253.24.422.31.096.128.166.19.29.331.075-.19.166-.352.195-.455a1.469 1.469 0 00-.145-.675c-.137-.153-.352-.28-.563-.417-.103.111.029.351.286.496a.423.423 0 00.202.538zm-12.372-.442c.128-.009.265-.03.418-.05.1-.025.21-.05.215-.174.008-.111-.124-.173-.215-.198a1.97 1.97 0 00-1.304.128 1.183 1.183 0 00-.264.19c-.1.108-.08.174-.005.232a.984.984 0 00.356.166c.021-.091.042-.24.07-.331.141-.232.539-.274.816-.282.066.013.066.095.012.112-.078.062-.236.05-.277.116 0 .07.066.095.178.087zm.885 2.4c-.004-.05.054-.112.058-.145.013-.066.013-.157.013-.228.008-.178-.03-.467-.03-.641l.096-.062c.033-.012.058.008.095.041.083.083.27.29.356.369.008 0 .02-.021.025-.025v-.133a.974.974 0 00-.042-.256c-.033-.112-.111-.19-.024-.199l.339-.025c-.033.067-.058.116-.07.216-.017.136-.042.26-.046.388.017.2.058.398.075.563 0 .013-.025.03-.05.042a.31.31 0 01-.095-.062c-.166-.166-.282-.32-.497-.522a.182.182 0 00-.029.091c.042.128.095.273.182.393.054.075.067.1-.07.15a.648.648 0 01-.281.04zm6.05.037c.195-.12.273-.521.224-.716a.257.257 0 00-.067-.136c-.062-.062-.132-.042-.165.066-.037.153-.054.318-.075.463a1.448 1.448 0 00-.438-.012c-.15.02-.439.107-.439.285 0 .29.666.224.96.05zm1.167-2.003a.331.331 0 00.083.232c.298.31.707.633.968.695.232.062.426.199.567.385l.136.186c.1.124.228.207.402.232.029.008.066 0 .1 0-.026-.104-.026-.116-.1-.19-.613-.547-1.262-.973-1.895-1.416-.062-.037-.174-.111-.261-.124zm-6.397 7.035v-.009c-.062-.26-.133-.513-.199-.765-.05-.091-.14-.025-.132.012-.066.187-.133.373-.19.567a.273.273 0 000 .174c.099.273.19.542.297.815.017.037.067.062.095.083.025-.033.063-.07.07-.103zm1.084-6.489c.016.05.041.112.05.17.004.042.004.075-.009.1-.004.012-.029.008-.054-.005-.128-.058-.273-.14-.389-.062-.04.03-.024.104.03.129l.364.149c.165.062.206.136.173.33-.029.187-.165.261-.327.307-.066.016-.136.025-.227.016-.012.058.004.124-.037.15-.03.016-.038.012-.067.024a1.597 1.597 0 01-.124-.451c0-.037.013-.041.025-.054.054.017.104.091.186.17.1.033.27.062.294.033.05-.062.07-.1.07-.124 0-.042-.057-.083-.107-.104-.128-.07-.199-.095-.331-.149-.124-.05-.145-.16-.145-.264 0-.112.058-.232.236-.29.054-.02.153-.041.207-.058a.82.82 0 00.029-.186c.029-.004.083-.013.09.008zM2.665 5c-.248 0-.406-.067-.654-.042-.178.013-.352.091-.525.157-.104.05-.083.096.008.133a.483.483 0 00.24.062c.513-.041 1.088-.1 1.601-.149.03-.041.054-.074.083-.14-.195-.129-.447-.104-.683-.174zm5.892 7.659a.523.523 0 00-.12.108.323.323 0 01-.103.074l-.07-.041.111-.27c.042-.103.083-.115.182-.049l.091.074c.075.063.174.112.265.07.087-.04.041-.165-.05-.21-.132-.083-.231-.108-.393-.207-.099-.058-.14-.145-.14-.27 0-.103.07-.227.202-.24.05-.011.112-.011.182-.011.087 0 .145-.013.2-.087.04-.054.086-.087.098-.03a.756.756 0 01-.024.406c-.03-.008-.05-.008-.075-.02-.079-.125-.182-.183-.269-.17-.083.012-.124.074-.062.14.112.116.269.178.401.253.19.103.178.248.154.352a.269.269 0 01-.278.223.527.527 0 01-.302-.095zm-.376-.38c.016.318-.24.434-.422.43-.17 0-.27-.038-.327-.207-.03-.1-.062-.402-.083-.513-.033-.042-.091-.058-.178-.083-.041-.008-.045-.042-.054-.079.062-.029.174-.062.253-.074.182-.03.182-.017.21.149.026.19.054.389.092.579.062.186.26.145.26-.012 0-.15.009-.319 0-.476-.029-.038-.082-.116-.14-.17-.07-.083-.075-.108.025-.145.231-.09.248-.149.28.157.013.116.084.294.084.443zm.215 1.63l.58-.137c.152-.041.24-.207.227-.352-.017-.111-.083-.173-.199-.198a1.572 1.572 0 00-.745.103c-.02.199.05.414.137.58zM3.074 11.85a1.03 1.03 0 00-.248.037.913.913 0 01-.364.038c-.083-.009-.215-.063-.294-.083-.087.008-.174.087-.207.21-.016.125.058.212.195.237.277.062.538.111.794.111.1 0 .112-.012.116-.095.013-.157.008-.29.008-.455zm6.621-5.917a1.676 1.676 0 01-.36-.112c-.041-.012-.07-.112-.07-.165.012-.145-.025-.29 0-.443.012-.083.058-.108.136-.091.112.025.216.05.323.083.14.057.352.446.29.583-.062.124-.174.14-.315.149zm-2.387 6.782a.414.414 0 01-.116.112c-.137.09-.385.144-.555.256-.083.058-.041-.14-.05-.215l-.086-.463a.604.604 0 00-.15-.249c-.049-.058.092-.083.162-.103l.27-.083c.098-.033.123.037.094.058-.136.1-.124.145-.107.273.02.124.02.26.024.364.021.05.05.116.087.162.083-.025.174-.087.174-.112l.02-.265c.1-.124.117-.062.133-.008.042.099.062.161.1.273zm.41-2.938a7.687 7.687 0 01-.158-.55c-.012-.075.05-.116.12-.104.248.054.492.112.74.178.083.017.083.083.03.137a1.763 1.763 0 01-.555.405c-.112.062-.116.017-.178-.066zm10.72-6.563a1.82 1.82 0 00-.285-.687c-.112-.14-.248-.153-.372-.025a.96.96 0 00-.108.125c-.124.157-.112.206.075.298.28.082.442.248.645.455zM5.289 19.291a1.159 1.159 0 00-.372.331c-.083.153-.174.298-.257.447-.029.07-.078.24-.099.352l.05.05a2.069 2.069 0 00.364-.27c.21-.207.26-.401.376-.815l.021-.05zM23.524 2.276a4.63 4.63 0 00-.405-.654c-.112-.14-.166-.153-.29-.025a1.008 1.008 0 00-.112.124c-.124.153-.198.344.004.373.174.029.41 0 .522.078.103.067.194.137.24.162zM2.544 13.394c-.032.303-.024.303-.024.514 0 .115.054.115.157.124.095.004.124-.083.145-.195l.062-.418c.017-.136.025-.215-.058-.227-.153-.021-.269.074-.281.202zM4.16 7.8a1.597 1.597 0 01-.39-.137c-.206-.107-.405-.33-.372-.537.017-.096.07-.125.153-.08.158.117.29.29.406.415a.818.818 0 01.207.339zm1.551 4.916c.004.083.075.327.1.467.012.075.029.133.136.12.14-.02.19-.082.17-.194-.017-.128-.05-.257-.075-.389-.024-.124-.078-.194-.19-.19-.116.012-.153.053-.14.186zm6.15-7.808c-.088.157-.166.314-.27.45-.078.112-.202.183-.314.278-.108.029-.112.02-.075-.087.162-.265.315-.472.489-.7.124-.066.17-.012.165.059zm8.3 4.295c0 .1-.017.19-.05.285l-.025.013c-.128-.323-.438-.844-.417-.898-.009-.037.074-.058.111-.05l.141.058c.083.19.166.372.24.592zm.902-6.857c.017.004.066.017.104.05.062.05.07.107-.013.14-.194.092-.521.265-.732.344-.042.02-.087.025-.07-.05.04-.124.537-.484.711-.484zm-7.08 8.992c-.136 0-.252.108-.252.215.004.12.157.248.293.248.125 0 .211-.082.211-.207.009-.148-.099-.256-.252-.256zM3.074 21.778c-.028 0-.082.091-.128.095-.165.013-.223.03-.223.1 0 .095.05.144.128.12.248-.075.306-.067.629-.042l.112-.132c-.038-.033-.066-.075-.112-.087a1.85 1.85 0 00-.406-.054zM17.648 9.869c-.054.033-.099.066-.082.128l.04.1c.096-.017.204-.025.303-.017.132.041.356.091.497.116.033.008.074-.03.099-.062.008-.004-.017-.03-.03-.054-.19-.19-.508-.194-.827-.207zM8.532 5.686l-.339-.15c-.02-.012-.033-.074-.012-.099.074-.111.153-.215.231-.314.042-.042.075-.037.096.016l.17.422c.032.083-.005.116-.146.125zM4.08 9.844c.083-.016.124.033.112.108-.009.041-.021.058-.087.09a1.497 1.497 0 01-.753.026c-.083-.013-.137-.03-.15-.05a.157.157 0 01.096-.066zm2.375-6.641c-.025.008-.054.029-.07.016-.22-.124-.534-.29-.733-.418-.045-.066-.016-.09.046-.082.161.053.443.136.604.198.104.05.137.145.153.286zm3.373 4.833c.024.037.05.074-.021.186-.112.174-.14.352-.215.592a.645.645 0 01-.075.14c-.025.025-.062.034-.09.05-.01-.029-.026-.066-.021-.09l.223-.73c.033-.086.1-.132.199-.148zm8.081-2.442a4.014 4.014 0 01-.869-.306c-.095-.082-.079-.078.046-.082l.815.219c.157.12.124.116.008.165zm-3.364 5.181a.277.277 0 00-.124-.153c-.042-.025-.12-.012-.166.025a.857.857 0 00-.132.116c-.062.087-.025.174.074.244.083.058.174.054.228-.025.05-.062.095-.108.12-.207zM9.09 6.778c-.029.062-.037.124-.079.17-.111.132-.235.26-.355.389-.12.053-.125-.021-.112-.08.112-.206.269-.38.414-.55.016-.016.062-.028.082-.016.021.012.033.041.05.083zM4.415 5.64c-.029.02-.467-.662-.521-.803 0-.025.07-.074.107-.103a.195.195 0 01.075.066c.14.298.385.803.364.823zM4.23 8.367l-.186-.083c-.137.03-.249.091-.402.108-.161.012-.227-.021-.29-.062.026-.05.112-.1.24-.124.075-.013.402-.042.688-.017zM21.07 4.89l.48.36c.05.033.042.1.062.14l-.107-.012c-.207-.103-.422-.186-.559-.389-.116-.17.075-.149.124-.099zm-12.157.592l-.054.083c-.02-.025-.05-.05-.062-.083-.041-.083-.041-.178-.05-.265-.024-.207-.012-.319.112-.443.05-.058.091-.025.091.03.009.26-.004.421-.037.678zM5.834 4.73c.046.016.125.509.178.761a.562.562 0 010 .186c-.02.058-.041.07-.09.02-.083-.26-.125-.525-.166-.773-.017-.074-.017-.153.078-.194zM19.87 7.72c.199.112.43.31.526.427.025.024.012.09 0 .14-.033-.012-.07-.016-.095-.037-.166-.103-.319-.22-.472-.327-.02-.016-.025-.136-.041-.161a.174.174 0 01.082-.042zM10.82 3.46c.034.021.05.042.071.07a.174.174 0 01-.07.075c-.141.054-.468.054-.604-.025a.422.422 0 01-.07-.082l.094-.054a1.29 1.29 0 01.58.02zm3.725.795c.132.207.19.405.248.629 0 .012-.008.016-.008.05-.033-.021-.05-.025-.062-.042a1.159 1.159 0 01-.331-.546c-.017-.05-.009-.091.053-.128a.224.224 0 01.1.037zM11.97 18.418c.157-.091.203-.161.343-.248.058-.033.05-.042.021-.096-.033-.062-.062-.062-.145-.04-.153.053-.215.09-.372.152-.066.025-.091.054-.02.104zM7.126 3.745c.19-.133.397-.203.608-.282.033-.008.083.005.12.038l-.075.066c-.165.116-.33.207-.488.302a.983.983 0 01-.165-.029.124.124 0 010-.095zM2.18 7.8c-.046-.223-.108-.497-.07-.695a.285.285 0 01.086-.124c.042.037.083.066.087.103.042.232-.025.497-.041.712zm10.77-4.994a3.53 3.53 0 01.56-.327 2.09 2.09 0 01-.572.608c-.012-.083-.041-.232.013-.281zm-2.648 8.644c0 .09.042.19.116.26.042-.033.075-.095.075-.124.016-.174.029-.352.029-.534.02-.07-.083-.09-.108-.016-.041.136-.107.273-.112.414zm9.087 7.158l-.765.257c.178.203.695.037.765-.257zM8.12 4.705c.012.203-.025.455-.137.641-.012.025-.041.042-.074.066-.013-.037-.05-.066-.042-.09.042-.208.095-.456.145-.663.008-.012.041-.025.058-.029zm10.717 14.632c.165 0 .323-.005.447-.042.111-.07.107-.215.145-.314l-.042-.013-.182.166a2.579 2.579 0 01-.372.074.258.258 0 00-.058.075c.02.029.041.05.066.054zm-1.531-8.202c.054-.12.103-.227.145-.34.008-.024-.03-.086-.075-.127a.323.323 0 00-.09.041 1.655 1.655 0 00-.24.364c.016.03.098.03.256.062zM4.494 7.895l.161-.414c.03-.008.054-.008.075.005.024.124.004.322-.009.4-.024.113-.066.179-.165.228a.674.674 0 01-.062-.219zm9.34 3.037c-.113 0-.2.067-.208.166 0 .083.091.161.19.161.104-.008.183-.082.19-.173 0-.1-.061-.154-.173-.154zm-.1 1.018c0-.111-.066-.186-.186-.186-.096 0-.166.062-.166.15 0 .098.104.198.207.19.091 0 .145-.067.145-.154zm-.418-1.042c0 .09-.058.144-.145.144-.116 0-.203-.07-.203-.178 0-.082.083-.165.166-.165.087-.008.182.074.182.199zm.074.413c-.099 0-.165.062-.165.145 0 .087.09.166.186.166.074 0 .145-.079.145-.166.004-.078-.07-.145-.166-.145zm-1.088 7.399c-.128 0-.24.062-.236.132.008.07.108.166.186.166.083 0 .129-.087.129-.199-.004-.082 0-.099-.079-.099zM4.415 3.062c-.062-.248-.033-.472.03-.724.103.215.11.563-.03.724zm9.31 7.25c-.066.041-.124.107-.115.136.008.05.062.095.095.145a.27.27 0 00.112-.132c.012-.03-.05-.083-.096-.15z");
    }
}

