package org.silentsoft.simpleicons.icons;

/**
 * <img src="doc-files/virgin.svg" width="48" height="48"/>
 * <p>The Virgin Icon.</p>
 * <code>virgin</code> is used as the icon's slug.
 */
public class VirginIcon extends org.silentsoft.simpleicons.Icon {

    public VirginIcon() {
        super();

        setTitle("Virgin");
        setSlug("virgin");
        setHex("E10A0A");
        setSource("https://www.virgin.com/img/virgin-logo-square.svg");
        setSvg("<svg role=\"img\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>Virgin</title><path d=\"m7.951 9.821.008-.004c.044-.06.105-.114.13-.18.04-.11.066-.228-.005-.34-.016-.026-.024-.056-.036-.084-.035-.09-.08-.118-.204-.116a.56.56 0 0 0-.281.086 3.11 3.11 0 0 0-.298.211c-.05.04-.09.092-.135.137-.06.06-.074.14-.11.21a.46.46 0 0 0-.053.222c.002.094.041.18.113.23.08.054.184.092.29.042a1.84 1.84 0 0 0 .216-.116c.133-.086.282-.156.365-.298M24 9.423c-.008-.01-.02-.02-.023-.033a.635.635 0 0 0-.173-.28.3.3 0 0 0-.123-.06c-.039-.01-.082.002-.122-.007a.986.986 0 0 0-.688.098c-.217.113-.43.233-.65.341a5.64 5.64 0 0 1-.448.192c-.106.042-.167.02-.234-.06-.009-.012-.02-.025-.032-.028-.05-.012-.05-.055-.063-.09-.005-.015-.01-.04-.017-.042-.068-.011-.046-.038-.016-.07.01-.01.015-.023.025-.038-.034-.032-.09-.05-.064-.11.002-.004-.008-.016-.015-.019-.044-.019-.024-.052-.021-.082.005-.057.006-.064.032-.088l-.052-.05.053-.094c-.046-.01-.063-.038-.036-.066.032-.031.027-.06.022-.096-.002-.016-.005-.037.003-.05.02-.03.016-.058.006-.09-.006-.02.006-.044.01-.07-.047-.019-.061-.054-.042-.104.005-.012.009-.03.004-.04-.025-.047.002-.081.019-.1-.013-.05-.03-.084-.03-.119a9.858 9.858 0 0 1 .002-.412c0-.022.02-.043.031-.066-.03-.053-.03-.053.014-.096-.014-.03-.032-.057-.037-.085-.008-.053.051-.034.07-.054-.008-.05-.02-.095-.022-.14 0-.041-.007-.082.01-.125.014-.038.002-.085.002-.131l-.046.004-.007-.149c-.002-.054.008-.1.066-.102v-.127c-.021-.032-.045-.061-.062-.094-.022-.043.013-.073.041-.107-.057-.027-.067-.073-.08-.123-.016-.063-.03-.142-.075-.18-.042-.036-.077-.085-.131-.109l-.033-.013c-.22-.099-.437-.061-.647.024-.114.046-.218.117-.326.178a.343.343 0 0 0-.07.052c-.078.075-.154.152-.23.228a1.096 1.096 0 0 0-.08.095.747.747 0 0 1-.338.244.362.362 0 0 1-.275-.01c-.066-.029-.117-.039-.179 0a.165.165 0 0 1-.093.018c-.273-.036-.497.075-.682.252a.927.927 0 0 0-.263.547c-.015.107-.015.217-.02.325-.01.179-.017.357-.026.536l-.036.682c-.007.138-.009.276-.016.413-.016.32-.035.64-.05.961a.932.932 0 0 0 .007.182c.023.16.08.25.22.279a.52.52 0 0 0 .331-.028c.088-.041.18-.077.26-.13.099-.066.219-.12.235-.26 0-.003.003-.005.004-.008.04-.07.08-.14.115-.213a.12.12 0 0 0 .013-.072c-.007-.032-.048-.055-.007-.099.019-.02 0-.07.007-.106.007-.039.022-.076.034-.118l-.061-.049.032-.03c-.068-.063-.013-.116.022-.17-.019-.021-.062-.004-.057-.05.012-.12-.027-.244.034-.36.002-.004.005-.013.003-.015-.047-.054-.004-.1.008-.153.03.038.048.006.067-.002l-.011-.068c-.01-.052.002-.11-.054-.148-.013-.008-.016-.051-.006-.07a.36.36 0 0 1 .074-.096c.03-.029.035-.057.02-.094a.758.758 0 0 1-.036-.106c-.005-.024-.011-.057 0-.075.012-.018.044-.022.066-.032v-.115l-.04-.026.026-.057c.055.009.055.009.044-.042-.001-.008-.004-.02 0-.024.045-.053.025-.117.033-.176.002-.017 0-.038.01-.049.049-.058.05-.128.056-.188.038-.034.09-.058.1-.093.022-.077.078-.12.134-.164a.213.213 0 0 0 .066-.078.387.387 0 0 1 .102-.137c.068-.054.148-.093.22-.143.11-.076.227-.039.342-.026.023.003.047.025.064.045.066.075.106.164.03.304a.358.358 0 0 0-.01.344c.102.188.009.359.026.538-.04.054-.02.109-.002.164a.066.066 0 0 1 0 .041.495.495 0 0 0-.015.327c.006.018.002.04 0 .061-.01.156-.039.31-.035.467.002.13 0 .258.005.387a.448.448 0 0 0 .118.286c.04.045.095.077.145.111.044.03.049.047.01.08a.368.368 0 0 1-.051.035c-.066.04-.132.079-.199.116l-.696.39-.996.558c-.196.11-.392.219-.586.33-.224.13-.446.264-.671.393-.031.018-.071.022-.106.034-.016.005-.034.01-.046.021a.766.766 0 0 1-.221.14c-.07.033-.14.064-.206.103-.12.073-.238.152-.357.227l-.557.343c-.236.145-.474.288-.709.435-.13.081-.255.169-.384.253-.023.015-.05.024-.082.04-.005-.033-.011-.053-.011-.072a5.868 5.868 0 0 1 0-.227 2.493 2.493 0 0 1 .01-.19c.007-.078.028-.152.013-.233-.013-.07.006-.144.01-.216.005-.051.024-.107.01-.154a.52.52 0 0 1-.013-.208 4.242 4.242 0 0 0 .024-.39c0-.046.014-.091.018-.137.008-.088.013-.176.02-.263.02-.201.042-.402.057-.603.016-.201.023-.403.037-.604.008-.115 0-.239.041-.342.044-.11-.008-.218.033-.32-.049-.108.04-.214.004-.321-.002-.005.013-.013.014-.02a.134.134 0 0 0 0-.045c-.003-.02-.014-.039-.014-.058 0-.059-.002-.119.005-.177a.354.354 0 0 0-.09-.284.361.361 0 0 0-.232-.114.701.701 0 0 0-.39.052c-.174.08-.304.197-.34.387a3.91 3.91 0 0 0-.05.427c-.017.22-.027.439-.042.658-.01.143-.025.286-.038.429-.007.08.005.163-.047.234a.025.025 0 0 0-.003.022c.034.078.01.158.005.235-.007.152-.036.303-.049.454-.022.254-.062.505-.103.756-.028.176-.08.34-.213.474a.785.785 0 0 1-.503.25.244.244 0 0 1-.252-.131.654.654 0 0 1-.082-.239c-.015-.156-.04-.314.003-.471.005-.02 0-.04 0-.061.002-.047.001-.094.005-.14a3.877 3.877 0 0 1 .026-.21c.005-.033.008-.07.024-.1.028-.056.024-.104-.002-.16a.218.218 0 0 1-.019-.126c.014-.085.019-.171.051-.254.032-.084.046-.175.072-.262a.248.248 0 0 1 .048-.103c.04-.042.047-.092.061-.142a.498.498 0 0 1 .044-.113c.03-.051.063-.104.086-.155.024-.052.04-.1.089-.134a.12.12 0 0 0 .036-.058.27.27 0 0 1 .102-.13c.029-.02.067-.038.081-.066.05-.095.123-.177.146-.286.012-.054.01-.111.027-.16a.246.246 0 0 0-.009-.182.186.186 0 0 0-.084-.086.344.344 0 0 0-.237-.023c-.164.047-.337.073-.468.198-.014.013-.037.018-.053.03-.104.083-.216.157-.308.25-.086.088-.15.195-.224.294-.166.224-.29.47-.376.733-.095.288-.133.587-.175.884-.026.188.001.382-.061.566-.01.027-.006.058-.004.088.006.063.018.126.02.19.003.114 0 .228-.001.343-.001.24-.018.48.036.718.026.115.056.23.13.323a.796.796 0 0 0 .602.307c.146.009.29-.011.431-.044.05-.011.099-.036.154-.013.012.005.033-.005.049-.012.02-.009.04-.022.06-.031.076-.031.149-.07.232-.077a.099.099 0 0 0 .039-.014c.109-.072.217-.146.326-.219.02-.013.05-.03.068-.024.016.006.028.04.03.064.003.06-.005.122.002.182a1.65 1.65 0 0 1-.003.344.099.099 0 0 1-.044.071c-.149.1-.298.2-.443.307-.217.16-.43.324-.644.485a23.486 23.486 0 0 1-.384.281c-.134.096-.27.189-.404.285-.15.11-.297.224-.448.332-.193.14-.39.274-.584.413-.047.035-.086.08-.131.118-.057.046-.117.09-.175.135a41.919 41.919 0 0 0-.255.203l-.353.282c-.142.114-.284.23-.426.343-.076.06-.155.116-.229.178-.114.098-.221.202-.336.298-.142.12-.29.232-.433.35a45.057 45.057 0 0 0-.515.432c-.15.128-.3.256-.447.388-.138.124-.271.253-.407.38-.164.152-.33.302-.494.455-.229.217-.467.425-.661.675l-.214.28a.328.328 0 0 0-.057.217.78.78 0 0 0 .079.322.493.493 0 0 0 .188.202c.154.093.32.111.495.105a.378.378 0 0 0 .257-.113c.076-.073.155-.143.23-.216.08-.075.156-.152.234-.228.019-.019.04-.036.058-.055a11.42 11.42 0 0 0 .123-.124 2.737 2.737 0 0 0 .073-.077l.204-.228c.025-.029.047-.06.074-.086l.596-.589c.045-.045.09-.092.133-.139a2.143 2.143 0 0 0 .087-.097c.028-.034.05-.072.08-.103.056-.056.116-.107.172-.163.096-.094.188-.193.288-.284.092-.085.194-.16.288-.243.042-.037.074-.083.112-.123l.246-.252c.006-.006.014-.01.021-.016.15-.12.3-.238.447-.36.21-.171.417-.346.627-.517.14-.114.285-.221.424-.335.203-.166.401-.337.605-.502.116-.095.24-.182.358-.274.116-.09.23-.184.347-.274a64.393 64.393 0 0 1 .489-.377c.157-.12.313-.24.473-.355.085-.06.176-.116.28-.155.004.027.01.047.009.066-.003.07-.01.139-.011.208-.002.208-.002.416-.002.625l-.001.79c0 .316 0 .632-.002.948 0 .056.022.117-.027.167-.007.007.002.027.003.041.003.037.009.075.008.112-.004.093-.014.186-.015.279 0 .082.012.163.014.245a7.293 7.293 0 0 1-.004.314l-.014.358c-.003.137-.003.275-.009.412-.006.152-.018.304-.023.456-.007.202-.004.404-.016.605-.016.277-.007.55.083.816.031.09.055.184.126.259a.7.7 0 0 0 .34.195c.023.005.044.015.066.023.07.021.132.02.203.015a.384.384 0 0 0 .16-.05c.077-.043.154-.085.226-.134a.523.523 0 0 0 .118-.13c.022-.03.025-.073.047-.103.023-.031.057-.054.087-.08l-.078-.045c.012-.026.022-.048.034-.07.006-.012.024-.023.022-.032-.01-.053.024-.085.06-.121-.03-.017-.074-.028-.077-.046-.01-.053-.051-.082-.077-.12l.042-.075-.05-.018c.094-.003.05-.098.1-.124-.02-.027-.06-.031-.036-.081.014-.03-.033-.06-.076-.06-.047 0-.072-.02-.073-.067l-.008-.129.058-.026-.002-.014-.065-.01c.077-.022.1-.084.127-.146a.394.394 0 0 1-.077-.256c.002-.026-.003-.06-.054-.053-.043.005-.079-.056-.064-.1.015-.043.031-.082-.01-.124l.057-.025c.025-.063-.03-.12-.011-.18-.044-.029-.047-.067-.02-.11l-.056-.006.048-.124-.1-.105c.03-.066.03-.066.006-.166l.051-.029c-.024-.026-.022-.073-.071-.07-.006 0-.014-.012-.017-.02-.026-.06-.001-.111.064-.135l-.023-.036c-.043-.069-.064-.136.015-.198.01-.008.012-.038.006-.054-.02-.064-.045-.127-.064-.18.02-.054.035-.102.056-.147.018-.04.028-.074-.003-.113-.007-.01.003-.032.005-.053l-.056-.074.08-.02c-.002-.014 0-.03-.007-.035-.022-.018-.046-.031-.069-.046 0-.037-.007-.076.003-.11.01-.032.037-.059.058-.09-.005-.054-.016-.116-.014-.178.001-.067.015-.133.022-.2 0-.009 0-.02-.005-.025-.025-.024-.023-.048-.017-.08.01-.044.008-.09.01-.136l.016-.473a.361.361 0 0 0-.016-.108c-.013-.039-.02-.075.023-.109.008-.006.009-.032.003-.042-.029-.043-.02-.093-.02-.138a2.898 2.898 0 0 1 .004-.356c.005-.052.03-.1-.005-.15-.006-.008-.003-.03.003-.04.029-.05.024-.094-.006-.14-.01-.016-.01-.039-.01-.041.021-.028.049-.058.046-.06-.06-.068-.013-.136.003-.199.015-.059.018-.108-.028-.148.007-.061.058-.117.004-.176-.005-.006.007-.033.017-.046.022-.029.045-.055.014-.092-.006-.007-.002-.023-.001-.034.006-.097.022-.194.016-.29-.005-.086.04-.123.103-.161.053-.033.119-.054.139-.125.002-.009.016-.016.026-.023.091-.064.182-.13.274-.191.202-.136.4-.276.618-.388.088-.045.162-.114.245-.168.19-.123.38-.248.575-.366.219-.133.442-.26.664-.39.26-.152.517-.307.78-.455a94.35 94.35 0 0 1 1.162-.639c.26-.14.522-.276.783-.414.208-.11.417-.22.627-.329.178-.092.355-.188.538-.27.27-.12.54-.237.817-.341.262-.1.53-.184.798-.27.226-.073.455-.134.66-.257.215-.128.399-.285.498-.522a.672.672 0 0 1 .073-.124c.005-.008.026-.006.039-.009v-.035c-.04-.05-.04-.05 0-.106zm-7.653-2.757a.408.408 0 0 0 .122.071c.098.039.208.054.3.013.154-.068.3-.16.39-.32a.385.385 0 0 1 .043-.06c.086-.1.17-.199.202-.34a.527.527 0 0 0 .014-.157c-.007-.091-.063-.15-.1-.218-.035-.005-.07-.003-.098-.014a.468.468 0 0 0-.297-.008.906.906 0 0 0-.464.294c-.158.18-.254.387-.17.64a.238.238 0 0 0 .058.1m-.54 5.139a.592.592 0 0 0 .281-.06 9.347 9.347 0 0 0 .335-.164.699.699 0 0 0 .255-.219c.05-.07.123-.136.12-.231-.002-.033.014-.067.017-.1.002-.025-.004-.05-.008-.076-.006-.033-.022-.067-.02-.1a18.424 18.424 0 0 1 .024-.497c.003-.054.015-.108.023-.161l.074.004c-.017-.023-.031-.038-.041-.054a.802.802 0 0 1-.031-.065l.105.018c-.021-.03-.027-.054-.043-.061-.054-.023-.055-.064-.054-.105.002-.042-.009-.097.017-.123.064-.063.068-.128.056-.203a.798.798 0 0 1-.01-.143c.003-.098.01-.196.014-.293 0-.005-.007-.01-.008-.016-.002-.028-.012-.058-.003-.083a.17.17 0 0 0 .003-.11.537.537 0 0 1-.005-.278c.014-.056.031-.112.043-.17.002-.008-.018-.02-.029-.033.053-.074.058-.151.064-.227.003-.04-.019-.078.011-.122a.242.242 0 0 0 .033-.13c0-.053.013-.106-.021-.161-.026-.041-.061-.084-.06-.14.003-.091-.051-.144-.156-.15-.139-.01-.278-.007-.403.058a.983.983 0 0 0-.552.773c-.005.06-.014.121-.022.181-.04.284-.082.567-.117.85-.039.319-.07.638-.107.957-.026.231-.055.463-.079.695-.015.148-.033.297-.028.444.005.179.108.284.322.295m-10.31 1.223a.328.328 0 0 1 .073-.282c.018-.02.034-.062.024-.08-.024-.04.014-.058.018-.087.006-.03-.028-.06 0-.093.01-.012.01-.033.012-.05.003-.038 0-.077.007-.113l.122-.521c.052-.223.098-.447.156-.669.047-.183.08-.372.166-.544.019-.037.025-.08.046-.116.032-.056.023-.13.081-.173.009-.007.013-.02.016-.032l.054-.206c.016-.061.028-.124.098-.152.012-.005.022-.02.027-.034.034-.076.07-.151.07-.237 0-.032-.007-.064-.002-.095.02-.126.051-.25.06-.377a.417.417 0 0 1 .06-.19c.066-.111.089-.235.114-.355.02-.094.068-.168.113-.247.018-.032.03-.054.009-.088a.087.087 0 0 1-.003-.093c.065-.126.095-.262.125-.399a2.69 2.69 0 0 1 .06-.23c.027-.088.062-.173.091-.26.03-.086.054-.173.083-.26.02-.062.037-.128.071-.183a.635.635 0 0 0 .08-.203 1.05 1.05 0 0 1 .064-.194c.055-.124.116-.247.175-.37.02-.04.045-.077.062-.117a.224.224 0 0 0 .022-.094.351.351 0 0 1 .034-.164c.084-.188.161-.379.249-.565.15-.32.256-.662.468-.953.049-.066.077-.146.12-.216a4.29 4.29 0 0 1 .439-.566c.053-.06.116-.113.176-.17.027.015.047.012.05-.015.01-.072.063-.094.121-.115.013-.005.03-.012.035-.023.019-.046.063-.082.053-.139-.002-.013.005-.03.013-.04.044-.064.092-.124.135-.188a.742.742 0 0 0 .133-.393 1.137 1.137 0 0 0-.043-.352.789.789 0 0 0-.568-.571 1.305 1.305 0 0 0-.246-.056 1.059 1.059 0 0 0-.19 0 .954.954 0 0 0-.492.27c-.13.123-.244.258-.335.416a3.677 3.677 0 0 0-.248.526 24.106 24.106 0 0 1-.146.375c-.037.094-.08.186-.116.281-.1.26-.195.52-.293.78-.093.248-.19.496-.281.745-.06.16-.112.322-.17.482L6.175 6.26c-.02.053-.033.111-.064.157-.048.073-.064.153-.085.234-.026.1-.052.203-.098.296-.077.157-.123.322-.172.488-.033.113-.037.237-.107.34-.011.015-.012.04-.012.06-.002.073.008.149-.049.21-.003.004-.003.012-.004.017l-.076.294-.132.465c-.04.146-.082.293-.119.44-.018.072-.021.147-.04.219-.027.094-.067.185-.092.28-.09.333-.175.668-.262 1.003-.012.045-.026.09-.037.137a88.407 88.407 0 0 0-.106.434c-.015.064-.031.128-.044.192-.06.298-.112.597-.177.894-.055.25-.107.501-.143.755-.035.236-.084.47-.126.705-.016.085-.03.17-.042.255l-.054.354c-.043.277-.089.553-.13.83-.026.171-.044.343-.07.513-.007.051-.03.1-.048.152-.032-.026-.058-.04-.074-.061a.137.137 0 0 1-.025-.07c-.003-.062 0-.124-.003-.185 0-.013-.01-.03-.021-.035-.038-.016-.033-.046-.034-.076-.003-.106 0-.213-.036-.318-.01-.031 0-.07.003-.106.003-.058.011-.117.01-.176 0-.028-.006-.066-.025-.082-.071-.06-.074-.15-.092-.226a.44.44 0 0 1 .028-.241c.027-.07.034-.129 0-.194a.399.399 0 0 1-.02-.049c-.032-.093-.077-.183-.072-.284a.563.563 0 0 0-.04-.217c-.027-.077-.063-.16-.008-.237-.02-.043-.06-.085-.054-.122.017-.137-.057-.246-.1-.364-.016-.044-.032-.081-.016-.112-.02-.039-.045-.067-.051-.097-.015-.08-.014-.16-.034-.24-.03-.116-.034-.238-.055-.357-.022-.125-.075-.246-.038-.377a.039.039 0 0 0-.003-.027c-.025-.049.016-.12-.053-.157-.006-.002.001-.027 0-.04 0-.023.004-.047-.005-.066-.036-.085-.022-.182-.066-.265-.006-.012 0-.03 0-.044-.001-.018 0-.035-.004-.052-.01-.04-.024-.08-.03-.12-.023-.14-.04-.283-.064-.424a104.342 104.342 0 0 0-.16-.923.85.85 0 0 0-.144-.345c-.17-.24-.53-.289-.772-.142a.656.656 0 0 0-.279.342c-.036.095-.06.194-.099.288-.117.287-.174.595-.31.876-.008.109-.057.205-.092.306-.029.081-.041.167-.067.25-.027.088-.063.173-.09.262-.039.13-.096.254-.127.389a.693.693 0 0 1-.116.288c-.025.033-.026.084-.037.126-.015.058-.014.128-.049.17-.053.063-.065.137-.089.208-.012.037-.01.077-.023.113-.058.168-.14.326-.187.5-.054.204-.138.4-.208.6a1.24 1.24 0 0 0-.047.163.43.43 0 0 0 .287.49c.182.063.35.022.507-.076.052-.032.093-.081.14-.122-.018-.066.042-.106.058-.163.02-.073.059-.14.084-.213.03-.083.092-.15.104-.242.005-.04.042-.075.065-.113-.022-.016-.006-.036.004-.058.03-.067.068-.133.087-.203.015-.055.02-.11.044-.166.038-.085.035-.187.088-.27-.013-.084.048-.145.08-.21a.325.325 0 0 0 .037-.201c.032-.016.077-.023.066-.077 0-.004.018-.012.025-.02.02-.02.044-.038.055-.063.024-.05.04-.105.062-.156.007-.017.033-.04.042-.037a.44.44 0 0 1 .11.053c.034.024.047.058.027.101-.005.01.001.026.003.045.031-.008.054-.049.083-.012-.006.028-.014.055-.017.083a.972.972 0 0 0-.004.127c.002.037.016.073.014.109a.119.119 0 0 0 .034.096.242.242 0 0 1 .057.098c.018.078.026.158.039.237l.11.706c.007.05.013.1.014.15.002.091-.018.185.046.267.01.012.006.034.009.052.027.186.053.372.081.557.027.177.056.353.082.53.037.24.072.482.108.722.026.18.052.359.08.538l.12.748c.017.108.052.214.016.324-.007.022-.008.046-.012.065.096.077.102.107.041.21.048 0 .063.03.07.069.025.154.041.31.08.463.005.02.008.045 0 .062a.072.072 0 0 0 .01.082.118.118 0 0 1 .02.05c.03.166.06.332.087.498.03.182.054.366.09.546.044.213.103.423.144.636.036.19.25.391.486.36.2-.025.428-.14.491-.384a6.125 6.125 0 0 0 .104-.47c.037-.204.065-.411.094-.617.039-.271.078-.542.113-.814.036-.277.066-.556.101-.833a85.361 85.361 0 0 1 .098-.754c.013-.097.02-.197.049-.29.026-.085.07-.163.057-.253.098-.037.12-.08.064-.131-.04-.037-.045-.073-.04-.118l.01-.088c.014-.103.034-.206.037-.31.002-.067.019-.134.061-.172.078-.07.07-.165.1-.248.023-.065.01-.144.014-.22-.049-.014-.084-.034-.077-.086.009-.065.012-.131.025-.195.028-.139.062-.276.092-.414a.167.167 0 0 0 0-.079c-.013-.044.003-.073.032-.103a.107.107 0 0 0 .03-.06 2.729 2.729 0 0 0 .008-.245c0-.043.011-.079.025-.119.027-.082.074-.161.048-.257-.008-.027.012-.07.033-.096.081-.098.083-.207.056-.32m2.18-.666c-.015-.065-.001-.08.065-.115-.021-.038-.06-.075-.053-.102.017-.067-.016-.12-.034-.176a.228.228 0 0 0-.2-.16.476.476 0 0 0-.195.014 1.239 1.239 0 0 0-.333.157c-.172.11-.3.248-.386.425a1.766 1.766 0 0 0-.16.569c-.019.152-.03.306-.043.459-.002.014 0 .029-.001.044-.004.109-.007.218-.013.327a52.91 52.91 0 0 1-.028.504c-.002.039.011.081-.03.113-.008.006-.004.027-.003.041 0 .072.015.146 0 .214-.035.149-.03.299-.037.448-.008.171-.021.342-.026.513-.004.183-.01.366 0 .548.008.162.114.249.288.263a.455.455 0 0 0 .241-.05 2.2 2.2 0 0 0 .391-.253c.031-.024.045-.075.104-.054.006.002.027-.012.028-.02.005-.06.06-.032.097-.044l.02-.083-.084-.005c.006-.033.011-.063.019-.093.007-.03.021-.06.026-.09.015-.086.014-.176.044-.256.046-.118.012-.235.021-.352.006-.083-.004-.166.005-.249.014-.138.036-.275.056-.413.01-.068.026-.136.037-.204a2.184 2.184 0 0 0 .024-.18c.004-.054 0-.106.025-.16a.495.495 0 0 0 .04-.184c.008-.127.005-.254.007-.381 0-.015-.002-.032.005-.043.055-.088.055-.188.07-.283a.793.793 0 0 0 .019-.18.253.253 0 0 1 .03-.143c.015-.025.031-.06.022-.08a.125.125 0 0 1 .008-.12c-.025-.063-.052-.113-.065-.166m1.132-.94a1.285 1.285 0 0 0-.12.473c-.01.155-.014.31-.021.465-.008.15-.015.298-.025.447-.007.093-.018.186-.026.278-.004.048.005.1-.012.142a.604.604 0 0 0-.04.268l-.002.008c.004.071-.021.141-.006.214.006.03.001.065-.002.097-.007.064-.037.134-.02.19.032.11.006.217.007.325 0 .094-.035.184-.024.282.012.1.004.203.005.304 0 .082.027.156.066.225.06.107.166.164.269.145.193-.036.402-.137.57-.304a.708.708 0 0 0 .206-.398 3.67 3.67 0 0 0 .042-.492c.005-.24.017-.48.028-.719.003-.06.026-.124.016-.183-.018-.102.009-.201.008-.302 0-.049.01-.106.053-.134.003-.055-.006-.102.01-.136.028-.06.027-.123.044-.184.009-.033.034-.064.034-.097a.24.24 0 0 1 .046-.133c.103-.16.21-.318.366-.433a6.662 6.662 0 0 0 .29-.228c.136-.112.273-.226.26-.431 0-.014.009-.028.008-.042-.003-.036-.001-.075-.014-.107-.028-.067-.064-.13-.097-.195-.048-.095-.13-.124-.229-.124-.096 0-.18.041-.265.081-.056.027-.11.056-.168.082-.054.024-.112.039-.163.068a.77.77 0 0 1-.3.096 1.25 1.25 0 0 0-.455.125.74.74 0 0 0-.34.327\"/></svg>");
        setPath("m7.951 9.821.008-.004c.044-.06.105-.114.13-.18.04-.11.066-.228-.005-.34-.016-.026-.024-.056-.036-.084-.035-.09-.08-.118-.204-.116a.56.56 0 0 0-.281.086 3.11 3.11 0 0 0-.298.211c-.05.04-.09.092-.135.137-.06.06-.074.14-.11.21a.46.46 0 0 0-.053.222c.002.094.041.18.113.23.08.054.184.092.29.042a1.84 1.84 0 0 0 .216-.116c.133-.086.282-.156.365-.298M24 9.423c-.008-.01-.02-.02-.023-.033a.635.635 0 0 0-.173-.28.3.3 0 0 0-.123-.06c-.039-.01-.082.002-.122-.007a.986.986 0 0 0-.688.098c-.217.113-.43.233-.65.341a5.64 5.64 0 0 1-.448.192c-.106.042-.167.02-.234-.06-.009-.012-.02-.025-.032-.028-.05-.012-.05-.055-.063-.09-.005-.015-.01-.04-.017-.042-.068-.011-.046-.038-.016-.07.01-.01.015-.023.025-.038-.034-.032-.09-.05-.064-.11.002-.004-.008-.016-.015-.019-.044-.019-.024-.052-.021-.082.005-.057.006-.064.032-.088l-.052-.05.053-.094c-.046-.01-.063-.038-.036-.066.032-.031.027-.06.022-.096-.002-.016-.005-.037.003-.05.02-.03.016-.058.006-.09-.006-.02.006-.044.01-.07-.047-.019-.061-.054-.042-.104.005-.012.009-.03.004-.04-.025-.047.002-.081.019-.1-.013-.05-.03-.084-.03-.119a9.858 9.858 0 0 1 .002-.412c0-.022.02-.043.031-.066-.03-.053-.03-.053.014-.096-.014-.03-.032-.057-.037-.085-.008-.053.051-.034.07-.054-.008-.05-.02-.095-.022-.14 0-.041-.007-.082.01-.125.014-.038.002-.085.002-.131l-.046.004-.007-.149c-.002-.054.008-.1.066-.102v-.127c-.021-.032-.045-.061-.062-.094-.022-.043.013-.073.041-.107-.057-.027-.067-.073-.08-.123-.016-.063-.03-.142-.075-.18-.042-.036-.077-.085-.131-.109l-.033-.013c-.22-.099-.437-.061-.647.024-.114.046-.218.117-.326.178a.343.343 0 0 0-.07.052c-.078.075-.154.152-.23.228a1.096 1.096 0 0 0-.08.095.747.747 0 0 1-.338.244.362.362 0 0 1-.275-.01c-.066-.029-.117-.039-.179 0a.165.165 0 0 1-.093.018c-.273-.036-.497.075-.682.252a.927.927 0 0 0-.263.547c-.015.107-.015.217-.02.325-.01.179-.017.357-.026.536l-.036.682c-.007.138-.009.276-.016.413-.016.32-.035.64-.05.961a.932.932 0 0 0 .007.182c.023.16.08.25.22.279a.52.52 0 0 0 .331-.028c.088-.041.18-.077.26-.13.099-.066.219-.12.235-.26 0-.003.003-.005.004-.008.04-.07.08-.14.115-.213a.12.12 0 0 0 .013-.072c-.007-.032-.048-.055-.007-.099.019-.02 0-.07.007-.106.007-.039.022-.076.034-.118l-.061-.049.032-.03c-.068-.063-.013-.116.022-.17-.019-.021-.062-.004-.057-.05.012-.12-.027-.244.034-.36.002-.004.005-.013.003-.015-.047-.054-.004-.1.008-.153.03.038.048.006.067-.002l-.011-.068c-.01-.052.002-.11-.054-.148-.013-.008-.016-.051-.006-.07a.36.36 0 0 1 .074-.096c.03-.029.035-.057.02-.094a.758.758 0 0 1-.036-.106c-.005-.024-.011-.057 0-.075.012-.018.044-.022.066-.032v-.115l-.04-.026.026-.057c.055.009.055.009.044-.042-.001-.008-.004-.02 0-.024.045-.053.025-.117.033-.176.002-.017 0-.038.01-.049.049-.058.05-.128.056-.188.038-.034.09-.058.1-.093.022-.077.078-.12.134-.164a.213.213 0 0 0 .066-.078.387.387 0 0 1 .102-.137c.068-.054.148-.093.22-.143.11-.076.227-.039.342-.026.023.003.047.025.064.045.066.075.106.164.03.304a.358.358 0 0 0-.01.344c.102.188.009.359.026.538-.04.054-.02.109-.002.164a.066.066 0 0 1 0 .041.495.495 0 0 0-.015.327c.006.018.002.04 0 .061-.01.156-.039.31-.035.467.002.13 0 .258.005.387a.448.448 0 0 0 .118.286c.04.045.095.077.145.111.044.03.049.047.01.08a.368.368 0 0 1-.051.035c-.066.04-.132.079-.199.116l-.696.39-.996.558c-.196.11-.392.219-.586.33-.224.13-.446.264-.671.393-.031.018-.071.022-.106.034-.016.005-.034.01-.046.021a.766.766 0 0 1-.221.14c-.07.033-.14.064-.206.103-.12.073-.238.152-.357.227l-.557.343c-.236.145-.474.288-.709.435-.13.081-.255.169-.384.253-.023.015-.05.024-.082.04-.005-.033-.011-.053-.011-.072a5.868 5.868 0 0 1 0-.227 2.493 2.493 0 0 1 .01-.19c.007-.078.028-.152.013-.233-.013-.07.006-.144.01-.216.005-.051.024-.107.01-.154a.52.52 0 0 1-.013-.208 4.242 4.242 0 0 0 .024-.39c0-.046.014-.091.018-.137.008-.088.013-.176.02-.263.02-.201.042-.402.057-.603.016-.201.023-.403.037-.604.008-.115 0-.239.041-.342.044-.11-.008-.218.033-.32-.049-.108.04-.214.004-.321-.002-.005.013-.013.014-.02a.134.134 0 0 0 0-.045c-.003-.02-.014-.039-.014-.058 0-.059-.002-.119.005-.177a.354.354 0 0 0-.09-.284.361.361 0 0 0-.232-.114.701.701 0 0 0-.39.052c-.174.08-.304.197-.34.387a3.91 3.91 0 0 0-.05.427c-.017.22-.027.439-.042.658-.01.143-.025.286-.038.429-.007.08.005.163-.047.234a.025.025 0 0 0-.003.022c.034.078.01.158.005.235-.007.152-.036.303-.049.454-.022.254-.062.505-.103.756-.028.176-.08.34-.213.474a.785.785 0 0 1-.503.25.244.244 0 0 1-.252-.131.654.654 0 0 1-.082-.239c-.015-.156-.04-.314.003-.471.005-.02 0-.04 0-.061.002-.047.001-.094.005-.14a3.877 3.877 0 0 1 .026-.21c.005-.033.008-.07.024-.1.028-.056.024-.104-.002-.16a.218.218 0 0 1-.019-.126c.014-.085.019-.171.051-.254.032-.084.046-.175.072-.262a.248.248 0 0 1 .048-.103c.04-.042.047-.092.061-.142a.498.498 0 0 1 .044-.113c.03-.051.063-.104.086-.155.024-.052.04-.1.089-.134a.12.12 0 0 0 .036-.058.27.27 0 0 1 .102-.13c.029-.02.067-.038.081-.066.05-.095.123-.177.146-.286.012-.054.01-.111.027-.16a.246.246 0 0 0-.009-.182.186.186 0 0 0-.084-.086.344.344 0 0 0-.237-.023c-.164.047-.337.073-.468.198-.014.013-.037.018-.053.03-.104.083-.216.157-.308.25-.086.088-.15.195-.224.294-.166.224-.29.47-.376.733-.095.288-.133.587-.175.884-.026.188.001.382-.061.566-.01.027-.006.058-.004.088.006.063.018.126.02.19.003.114 0 .228-.001.343-.001.24-.018.48.036.718.026.115.056.23.13.323a.796.796 0 0 0 .602.307c.146.009.29-.011.431-.044.05-.011.099-.036.154-.013.012.005.033-.005.049-.012.02-.009.04-.022.06-.031.076-.031.149-.07.232-.077a.099.099 0 0 0 .039-.014c.109-.072.217-.146.326-.219.02-.013.05-.03.068-.024.016.006.028.04.03.064.003.06-.005.122.002.182a1.65 1.65 0 0 1-.003.344.099.099 0 0 1-.044.071c-.149.1-.298.2-.443.307-.217.16-.43.324-.644.485a23.486 23.486 0 0 1-.384.281c-.134.096-.27.189-.404.285-.15.11-.297.224-.448.332-.193.14-.39.274-.584.413-.047.035-.086.08-.131.118-.057.046-.117.09-.175.135a41.919 41.919 0 0 0-.255.203l-.353.282c-.142.114-.284.23-.426.343-.076.06-.155.116-.229.178-.114.098-.221.202-.336.298-.142.12-.29.232-.433.35a45.057 45.057 0 0 0-.515.432c-.15.128-.3.256-.447.388-.138.124-.271.253-.407.38-.164.152-.33.302-.494.455-.229.217-.467.425-.661.675l-.214.28a.328.328 0 0 0-.057.217.78.78 0 0 0 .079.322.493.493 0 0 0 .188.202c.154.093.32.111.495.105a.378.378 0 0 0 .257-.113c.076-.073.155-.143.23-.216.08-.075.156-.152.234-.228.019-.019.04-.036.058-.055a11.42 11.42 0 0 0 .123-.124 2.737 2.737 0 0 0 .073-.077l.204-.228c.025-.029.047-.06.074-.086l.596-.589c.045-.045.09-.092.133-.139a2.143 2.143 0 0 0 .087-.097c.028-.034.05-.072.08-.103.056-.056.116-.107.172-.163.096-.094.188-.193.288-.284.092-.085.194-.16.288-.243.042-.037.074-.083.112-.123l.246-.252c.006-.006.014-.01.021-.016.15-.12.3-.238.447-.36.21-.171.417-.346.627-.517.14-.114.285-.221.424-.335.203-.166.401-.337.605-.502.116-.095.24-.182.358-.274.116-.09.23-.184.347-.274a64.393 64.393 0 0 1 .489-.377c.157-.12.313-.24.473-.355.085-.06.176-.116.28-.155.004.027.01.047.009.066-.003.07-.01.139-.011.208-.002.208-.002.416-.002.625l-.001.79c0 .316 0 .632-.002.948 0 .056.022.117-.027.167-.007.007.002.027.003.041.003.037.009.075.008.112-.004.093-.014.186-.015.279 0 .082.012.163.014.245a7.293 7.293 0 0 1-.004.314l-.014.358c-.003.137-.003.275-.009.412-.006.152-.018.304-.023.456-.007.202-.004.404-.016.605-.016.277-.007.55.083.816.031.09.055.184.126.259a.7.7 0 0 0 .34.195c.023.005.044.015.066.023.07.021.132.02.203.015a.384.384 0 0 0 .16-.05c.077-.043.154-.085.226-.134a.523.523 0 0 0 .118-.13c.022-.03.025-.073.047-.103.023-.031.057-.054.087-.08l-.078-.045c.012-.026.022-.048.034-.07.006-.012.024-.023.022-.032-.01-.053.024-.085.06-.121-.03-.017-.074-.028-.077-.046-.01-.053-.051-.082-.077-.12l.042-.075-.05-.018c.094-.003.05-.098.1-.124-.02-.027-.06-.031-.036-.081.014-.03-.033-.06-.076-.06-.047 0-.072-.02-.073-.067l-.008-.129.058-.026-.002-.014-.065-.01c.077-.022.1-.084.127-.146a.394.394 0 0 1-.077-.256c.002-.026-.003-.06-.054-.053-.043.005-.079-.056-.064-.1.015-.043.031-.082-.01-.124l.057-.025c.025-.063-.03-.12-.011-.18-.044-.029-.047-.067-.02-.11l-.056-.006.048-.124-.1-.105c.03-.066.03-.066.006-.166l.051-.029c-.024-.026-.022-.073-.071-.07-.006 0-.014-.012-.017-.02-.026-.06-.001-.111.064-.135l-.023-.036c-.043-.069-.064-.136.015-.198.01-.008.012-.038.006-.054-.02-.064-.045-.127-.064-.18.02-.054.035-.102.056-.147.018-.04.028-.074-.003-.113-.007-.01.003-.032.005-.053l-.056-.074.08-.02c-.002-.014 0-.03-.007-.035-.022-.018-.046-.031-.069-.046 0-.037-.007-.076.003-.11.01-.032.037-.059.058-.09-.005-.054-.016-.116-.014-.178.001-.067.015-.133.022-.2 0-.009 0-.02-.005-.025-.025-.024-.023-.048-.017-.08.01-.044.008-.09.01-.136l.016-.473a.361.361 0 0 0-.016-.108c-.013-.039-.02-.075.023-.109.008-.006.009-.032.003-.042-.029-.043-.02-.093-.02-.138a2.898 2.898 0 0 1 .004-.356c.005-.052.03-.1-.005-.15-.006-.008-.003-.03.003-.04.029-.05.024-.094-.006-.14-.01-.016-.01-.039-.01-.041.021-.028.049-.058.046-.06-.06-.068-.013-.136.003-.199.015-.059.018-.108-.028-.148.007-.061.058-.117.004-.176-.005-.006.007-.033.017-.046.022-.029.045-.055.014-.092-.006-.007-.002-.023-.001-.034.006-.097.022-.194.016-.29-.005-.086.04-.123.103-.161.053-.033.119-.054.139-.125.002-.009.016-.016.026-.023.091-.064.182-.13.274-.191.202-.136.4-.276.618-.388.088-.045.162-.114.245-.168.19-.123.38-.248.575-.366.219-.133.442-.26.664-.39.26-.152.517-.307.78-.455a94.35 94.35 0 0 1 1.162-.639c.26-.14.522-.276.783-.414.208-.11.417-.22.627-.329.178-.092.355-.188.538-.27.27-.12.54-.237.817-.341.262-.1.53-.184.798-.27.226-.073.455-.134.66-.257.215-.128.399-.285.498-.522a.672.672 0 0 1 .073-.124c.005-.008.026-.006.039-.009v-.035c-.04-.05-.04-.05 0-.106zm-7.653-2.757a.408.408 0 0 0 .122.071c.098.039.208.054.3.013.154-.068.3-.16.39-.32a.385.385 0 0 1 .043-.06c.086-.1.17-.199.202-.34a.527.527 0 0 0 .014-.157c-.007-.091-.063-.15-.1-.218-.035-.005-.07-.003-.098-.014a.468.468 0 0 0-.297-.008.906.906 0 0 0-.464.294c-.158.18-.254.387-.17.64a.238.238 0 0 0 .058.1m-.54 5.139a.592.592 0 0 0 .281-.06 9.347 9.347 0 0 0 .335-.164.699.699 0 0 0 .255-.219c.05-.07.123-.136.12-.231-.002-.033.014-.067.017-.1.002-.025-.004-.05-.008-.076-.006-.033-.022-.067-.02-.1a18.424 18.424 0 0 1 .024-.497c.003-.054.015-.108.023-.161l.074.004c-.017-.023-.031-.038-.041-.054a.802.802 0 0 1-.031-.065l.105.018c-.021-.03-.027-.054-.043-.061-.054-.023-.055-.064-.054-.105.002-.042-.009-.097.017-.123.064-.063.068-.128.056-.203a.798.798 0 0 1-.01-.143c.003-.098.01-.196.014-.293 0-.005-.007-.01-.008-.016-.002-.028-.012-.058-.003-.083a.17.17 0 0 0 .003-.11.537.537 0 0 1-.005-.278c.014-.056.031-.112.043-.17.002-.008-.018-.02-.029-.033.053-.074.058-.151.064-.227.003-.04-.019-.078.011-.122a.242.242 0 0 0 .033-.13c0-.053.013-.106-.021-.161-.026-.041-.061-.084-.06-.14.003-.091-.051-.144-.156-.15-.139-.01-.278-.007-.403.058a.983.983 0 0 0-.552.773c-.005.06-.014.121-.022.181-.04.284-.082.567-.117.85-.039.319-.07.638-.107.957-.026.231-.055.463-.079.695-.015.148-.033.297-.028.444.005.179.108.284.322.295m-10.31 1.223a.328.328 0 0 1 .073-.282c.018-.02.034-.062.024-.08-.024-.04.014-.058.018-.087.006-.03-.028-.06 0-.093.01-.012.01-.033.012-.05.003-.038 0-.077.007-.113l.122-.521c.052-.223.098-.447.156-.669.047-.183.08-.372.166-.544.019-.037.025-.08.046-.116.032-.056.023-.13.081-.173.009-.007.013-.02.016-.032l.054-.206c.016-.061.028-.124.098-.152.012-.005.022-.02.027-.034.034-.076.07-.151.07-.237 0-.032-.007-.064-.002-.095.02-.126.051-.25.06-.377a.417.417 0 0 1 .06-.19c.066-.111.089-.235.114-.355.02-.094.068-.168.113-.247.018-.032.03-.054.009-.088a.087.087 0 0 1-.003-.093c.065-.126.095-.262.125-.399a2.69 2.69 0 0 1 .06-.23c.027-.088.062-.173.091-.26.03-.086.054-.173.083-.26.02-.062.037-.128.071-.183a.635.635 0 0 0 .08-.203 1.05 1.05 0 0 1 .064-.194c.055-.124.116-.247.175-.37.02-.04.045-.077.062-.117a.224.224 0 0 0 .022-.094.351.351 0 0 1 .034-.164c.084-.188.161-.379.249-.565.15-.32.256-.662.468-.953.049-.066.077-.146.12-.216a4.29 4.29 0 0 1 .439-.566c.053-.06.116-.113.176-.17.027.015.047.012.05-.015.01-.072.063-.094.121-.115.013-.005.03-.012.035-.023.019-.046.063-.082.053-.139-.002-.013.005-.03.013-.04.044-.064.092-.124.135-.188a.742.742 0 0 0 .133-.393 1.137 1.137 0 0 0-.043-.352.789.789 0 0 0-.568-.571 1.305 1.305 0 0 0-.246-.056 1.059 1.059 0 0 0-.19 0 .954.954 0 0 0-.492.27c-.13.123-.244.258-.335.416a3.677 3.677 0 0 0-.248.526 24.106 24.106 0 0 1-.146.375c-.037.094-.08.186-.116.281-.1.26-.195.52-.293.78-.093.248-.19.496-.281.745-.06.16-.112.322-.17.482L6.175 6.26c-.02.053-.033.111-.064.157-.048.073-.064.153-.085.234-.026.1-.052.203-.098.296-.077.157-.123.322-.172.488-.033.113-.037.237-.107.34-.011.015-.012.04-.012.06-.002.073.008.149-.049.21-.003.004-.003.012-.004.017l-.076.294-.132.465c-.04.146-.082.293-.119.44-.018.072-.021.147-.04.219-.027.094-.067.185-.092.28-.09.333-.175.668-.262 1.003-.012.045-.026.09-.037.137a88.407 88.407 0 0 0-.106.434c-.015.064-.031.128-.044.192-.06.298-.112.597-.177.894-.055.25-.107.501-.143.755-.035.236-.084.47-.126.705-.016.085-.03.17-.042.255l-.054.354c-.043.277-.089.553-.13.83-.026.171-.044.343-.07.513-.007.051-.03.1-.048.152-.032-.026-.058-.04-.074-.061a.137.137 0 0 1-.025-.07c-.003-.062 0-.124-.003-.185 0-.013-.01-.03-.021-.035-.038-.016-.033-.046-.034-.076-.003-.106 0-.213-.036-.318-.01-.031 0-.07.003-.106.003-.058.011-.117.01-.176 0-.028-.006-.066-.025-.082-.071-.06-.074-.15-.092-.226a.44.44 0 0 1 .028-.241c.027-.07.034-.129 0-.194a.399.399 0 0 1-.02-.049c-.032-.093-.077-.183-.072-.284a.563.563 0 0 0-.04-.217c-.027-.077-.063-.16-.008-.237-.02-.043-.06-.085-.054-.122.017-.137-.057-.246-.1-.364-.016-.044-.032-.081-.016-.112-.02-.039-.045-.067-.051-.097-.015-.08-.014-.16-.034-.24-.03-.116-.034-.238-.055-.357-.022-.125-.075-.246-.038-.377a.039.039 0 0 0-.003-.027c-.025-.049.016-.12-.053-.157-.006-.002.001-.027 0-.04 0-.023.004-.047-.005-.066-.036-.085-.022-.182-.066-.265-.006-.012 0-.03 0-.044-.001-.018 0-.035-.004-.052-.01-.04-.024-.08-.03-.12-.023-.14-.04-.283-.064-.424a104.342 104.342 0 0 0-.16-.923.85.85 0 0 0-.144-.345c-.17-.24-.53-.289-.772-.142a.656.656 0 0 0-.279.342c-.036.095-.06.194-.099.288-.117.287-.174.595-.31.876-.008.109-.057.205-.092.306-.029.081-.041.167-.067.25-.027.088-.063.173-.09.262-.039.13-.096.254-.127.389a.693.693 0 0 1-.116.288c-.025.033-.026.084-.037.126-.015.058-.014.128-.049.17-.053.063-.065.137-.089.208-.012.037-.01.077-.023.113-.058.168-.14.326-.187.5-.054.204-.138.4-.208.6a1.24 1.24 0 0 0-.047.163.43.43 0 0 0 .287.49c.182.063.35.022.507-.076.052-.032.093-.081.14-.122-.018-.066.042-.106.058-.163.02-.073.059-.14.084-.213.03-.083.092-.15.104-.242.005-.04.042-.075.065-.113-.022-.016-.006-.036.004-.058.03-.067.068-.133.087-.203.015-.055.02-.11.044-.166.038-.085.035-.187.088-.27-.013-.084.048-.145.08-.21a.325.325 0 0 0 .037-.201c.032-.016.077-.023.066-.077 0-.004.018-.012.025-.02.02-.02.044-.038.055-.063.024-.05.04-.105.062-.156.007-.017.033-.04.042-.037a.44.44 0 0 1 .11.053c.034.024.047.058.027.101-.005.01.001.026.003.045.031-.008.054-.049.083-.012-.006.028-.014.055-.017.083a.972.972 0 0 0-.004.127c.002.037.016.073.014.109a.119.119 0 0 0 .034.096.242.242 0 0 1 .057.098c.018.078.026.158.039.237l.11.706c.007.05.013.1.014.15.002.091-.018.185.046.267.01.012.006.034.009.052.027.186.053.372.081.557.027.177.056.353.082.53.037.24.072.482.108.722.026.18.052.359.08.538l.12.748c.017.108.052.214.016.324-.007.022-.008.046-.012.065.096.077.102.107.041.21.048 0 .063.03.07.069.025.154.041.31.08.463.005.02.008.045 0 .062a.072.072 0 0 0 .01.082.118.118 0 0 1 .02.05c.03.166.06.332.087.498.03.182.054.366.09.546.044.213.103.423.144.636.036.19.25.391.486.36.2-.025.428-.14.491-.384a6.125 6.125 0 0 0 .104-.47c.037-.204.065-.411.094-.617.039-.271.078-.542.113-.814.036-.277.066-.556.101-.833a85.361 85.361 0 0 1 .098-.754c.013-.097.02-.197.049-.29.026-.085.07-.163.057-.253.098-.037.12-.08.064-.131-.04-.037-.045-.073-.04-.118l.01-.088c.014-.103.034-.206.037-.31.002-.067.019-.134.061-.172.078-.07.07-.165.1-.248.023-.065.01-.144.014-.22-.049-.014-.084-.034-.077-.086.009-.065.012-.131.025-.195.028-.139.062-.276.092-.414a.167.167 0 0 0 0-.079c-.013-.044.003-.073.032-.103a.107.107 0 0 0 .03-.06 2.729 2.729 0 0 0 .008-.245c0-.043.011-.079.025-.119.027-.082.074-.161.048-.257-.008-.027.012-.07.033-.096.081-.098.083-.207.056-.32m2.18-.666c-.015-.065-.001-.08.065-.115-.021-.038-.06-.075-.053-.102.017-.067-.016-.12-.034-.176a.228.228 0 0 0-.2-.16.476.476 0 0 0-.195.014 1.239 1.239 0 0 0-.333.157c-.172.11-.3.248-.386.425a1.766 1.766 0 0 0-.16.569c-.019.152-.03.306-.043.459-.002.014 0 .029-.001.044-.004.109-.007.218-.013.327a52.91 52.91 0 0 1-.028.504c-.002.039.011.081-.03.113-.008.006-.004.027-.003.041 0 .072.015.146 0 .214-.035.149-.03.299-.037.448-.008.171-.021.342-.026.513-.004.183-.01.366 0 .548.008.162.114.249.288.263a.455.455 0 0 0 .241-.05 2.2 2.2 0 0 0 .391-.253c.031-.024.045-.075.104-.054.006.002.027-.012.028-.02.005-.06.06-.032.097-.044l.02-.083-.084-.005c.006-.033.011-.063.019-.093.007-.03.021-.06.026-.09.015-.086.014-.176.044-.256.046-.118.012-.235.021-.352.006-.083-.004-.166.005-.249.014-.138.036-.275.056-.413.01-.068.026-.136.037-.204a2.184 2.184 0 0 0 .024-.18c.004-.054 0-.106.025-.16a.495.495 0 0 0 .04-.184c.008-.127.005-.254.007-.381 0-.015-.002-.032.005-.043.055-.088.055-.188.07-.283a.793.793 0 0 0 .019-.18.253.253 0 0 1 .03-.143c.015-.025.031-.06.022-.08a.125.125 0 0 1 .008-.12c-.025-.063-.052-.113-.065-.166m1.132-.94a1.285 1.285 0 0 0-.12.473c-.01.155-.014.31-.021.465-.008.15-.015.298-.025.447-.007.093-.018.186-.026.278-.004.048.005.1-.012.142a.604.604 0 0 0-.04.268l-.002.008c.004.071-.021.141-.006.214.006.03.001.065-.002.097-.007.064-.037.134-.02.19.032.11.006.217.007.325 0 .094-.035.184-.024.282.012.1.004.203.005.304 0 .082.027.156.066.225.06.107.166.164.269.145.193-.036.402-.137.57-.304a.708.708 0 0 0 .206-.398 3.67 3.67 0 0 0 .042-.492c.005-.24.017-.48.028-.719.003-.06.026-.124.016-.183-.018-.102.009-.201.008-.302 0-.049.01-.106.053-.134.003-.055-.006-.102.01-.136.028-.06.027-.123.044-.184.009-.033.034-.064.034-.097a.24.24 0 0 1 .046-.133c.103-.16.21-.318.366-.433a6.662 6.662 0 0 0 .29-.228c.136-.112.273-.226.26-.431 0-.014.009-.028.008-.042-.003-.036-.001-.075-.014-.107-.028-.067-.064-.13-.097-.195-.048-.095-.13-.124-.229-.124-.096 0-.18.041-.265.081-.056.027-.11.056-.168.082-.054.024-.112.039-.163.068a.77.77 0 0 1-.3.096 1.25 1.25 0 0 0-.455.125.74.74 0 0 0-.34.327");
    }

}
