package org.silentsoft.simpleicons.icons;

/**
 * <img src="doc-files/unilever.svg" width="48" height="48"/>
 * <p>The Unilever Icon.</p>
 * <code>unilever</code> is used as the icon's slug.
 */
public class UnileverIcon extends org.silentsoft.simpleicons.Icon {

    public UnileverIcon() {
        super();

        setTitle("Unilever");
        setSlug("unilever");
        setHex("1F36C7");
        setSource("https://www.unilever.com/our-company/the-logo");
        setSvg("<svg role=\"img\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>Unilever</title><path d=\"M21.436 6.6255c.1147.8467 1.392 1.99 1.746 1.9613.2344-.0191.3205-1.105.3205-1.9613 0-.488.0287-.8754-.2296-.9616-.4114.8276-1.4878.995-1.837.9616zm.0717-.378c.928 0 1.7747-.7414 1.7747-1.392 0-.3014-.1435-.555-.507-.598.0622.0813.0909.1388.0909.287 0 .4928-.7463 1.0333-1.5595 1.0333-.2966 0-.3827.2057-.3827.311-.0048.2583.2344.3588.5836.3588zm-.1962-1.0045c-.1243 0-.3013 0-.4018-.1962-.0335-.0621-.0478-.1387-.0622-.22-.0239-.1244-.0478-.2488-.1435-.3157.153.0478.3062.0478.4353.0478.4019 0 .7846-.2775 1.0811-.2775.1962 0 .2536.1244.2536.2488.0096.3923-.7893.7128-1.1529.7128h-.0096zM1.373 12.232c.3014 0 .2392-1.856.732-1.856.1148 0 .1482.1147.1482.263 0 .421-.2057 1.0333-.2057 1.373 0 .1722.0479.2296.1244.2248.2153 0 .5884-2.0427.952-2.0427.1148 0 .1722.1149.1722.2344 0 .4258-.5454 1.66-.5454 2.0044 0 .0574.024.1005.0575.1005.2248 0 .6697-.9615.8132-1.4447.0813-.2488.1866-.3827.287-.3827.0909 0 .1722.1005.1722.3062 0 .4831-.4449 1.612-.8371 2.3727-.3014.5884-.775 1.4351-.775 1.9087 0 .2392.0478.4927.3875.7893-.5693-.0335-.8037-.0909-1.0142-.5358-.952 1.8944 1.7605 1.7126.8324 3.3965-.1674-.3014-1.5069-.6123-1.5069-2.3775 0-1.526 1.3347-2.4158 1.3347-3.0473 0-.1243-.043-.2296-.1579-.33-.2966-.2488-.3013-.4545-.5358-.4545-.1674 0-.373.3923-.1626.7415.0718.1148.1387.1818.1387.2966 0 .2487-.3922.9185-.6697.9137-.2774 0-.488-.6841-.488-1.7891 0-.9807.2249-1.971.4976-1.971.0813 0 .1004.0575.1004.1244 0 .1148-.0335.3492-.0335.7415.0048.4162.0957.4497.1818.4401zm2.2723 2.612c.3731 0 .684-.2775.684-.8898v-.909c0-.3492.0288-.7414.2584-1.0141-.0287.1148-.0287.2392-.0287.354 0 .7654.421 1.2916.421 2.033 0 .2775-.0814.4258-.2918.421-.2057 0-.1866-.1865-.2344-.1865-.0335 0-.091.1148-.091.2392 0 .1817.1388.4783.5024.4831.3205 0 .5788-.2918.5788-.6219 0-.8036-.6219-1.6934-.6219-2.5497 0-.3731.1005-.6219.177-.818 0 1.77 1.5069 3.0616 1.5069 3.803 0 .1675-.1244.3014-.311.3014-.2057 0-.3013-.1626-.3013-.287 0-.0622-.0096-.0813-.0335-.0813-.0526 0-.2153.177-.2153.4114 0 .2966.2392.6506.684.6506.5072 0 .7846-.4306.7846-.8133 0-.9376-1.8274-2.3536-1.8274-3.87 0-.2583.043-.6793.2296-.9998-1.1768.7558-1.5403 1.7652-1.5403 2.6502 0 .7654-.0287 1.148-.421 1.148-.2057 0-.2583-.1865-.33-.1865-.0527 0-.0814.1627-.0814.2057.0096.3349.244.5167.488.5167h.0143v.0095zM19.8334 4.6401c-.1722 0-.4545.1866-.6793.1866-.2823-.0048-.201-.3588-.5119-.3588-.067 0-.1483.0191-.2296.0622-.6458.3253-1.1481.201-1.263.2775-.0286.0143-.0525.0382-.0621.0908 0 .6698.7128 1.703 1.8991 1.703.8133 0 1.4974-.2774 1.4974-.7319 0-.397-.3827-1.2294-.6506-1.2294zm-.7415 1.3012c-.6554 0-1.086-.354-1.0811-.5884 0-.0287.0191-.0478.0526-.0478.1052 0 .3923.1435.7654.2057.4353.0717.6697.0813.7845.0813.1148 0 .1674.0287.1674.0622 0 .11-.2965.287-.6888.287zM3.8318 18.2069c-.2918.0718-.7654.5358-.7654 1.2677 0 .8706.9376 2.2149 2.478 2.2149 1.3011 0 1.6216-.8994 1.6216-1.507 0-1.3441-.8276-2.2913-1.9087-2.2913-.5884 0-1.1146.4305-1.1146 1.062 0 .5931.4449 1.4733 1.5069 1.4733.4975 0 .794-.3587.794-.7653 0-.4019-.3635-.952-.8993-.952-.1626 0-.2774.1052-.2774.2774 0 .2153.2966.421.665.4258.0908 0 .1626-.0191.196-.0335.0192.024.024.067.024.1053 0 .2057-.1962.33-.4975.33-.4545 0-.8898-.3396-.8898-.8754 0-.3205.2775-.5501.6793-.5501.794 0 1.2677.708 1.2677 1.4064 0 .6315-.3492.9998-1.062.995-1.4351.0048-2.124-1.2868-1.8178-2.5832zm11.0552 2.8368c-.091-.1723-.0192-.4689-.287-.4689-.1818 0-.1962.1436-.2153.2584-.3875-.11-.708-.1675-.995-.1675-.2057 0-.3827.0287-.5358.0814-.1005-.1818-.5406-.5262-.9233-.6506-.1483.8036-.8706 1.435-1.9422 1.526-.0621.5262-.4736.6601-.794.6601-.2297.0048-.598-.0765-.6172-.1674-.1243-.7558-.6984-1.1816-.9471-1.282.0095.0813.019.1674.019.2487 0 .641-.44 1.0429-1.258 1.0429-.1244 0-.2966-.0096-.421-.0335.9376 1.0428 1.6073.6601 2.0427.8563C8.582 23.2059 9.046 24 10.8734 24c.665 0 1.3443-.2583 1.7891-.5453.0814.2678.3588.507.8133.507.775 0 1.2103-.2392 1.2103-.4353 0-.0526-.0048-.134-.1388-.134s-.1148.0336-.5405.0336c-.4928-.0048-1.2964-.1962-1.6743-1.0573-.067-.1435-.1722-.1435-.2057-.1435-.2488 0-.6315.885-2.2006.885-.6553.0048-.9615-.244-.9615-.3013 0-.0096 0-.0192.0335-.0192.0622 0 .3062.0287.6075.0287.9903 0 1.7892-.4544 2.2723-.9806.1674-.1866.2488-.2153.3923-.2153.1244 0 .2583.11.3205.2774.22.5693.7271 1.0238 1.282 1.0238.751 0 .7606-1.282.9376-1.3443a.344.344 0 00.1053.0192c.0909 0 .2344-.067.2344-.2344 0-.1818-.22-.2297-.2631-.3205zm-1.215.9615c-.1962-.0048-.354-.1627-.354-.3588 0-.201.1578-.3588.354-.3588.196 0 .3587.1627.3587.3588a.3583.3583 0 01-.3588.3588zm6.4245-5.1808c-1.3108 0-.9711 1.148-2.502 1.4973-.2822.0622-.3635.153-.3635.2775 0 .2344.1292.5357.2918.5357.665 0 1.703-1.3825 1.8896-1.3825v-.009c.0784.0046.1577.0117.153.1956 0 .5023-1.4446 1.1577-1.4446 1.5165 0 .2152.5118.6697 1.0094.6697.7223.0048 1.3681-1.4734 1.5212-1.4734.1196 0 .1626.086.1626.177 0 .4018-.488 1.1863-1.3442 1.526-.177.0717-.2057.153-.2057.2153 0 .1961.2248.4879.4305.4879.2488 0 1.9231-1.459 1.9231-2.6358 0-1.105-.7989-1.5978-1.5212-1.5978zm.6027 1.2677a.5738.5738 0 01-.263-.067c-.1149-.0526-.3206-.2248-.3206-.488 0-.2391.134-.3396.2583-.3396.3827 0 .7846.3397.7893.6076 0 .2152-.2057.287-.464.287zM3.7265 6.8742c0 .1962.1579.354.354.3588.1962 0 .354-.1626.354-.3588 0-.1961-.1626-.354-.354-.354-.1913.0048-.3588.1627-.3588.354h.0048zm-.464-.7989c0 .1962.1579.354.354.354.1961 0 .3588-.1626.3588-.3587 0-.1962-.1627-.3588-.3588-.3588s-.354.1722-.354.3635zm-.3205 2.435c-.2057.0526-.6315.3013-.6315.7462 0 .3205.2536.5262.5597.5262.1627 0 .2775-.0334.3493-.0909-.2488-.2391-.3397-.507-.3397-.775 0-.177.0287-.2917.0622-.4065zm-2.1862.1291c-.0095.043-.0095.091-.0095.134 0 .421.2152.6506.5118.6506.22 0 .4832-.134.7128-.4258-.0957.0191-.2153.0287-.3205.0287-.3205 0-.684-.0909-.8946-.3875zm-.311.799c0 .6744.2058.995.5694.9997.287 0 .6697-.2057 1.1241-.598-.3492.0814-.617.134-.8563.1388C.9615 9.974.7176 9.8497.445 9.4383zm2.3106-3.5688c.043-.1435.0814-.3205.0814-.5166 0-.4258-.1962-1.0763-.8037-1.0763-.3492 0-.598.2774-.598.6075 0 .708.708.9902 1.3203.9854zm.4497.8994c-.1148-.153-.0718-.2918-.1435-.3636-.043-.043-.1674-.043-.33-.0622a2.2396 2.2396 0 00-.1962-.0095c-.2918 0-.641.0382-1.0333.287-.7702.488-.6602 1.3107-.7798 1.5117-.0143.0287-.0287.0621-.0287.1004 0 .0813.091.1722.1723.1674.0717 0 .1148-.0191.153-.0191.2153 0 .4593.1483.799.153.2056 0 .4448-.0621.7462-.2152.641-.3205.8898-1.1146.8898-1.2485 0-.1675-.134-.1483-.2488-.3014zM1.9948 8.118c-.2918 0-.6123-.3636-.6123-.6936 0-.177.134-.4019.2296-.4019.0335 0 .0574.024.0574.091.0526.4352.3445.684.6076.8131.0287.024.0478.024.0478.0431 0 .0526-.1674.1435-.33.1483zm.8372-.5501c-.311 0-.5597-.4736-.5597-.7415 0-.1674.1004-.1866.2296-.1866.0622 0 .0909.0096.1387.0335.0766.043.0766.2153.177.354.0622.0813.2296.1818.2296.2535 0 .1244-.0717.287-.2152.287zm.8515.2105c-.1962.2296-.4019.6218-.4019 1.0285 0 .4783.2966.8802.7559.8802.4353 0 .641-.3732.641-.7559-.0048-.6027-.5454-1.0237-.995-1.1528zM1.7748 6.0658s-.2584.1961-.5789.1961c-.3827 0-.684-.287-.684-.684 0-.2775.1435-.5598.4735-.7033-.0095.0526-.0095.0957-.0095.1531-.0048.5023.2774.8898.7989 1.038zM17.4893 9.022c0 .2057.1722.378.378.3732.2056 0 .373-.1675.373-.3732s-.1674-.3731-.373-.3731c-.2105 0-.378.1722-.378.3731zm.024 1.1242c0 .2296.1817.421.421.421a.4216.4216 0 00.4209-.421.4216.4216 0 00-.421-.421c-.2296.0096-.421.1914-.421.421zm-1.282.7606c0 .3444.2726.6171.617.6171.3397 0 .6171-.2774.6171-.617s-.2774-.6172-.617-.6172c-.3397.0048-.6172.2775-.6172.6171zm.33-1.2629c0 .1961.1579.354.354.3588.1961 0 .3588-.1627.3588-.3588s-.1627-.3588-.3588-.3588c-.1914 0-.3492.1627-.3492.3636l-.0048-.0048zm-1.1672.7176c0 .1961.1578.354.354.354s.3587-.1579.3587-.354-.1626-.354-.3587-.354c-.1914 0-.3493.1626-.354.354zm.9184-2.0905c0 .3061.2631.5692.5693.5692s.5693-.2583.5693-.5692-.2584-.5693-.5693-.5693c-.311 0-.5693.2631-.5693.5693zm.665-1.0907c0 .1818.1483.3444.3444.3396a.341.341 0 00.3397-.3396.341.341 0 00-.3397-.3397c-.1913.0048-.3492.1531-.3444.3397zm-1.6121.8563c0 .1818.1483.3444.33.3396a.341.341 0 00.3397-.3396.341.341 0 00-.3397-.3397c-.177.0048-.33.1531-.33.3397zm-.0431 1.1624c0 .3062.2392.5502.5358.5454a.542.542 0 00.5453-.5454.542.542 0 00-.5453-.5453c-.2966-.0048-.5406.2344-.5358.5453zm-1.1242.5645c0 .2727.2296.5023.5023.507.2775 0 .507-.2295.507-.507 0-.2775-.2343-.507-.507-.507-.2679 0-.5023.2248-.5023.507zm.3014-1.2581c0 .1961.1579.354.354.354s.3588-.1627.3588-.3588-.1627-.3588-.3588-.3588c-.1914-.0048-.3492.1579-.3492.3588h-.0048v.0048zm3.1333 2.7506c0-.177.1627-.33.335-.33.196 0 .3443.1482.3443.33 0 .2057-.153.3492-.3492.3445a.3312.3312 0 01-.33-.3445zm.3014 9.3666c.0718-.0622.091-.1627.091-.2583v-.2057c0-.2584-.3924-.4114-.9281-.4114-.6506 0-.9998.2918-.9998.4161v.4114c0 .1723.3875.3445.8802.3445.3779 0 .7271-.1005.9567-.2966zm.4638.0958c-.2297.1771-.775.5787-1.674.5835-.4832 0-.6937-.1531-.7655-.1531-.0909 0-.1865.0909-.287.2057-.2105.2487-.488.7128-.488 1.2246 0 .354.2727.708.7894.7128 1.6695 0 2.9133-1.0428 2.9133-1.8896.0047-.4796-.2828-.6856-.4882-.6839zm-.8417 1.6359c-.2248.153-.5262.2774-.971.2822.0717-.2152.1243-.4353.1243-.6506 0-.0717-.0096-.1243-.0191-.2057h.1148c.6984-.0047 1.0045-.2822 1.0572-.2774.043 0 .1004.024.1004.1866 0 .196-.0909.4544-.4066.6649zm1.1529-9.1322c0 .2153.067.4784.2966.4832.1865 0 .3492-.287.3492-.598 0-.3587-.0622-.6314-.0622-.775 0-.0621.0287-.0908.0622-.0908.134.0095.2631.3779.4018.3779.1627 0 .4019-.2966.4975-.2966.0287 0 .0335.0335.0335.043 0 .134-.2057.4306-.2057.5502 0 .1004.5119.1148.5119.2057 0 .134-.5406.134-.7989.2487-.2488.1053-.4018.2392-.4018.421s.1817.2153.4353.2153c.598 0 1.0141-.3205 1.148-.3205.0288 0 .048.0239.048.043 0 .091-.3015.3827-.3015.5119 0 .1483.5502.33.5502.421-.0096.0286-.043.0334-.1053.0334-.1004 0-.2487-.0287-.3683-.0287-.0718 0-.134.0096-.1627.043-.0622.067.024.5454-.1052.5454-.1148 0-.421-1.0524-1.105-1.0524-.1005 0-.1675.0813-.1675.2153 0 .354.3444.7654.6745.9615.1483.1005.4019.1961.4019.2535 0 .1053-.5693.0096-.5693.1866 0 .1579.067.4018.067.5454 0 .043-.0096.0956-.0622.1004-.1053 0-.3684-.488-.4927-.488-.1053 0-.3397.2919-.4354.2919-.0239 0-.043-.0287-.043-.0526 0-.2057.33-.6698.33-1.1242 0-.2153-.0286-.6793-.287-.6793-.2152 0-.4544.3396-.5597.6745-.0622.1961-.0191.952-.1626.952-.134 0-.1005-.5071-.2775-.5071-.134 0-.4162.2392-.5166.2392-.0191 0-.0335-.0096-.0335-.0287 0-.1053.2583-.4545.2583-.5262 0-.134-.5884-.1531-.5884-.2584 0-.0622.2296-.1052.445-.1435.4544-.0813 1.124-.4114 1.124-.8754 0-.5166-.4974-.7415-.8275-.952-.1674-.1052-.3588-.1961-.3588-.2679 0-.0717.2153-.0717.3014-.0717.134 0 .2679-.0096.2679-.1148 0-.0813-.0191-.2392-.0191-.3636 0-.0909.0095-.1626.043-.1626.134 0 .3205.4353.4114.4353.1435 0 .3397-.3588.4736-.3588.043 0 .0574.024.0574.1053-.0048.3348-.1722.7127-.1722 1.0332zm-4.2528-2.607c.1005.7557 1.1194.3778 1.1194 1.2915 0 .134-.0334.3301-.0334.4975 0 .1962.0239.3636.1722.3636.153 0 .1865-.1053.1865-.2488s-.0335-.3205-.0335-.421c0-.3109.2249-.3826.3588-.3826.3397 0 .5932.3444 1.1099.3492-.1149.5692-1.2917.421-1.2917 1.0428 0 .3062.3062.3875.512.3875.1865 0 .2487-.0287.2487-.1865 0-.091-.0192-.1866-.0192-.2488 0-.0335.0287-.0718.0718-.0718.1961 0 1.1529.732 1.1529.952 0 .2057-1.0142.4114-1.3108.4114-.0909 0-.1052-.0622-.1052-.0957 0-.0622.153-.2487.153-.3587 0-.0814-.1339-.134-.4927-.134-.1674 0-.2966.0191-.2966.153 0 .2393.3875.5359.3875.756 0 .177-.1052.287-.3922.287-.2392 0-.6028-.1866-.6028-.4976 0-.2487.2583-.4975.2583-.6506 0-.043-.0335-.1148-.1387-.1148-.33 0-.421.8755-1.5882.9711.1866-.1674.3492-.3587.3492-.7414 0-.1866-.043-.3397-.043-.5454 0-.2679.1243-.4018.3013-.4018.3301 0 .4928.4688.708.4688.1148 0 .2392-.1053.2392-.268 0-.6792-1.3012-.5787-1.3012-1.5307-.0095-.2679.0861-.5884.3205-1.0333zm2.9947 5.5538c.0622.1005.0909.1962.0909.287 0 .2488-.1675.4832-.1675.7415 0 .2966.2296.5358.5597.5358.3636 0 .6171-.2918.6171-.641-.0048-.4784-.4353-.8802-1.1002-.9233zm-2.9516.5693c.0909.0909.1148.1818.1148.2679 0 .134-.0622.2774-.0622.4257 0 .2153.1579.4019.3875.4019.2488 0 .421-.1962.421-.4258.0048-.3348-.3397-.6697-.8563-.6697h-.0048zm.2153-1.0524c.4114.0574.5118.1961.5118.311 0 .196-.177.2582-.3492.2582-.1244 0-.2679-.0287-.421-.0287-.196 0-.3922.043-.5549.2296.1148.024.287.1005.287.2775 0 .5166-1.435.0909-1.435 1.416 0 .708.7318 1.4734 1.8417 1.4686.5692 0 .9376-.1866.9376-.4018 0-.1675-.3014-.0527-.3014-.1962 0-.0622.1053-.177.1053-.2774 0-.043-.0335-.1244-.1053-.1244-.1626 0-.464.2583-1.0811.2631-.4832 0-.952-.2775-.952-.6506 0-.0813.0335-.1244.091-.1244.0525 0 .1243.0335.1817.0335.0526 0 .0622-.0335.0622-.134s0-.373.1674-.373.4927.6266 1.727.6266c.4066 0 1.2007-.0813 1.4973-.3492-.0096.9807-.775 2.2723-2.3823 2.2723-1.6648 0-2.5593-1.3395-2.5593-2.5689 0-1.3633 1.1146-2.6023 2.6406-2.6023.3922 0 .7175.1387.7175.3013 0 .2488-.5836.1005-.6266.3732zm.971-.4688c.1244.1483.1675.311.1627.4544 0 .3827-.2918.775-.2918 1.1481 0 .5023.33.8132.7845.8132.4975 0 .7846-.421.7846-.8754 0-.6601-.5023-1.3586-1.44-1.5403zm.6794 1.4112c-.1244-.0096-.2153-.1005-.2153-.2249 0-.067.043-.177.0574-.263.0191-.1197-.0096-.225.0622-.225.1626 0 .33.2584.33.445 0 .1435-.0908.2679-.2343.2679zM8.9504 5.5109c-.4545.0095-.8755.3827-1.1625.8897a1.697 1.697 0 00.0287-.3061c0-.6937-.3731-1.3203-1.0763-1.3203-.5693 0-1.086.33-1.3012.971.0622-.067.2488-.1817.4018-.1817.177 0 .2297.153.2297.3923 0 .1626-.0383.3492-.1005.5262-.11.2918-.3062.3827-.4114.3827-.4449 0-.244-.732-.4688-.732-.1866 0-.2392.3923-.2392.5454 0 .507.33 1.0428 1.062 1.0428.775 0 1.215-.3683 1.6887-.8658.0908.5358.3827 1.4542 1.1672 1.4542.4257 0 .7319-.354.7654-.7653-.0574.0526-.134.0956-.2249.0956-.1626 0-.196-.2296-.196-.4353 0-.33.0956-.684.2487-.684.0813 0 .1243.0526.1435.2917.0143.1866 0 .3923.1148.3923s.1866-.3683.1866-.6171c0-.574-.268-1.0763-.8563-1.0763zM6.3097 7.233c-.0765 0-.0956-.0717-.1004-.134 0-.3491.3827-1.9086.6601-1.9086.067 0 .091.0526.091.1243 0 .2775-.3493 1.9183-.6507 1.9183zm1.1864-.665c-.2296.2584-.354.3636-.4544.3636-.0527.0048-.1053-.086-.1053-.1913 0-.1914.134-.9041.4018-.9041.1053 0 .177.196.177.373 0 .134 0 .244-.019.3589zm.5214.6172c-.0909.0048-.1387-.1435-.1578-.464.1435-.2392.2392-.3445.33-.3445.0383 0 .0718.0335.0718.1866v.0048h.0048c0 .311-.1483.6219-.2488.617zm.4784.5405c-.0574 0-.1004-.0813-.0957-.2679 0-.4831.311-1.3633.4975-1.3633.0527 0 .0718.1244.0718.2392 0 .5357-.2488 1.392-.4736 1.392zm-1.215.1866c-.3828 0-.4019.464-.4019 1.4016-.287-.617-.7558-1.2724-1.3107-1.2724-.3732 0-.5167.2487-.5167.684 0 .091.0096.2297.024.3014.043-.153.1865-.2153.3635-.2153.3827 0 .8467.2966 1.1529.6937-.3492-.0622-.6889-.1244-.9711-.1244-.177 0-.3397.0191-.4736.0813-.2583.1148-.6075.4975-.6075 1.0764 0 .0909.0095.1818.0239.2918.311-.6937 1.1385-1.0094 1.6743-1.0094.1052 0 .1818.0096.2535.0191-.2774.2488-.3396.6841-.3588.9807-.0095.1435-.0621.153-.1626.1483 0 .2966.2296.732.2296.952 0 .0813-.043.153-.0909.1674 0 .3875.3875.6745.3875.9233 0 .0621-.0191.1148-.043.1435.0287.1578.4592.4353.5118.5645.067.1578.1483.196.1962.196.153 0 .3922-.177.3922-.3396 0-.0526-.043-.1148-.0813-.1435-.1674-.1243-.2583-.3922-.33-.5692-.0623 0-.1436-.024-.1723-.1292-.0478-.1866-.0526-.5262-.1244-.732-.1148-.0286-.1674-.0717-.1674-.3109 0-.1148.0718-.5692.0718-.7319-.0527 0-.1244-.0334-.1244-.1435 0-.287.287-.507.3635-.8754.5071.378.6267.7558.6267 1.0955 0 .177-.0287.3492-.0622.507.3732-.1865.9376-.464.9376-1.0237 0-.33-.153-.6936-1.1576-.8371.311-.1148.7032-.177 1.0333-.177.5692 0 .904.1818.971.5836.1149-.177.2058-.3827.2058-.5693 0-.4353-.3636-.7223-.8276-.7223-.5454 0-1.0238.287-1.5404.6267.2344-.4832.3923-.7654.6793-.7654.043 0 .0909.0095.1387.0191-.0957-.3827-.5023-.7702-.7128-.7654zm15.0209 6.4246c.4449 0 .7989.5836.7989 1.258 0 .7224-.3397 1.507-.9424 2.0475-.0096-1.2007-1.483-.818-1.483-1.6934 0-.3732.2679-.622.5884-.622.287 0 .5023.0814.6745.2393-.1626-.1531-.2392-.3636-.2392-.5693-.0048-.3492.2105-.6601.6028-.6601zm-6.616-9.1178c-.0717-.1149-.3396-.177-.464-.177-.3922 0-.6601.2774-.7127.5262-.0335-.091-.0622-.1962-.0622-.3014 0-.3923.2679-.8754.9185-.8754.5692 0 .7893.2966.8706.2966.0909 0 .177-.091.2488-.091.0956 0 .1004.1484.1004.2584 0 .354-.1626.971-.5645 1.2007-.0717-.153-.2152-.3205-.4449-.4257-.0621-.0287-.0908-.0814-.0908-.134.0047-.1052.0956-.2296.2009-.2774zm-1.3442.6505c.2297.2297.4354.3206.6841.3206.1005 0 .2153-.0287.2775-.0287.0813 0 .1387.0334.1387.1004 0 .1005-.0909.2583-.1961.3492.1052.0479.2296.0574.3444.0622.507 0 1.0859-.3205 1.0859-1.1242.1052.1388.1722.4354.1722.5693 0 .9711-.7128 1.3442-1.373 1.3442-.4305 0-.641-.1435-.6983-.1435-.1675 0-.158.3397-.2775.33-.2057-.0334-.3923-.4878-.3923-.971 0-.287.0766-.598.2392-.818h-.0048v.0095zM6.7116.201c0-.0526-.268-.1052-.6315-.1052-.5788 0-.4975.4831-.9424.4783-.464 0-.3492-.4975-.9376-.4975-.3588 0-.684.0622-.684.1436 0 .1004.421.0574.421.354 0 .3109-.8994.4018-.8994.5883 0 .0575.067.091.1578.091.1962 0 .5071-.091.732-.091.1243 0 .2391.024.2391.1436 0 .2248-.4831.6218-.4831.8036 0 .0574.0478.067.0909.0718.177 0 .4831-.4545.7654-.4545.4736 0 .1578 1.0046.421 1.0094.2678 0 .153-.9902.5357-.9902.311 0 .5501.684.7558.684.0527 0 .0957-.043.0957-.1052 0-.1866-.2679-.5693-.2679-.818 0-.1531.1053-.2249.2488-.2249.2057 0 .4784.1244.6267.1244.0526 0 .1052-.0191.1052-.0813 0-.2153-.7941-.4449-.7941-.7223C6.2763.33 6.7164.33 6.7116.2009zm2.0953.909c0 .1578.5597.5022.8228.507.153 0 .196-.2057.196-.421 0-.2679-.1147-.2774-.3491-.2774-.2966.0048-.6697.086-.6697.1913zm.928 1.7651c0-.5358-1.4447-1.5069-1.4638-1.923 0-.0383.0191-.0766.0526-.11C8.5725.5787 9.601.3922 9.601.1673c0-.1148-.2153-.1148-.3206-.1148-.8275 0-2.0426.3014-2.0426.598 0 .3061 1.0859 1.038 1.0859 1.4064 0 .1005-.0622.134-.1626.1387-.3014 0-.9616-.3635-1.2725-.3635-.1435 0-.1962.0956-.1962.2392 0 .421.5023 1.2342.5023 1.4733 0 .0288-.0095.0622-.043.0622-.1627 0-.9185-.8897-1.1864-.8897-.0957 0-.1052.134-.1052.33v.3014c0 .2057-.0096.33-.1053.33-.2296 0-.3396-.6505-.5597-.6505-.2296 0-.2774 1.1577-.4975 1.1529-.2583 0-.0335-1.2725-.287-1.2725-.2775 0-.5884.8467-.7845.8467-.0718 0-.091-.0717-.091-.134 0-.2582.1532-.6792.1532-.928 0-.1243-.0335-.196-.1436-.196-.2774 0-.885.4448-1.1146.4448-.0334 0-.0813-.0191-.0813-.0526 0-.2153.9711-.8898.9711-1.196 0-.2965-1.3394-.1004-1.3394-.4353 0-.287.952-.5788.952-.8754 0-.2583-1.1338-.3731-1.5691-.3731C.8372.0096.55.0718.55.2248c0 .2297 1.2007.3062 1.2007.5023s-1.239.7224-1.239 1.0237c0 .2632 1.7461.024 1.7461.2966 0 .3014-1.526 1.6122-1.526 2.0475 0 .1004.067.1387.1722.1435.464 0 1.6648-.8802 1.9948-.8802.1149 0 .1244.1387.1244.263 0 .2345-.0813.5885-.0813.8468 0 .2057.0574.3444.2296.3492.33 0 .6315-.5597.8563-.5597.287 0 .1148 1.6456.5501 1.6504.3636 0 .5167-1.7843.7463-1.7843s.421.5118.6267.5118c.2679 0 .1435-.8993.4305-.8993.311 0 1.2007 1.0763 1.5978 1.0716.1243 0 .1674-.1005.1674-.2249 0-.4736-.6602-1.5403-.6602-1.88 0-.0909.024-.1148.1244-.1148.3492 0 1.3586.4784 1.8418.4784.1817.0191.2774-.0718.2822-.1914zm-8.142-.5166c0 .177-.6792.775-.9184.775-.0909 0-.1148-.1053-.1148-.2058 0-.177.0813-.4257.177-.507.1148-.1053.3827-.1579.5884-.1579.1292 0 .2679.024.2679.0957zm6.5538.9185c0 .3061 1.1194 1.8417 1.325 1.837.177 0 .311-.311.311-.579 0-.0717-.0191-.1434-.0526-.196-.1626-.2249-1.2916-1.1147-1.5403-1.1147-.024-.0047-.0479.0192-.0431.0527zM23.5073.1722c-.445 0-.5215-.1387-.8228-.1387-.3636 0-.622.2487-.622.6219 0 .1244.0431.3205.0431.5788 0 .3157-.0622.6075-.3396.6075-.2535 0-.354-.1674-.354-.3635 0-.354.1866-.5932.1866-.8276 0-.4258-.5262-.5501-1.0764-.5501-.6601 0-1.373.177-1.373.2678 0 .1531.952.0622 1.6218.9185-.4353.0096-1.282.2057-1.282.3205 0 .1435 1.5164.3062 1.5164.9376.0048.4162-.3301.4593-.4593.464-.5022 0-.7701-.5118-.904-.5118a.0704.0704 0 00-.0718.0718c0 .0813.0717.2918.0717.5166 0 .5693-.6314.6315-.6314.7463 0 .043.0191.0622.0909.0717a9.153 9.153 0 001.3825.1053c1.612 0 2.9324-.5023 2.9324-1.9087 0-.775-.2392-1.0238-.2392-1.4017 0-.1244.0909-.3827.33-.5262zm-2.2867 3.0473c-.1004 0-.2152 0-.33-.0096 1.0428-.1674 1.6217-.7702 1.6217-1.5643.2344.067.3779.3062.373.5597 0 .464-.4448 1.0142-1.6647 1.0142zM22.6893.794c-.1292-.0048-.2297-.0957-.2297-.22 0-.1292.1053-.2201.2297-.2249a.2246.2246 0 01.2248.2248c0 .1244-.1005.2249-.2248.2201zm.5597 11.5814c-.4162 0-.6602.732-1.0668.775.2583-1.0716 1.3203-1.6217 1.3203-2.6215 0-1.1337-.952-1.5308-1.349-1.7843-.665-.9376-1.1386-1.6791-2.2053-1.6791-.4545 0-.7415.0813-1.0524.0813-.6028-.0048-.7894-.2344-.8324-.2344-.0096 0-.0191.0096-.0191.043 0 .8276.4353 2.7268 2.3535 2.7268 1.0238 0 1.4639-.3923 1.703-.3923.2584 0 1.086.2823 1.086 1.2294 0 .5262-.4162 1.062-.5693 1.062-.1483.0048-.3062-.2344-.3062-.488 0-.2822.1531-.7988.1531-1.1193 0-.1196-.0191-.177-.0909-.177-.1626 0-.928.4784-.928 1.0955 0 .5262.775.8467 1.0668.9998-.2918.4831-.4688.794-.6124 1.239 0-.335-.3205-1.019-.421-1.306-.4927-1.3395-.6649-1.5882-1.679-1.703.153.5358 1.8991 1.8274 1.8991 3.1477 0 .0813-.0095.1961-.0191.2392-.5262-1.5404-1.4303-1.8944-1.7604-2.2723-.5358-.5884-.2296-1.1577-1.086-1.4782.0527.0718.0718.1627.0718.2583 0 .2823-.1626.641-.1626.8898 0 .928 1.0907.6506 1.7221 1.1577.622.5023.9711 1.3203 1.2294 2.2292.2488-.397.3923-.8802.8372-.8802.287 0 .3827.3588.3827.6075 0 .0526 0 .1005-.0096.134.4258-.3636.6506-.952.6506-1.3443 0-.263-.0909-.4353-.3061-.4353zm-1.66-3.4969c-.0909 0-.2631-.0478-.378-.0478-.306 0-.5213.421-.6792.421-.0574 0-.0813-.0527-.0813-.1005 0-.1722.3013-.378.3013-.4927 0-.0814-.1291-.1053-.1817-.1053-.3062 0-.732.4162-.9711.4162-.043 0-.1005-.024-.1005-.0813 0-.1148.3205-.2775.3205-.4019 0-.11-.1387-.1339-.2296-.1339-.1483 0-.4449.0813-.6315.0813-.1004 0-.1817-.0191-.1817-.1004 0-.1818.5788-.0622.5788-.2775 0-.1052-.1818-.3014-.1818-.4018 0-.0383.0478-.067.0909-.067.2057 0 .421.5597.6602.5597.1052 0 .1339-.0813.1339-.1961s-.024-.1722-.024-.2727c0-.1052.0431-.134.0766-.134.1483 0 .2823.8037.6937.8037.1817-.0048.0526-.4927.2152-.4927.1005 0 .1244.1435.134.2248.043.5262.5166.5454.5166.732 0 .019-.0287.067-.0813.067zM17.0062.0574c-.598 0-1.0333.2918-1.2677.2918-.1387.0096-.354-.3492-.464-.3492-.043 0-.091.0909-.091.2392 0 .1004 0 .4114-.1052.4114-.2152 0-1.0428-.6123-1.0428-.3923 0 .2057.5501.8324.5501.995s-.5453.311-.5453.421c0 .1961.5836.2296.5836.4832 0 .2487-.6076.4449-.6076.6266 0 .1483.6076.0479.6076.2297 0 .1865-.445.8132-.445.9902 0 .0478.0097.0478.048.0478.1674.0048.6792-.5788.7988-.5788.1435 0 .1722.3444.1961.555.0192.1004.0335.1147.0814.1147.1052 0 .2774-.4114.3922-.4114.1675 0 .6267.4688 1.3825.4736 1.0764 0 2.0953-.7558 2.0953-2.0953 0-1.2916-.9089-2.0522-2.167-2.0522zm-1.526 2.875c-.0287 0-.043-.0335-.043-.0813l-.0192-.354c0-.0335-.0192-.0717-.0622-.0717-.1053 0-.311-.0096-.3731-.0096-.043 0-.0622-.0096-.0622-.0287.0095-.067.3635-.3205.3683-.378 0-.1004-.3492-.287-.3492-.3922 0-.0191.0191-.0287.043-.0287.1005 0 .2632.0335.4019.0335.1148 0 .134-.4975.22-.4975.0622 0 .1723.4688.2631.4688.1149 0 .3301-.134.421-.134.0192 0 .0335.0096.0335.0287 0 .0622-.2248.3014-.2248.378 0 .0813.5023.1817.5023.2487 0 .0909-.5071.0813-.5071.1627 0 .0574.1818.3061.1818.3874 0 .0192-.0096.0287-.0287.0287-.0718 0-.3493-.1243-.4306-.1243-.1004 0-.2583.3635-.3348.3635zm1.5451.7702c-.6267 0-1.0333-.311-1.0333-.4736 0-.0813.0526-.134.1244-.134.1961 0 .6267.2967.7654.2967.0335 0 .0622-.0192.0622-.0718 0-.1626-.153-.4257-.153-.5597 0-.0335.0286-.0622.0812-.0622.2392 0 .5932.1005.7893.1005.0622 0 .0814-.0335.0814-.0718 0-.1961-.5789-.5788-.5789-.6936 0-.1053.7224-.2679.7224-.4353 0-.177-.9807-.0527-.9807-.2249 0-.1243.1866-.3396.1866-.4353 0-.043-.0335-.0622-.0957-.0622-.0813 0-.507.1675-.6888.1675-.091 0-.1962-.0192-.1962-.1436 0-.2057.3492-.4257.8946-.4257.8802 0 1.4064.6075 1.4064 1.6217-.0048 1.2868-.8993 1.6073-1.3873 1.6073zm-6.037 15.4228c0 .0813-.0288.1674-.1005.2583-.0957-.177-.3732-.2679-.4975-.2679-.9185 0-.5693 1.3299-1.55 1.3299-.4114 0-.4448-.0526-.598-.0526-.0621 0-.1004.0287-.1004.0813 0 .2296.33.7989 1.2438.8037.9185 0 1.7987-.5597 1.7987-1.2582 0-.1148-.0287-.2392-.0814-.3635.0335-.0527.1244-.091.2057-.091.1436 0 .2153.158.354.1627.1436 0 .2488-.1052.2488-.2487 0-.1148-.0622-.1962-.1674-.2488.0717-.0526.1243-.1435.1243-.2392 0-.153-.1052-.2918-.287-.2918-.0813 0-.134.0287-.1961.0861-.0191-.1578-.1053-.311-.2775-.311-.134 0-.2344.0958-.2344.2536.0192.1244.1148.2392.1148.397zm-2.8703-.6458c-.0622 0-.1435.0095-.2296.0095-.0813 0-.1962-.0191-.268-.0813-.1434-.1244-.1865-.794-.4544-1.196-.2918-.4448-.6123-.5692-1.0524-.5692-.311 0-.6601.1674-.6601.421 0 .153.086.2583.6505.4066.7128.1818 1.0764.5597 1.1434 1.0142.0717.4353.1578.7893.33.971.2249.2536.665.4689 1.0381.4689.3205 0 .5788-.1053.5788-.4019 0-.3205-.4353-1.0428-1.0763-1.0428zm.4736.9806c-.2679 0-.6697-.287-.6697-.4449 0-.1339.1243-.2057.2248-.2057.2248 0 .6267.2727.6267.5071-.0048.0622-.0479.1388-.1818.1435zm2.1335-3.9226c-.4114-.1483-.5932-.3875-.6745-.8563-.2009.2727-.2966.531-.2966.684 0 .6028.8276.6124.8276 1.0142-.0048.2344-.421.4736-.971.4784-.6411-.0048-1.0716-.1053-1.4735-.507-.1052-.1149-.153-.2154-.287-.2154-.153 0-.2153.268-.2153.5071 0 .8754.8324 1.9087 1.99 1.9087 1.4448-.0048 2.0045-.9998 2.0045-1.8034 0-.4688-.11-.9137-.9042-1.2103zm-.4257 2.4397c-.1148 0-.1387-.0718-.1387-.1722 0-.0814.0287-.2344.0287-.3492 0-.3158.1196-.2919.4257-.4306h-.0048c.2153-.1004.2966-.2344.3636-.2344.0813 0 .153.0526.153.177 0 .464-.507 1.0094-.8275 1.0094zM7.7736 12.519c0-.5692 1.3538-.8754 1.3538-1.5786 0-.1148-.043-.3205-.1244-.4736.4736.2631.8228.6984.8228 1.0524 0 .6171-.641.8994-.641 1.282 0 .445.684.512.684 1.0716 0 .4545-.6505.9807-.6505 1.5691 0 .4592.3205.8324.8132.8898-.1627.0335-.3014.0622-.4545.0622-.8993 0-1.8274-.7415-1.8274-1.6217 0-.4353.1866-.818.4736-1.0955.2488.2153.5023.354.665.354.1435 0 .2057-.0718.2057-.177-.0096-.3253-1.3155-.6362-1.3203-1.3347zM5.219 16.2743c-.0335-.3205-.3253-.5597-.622-.5215-.1147.0144-.2248.0574-.2965.1196-.0813-.2679-.3301-.4975-.6745-.4449-.311.0527-.5167.3158-.4832.6506.0048.0574.024.1148.0478.177 0 0-.0526.0096-.0908.0144-.2584.0478-.5454.311-.4975.6506.0382.3061.3205.5358.641.4975.1148-.0144.2248-.043.2966-.091.0717.2871.3061.4689.6266.4258.3301-.043.5502-.3013.5167-.6314-.0096-.0909-.0287-.1435-.0526-.2057 0 0 .043-.0048.0765-.0096.3205-.0622.5406-.3205.5119-.6314zm-1.2486.6697c-.1866.024-.354-.11-.378-.2966s.1101-.354.2967-.378c.1913-.0238.3588.1149.3779.2967.024.1865-.11.354-.2966.3779z\"/></svg>");
        setPath("M21.436 6.6255c.1147.8467 1.392 1.99 1.746 1.9613.2344-.0191.3205-1.105.3205-1.9613 0-.488.0287-.8754-.2296-.9616-.4114.8276-1.4878.995-1.837.9616zm.0717-.378c.928 0 1.7747-.7414 1.7747-1.392 0-.3014-.1435-.555-.507-.598.0622.0813.0909.1388.0909.287 0 .4928-.7463 1.0333-1.5595 1.0333-.2966 0-.3827.2057-.3827.311-.0048.2583.2344.3588.5836.3588zm-.1962-1.0045c-.1243 0-.3013 0-.4018-.1962-.0335-.0621-.0478-.1387-.0622-.22-.0239-.1244-.0478-.2488-.1435-.3157.153.0478.3062.0478.4353.0478.4019 0 .7846-.2775 1.0811-.2775.1962 0 .2536.1244.2536.2488.0096.3923-.7893.7128-1.1529.7128h-.0096zM1.373 12.232c.3014 0 .2392-1.856.732-1.856.1148 0 .1482.1147.1482.263 0 .421-.2057 1.0333-.2057 1.373 0 .1722.0479.2296.1244.2248.2153 0 .5884-2.0427.952-2.0427.1148 0 .1722.1149.1722.2344 0 .4258-.5454 1.66-.5454 2.0044 0 .0574.024.1005.0575.1005.2248 0 .6697-.9615.8132-1.4447.0813-.2488.1866-.3827.287-.3827.0909 0 .1722.1005.1722.3062 0 .4831-.4449 1.612-.8371 2.3727-.3014.5884-.775 1.4351-.775 1.9087 0 .2392.0478.4927.3875.7893-.5693-.0335-.8037-.0909-1.0142-.5358-.952 1.8944 1.7605 1.7126.8324 3.3965-.1674-.3014-1.5069-.6123-1.5069-2.3775 0-1.526 1.3347-2.4158 1.3347-3.0473 0-.1243-.043-.2296-.1579-.33-.2966-.2488-.3013-.4545-.5358-.4545-.1674 0-.373.3923-.1626.7415.0718.1148.1387.1818.1387.2966 0 .2487-.3922.9185-.6697.9137-.2774 0-.488-.6841-.488-1.7891 0-.9807.2249-1.971.4976-1.971.0813 0 .1004.0575.1004.1244 0 .1148-.0335.3492-.0335.7415.0048.4162.0957.4497.1818.4401zm2.2723 2.612c.3731 0 .684-.2775.684-.8898v-.909c0-.3492.0288-.7414.2584-1.0141-.0287.1148-.0287.2392-.0287.354 0 .7654.421 1.2916.421 2.033 0 .2775-.0814.4258-.2918.421-.2057 0-.1866-.1865-.2344-.1865-.0335 0-.091.1148-.091.2392 0 .1817.1388.4783.5024.4831.3205 0 .5788-.2918.5788-.6219 0-.8036-.6219-1.6934-.6219-2.5497 0-.3731.1005-.6219.177-.818 0 1.77 1.5069 3.0616 1.5069 3.803 0 .1675-.1244.3014-.311.3014-.2057 0-.3013-.1626-.3013-.287 0-.0622-.0096-.0813-.0335-.0813-.0526 0-.2153.177-.2153.4114 0 .2966.2392.6506.684.6506.5072 0 .7846-.4306.7846-.8133 0-.9376-1.8274-2.3536-1.8274-3.87 0-.2583.043-.6793.2296-.9998-1.1768.7558-1.5403 1.7652-1.5403 2.6502 0 .7654-.0287 1.148-.421 1.148-.2057 0-.2583-.1865-.33-.1865-.0527 0-.0814.1627-.0814.2057.0096.3349.244.5167.488.5167h.0143v.0095zM19.8334 4.6401c-.1722 0-.4545.1866-.6793.1866-.2823-.0048-.201-.3588-.5119-.3588-.067 0-.1483.0191-.2296.0622-.6458.3253-1.1481.201-1.263.2775-.0286.0143-.0525.0382-.0621.0908 0 .6698.7128 1.703 1.8991 1.703.8133 0 1.4974-.2774 1.4974-.7319 0-.397-.3827-1.2294-.6506-1.2294zm-.7415 1.3012c-.6554 0-1.086-.354-1.0811-.5884 0-.0287.0191-.0478.0526-.0478.1052 0 .3923.1435.7654.2057.4353.0717.6697.0813.7845.0813.1148 0 .1674.0287.1674.0622 0 .11-.2965.287-.6888.287zM3.8318 18.2069c-.2918.0718-.7654.5358-.7654 1.2677 0 .8706.9376 2.2149 2.478 2.2149 1.3011 0 1.6216-.8994 1.6216-1.507 0-1.3441-.8276-2.2913-1.9087-2.2913-.5884 0-1.1146.4305-1.1146 1.062 0 .5931.4449 1.4733 1.5069 1.4733.4975 0 .794-.3587.794-.7653 0-.4019-.3635-.952-.8993-.952-.1626 0-.2774.1052-.2774.2774 0 .2153.2966.421.665.4258.0908 0 .1626-.0191.196-.0335.0192.024.024.067.024.1053 0 .2057-.1962.33-.4975.33-.4545 0-.8898-.3396-.8898-.8754 0-.3205.2775-.5501.6793-.5501.794 0 1.2677.708 1.2677 1.4064 0 .6315-.3492.9998-1.062.995-1.4351.0048-2.124-1.2868-1.8178-2.5832zm11.0552 2.8368c-.091-.1723-.0192-.4689-.287-.4689-.1818 0-.1962.1436-.2153.2584-.3875-.11-.708-.1675-.995-.1675-.2057 0-.3827.0287-.5358.0814-.1005-.1818-.5406-.5262-.9233-.6506-.1483.8036-.8706 1.435-1.9422 1.526-.0621.5262-.4736.6601-.794.6601-.2297.0048-.598-.0765-.6172-.1674-.1243-.7558-.6984-1.1816-.9471-1.282.0095.0813.019.1674.019.2487 0 .641-.44 1.0429-1.258 1.0429-.1244 0-.2966-.0096-.421-.0335.9376 1.0428 1.6073.6601 2.0427.8563C8.582 23.2059 9.046 24 10.8734 24c.665 0 1.3443-.2583 1.7891-.5453.0814.2678.3588.507.8133.507.775 0 1.2103-.2392 1.2103-.4353 0-.0526-.0048-.134-.1388-.134s-.1148.0336-.5405.0336c-.4928-.0048-1.2964-.1962-1.6743-1.0573-.067-.1435-.1722-.1435-.2057-.1435-.2488 0-.6315.885-2.2006.885-.6553.0048-.9615-.244-.9615-.3013 0-.0096 0-.0192.0335-.0192.0622 0 .3062.0287.6075.0287.9903 0 1.7892-.4544 2.2723-.9806.1674-.1866.2488-.2153.3923-.2153.1244 0 .2583.11.3205.2774.22.5693.7271 1.0238 1.282 1.0238.751 0 .7606-1.282.9376-1.3443a.344.344 0 00.1053.0192c.0909 0 .2344-.067.2344-.2344 0-.1818-.22-.2297-.2631-.3205zm-1.215.9615c-.1962-.0048-.354-.1627-.354-.3588 0-.201.1578-.3588.354-.3588.196 0 .3587.1627.3587.3588a.3583.3583 0 01-.3588.3588zm6.4245-5.1808c-1.3108 0-.9711 1.148-2.502 1.4973-.2822.0622-.3635.153-.3635.2775 0 .2344.1292.5357.2918.5357.665 0 1.703-1.3825 1.8896-1.3825v-.009c.0784.0046.1577.0117.153.1956 0 .5023-1.4446 1.1577-1.4446 1.5165 0 .2152.5118.6697 1.0094.6697.7223.0048 1.3681-1.4734 1.5212-1.4734.1196 0 .1626.086.1626.177 0 .4018-.488 1.1863-1.3442 1.526-.177.0717-.2057.153-.2057.2153 0 .1961.2248.4879.4305.4879.2488 0 1.9231-1.459 1.9231-2.6358 0-1.105-.7989-1.5978-1.5212-1.5978zm.6027 1.2677a.5738.5738 0 01-.263-.067c-.1149-.0526-.3206-.2248-.3206-.488 0-.2391.134-.3396.2583-.3396.3827 0 .7846.3397.7893.6076 0 .2152-.2057.287-.464.287zM3.7265 6.8742c0 .1962.1579.354.354.3588.1962 0 .354-.1626.354-.3588 0-.1961-.1626-.354-.354-.354-.1913.0048-.3588.1627-.3588.354h.0048zm-.464-.7989c0 .1962.1579.354.354.354.1961 0 .3588-.1626.3588-.3587 0-.1962-.1627-.3588-.3588-.3588s-.354.1722-.354.3635zm-.3205 2.435c-.2057.0526-.6315.3013-.6315.7462 0 .3205.2536.5262.5597.5262.1627 0 .2775-.0334.3493-.0909-.2488-.2391-.3397-.507-.3397-.775 0-.177.0287-.2917.0622-.4065zm-2.1862.1291c-.0095.043-.0095.091-.0095.134 0 .421.2152.6506.5118.6506.22 0 .4832-.134.7128-.4258-.0957.0191-.2153.0287-.3205.0287-.3205 0-.684-.0909-.8946-.3875zm-.311.799c0 .6744.2058.995.5694.9997.287 0 .6697-.2057 1.1241-.598-.3492.0814-.617.134-.8563.1388C.9615 9.974.7176 9.8497.445 9.4383zm2.3106-3.5688c.043-.1435.0814-.3205.0814-.5166 0-.4258-.1962-1.0763-.8037-1.0763-.3492 0-.598.2774-.598.6075 0 .708.708.9902 1.3203.9854zm.4497.8994c-.1148-.153-.0718-.2918-.1435-.3636-.043-.043-.1674-.043-.33-.0622a2.2396 2.2396 0 00-.1962-.0095c-.2918 0-.641.0382-1.0333.287-.7702.488-.6602 1.3107-.7798 1.5117-.0143.0287-.0287.0621-.0287.1004 0 .0813.091.1722.1723.1674.0717 0 .1148-.0191.153-.0191.2153 0 .4593.1483.799.153.2056 0 .4448-.0621.7462-.2152.641-.3205.8898-1.1146.8898-1.2485 0-.1675-.134-.1483-.2488-.3014zM1.9948 8.118c-.2918 0-.6123-.3636-.6123-.6936 0-.177.134-.4019.2296-.4019.0335 0 .0574.024.0574.091.0526.4352.3445.684.6076.8131.0287.024.0478.024.0478.0431 0 .0526-.1674.1435-.33.1483zm.8372-.5501c-.311 0-.5597-.4736-.5597-.7415 0-.1674.1004-.1866.2296-.1866.0622 0 .0909.0096.1387.0335.0766.043.0766.2153.177.354.0622.0813.2296.1818.2296.2535 0 .1244-.0717.287-.2152.287zm.8515.2105c-.1962.2296-.4019.6218-.4019 1.0285 0 .4783.2966.8802.7559.8802.4353 0 .641-.3732.641-.7559-.0048-.6027-.5454-1.0237-.995-1.1528zM1.7748 6.0658s-.2584.1961-.5789.1961c-.3827 0-.684-.287-.684-.684 0-.2775.1435-.5598.4735-.7033-.0095.0526-.0095.0957-.0095.1531-.0048.5023.2774.8898.7989 1.038zM17.4893 9.022c0 .2057.1722.378.378.3732.2056 0 .373-.1675.373-.3732s-.1674-.3731-.373-.3731c-.2105 0-.378.1722-.378.3731zm.024 1.1242c0 .2296.1817.421.421.421a.4216.4216 0 00.4209-.421.4216.4216 0 00-.421-.421c-.2296.0096-.421.1914-.421.421zm-1.282.7606c0 .3444.2726.6171.617.6171.3397 0 .6171-.2774.6171-.617s-.2774-.6172-.617-.6172c-.3397.0048-.6172.2775-.6172.6171zm.33-1.2629c0 .1961.1579.354.354.3588.1961 0 .3588-.1627.3588-.3588s-.1627-.3588-.3588-.3588c-.1914 0-.3492.1627-.3492.3636l-.0048-.0048zm-1.1672.7176c0 .1961.1578.354.354.354s.3587-.1579.3587-.354-.1626-.354-.3587-.354c-.1914 0-.3493.1626-.354.354zm.9184-2.0905c0 .3061.2631.5692.5693.5692s.5693-.2583.5693-.5692-.2584-.5693-.5693-.5693c-.311 0-.5693.2631-.5693.5693zm.665-1.0907c0 .1818.1483.3444.3444.3396a.341.341 0 00.3397-.3396.341.341 0 00-.3397-.3397c-.1913.0048-.3492.1531-.3444.3397zm-1.6121.8563c0 .1818.1483.3444.33.3396a.341.341 0 00.3397-.3396.341.341 0 00-.3397-.3397c-.177.0048-.33.1531-.33.3397zm-.0431 1.1624c0 .3062.2392.5502.5358.5454a.542.542 0 00.5453-.5454.542.542 0 00-.5453-.5453c-.2966-.0048-.5406.2344-.5358.5453zm-1.1242.5645c0 .2727.2296.5023.5023.507.2775 0 .507-.2295.507-.507 0-.2775-.2343-.507-.507-.507-.2679 0-.5023.2248-.5023.507zm.3014-1.2581c0 .1961.1579.354.354.354s.3588-.1627.3588-.3588-.1627-.3588-.3588-.3588c-.1914-.0048-.3492.1579-.3492.3588h-.0048v.0048zm3.1333 2.7506c0-.177.1627-.33.335-.33.196 0 .3443.1482.3443.33 0 .2057-.153.3492-.3492.3445a.3312.3312 0 01-.33-.3445zm.3014 9.3666c.0718-.0622.091-.1627.091-.2583v-.2057c0-.2584-.3924-.4114-.9281-.4114-.6506 0-.9998.2918-.9998.4161v.4114c0 .1723.3875.3445.8802.3445.3779 0 .7271-.1005.9567-.2966zm.4638.0958c-.2297.1771-.775.5787-1.674.5835-.4832 0-.6937-.1531-.7655-.1531-.0909 0-.1865.0909-.287.2057-.2105.2487-.488.7128-.488 1.2246 0 .354.2727.708.7894.7128 1.6695 0 2.9133-1.0428 2.9133-1.8896.0047-.4796-.2828-.6856-.4882-.6839zm-.8417 1.6359c-.2248.153-.5262.2774-.971.2822.0717-.2152.1243-.4353.1243-.6506 0-.0717-.0096-.1243-.0191-.2057h.1148c.6984-.0047 1.0045-.2822 1.0572-.2774.043 0 .1004.024.1004.1866 0 .196-.0909.4544-.4066.6649zm1.1529-9.1322c0 .2153.067.4784.2966.4832.1865 0 .3492-.287.3492-.598 0-.3587-.0622-.6314-.0622-.775 0-.0621.0287-.0908.0622-.0908.134.0095.2631.3779.4018.3779.1627 0 .4019-.2966.4975-.2966.0287 0 .0335.0335.0335.043 0 .134-.2057.4306-.2057.5502 0 .1004.5119.1148.5119.2057 0 .134-.5406.134-.7989.2487-.2488.1053-.4018.2392-.4018.421s.1817.2153.4353.2153c.598 0 1.0141-.3205 1.148-.3205.0288 0 .048.0239.048.043 0 .091-.3015.3827-.3015.5119 0 .1483.5502.33.5502.421-.0096.0286-.043.0334-.1053.0334-.1004 0-.2487-.0287-.3683-.0287-.0718 0-.134.0096-.1627.043-.0622.067.024.5454-.1052.5454-.1148 0-.421-1.0524-1.105-1.0524-.1005 0-.1675.0813-.1675.2153 0 .354.3444.7654.6745.9615.1483.1005.4019.1961.4019.2535 0 .1053-.5693.0096-.5693.1866 0 .1579.067.4018.067.5454 0 .043-.0096.0956-.0622.1004-.1053 0-.3684-.488-.4927-.488-.1053 0-.3397.2919-.4354.2919-.0239 0-.043-.0287-.043-.0526 0-.2057.33-.6698.33-1.1242 0-.2153-.0286-.6793-.287-.6793-.2152 0-.4544.3396-.5597.6745-.0622.1961-.0191.952-.1626.952-.134 0-.1005-.5071-.2775-.5071-.134 0-.4162.2392-.5166.2392-.0191 0-.0335-.0096-.0335-.0287 0-.1053.2583-.4545.2583-.5262 0-.134-.5884-.1531-.5884-.2584 0-.0622.2296-.1052.445-.1435.4544-.0813 1.124-.4114 1.124-.8754 0-.5166-.4974-.7415-.8275-.952-.1674-.1052-.3588-.1961-.3588-.2679 0-.0717.2153-.0717.3014-.0717.134 0 .2679-.0096.2679-.1148 0-.0813-.0191-.2392-.0191-.3636 0-.0909.0095-.1626.043-.1626.134 0 .3205.4353.4114.4353.1435 0 .3397-.3588.4736-.3588.043 0 .0574.024.0574.1053-.0048.3348-.1722.7127-.1722 1.0332zm-4.2528-2.607c.1005.7557 1.1194.3778 1.1194 1.2915 0 .134-.0334.3301-.0334.4975 0 .1962.0239.3636.1722.3636.153 0 .1865-.1053.1865-.2488s-.0335-.3205-.0335-.421c0-.3109.2249-.3826.3588-.3826.3397 0 .5932.3444 1.1099.3492-.1149.5692-1.2917.421-1.2917 1.0428 0 .3062.3062.3875.512.3875.1865 0 .2487-.0287.2487-.1865 0-.091-.0192-.1866-.0192-.2488 0-.0335.0287-.0718.0718-.0718.1961 0 1.1529.732 1.1529.952 0 .2057-1.0142.4114-1.3108.4114-.0909 0-.1052-.0622-.1052-.0957 0-.0622.153-.2487.153-.3587 0-.0814-.1339-.134-.4927-.134-.1674 0-.2966.0191-.2966.153 0 .2393.3875.5359.3875.756 0 .177-.1052.287-.3922.287-.2392 0-.6028-.1866-.6028-.4976 0-.2487.2583-.4975.2583-.6506 0-.043-.0335-.1148-.1387-.1148-.33 0-.421.8755-1.5882.9711.1866-.1674.3492-.3587.3492-.7414 0-.1866-.043-.3397-.043-.5454 0-.2679.1243-.4018.3013-.4018.3301 0 .4928.4688.708.4688.1148 0 .2392-.1053.2392-.268 0-.6792-1.3012-.5787-1.3012-1.5307-.0095-.2679.0861-.5884.3205-1.0333zm2.9947 5.5538c.0622.1005.0909.1962.0909.287 0 .2488-.1675.4832-.1675.7415 0 .2966.2296.5358.5597.5358.3636 0 .6171-.2918.6171-.641-.0048-.4784-.4353-.8802-1.1002-.9233zm-2.9516.5693c.0909.0909.1148.1818.1148.2679 0 .134-.0622.2774-.0622.4257 0 .2153.1579.4019.3875.4019.2488 0 .421-.1962.421-.4258.0048-.3348-.3397-.6697-.8563-.6697h-.0048zm.2153-1.0524c.4114.0574.5118.1961.5118.311 0 .196-.177.2582-.3492.2582-.1244 0-.2679-.0287-.421-.0287-.196 0-.3922.043-.5549.2296.1148.024.287.1005.287.2775 0 .5166-1.435.0909-1.435 1.416 0 .708.7318 1.4734 1.8417 1.4686.5692 0 .9376-.1866.9376-.4018 0-.1675-.3014-.0527-.3014-.1962 0-.0622.1053-.177.1053-.2774 0-.043-.0335-.1244-.1053-.1244-.1626 0-.464.2583-1.0811.2631-.4832 0-.952-.2775-.952-.6506 0-.0813.0335-.1244.091-.1244.0525 0 .1243.0335.1817.0335.0526 0 .0622-.0335.0622-.134s0-.373.1674-.373.4927.6266 1.727.6266c.4066 0 1.2007-.0813 1.4973-.3492-.0096.9807-.775 2.2723-2.3823 2.2723-1.6648 0-2.5593-1.3395-2.5593-2.5689 0-1.3633 1.1146-2.6023 2.6406-2.6023.3922 0 .7175.1387.7175.3013 0 .2488-.5836.1005-.6266.3732zm.971-.4688c.1244.1483.1675.311.1627.4544 0 .3827-.2918.775-.2918 1.1481 0 .5023.33.8132.7845.8132.4975 0 .7846-.421.7846-.8754 0-.6601-.5023-1.3586-1.44-1.5403zm.6794 1.4112c-.1244-.0096-.2153-.1005-.2153-.2249 0-.067.043-.177.0574-.263.0191-.1197-.0096-.225.0622-.225.1626 0 .33.2584.33.445 0 .1435-.0908.2679-.2343.2679zM8.9504 5.5109c-.4545.0095-.8755.3827-1.1625.8897a1.697 1.697 0 00.0287-.3061c0-.6937-.3731-1.3203-1.0763-1.3203-.5693 0-1.086.33-1.3012.971.0622-.067.2488-.1817.4018-.1817.177 0 .2297.153.2297.3923 0 .1626-.0383.3492-.1005.5262-.11.2918-.3062.3827-.4114.3827-.4449 0-.244-.732-.4688-.732-.1866 0-.2392.3923-.2392.5454 0 .507.33 1.0428 1.062 1.0428.775 0 1.215-.3683 1.6887-.8658.0908.5358.3827 1.4542 1.1672 1.4542.4257 0 .7319-.354.7654-.7653-.0574.0526-.134.0956-.2249.0956-.1626 0-.196-.2296-.196-.4353 0-.33.0956-.684.2487-.684.0813 0 .1243.0526.1435.2917.0143.1866 0 .3923.1148.3923s.1866-.3683.1866-.6171c0-.574-.268-1.0763-.8563-1.0763zM6.3097 7.233c-.0765 0-.0956-.0717-.1004-.134 0-.3491.3827-1.9086.6601-1.9086.067 0 .091.0526.091.1243 0 .2775-.3493 1.9183-.6507 1.9183zm1.1864-.665c-.2296.2584-.354.3636-.4544.3636-.0527.0048-.1053-.086-.1053-.1913 0-.1914.134-.9041.4018-.9041.1053 0 .177.196.177.373 0 .134 0 .244-.019.3589zm.5214.6172c-.0909.0048-.1387-.1435-.1578-.464.1435-.2392.2392-.3445.33-.3445.0383 0 .0718.0335.0718.1866v.0048h.0048c0 .311-.1483.6219-.2488.617zm.4784.5405c-.0574 0-.1004-.0813-.0957-.2679 0-.4831.311-1.3633.4975-1.3633.0527 0 .0718.1244.0718.2392 0 .5357-.2488 1.392-.4736 1.392zm-1.215.1866c-.3828 0-.4019.464-.4019 1.4016-.287-.617-.7558-1.2724-1.3107-1.2724-.3732 0-.5167.2487-.5167.684 0 .091.0096.2297.024.3014.043-.153.1865-.2153.3635-.2153.3827 0 .8467.2966 1.1529.6937-.3492-.0622-.6889-.1244-.9711-.1244-.177 0-.3397.0191-.4736.0813-.2583.1148-.6075.4975-.6075 1.0764 0 .0909.0095.1818.0239.2918.311-.6937 1.1385-1.0094 1.6743-1.0094.1052 0 .1818.0096.2535.0191-.2774.2488-.3396.6841-.3588.9807-.0095.1435-.0621.153-.1626.1483 0 .2966.2296.732.2296.952 0 .0813-.043.153-.0909.1674 0 .3875.3875.6745.3875.9233 0 .0621-.0191.1148-.043.1435.0287.1578.4592.4353.5118.5645.067.1578.1483.196.1962.196.153 0 .3922-.177.3922-.3396 0-.0526-.043-.1148-.0813-.1435-.1674-.1243-.2583-.3922-.33-.5692-.0623 0-.1436-.024-.1723-.1292-.0478-.1866-.0526-.5262-.1244-.732-.1148-.0286-.1674-.0717-.1674-.3109 0-.1148.0718-.5692.0718-.7319-.0527 0-.1244-.0334-.1244-.1435 0-.287.287-.507.3635-.8754.5071.378.6267.7558.6267 1.0955 0 .177-.0287.3492-.0622.507.3732-.1865.9376-.464.9376-1.0237 0-.33-.153-.6936-1.1576-.8371.311-.1148.7032-.177 1.0333-.177.5692 0 .904.1818.971.5836.1149-.177.2058-.3827.2058-.5693 0-.4353-.3636-.7223-.8276-.7223-.5454 0-1.0238.287-1.5404.6267.2344-.4832.3923-.7654.6793-.7654.043 0 .0909.0095.1387.0191-.0957-.3827-.5023-.7702-.7128-.7654zm15.0209 6.4246c.4449 0 .7989.5836.7989 1.258 0 .7224-.3397 1.507-.9424 2.0475-.0096-1.2007-1.483-.818-1.483-1.6934 0-.3732.2679-.622.5884-.622.287 0 .5023.0814.6745.2393-.1626-.1531-.2392-.3636-.2392-.5693-.0048-.3492.2105-.6601.6028-.6601zm-6.616-9.1178c-.0717-.1149-.3396-.177-.464-.177-.3922 0-.6601.2774-.7127.5262-.0335-.091-.0622-.1962-.0622-.3014 0-.3923.2679-.8754.9185-.8754.5692 0 .7893.2966.8706.2966.0909 0 .177-.091.2488-.091.0956 0 .1004.1484.1004.2584 0 .354-.1626.971-.5645 1.2007-.0717-.153-.2152-.3205-.4449-.4257-.0621-.0287-.0908-.0814-.0908-.134.0047-.1052.0956-.2296.2009-.2774zm-1.3442.6505c.2297.2297.4354.3206.6841.3206.1005 0 .2153-.0287.2775-.0287.0813 0 .1387.0334.1387.1004 0 .1005-.0909.2583-.1961.3492.1052.0479.2296.0574.3444.0622.507 0 1.0859-.3205 1.0859-1.1242.1052.1388.1722.4354.1722.5693 0 .9711-.7128 1.3442-1.373 1.3442-.4305 0-.641-.1435-.6983-.1435-.1675 0-.158.3397-.2775.33-.2057-.0334-.3923-.4878-.3923-.971 0-.287.0766-.598.2392-.818h-.0048v.0095zM6.7116.201c0-.0526-.268-.1052-.6315-.1052-.5788 0-.4975.4831-.9424.4783-.464 0-.3492-.4975-.9376-.4975-.3588 0-.684.0622-.684.1436 0 .1004.421.0574.421.354 0 .3109-.8994.4018-.8994.5883 0 .0575.067.091.1578.091.1962 0 .5071-.091.732-.091.1243 0 .2391.024.2391.1436 0 .2248-.4831.6218-.4831.8036 0 .0574.0478.067.0909.0718.177 0 .4831-.4545.7654-.4545.4736 0 .1578 1.0046.421 1.0094.2678 0 .153-.9902.5357-.9902.311 0 .5501.684.7558.684.0527 0 .0957-.043.0957-.1052 0-.1866-.2679-.5693-.2679-.818 0-.1531.1053-.2249.2488-.2249.2057 0 .4784.1244.6267.1244.0526 0 .1052-.0191.1052-.0813 0-.2153-.7941-.4449-.7941-.7223C6.2763.33 6.7164.33 6.7116.2009zm2.0953.909c0 .1578.5597.5022.8228.507.153 0 .196-.2057.196-.421 0-.2679-.1147-.2774-.3491-.2774-.2966.0048-.6697.086-.6697.1913zm.928 1.7651c0-.5358-1.4447-1.5069-1.4638-1.923 0-.0383.0191-.0766.0526-.11C8.5725.5787 9.601.3922 9.601.1673c0-.1148-.2153-.1148-.3206-.1148-.8275 0-2.0426.3014-2.0426.598 0 .3061 1.0859 1.038 1.0859 1.4064 0 .1005-.0622.134-.1626.1387-.3014 0-.9616-.3635-1.2725-.3635-.1435 0-.1962.0956-.1962.2392 0 .421.5023 1.2342.5023 1.4733 0 .0288-.0095.0622-.043.0622-.1627 0-.9185-.8897-1.1864-.8897-.0957 0-.1052.134-.1052.33v.3014c0 .2057-.0096.33-.1053.33-.2296 0-.3396-.6505-.5597-.6505-.2296 0-.2774 1.1577-.4975 1.1529-.2583 0-.0335-1.2725-.287-1.2725-.2775 0-.5884.8467-.7845.8467-.0718 0-.091-.0717-.091-.134 0-.2582.1532-.6792.1532-.928 0-.1243-.0335-.196-.1436-.196-.2774 0-.885.4448-1.1146.4448-.0334 0-.0813-.0191-.0813-.0526 0-.2153.9711-.8898.9711-1.196 0-.2965-1.3394-.1004-1.3394-.4353 0-.287.952-.5788.952-.8754 0-.2583-1.1338-.3731-1.5691-.3731C.8372.0096.55.0718.55.2248c0 .2297 1.2007.3062 1.2007.5023s-1.239.7224-1.239 1.0237c0 .2632 1.7461.024 1.7461.2966 0 .3014-1.526 1.6122-1.526 2.0475 0 .1004.067.1387.1722.1435.464 0 1.6648-.8802 1.9948-.8802.1149 0 .1244.1387.1244.263 0 .2345-.0813.5885-.0813.8468 0 .2057.0574.3444.2296.3492.33 0 .6315-.5597.8563-.5597.287 0 .1148 1.6456.5501 1.6504.3636 0 .5167-1.7843.7463-1.7843s.421.5118.6267.5118c.2679 0 .1435-.8993.4305-.8993.311 0 1.2007 1.0763 1.5978 1.0716.1243 0 .1674-.1005.1674-.2249 0-.4736-.6602-1.5403-.6602-1.88 0-.0909.024-.1148.1244-.1148.3492 0 1.3586.4784 1.8418.4784.1817.0191.2774-.0718.2822-.1914zm-8.142-.5166c0 .177-.6792.775-.9184.775-.0909 0-.1148-.1053-.1148-.2058 0-.177.0813-.4257.177-.507.1148-.1053.3827-.1579.5884-.1579.1292 0 .2679.024.2679.0957zm6.5538.9185c0 .3061 1.1194 1.8417 1.325 1.837.177 0 .311-.311.311-.579 0-.0717-.0191-.1434-.0526-.196-.1626-.2249-1.2916-1.1147-1.5403-1.1147-.024-.0047-.0479.0192-.0431.0527zM23.5073.1722c-.445 0-.5215-.1387-.8228-.1387-.3636 0-.622.2487-.622.6219 0 .1244.0431.3205.0431.5788 0 .3157-.0622.6075-.3396.6075-.2535 0-.354-.1674-.354-.3635 0-.354.1866-.5932.1866-.8276 0-.4258-.5262-.5501-1.0764-.5501-.6601 0-1.373.177-1.373.2678 0 .1531.952.0622 1.6218.9185-.4353.0096-1.282.2057-1.282.3205 0 .1435 1.5164.3062 1.5164.9376.0048.4162-.3301.4593-.4593.464-.5022 0-.7701-.5118-.904-.5118a.0704.0704 0 00-.0718.0718c0 .0813.0717.2918.0717.5166 0 .5693-.6314.6315-.6314.7463 0 .043.0191.0622.0909.0717a9.153 9.153 0 001.3825.1053c1.612 0 2.9324-.5023 2.9324-1.9087 0-.775-.2392-1.0238-.2392-1.4017 0-.1244.0909-.3827.33-.5262zm-2.2867 3.0473c-.1004 0-.2152 0-.33-.0096 1.0428-.1674 1.6217-.7702 1.6217-1.5643.2344.067.3779.3062.373.5597 0 .464-.4448 1.0142-1.6647 1.0142zM22.6893.794c-.1292-.0048-.2297-.0957-.2297-.22 0-.1292.1053-.2201.2297-.2249a.2246.2246 0 01.2248.2248c0 .1244-.1005.2249-.2248.2201zm.5597 11.5814c-.4162 0-.6602.732-1.0668.775.2583-1.0716 1.3203-1.6217 1.3203-2.6215 0-1.1337-.952-1.5308-1.349-1.7843-.665-.9376-1.1386-1.6791-2.2053-1.6791-.4545 0-.7415.0813-1.0524.0813-.6028-.0048-.7894-.2344-.8324-.2344-.0096 0-.0191.0096-.0191.043 0 .8276.4353 2.7268 2.3535 2.7268 1.0238 0 1.4639-.3923 1.703-.3923.2584 0 1.086.2823 1.086 1.2294 0 .5262-.4162 1.062-.5693 1.062-.1483.0048-.3062-.2344-.3062-.488 0-.2822.1531-.7988.1531-1.1193 0-.1196-.0191-.177-.0909-.177-.1626 0-.928.4784-.928 1.0955 0 .5262.775.8467 1.0668.9998-.2918.4831-.4688.794-.6124 1.239 0-.335-.3205-1.019-.421-1.306-.4927-1.3395-.6649-1.5882-1.679-1.703.153.5358 1.8991 1.8274 1.8991 3.1477 0 .0813-.0095.1961-.0191.2392-.5262-1.5404-1.4303-1.8944-1.7604-2.2723-.5358-.5884-.2296-1.1577-1.086-1.4782.0527.0718.0718.1627.0718.2583 0 .2823-.1626.641-.1626.8898 0 .928 1.0907.6506 1.7221 1.1577.622.5023.9711 1.3203 1.2294 2.2292.2488-.397.3923-.8802.8372-.8802.287 0 .3827.3588.3827.6075 0 .0526 0 .1005-.0096.134.4258-.3636.6506-.952.6506-1.3443 0-.263-.0909-.4353-.3061-.4353zm-1.66-3.4969c-.0909 0-.2631-.0478-.378-.0478-.306 0-.5213.421-.6792.421-.0574 0-.0813-.0527-.0813-.1005 0-.1722.3013-.378.3013-.4927 0-.0814-.1291-.1053-.1817-.1053-.3062 0-.732.4162-.9711.4162-.043 0-.1005-.024-.1005-.0813 0-.1148.3205-.2775.3205-.4019 0-.11-.1387-.1339-.2296-.1339-.1483 0-.4449.0813-.6315.0813-.1004 0-.1817-.0191-.1817-.1004 0-.1818.5788-.0622.5788-.2775 0-.1052-.1818-.3014-.1818-.4018 0-.0383.0478-.067.0909-.067.2057 0 .421.5597.6602.5597.1052 0 .1339-.0813.1339-.1961s-.024-.1722-.024-.2727c0-.1052.0431-.134.0766-.134.1483 0 .2823.8037.6937.8037.1817-.0048.0526-.4927.2152-.4927.1005 0 .1244.1435.134.2248.043.5262.5166.5454.5166.732 0 .019-.0287.067-.0813.067zM17.0062.0574c-.598 0-1.0333.2918-1.2677.2918-.1387.0096-.354-.3492-.464-.3492-.043 0-.091.0909-.091.2392 0 .1004 0 .4114-.1052.4114-.2152 0-1.0428-.6123-1.0428-.3923 0 .2057.5501.8324.5501.995s-.5453.311-.5453.421c0 .1961.5836.2296.5836.4832 0 .2487-.6076.4449-.6076.6266 0 .1483.6076.0479.6076.2297 0 .1865-.445.8132-.445.9902 0 .0478.0097.0478.048.0478.1674.0048.6792-.5788.7988-.5788.1435 0 .1722.3444.1961.555.0192.1004.0335.1147.0814.1147.1052 0 .2774-.4114.3922-.4114.1675 0 .6267.4688 1.3825.4736 1.0764 0 2.0953-.7558 2.0953-2.0953 0-1.2916-.9089-2.0522-2.167-2.0522zm-1.526 2.875c-.0287 0-.043-.0335-.043-.0813l-.0192-.354c0-.0335-.0192-.0717-.0622-.0717-.1053 0-.311-.0096-.3731-.0096-.043 0-.0622-.0096-.0622-.0287.0095-.067.3635-.3205.3683-.378 0-.1004-.3492-.287-.3492-.3922 0-.0191.0191-.0287.043-.0287.1005 0 .2632.0335.4019.0335.1148 0 .134-.4975.22-.4975.0622 0 .1723.4688.2631.4688.1149 0 .3301-.134.421-.134.0192 0 .0335.0096.0335.0287 0 .0622-.2248.3014-.2248.378 0 .0813.5023.1817.5023.2487 0 .0909-.5071.0813-.5071.1627 0 .0574.1818.3061.1818.3874 0 .0192-.0096.0287-.0287.0287-.0718 0-.3493-.1243-.4306-.1243-.1004 0-.2583.3635-.3348.3635zm1.5451.7702c-.6267 0-1.0333-.311-1.0333-.4736 0-.0813.0526-.134.1244-.134.1961 0 .6267.2967.7654.2967.0335 0 .0622-.0192.0622-.0718 0-.1626-.153-.4257-.153-.5597 0-.0335.0286-.0622.0812-.0622.2392 0 .5932.1005.7893.1005.0622 0 .0814-.0335.0814-.0718 0-.1961-.5789-.5788-.5789-.6936 0-.1053.7224-.2679.7224-.4353 0-.177-.9807-.0527-.9807-.2249 0-.1243.1866-.3396.1866-.4353 0-.043-.0335-.0622-.0957-.0622-.0813 0-.507.1675-.6888.1675-.091 0-.1962-.0192-.1962-.1436 0-.2057.3492-.4257.8946-.4257.8802 0 1.4064.6075 1.4064 1.6217-.0048 1.2868-.8993 1.6073-1.3873 1.6073zm-6.037 15.4228c0 .0813-.0288.1674-.1005.2583-.0957-.177-.3732-.2679-.4975-.2679-.9185 0-.5693 1.3299-1.55 1.3299-.4114 0-.4448-.0526-.598-.0526-.0621 0-.1004.0287-.1004.0813 0 .2296.33.7989 1.2438.8037.9185 0 1.7987-.5597 1.7987-1.2582 0-.1148-.0287-.2392-.0814-.3635.0335-.0527.1244-.091.2057-.091.1436 0 .2153.158.354.1627.1436 0 .2488-.1052.2488-.2487 0-.1148-.0622-.1962-.1674-.2488.0717-.0526.1243-.1435.1243-.2392 0-.153-.1052-.2918-.287-.2918-.0813 0-.134.0287-.1961.0861-.0191-.1578-.1053-.311-.2775-.311-.134 0-.2344.0958-.2344.2536.0192.1244.1148.2392.1148.397zm-2.8703-.6458c-.0622 0-.1435.0095-.2296.0095-.0813 0-.1962-.0191-.268-.0813-.1434-.1244-.1865-.794-.4544-1.196-.2918-.4448-.6123-.5692-1.0524-.5692-.311 0-.6601.1674-.6601.421 0 .153.086.2583.6505.4066.7128.1818 1.0764.5597 1.1434 1.0142.0717.4353.1578.7893.33.971.2249.2536.665.4689 1.0381.4689.3205 0 .5788-.1053.5788-.4019 0-.3205-.4353-1.0428-1.0763-1.0428zm.4736.9806c-.2679 0-.6697-.287-.6697-.4449 0-.1339.1243-.2057.2248-.2057.2248 0 .6267.2727.6267.5071-.0048.0622-.0479.1388-.1818.1435zm2.1335-3.9226c-.4114-.1483-.5932-.3875-.6745-.8563-.2009.2727-.2966.531-.2966.684 0 .6028.8276.6124.8276 1.0142-.0048.2344-.421.4736-.971.4784-.6411-.0048-1.0716-.1053-1.4735-.507-.1052-.1149-.153-.2154-.287-.2154-.153 0-.2153.268-.2153.5071 0 .8754.8324 1.9087 1.99 1.9087 1.4448-.0048 2.0045-.9998 2.0045-1.8034 0-.4688-.11-.9137-.9042-1.2103zm-.4257 2.4397c-.1148 0-.1387-.0718-.1387-.1722 0-.0814.0287-.2344.0287-.3492 0-.3158.1196-.2919.4257-.4306h-.0048c.2153-.1004.2966-.2344.3636-.2344.0813 0 .153.0526.153.177 0 .464-.507 1.0094-.8275 1.0094zM7.7736 12.519c0-.5692 1.3538-.8754 1.3538-1.5786 0-.1148-.043-.3205-.1244-.4736.4736.2631.8228.6984.8228 1.0524 0 .6171-.641.8994-.641 1.282 0 .445.684.512.684 1.0716 0 .4545-.6505.9807-.6505 1.5691 0 .4592.3205.8324.8132.8898-.1627.0335-.3014.0622-.4545.0622-.8993 0-1.8274-.7415-1.8274-1.6217 0-.4353.1866-.818.4736-1.0955.2488.2153.5023.354.665.354.1435 0 .2057-.0718.2057-.177-.0096-.3253-1.3155-.6362-1.3203-1.3347zM5.219 16.2743c-.0335-.3205-.3253-.5597-.622-.5215-.1147.0144-.2248.0574-.2965.1196-.0813-.2679-.3301-.4975-.6745-.4449-.311.0527-.5167.3158-.4832.6506.0048.0574.024.1148.0478.177 0 0-.0526.0096-.0908.0144-.2584.0478-.5454.311-.4975.6506.0382.3061.3205.5358.641.4975.1148-.0144.2248-.043.2966-.091.0717.2871.3061.4689.6266.4258.3301-.043.5502-.3013.5167-.6314-.0096-.0909-.0287-.1435-.0526-.2057 0 0 .043-.0048.0765-.0096.3205-.0622.5406-.3205.5119-.6314zm-1.2486.6697c-.1866.024-.354-.11-.378-.2966s.1101-.354.2967-.378c.1913-.0238.3588.1149.3779.2967.024.1865-.11.354-.2966.3779z");
    }

}
