/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.asn1.authenticode;

import java.io.IOException;
import net.jsign.asn1.authenticode.AuthenticodeSignedData;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;

public class AuthenticodeSignedDataGenerator
extends CMSSignedDataGenerator {
    public CMSSignedData generate(ASN1ObjectIdentifier contentTypeOID, ASN1Encodable content) throws CMSException, IOException {
        SignerInfo signerInfo;
        this.digests.clear();
        if (!this._signers.isEmpty()) {
            signerInfo = ((SignerInformation)this._signers.get(0)).toASN1Structure();
        } else {
            CMSSignedData sigData = super.generate((CMSTypedData)new CMSProcessableByteArray(contentTypeOID, content.toASN1Primitive().getEncoded("DER")));
            signerInfo = ((SignerInformation)sigData.getSignerInfos().iterator().next()).toASN1Structure();
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, content);
        DERSet certificates = new DERSet(this.certs.toArray(new ASN1Encodable[0]));
        AuthenticodeSignedData signedData = new AuthenticodeSignedData(signerInfo.getDigestAlgorithm(), encInfo, (ASN1Set)certificates, signerInfo);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
        return new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(contentTypeOID, content.toASN1Primitive().getEncoded("DER")), contentInfo);
    }
}

