/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.asn1.authenticode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class AuthenticodeDigestCalculatorProvider
implements DigestCalculatorProvider {
    public DigestCalculator get(final AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        final DigestCalculator delegate = new JcaDigestCalculatorProviderBuilder().build().get(digestAlgorithmIdentifier);
        return new DigestCalculator(){
            private ByteArrayOutputStream out = new ByteArrayOutputStream();

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return digestAlgorithmIdentifier;
            }

            public OutputStream getOutputStream() {
                return this.out;
            }

            public byte[] getDigest() {
                try {
                    delegate.getOutputStream().write(this.out.toByteArray(), 2, this.out.size() - 2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return delegate.getDigest();
            }
        };
    }
}

