/**
 * Copyright (C) 2016 Joerg Bellmann (joerg.bellmann@googlemail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.siggici.keys;

import lombok.Builder;
import lombok.Getter;

@Builder
@Getter
public class DeployKey {
    private String id;
    private String publicKey;
    private String privateKey;
    private String fingerprint;

    protected DeployKey() {
        //
    }

    public DeployKey(String id, String publicKey, String privateKey, String fingerprint) {
        this.id = id;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.fingerprint = fingerprint;
    }

    public DeployKey fully(boolean fully) {
        return fully ? this : DeployKey.builder().id(id).publicKey(publicKey).fingerprint(fingerprint).build();
    }
}
