/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.keys;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerprintCheck {
    private static final Logger log = LoggerFactory.getLogger(FingerprintCheck.class);
    private static final String HOST = "host";

    public boolean hasSameFingerprint(String pubkey, String fingerprint) {
        try {
            byte[] pubKeyDecoded = Base64.getDecoder().decode(pubkey.getBytes());
            HostKey hk = new HostKey(HOST, pubKeyDecoded);
            String pubkeyFingerprint = hk.getFingerPrint(new JSch());
            return fingerprint.equals(pubkeyFingerprint);
        }
        catch (JSchException e) {
            log.warn(e.getMessage());
            return false;
        }
    }
}

