/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.keys;

public class DeployKey {
    private String id;
    private String publicKey;
    private String privateKey;
    private String fingerprint;

    protected DeployKey() {
    }

    public DeployKey(String id, String publicKey, String privateKey, String fingerprint) {
        this.id = id;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.fingerprint = fingerprint;
    }

    public DeployKey fully(boolean fully) {
        return fully ? this : DeployKey.builder().id(this.id).publicKey(this.publicKey).fingerprint(this.fingerprint).build();
    }

    public static DeployKeyBuilder builder() {
        return new DeployKeyBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public static class DeployKeyBuilder {
        private String id;
        private String publicKey;
        private String privateKey;
        private String fingerprint;

        DeployKeyBuilder() {
        }

        public DeployKeyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DeployKeyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public DeployKeyBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public DeployKeyBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public DeployKey build() {
            return new DeployKey(this.id, this.publicKey, this.privateKey, this.fingerprint);
        }

        public String toString() {
            return "DeployKey.DeployKeyBuilder(id=" + this.id + ", publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", fingerprint=" + this.fingerprint + ")";
        }
    }
}

