/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.keys;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.siggici.keys.DeployKey;
import org.siggici.keys.DeployKeyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeployKeyService
implements DeployKeyService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeployKeyService.class);
    private final int type;
    private final int size;
    private final String comment;

    public DefaultDeployKeyService(int type, int size, String comment) {
        this.type = type;
        this.size = size;
        this.comment = comment;
    }

    @Override
    public DeployKey create() {
        log.debug("creating keypair ...");
        try {
            ByteArrayOutputStream privBaos = new ByteArrayOutputStream();
            ByteArrayOutputStream pubBaos = new ByteArrayOutputStream();
            KeyPair keypair = KeyPair.genKeyPair((JSch)new JSch(), (int)this.type, (int)this.size);
            keypair.writePrivateKey((OutputStream)privBaos, null);
            keypair.writePublicKey((OutputStream)pubBaos, this.comment);
            DeployKey deployKey = DeployKey.builder().id(UUID.randomUUID().toString()).publicKey(new String(pubBaos.toByteArray())).privateKey(new String(privBaos.toByteArray())).fingerprint(keypair.getFingerPrint()).build();
            return deployKey;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create DeployKey", e);
        }
        finally {
            log.debug("keypair created");
        }
    }
}

