/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.ghcom.connect;

import org.siggici.connect.github.auth.AuthorizationOperations;
import org.siggici.connect.github.auth.AuthorizationTemplate;
import org.siggici.connect.github.ghcom.api.Ghcom;
import org.siggici.connect.github.organization.OrganizationOperations;
import org.siggici.connect.github.organization.OrganizationTemplate;
import org.siggici.connect.github.repository.RepositoryOperations;
import org.siggici.connect.github.repository.RepositoryTemplate;
import org.siggici.connect.github.user.UserOperations;
import org.siggici.connect.github.user.UserTemplate;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;

class GhcomTemplate
extends AbstractOAuth2ApiBinding
implements Ghcom {
    private String accessToken;
    private UserOperations userOperations;
    private RepositoryOperations repositoryOperations;
    private AuthorizationOperations authorizationOperations;
    private OrganizationOperations organizationOperations;

    public GhcomTemplate() {
        this.initialize();
    }

    public GhcomTemplate(String accessToken) {
        super(accessToken);
        this.accessToken = accessToken;
        this.initialize();
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.BEARER;
    }

    private void initialize() {
        this.userOperations = new UserTemplate(this.getRestTemplate(), this.isAuthorized());
        this.repositoryOperations = new RepositoryTemplate(this.getRestTemplate(), this.isAuthorized());
        this.authorizationOperations = new AuthorizationTemplate(this.getRestTemplate(), this.isAuthorized());
        this.organizationOperations = new OrganizationTemplate(this.getRestTemplate(), this.isAuthorized());
    }

    public UserOperations getUserOperations() {
        return this.userOperations;
    }

    public RepositoryOperations getRepositoryOperations() {
        return this.repositoryOperations;
    }

    public AuthorizationOperations getAuthorizationOperations() {
        return this.authorizationOperations;
    }

    public OrganizationOperations getOrganizationOperations() {
        return this.organizationOperations;
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

