/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.ghcom.config.boot;

import javax.sql.DataSource;
import org.siggici.connect.github.ghcom.api.Ghcom;
import org.siggici.connect.github.ghcom.config.AbstractGhcomSocialConfigurer;
import org.siggici.connect.github.ghcom.config.GhcomUsersConnectionRepositoryConfigurer;
import org.siggici.connect.github.ghcom.config.boot.GhcomJdbcUsersConnectionRepositoryConfigurer;
import org.siggici.connect.github.ghcom.config.boot.GhcomProperties;
import org.siggici.connect.github.ghcom.connect.GhcomConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.web.GenericConnectionStatusView;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, GhcomConnectionFactory.class})
@ConditionalOnProperty(prefix="siggi.connect.ghcom.oauth2", name={"clientId"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
public class GhcomAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={GhcomUsersConnectionRepositoryConfigurer.class})
    protected static class GhcomUsersConnectionRepositoryConfigurerAutoConfiguration {
        private static final Logger log = LoggerFactory.getLogger(GhcomUsersConnectionRepositoryConfigurerAutoConfiguration.class);
        @Autowired
        private DataSource dataSource;

        protected GhcomUsersConnectionRepositoryConfigurerAutoConfiguration() {
        }

        @Bean
        public GhcomUsersConnectionRepositoryConfigurer ghcomUsersConnectionRepositoryConfigurer() {
            log.info("GHCOM_CONFIGURER WILL BE CREATED :::");
            return new GhcomJdbcUsersConnectionRepositoryConfigurer(this.dataSource);
        }
    }

    @Configuration
    @EnableSocial
    @EnableConfigurationProperties(value={GhcomProperties.class})
    @ConditionalOnWebApplication
    protected static class GhcomConfigurerAdapter
    extends AbstractGhcomSocialConfigurer {
        @Autowired
        private GhcomProperties ghcomProperties;
        @Autowired
        private GhcomUsersConnectionRepositoryConfigurer ghcomUsersConnectionRepositoryConfigurer;

        protected GhcomConfigurerAdapter() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public Ghcom ghcom(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(Ghcom.class);
            return connection != null ? (Ghcom)connection.getApi() : null;
        }

        @Bean(name={"connect/ghcomConnect", "connect/ghcomConnected"})
        @ConditionalOnProperty(prefix="spring.social", name={"auto-connection-views"})
        public GenericConnectionStatusView ghcomConnectView() {
            return new GenericConnectionStatusView("ghcom", "Ghcom");
        }

        @Override
        protected UsersConnectionRepository doGetUsersConnectionRepository(ConnectionFactoryLocator connectionFactoryLocator) {
            return this.ghcomUsersConnectionRepositoryConfigurer.configureUsersConnectionRepository(connectionFactoryLocator);
        }

        @Override
        protected String getClientId() {
            return this.ghcomProperties.getClientId();
        }

        @Override
        protected String getClientSecret() {
            return this.ghcomProperties.getClientSecret();
        }
    }
}

