/*
 * Decompiled with CFR 0.152.
 */
package org.siggici.connect.github.ghcom.config;

import org.siggici.connect.github.ghcom.security.GhcomAuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.annotation.ConnectionFactoryConfigurer;
import org.springframework.social.config.annotation.SocialConfigurer;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.security.AuthenticationNameUserIdSource;
import org.springframework.social.security.SocialAuthenticationServiceRegistry;
import org.springframework.social.security.provider.SocialAuthenticationService;

public abstract class AbstractGhcomSocialConfigurer
implements SocialConfigurer {
    private final Logger log = LoggerFactory.getLogger(AbstractGhcomSocialConfigurer.class);

    public void addConnectionFactories(ConnectionFactoryConfigurer connectionFactoryConfigurer, Environment environment) {
    }

    public UserIdSource getUserIdSource() {
        return new AuthenticationNameUserIdSource();
    }

    public UsersConnectionRepository getUsersConnectionRepository(ConnectionFactoryLocator connectionFactoryLocator) {
        if (connectionFactoryLocator instanceof SocialAuthenticationServiceRegistry) {
            this.log.debug("Initialize ConnectionFactory with key {} and secret {}", (Object)this.getClientId().substring(0, this.getClientIdSubstringLenght()), (Object)this.getClientSecret().substring(0, this.getClientSecretIdSubstringCount()));
            SocialAuthenticationServiceRegistry registry = (SocialAuthenticationServiceRegistry)connectionFactoryLocator;
            registry.addAuthenticationService((SocialAuthenticationService)new GhcomAuthenticationService(this.getClientId(), this.getClientSecret()));
        }
        return this.doGetUsersConnectionRepository(connectionFactoryLocator);
    }

    protected abstract UsersConnectionRepository doGetUsersConnectionRepository(ConnectionFactoryLocator var1);

    protected abstract String getClientId();

    protected abstract String getClientSecret();

    protected int getClientIdSubstringLenght() {
        return 8;
    }

    protected int getClientSecretIdSubstringCount() {
        return 4;
    }
}

