/**
 * Copyright (C) 2016 Joerg Bellmann (joerg.bellmann@googlemail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.siggici.connect.github.ghcom.connect;

import org.siggici.connect.github.ghcom.api.Ghcom;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;

public class GhcomAdapter implements ApiAdapter<Ghcom> {

	@Override
	public boolean test(Ghcom api) {
		try {
			api.getUserOperations().getUserProfile().getLogin();
			return true;
		} catch (Exception e) {
			// ignore
		}
		return false;
	}

	@Override
	public void setConnectionValues(Ghcom api, ConnectionValues values) {
		values.setProviderUserId(api.getUserOperations().getUserProfile().getLogin());
		values.setDisplayName(api.getUserOperations().getUserProfile().getName());
	}

	@Override
	public UserProfile fetchUserProfile(Ghcom api) {
		return new UserProfileBuilder().setUsername(api.getUserOperations().getUserProfile().getLogin())
				.setEmail(api.getUserOperations().getUserProfile().getEmail()).build();
	}

	@Override
	public void updateStatus(Ghcom api, String message) {
		throw new UnsupportedOperationException();
	}

}
