/*
 * Decompiled with CFR 0.152.
 */
package org.shenjia.mybatis.generator.plugins;

import java.lang.reflect.Field;
import java.util.List;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class RenameExamplePlugin
extends PluginAdapter {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public void initialized(IntrospectedTable introspectedTable) {
        if (null != introspectedTable.getExampleType()) {
            this.renameExampleClass(introspectedTable);
        }
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        for (Method m : interfaze.getMethods()) {
            if (m.getName().indexOf("Example") < 0) continue;
            this.renameExampleMethod(m);
        }
        return true;
    }

    public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
        this.renameXmlNodes(sqlMap);
        return true;
    }

    private void renameExampleClass(IntrospectedTable it) {
        String oldType = it.getExampleType();
        String newType = oldType.replaceAll("Example", "Filter");
        it.setExampleType(newType);
    }

    private void renameExampleMethod(Method m) {
        m.setName(m.getName().replaceAll("Example", "Filter"));
        List params = m.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Parameter oldParam = (Parameter)params.get(i);
            if (!"example".equals(oldParam.getName())) continue;
            Parameter newParam = new Parameter(oldParam.getType(), "filter");
            for (String a : oldParam.getAnnotations()) {
                newParam.addAnnotation(a.replaceAll("example", "filter"));
            }
            params.set(i, newParam);
        }
    }

    private void renameXmlNodes(GeneratedXmlFile sqlMap) {
        try {
            Field field = sqlMap.getClass().getDeclaredField("document");
            field.setAccessible(true);
            Document doc = (Document)field.get(sqlMap);
            XmlElement oldRoot = doc.getRootElement();
            XmlElement newRoot = new XmlElement(oldRoot.getName());
            this.updateNode(oldRoot, newRoot);
            doc.setRootElement(newRoot);
            field.set(sqlMap, doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateNode(XmlElement oldRoot, XmlElement newRoot) {
        for (Attribute a : oldRoot.getAttributes()) {
            String name = a.getName();
            String value = a.getValue();
            if ("id".equals(name) || "refid".equals(name)) {
                value = value.replaceAll("Example", "Filter");
            } else if ("collection".equals(a.getName())) {
                value = value.replaceAll("example.oredCriteria", "filter.oredCriteria");
            }
            newRoot.addAttribute(new Attribute(name, value));
        }
        List oldElements = oldRoot.getElements();
        for (VisitableElement e : oldElements) {
            if (e instanceof TextElement) {
                newRoot.addElement(e);
                continue;
            }
            XmlElement oldNode = (XmlElement)e;
            XmlElement newNode = new XmlElement(oldNode.getName());
            newRoot.addElement((VisitableElement)newNode);
            this.updateNode(oldNode, newNode);
        }
    }
}

