/*
 * Decompiled with CFR 0.152.
 */
package org.shenjia.mybatis.generator.plugins;

import java.util.List;
import java.util.Optional;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class OptimisticLockPlugin
extends PluginAdapter {
    private String lockColumnName = "version";

    public boolean validate(List<String> warnings) {
        if (StringUtility.stringHasValue((String)this.properties.getProperty("lockColumnName"))) {
            this.lockColumnName = this.properties.getProperty("lockColumnName");
        }
        return true;
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.sqlMapUpdateByExampleWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        Optional ic = introspectedTable.getColumn(this.lockColumnName);
        if (!ic.isPresent()) {
            String tableName = introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime();
            System.err.println("[" + tableName + "] lock column not exists");
            return true;
        }
        String jp = ((IntrospectedColumn)ic.get()).getJavaProperty();
        List elements = element.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            String content = ((TextElement)elements.get(i)).getContent();
            if (content.indexOf(this.lockColumnName) <= 0) continue;
            elements.set(i, new TextElement(content.replaceAll(jp, jp + " + 1")));
            break;
        }
        return true;
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        try {
            VisitableElement oldNode;
            Optional ic = introspectedTable.getColumn(this.lockColumnName);
            if (!ic.isPresent()) {
                String tableName = introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime();
                System.err.println("[" + tableName + "] lock column not exists");
                return true;
            }
            List elements = element.getElements();
            for (int i = 0; i < elements.size() && !this.updateSetNode(oldNode = (VisitableElement)elements.get(i), (IntrospectedColumn)ic.get()); ++i) {
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        Optional ic = introspectedTable.getColumn(this.lockColumnName);
        if (!ic.isPresent()) {
            String tableName = introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime();
            System.err.println("[" + tableName + "] lock column not exists");
            return true;
        }
        String jp = ((IntrospectedColumn)ic.get()).getJavaProperty();
        List elements = element.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            String content = ((TextElement)elements.get(i)).getContent();
            if (content.indexOf(this.lockColumnName) > 0) {
                elements.set(i, new TextElement(content.replaceAll(jp, jp + " + 1")));
                continue;
            }
            if (content.indexOf("where") < 0) continue;
            elements.set(i, this.buildWhereElement(content, jp, ((IntrospectedColumn)ic.get()).getJdbcTypeName()));
            break;
        }
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        try {
            Optional ic = introspectedTable.getColumn(this.lockColumnName);
            if (!ic.isPresent()) {
                String tableName = introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime();
                System.err.println("[" + tableName + "] lock column not exists");
                return true;
            }
            List elements = element.getElements();
            for (int i = 0; i < elements.size(); ++i) {
                VisitableElement oldNode = (VisitableElement)elements.get(i);
                this.updateSetNode(oldNode, (IntrospectedColumn)ic.get());
                VisitableElement newNode = this.updateWhereNode(oldNode, (IntrospectedColumn)ic.get());
                if (null == newNode) continue;
                elements.set(i, newNode);
                break;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return true;
    }

    private boolean updateSetNode(VisitableElement element, IntrospectedColumn ic) {
        if (!(element instanceof XmlElement)) {
            return false;
        }
        XmlElement xe = (XmlElement)element;
        if (!"set".equals(xe.getName())) {
            return false;
        }
        for (VisitableElement e : xe.getElements()) {
            if (!(e instanceof XmlElement)) continue;
            XmlElement setNode = (XmlElement)e;
            for (Attribute a : setNode.getAttributes()) {
                if (!"test".equals(a.getName())) continue;
                String jp = ic.getJavaProperty();
                if (a.getValue().indexOf(jp) < 0) continue;
                List elements = setNode.getElements();
                String content = ((TextElement)elements.get(0)).getContent();
                elements.set(0, new TextElement(content.replaceAll(jp, jp + " + 1")));
                return true;
            }
        }
        return false;
    }

    private VisitableElement updateWhereNode(VisitableElement element, IntrospectedColumn ic) {
        if (!(element instanceof TextElement)) {
            return null;
        }
        String content = ((TextElement)element).getContent();
        if (content.indexOf("where ") < 0) {
            return null;
        }
        return this.buildWhereElement(content, ic.getJavaProperty(), ic.getJdbcTypeName());
    }

    private TextElement buildWhereElement(String content, String javaProperty, String javaTypeName) {
        int idx = content.indexOf("where") + 6;
        StringBuilder buf = new StringBuilder(200);
        buf.append(content.substring(0, idx)).append(this.lockColumnName).append(" = #{").append(javaProperty).append(",jdbcType=").append(javaTypeName).append("} and ").append(content.substring(idx));
        return new TextElement(buf.toString());
    }
}

