/*
 * Decompiled with CFR 0.152.
 */
package org.shenjia.mybatis.generator.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class JavaCommentPlugin
extends PluginAdapter {
    private String licenseComment;
    private String classComment;

    public boolean validate(List<String> warnings) {
        boolean valid = true;
        if (StringUtility.stringHasValue((String)this.properties.getProperty("licenseCommentFile"))) {
            File lcf = new File(this.properties.getProperty("licenseCommentFile"));
            if (lcf.exists() && lcf.isFile()) {
                this.licenseComment = this.copyFileToString(lcf);
            } else {
                System.err.println("[ERROR] ----- LICENSE-COMMENT-FILE -----:" + lcf.getPath());
                warnings.add(Messages.getString((String)"ValidationError.18", (String)"JavaCommentPlugin", (String)"licenseCommentFile"));
                valid = false;
            }
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("classCommentFile"))) {
            File ccf = new File(this.properties.getProperty("classCommentFile"));
            if (ccf.exists() && ccf.isFile()) {
                this.classComment = this.copyFileToString(ccf);
            } else {
                System.err.println("[ERROR] ----- CLASS-COMMENT-FILE -----:" + ccf.getPath());
                warnings.add(Messages.getString((String)"ValidationError.18", (String)"JavaCommentPlugin", (String)"classCommentFile"));
                valid = false;
            }
        }
        return valid;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        if (null != this.licenseComment) {
            interfaze.addFileCommentLine(this.licenseComment);
        }
        if (null != this.classComment) {
            interfaze.addJavaDocLine(this.classComment);
        }
        return true;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.addJavaComment(topLevelClass);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.addJavaComment(topLevelClass);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.addJavaComment(topLevelClass);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.addJavaComment(topLevelClass);
    }

    public boolean providerGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.addJavaComment(topLevelClass);
    }

    private boolean addJavaComment(TopLevelClass tlc) {
        if (null != this.licenseComment) {
            tlc.addFileCommentLine(this.licenseComment);
        }
        if (null != this.classComment) {
            tlc.addJavaDocLine(this.classComment);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyFileToString(File file) {
        InputStream in = null;
        try {
            byte[] bytes = new byte[(int)file.length()];
            in = new FileInputStream(file);
            in.read(bytes);
            String string = new String(bytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

