/*
 * Decompiled with CFR 0.152.
 */
package org.shenjia.mybatis.generator.plugins;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class ExtendableModelPlugin
extends PluginAdapter {
    private List<GeneratedJavaFile> extendableModels = new ArrayList<GeneratedJavaFile>();
    private boolean generateBuildMethod = true;
    private boolean generateSerialVersionUID = true;

    public boolean validate(List<String> warnings) {
        if (StringUtility.stringHasValue((String)this.properties.getProperty("generateBuildMethod"))) {
            this.generateBuildMethod = Boolean.parseBoolean(this.properties.getProperty("generateBuildMethod"));
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("generateSerialVersionUID"))) {
            this.generateSerialVersionUID = Boolean.parseBoolean(this.properties.getProperty("generateSerialVersionUID"));
        }
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        return this.extendableModels;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass oldModelClass, IntrospectedTable introspectedTable) {
        TopLevelClass newModelClass = new TopLevelClass(oldModelClass.getType().getFullyQualifiedName());
        oldModelClass.setAbstract(true);
        FullyQualifiedJavaType oldModelType = oldModelClass.getType();
        Class<?> clazz = oldModelType.getClass();
        try {
            Field pn = clazz.getDeclaredField("packageName");
            pn.setAccessible(true);
            String packageName = oldModelType.getPackageName() + ".internal";
            pn.set(oldModelType, packageName);
            Field bsn = clazz.getDeclaredField("baseShortName");
            bsn.setAccessible(true);
            String shortName = "Abstract" + oldModelType.getShortName();
            bsn.set(oldModelType, shortName);
            Field bqn = clazz.getDeclaredField("baseQualifiedName");
            bqn.setAccessible(true);
            String fullName = oldModelType.getFullyQualifiedNameWithoutTypeParameters();
            fullName = oldModelType.getPackageName() + "." + shortName;
            bqn.set(oldModelType, fullName);
            if (this.generateBuildMethod) {
                Method buildMethod = new Method("T build");
                buildMethod.setVisibility(JavaVisibility.PUBLIC);
                buildMethod.setReturnType(new FullyQualifiedJavaType("<T extends " + shortName + ">"));
                buildMethod.addBodyLine("return (T)this;");
                buildMethod.addAnnotation("@SuppressWarnings(\"unchecked\")");
                oldModelClass.addMethod(buildMethod);
                this.context.getCommentGenerator().addGeneralMethodComment(buildMethod, introspectedTable);
            }
            List oldModelMethods = oldModelClass.getMethods();
            for (Method oldModelMethod : oldModelMethods) {
                if (!oldModelMethod.isConstructor()) continue;
                Method newModelMethod = new Method(oldModelMethod.getName());
                newModelMethod.setConstructor(true);
                newModelMethod.setVisibility(JavaVisibility.PUBLIC);
                StringBuilder bodyBuf = new StringBuilder("super(");
                for (Parameter p : oldModelMethod.getParameters()) {
                    newModelMethod.addParameter(p);
                    bodyBuf.append(p.getName() + " ,");
                }
                int bodyLen = bodyBuf.length();
                if (bodyLen > 6) {
                    bodyBuf.delete(bodyLen - 2, bodyLen);
                }
                bodyBuf.append(");");
                newModelMethod.addBodyLine(bodyBuf.toString());
                newModelClass.addMethod(newModelMethod);
                oldModelMethod.setName("Abstract" + oldModelMethod.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.generateSerialVersionUID) {
            newModelClass.addField(this.buildSerialVersionUID(introspectedTable));
        }
        newModelClass.setVisibility(JavaVisibility.PUBLIC);
        newModelClass.setSuperClass(oldModelType);
        newModelClass.addImportedType(oldModelType);
        String targetProject = this.context.getJavaModelGeneratorConfiguration().getTargetProject();
        if (!this.checkExists(targetProject, newModelClass)) {
            GeneratedJavaFile modelJavaFile = new GeneratedJavaFile((CompilationUnit)newModelClass, targetProject, this.context.getJavaFormatter());
            this.extendableModels.add(modelJavaFile);
        } else {
            System.out.println("---- JAVA FILE EXISTS, IGNORED. --:" + newModelClass.getType().getFullyQualifiedName());
        }
        return true;
    }

    private org.mybatis.generator.api.dom.java.Field buildSerialVersionUID(IntrospectedTable it) {
        org.mybatis.generator.api.dom.java.Field field = new org.mybatis.generator.api.dom.java.Field("serialVersionUID", new FullyQualifiedJavaType("long"));
        field.setFinal(true);
        field.setStatic(true);
        field.setVisibility(JavaVisibility.PRIVATE);
        field.setInitializationString("1L");
        this.context.getCommentGenerator().addFieldComment(field, it);
        return field;
    }

    private boolean checkExists(String targetProject, TopLevelClass newModelClass) {
        String fullName = newModelClass.getType().getFullyQualifiedNameWithoutTypeParameters();
        File pomFile = new File(System.getProperty("user.dir") + "/pom.xml");
        String filePath = System.getProperty("user.dir") + "/";
        if (pomFile.exists()) {
            filePath = filePath + targetProject + "/" + fullName.replaceAll("\\.", "/") + ".java";
        }
        File javaFile = new File(filePath);
        return javaFile.exists();
    }
}

