/*
 * Decompiled with CFR 0.152.
 */
package org.shenjia.mybatis.generator.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.LogFactory;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.FragmentGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import org.shenjia.mybatis.generator.runtime.dynamic.sql.elements.SelectPageMethodGenerator;
import org.shenjia.mybatis.generator.runtime.dynamic.sql.elements.SelectRangeMethodGenerator;

public class DynamicSqlExtensionPlugin
extends PluginAdapter {
    private static final Log LOG = LogFactory.getLog(DynamicSqlExtensionPlugin.class);
    private List<GeneratedJavaFile> generatedJavaFiles = new ArrayList<GeneratedJavaFile>();

    public boolean validate(List<String> warnings) {
        return true;
    }

    public void initialized(IntrospectedTable introspectedTable) {
        String suffix = this.properties.getProperty("dynamicSqlSupportSuffix");
        String type = introspectedTable.getMyBatisDynamicSqlSupportType();
        if (null != suffix && type.endsWith("DynamicSqlSupport")) {
            String newType = type.substring(0, type.length() - 17) + suffix;
            introspectedTable.setMyBatisDynamicSqlSupportType(newType);
        }
        super.initialized(introspectedTable);
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        return this.generatedJavaFiles;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        String resultMapId = recordType.getShortNameWithoutTypeArguments() + "Result";
        String tableFieldName = JavaBeansUtil.getValidPropertyName((String)introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        FragmentGenerator fragmentGenerator = new FragmentGenerator.Builder().withIntrospectedTable(introspectedTable).withResultMapId(resultMapId).build();
        this.generateDaoClassIfNotExsits(interfaze, introspectedTable);
        String addSelectPageMethod = this.properties.getProperty("addSelectPageMethod", "true");
        if (StringUtility.isTrue((String)addSelectPageMethod)) {
            this.addSelectRangeMethod(interfaze, introspectedTable, fragmentGenerator, tableFieldName, recordType);
            this.addSelectPageMethod(interfaze, introspectedTable, fragmentGenerator, tableFieldName, recordType);
        }
        return super.clientGenerated(interfaze, introspectedTable);
    }

    public boolean clientBasicSelectManyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        boolean haveSelectOne = false;
        for (Method m : interfaze.getMethods()) {
            if (!"selectOne".equals(m.getName())) continue;
            haveSelectOne = true;
            break;
        }
        if (!haveSelectOne) {
            FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
            FullyQualifiedJavaType returnType = new FullyQualifiedJavaType(recordType.getShortNameWithoutTypeArguments());
            Method m = new Method("selectOne");
            for (Parameter p : method.getParameters()) {
                m.addParameter(p);
            }
            m.addAnnotation("@Generated(\"org.mybatis.generator.api.MyBatisGenerator\")");
            m.addAnnotation("@SelectProvider(type=SqlProviderAdapter.class, method=\"select\")");
            m.addAnnotation("@ResultMap(\"" + recordType.getShortNameWithoutTypeArguments() + "Result\")");
            m.addBodyLines((Collection)method.getBodyLines());
            m.setReturnType(returnType);
            interfaze.addMethod(m);
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.ResultMap"));
        }
        return super.clientBasicSelectManyMethodGenerated(method, interfaze, introspectedTable);
    }

    private void addSelectRangeMethod(Interface interfaze, IntrospectedTable introspectedTable, FragmentGenerator fragmentGenerator, String tableFieldName, FullyQualifiedJavaType recordType) {
        SelectRangeMethodGenerator generator = ((SelectRangeMethodGenerator.Builder)((SelectRangeMethodGenerator.Builder)new SelectRangeMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(fragmentGenerator).withIntrospectedTable(introspectedTable)).withTableFieldName(tableFieldName).withRecordType(recordType).build();
        this.generate(interfaze, generator);
    }

    private void addSelectPageMethod(Interface interfaze, IntrospectedTable introspectedTable, FragmentGenerator fragmentGenerator, String tableFieldName, FullyQualifiedJavaType recordType) {
        SelectPageMethodGenerator generator = ((SelectPageMethodGenerator.Builder)((SelectPageMethodGenerator.Builder)new SelectPageMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(fragmentGenerator).withIntrospectedTable(introspectedTable)).withTableFieldName(tableFieldName).withRecordType(recordType).build();
        this.generate(interfaze, generator);
    }

    private void generate(Interface interfaze, AbstractMethodGenerator generator) {
        MethodAndImports mi = generator.generateMethodAndImports();
        if (mi != null && generator.callPlugins(mi.getMethod(), interfaze)) {
            interfaze.addMethod(mi.getMethod());
            interfaze.addImportedTypes(mi.getImports());
            interfaze.addStaticImports(mi.getStaticImports());
        }
    }

    private void generateDaoClassIfNotExsits(Interface mapperInterfaze, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType mapperType = new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper");
        mapperInterfaze.setVisibility(JavaVisibility.DEFAULT);
        mapperInterfaze.addJavaDocLine("// Do not modify this file, it will be overwritten when code is generated.");
        mapperInterfaze.getAnnotations().clear();
        Set importTypes = mapperInterfaze.getImportedTypes();
        Set newImportTypes = importTypes.stream().filter(t -> !t.equals((Object)mapperType)).collect(Collectors.toSet());
        importTypes.clear();
        importTypes.addAll(newImportTypes);
        String targetProject = this.context.getJavaModelGeneratorConfiguration().getTargetProject();
        FullyQualifiedJavaType daoType = new FullyQualifiedJavaType(mapperInterfaze.getType().getFullyQualifiedName().replaceFirst("Mapper", "Dao"));
        try {
            DefaultShellCallback sc = new DefaultShellCallback(false);
            File fileDir = sc.getDirectory(targetProject, daoType.getPackageName());
            File javaFile = new File(fileDir, daoType.getShortName() + ".java");
            if (javaFile.exists() && javaFile.isFile()) {
                LOG.debug("Existing file " + javaFile.getPath() + ", skips generating this file.");
                return;
            }
        }
        catch (ShellException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        Interface daoInterface = new Interface(daoType);
        daoInterface.setVisibility(JavaVisibility.PUBLIC);
        daoInterface.addSuperInterface(mapperInterfaze.getType());
        daoInterface.addAnnotation("@Mapper");
        daoInterface.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
        GeneratedJavaFile daoInterfaceJavaFile = new GeneratedJavaFile((CompilationUnit)daoInterface, targetProject, this.context.getJavaFormatter()){

            public boolean isMergeable() {
                return false;
            }
        };
        this.generatedJavaFiles.add(daoInterfaceJavaFile);
    }
}

