/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.wbem;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.Wbemcli;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sentrysoftware.wmi.AutoCloseableReadWriteLock;
import org.sentrysoftware.wmi.Utils;
import org.sentrysoftware.wmi.WmiHelper;
import org.sentrysoftware.wmi.WqlQuery;
import org.sentrysoftware.wmi.exceptions.WmiComException;
import org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wmi.remotecommand.RemoteProcess;
import org.sentrysoftware.wmi.wbem.CoAuthIdentity;
import org.sentrysoftware.wmi.wbem.Ole32Enhanced;
import org.sentrysoftware.wmi.wbem.WmiCimTypeHandler;
import org.sentrysoftware.wmi.wbem.WmiComHelper;
import org.sentrysoftware.wmi.windows.remote.WindowsRemoteCommandResult;
import org.sentrysoftware.wmi.windows.remote.WindowsRemoteExecutor;

public class WmiWbemServices
implements WindowsRemoteExecutor {
    private static final Map<Long, String> MAP_HRESULT_MESSAGE;
    private static final Guid.CLSID CLSID_WBEM_CONTEXT;
    private static final Guid.GUID IID_WBEM_CONTEXT;
    private static final String WBEMCONTEXT_NAME_FOR_PROVIDER_ARCHITECTURE = "__ProviderArchitecture";
    private static final int SET_VALUE_FUNCTION_VTABLE_ID_IN_WBEM_CONTEXT_INTERFACE = 8;
    private static final int WBEM_SERVICES_GET_OBJECT_VTABLE_ID = 6;
    private static final int WBEM_SERVICES_EXEC_METHOD_VTABLE_ID = 24;
    private static final int WBEM_CLASS_OBJECT_PUT_VTABLE_ID = 5;
    private static final int WBEM_CLASS_OBJECT_SPAWN_INSTANCE_VTABLE_ID = 15;
    private static final int WBEM_CLASS_OBJECT_GET_METHOD_VTABLE_ID = 19;
    private static final int WBEM_FLAG_RETURN_WBEM_COMPLETE = 0;
    private static final String WQL = "WQL";
    private final String networkResource;
    private final String hostname;
    private final String username;
    private final char[] password;
    private final Wbemcli.IWbemServices wbemServices;
    private final Wbemcli.IWbemLocator wbemLocator;
    private final Wbemcli.IWbemContext context;
    private final CoAuthIdentity authIdent;
    private boolean isClosed = false;
    private AutoCloseableReadWriteLock lock;

    static void checkHResult(WinNT.HRESULT hResult, String message) throws WmiComException {
        Utils.checkNonNull(hResult, "hResult");
        if (COMUtils.FAILED(hResult)) {
            throw new WmiComException("%s. %s", message, WmiWbemServices.getWmiComErrorMessage(hResult));
        }
    }

    static String getWmiComErrorMessage(WinNT.HRESULT hResult) {
        int code = hResult.intValue();
        return MAP_HRESULT_MESSAGE.getOrDefault(Integer.toUnsignedLong(code), String.format("code: 0x%s.", Integer.toHexString(code)));
    }

    private WmiWbemServices(String networkResource, String username, char[] password, Wbemcli.IWbemServices wbemServices, Wbemcli.IWbemLocator wbemLocator, Wbemcli.IWbemContext context, CoAuthIdentity authIdent) {
        this.networkResource = networkResource;
        this.username = username;
        this.password = password;
        this.wbemServices = wbemServices;
        this.wbemLocator = wbemLocator;
        this.context = context;
        this.authIdent = authIdent;
        this.hostname = networkResource != null && networkResource.startsWith("\\\\") ? networkResource.split("\\\\")[2] : null;
        this.lock = new AutoCloseableReadWriteLock();
    }

    public static WmiWbemServices getInstance(String networkResource, String username, char[] password) throws WmiComException {
        Utils.checkNonNull(networkResource, "networkResource");
        if (WmiHelper.isLocalNetworkResource(networkResource) && (username != null || password != null)) {
            throw new IllegalArgumentException("A local resource must be accessed without specific credentials");
        }
        Wbemcli.IWbemLocator jnaWbemLocator = null;
        Wbemcli.IWbemContext jnaWbemContext = null;
        Unknown jnaWbemServices = null;
        try {
            WmiComHelper.initializeComLibrary();
            jnaWbemLocator = Wbemcli.IWbemLocator.create();
            if (jnaWbemLocator == null) {
                throw new COMException("Failed to create WbemLocator object.");
            }
            jnaWbemContext = WmiWbemServices.createWbemContextFor64BitWbemProvider();
            jnaWbemServices = jnaWbemLocator.ConnectServer(networkResource, username, password == null ? null : String.valueOf(password), null, 0, null, jnaWbemContext);
            CoAuthIdentity authIdent = username != null && !username.isEmpty() ? new CoAuthIdentity(username, password) : null;
            WmiWbemServices.setProxySecurity(jnaWbemServices.getPointer(), authIdent);
            return new WmiWbemServices(networkResource, username, password, (Wbemcli.IWbemServices)jnaWbemServices, jnaWbemLocator, jnaWbemContext, authIdent);
        }
        catch (COMException e) {
            if (jnaWbemServices != null) {
                jnaWbemServices.Release();
            }
            if (jnaWbemLocator != null) {
                jnaWbemLocator.Release();
            }
            if (jnaWbemContext != null) {
                jnaWbemContext.Release();
            }
            throw new WmiComException(e, e.getMessage());
        }
    }

    @Override
    public synchronized void close() {
        try (AutoCloseableReadWriteLock.AutoCloseableWriteLock writeLock = this.lock.write();){
            this.isClosed = true;
            if (this.context != null) {
                this.context.Release();
            }
            if (this.wbemServices != null) {
                this.wbemServices.Release();
            }
            if (this.wbemLocator != null) {
                this.wbemLocator.Release();
            }
        }
    }

    private void checkState() {
        if (this.isClosed) {
            throw new IllegalStateException("This instance was closed");
        }
    }

    @Override
    public List<Map<String, Object>> executeWql(String wql, long timeout) throws TimeoutException, WqlQuerySyntaxException, WmiComException {
        WqlQuery wqlQuery = WqlQuery.newInstance(wql);
        return this.executeWql(wqlQuery, timeout);
    }

    /*
     * Loose catch block
     */
    public List<Map<String, Object>> executeWql(WqlQuery wqlQuery, long timeout) throws TimeoutException, WmiComException, WqlQuerySyntaxException {
        try (AutoCloseableReadWriteLock.AutoCloseableReadLock readLock = this.lock.read();){
            this.checkState();
            Utils.checkNonNullField(this.wbemServices, "wbemServices");
            Utils.checkNonNullField(wqlQuery, "wqlQuery");
            Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
            Unknown wbemClassObjectQueryResult = null;
            try {
                wbemClassObjectQueryResult = this.wbemServices.ExecQuery(WQL, wqlQuery.getCleanWql(), 48, null);
                List<Map<String, Object>> list = this.processWqlResult((Wbemcli.IEnumWbemClassObject)wbemClassObjectQueryResult, this.authIdent, timeout, wqlQuery.getSubPropertiesMap());
                return list;
            }
            catch (COMException e) {
                throw new WmiComException(e, e.getClass().getSimpleName() + ": " + e.getMessage());
            }
            finally {
                if (wbemClassObjectQueryResult != null) {
                    wbemClassObjectQueryResult.Release();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public WindowsRemoteCommandResult executeCommand(String command, String workingDirectory, Charset charset, long timeout) throws WmiComException, TimeoutException {
        RemoteProcess.executeCommand(command, this.hostname, this.username, this.password, workingDirectory, timeout);
        return null;
    }

    static void setProxySecurity(Pointer pProxy, CoAuthIdentity authIdent) throws WmiComException {
        WinNT.HRESULT hResult = Ole32Enhanced.INSTANCE.CoSetProxyBlanket(pProxy, -1, -1, null, 3, 3, authIdent, 0);
        WmiWbemServices.checkHResult(hResult, "Could not set proxy blanket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Wbemcli.IWbemContext createWbemContextFor64BitWbemProvider() {
        try {
            WmiComHelper.initializeComLibrary();
        }
        catch (WmiComException e) {
            return null;
        }
        PointerByReference contextPointer = new PointerByReference();
        WinNT.HRESULT hCoCreateInstanceResult = Ole32.INSTANCE.CoCreateInstance(CLSID_WBEM_CONTEXT, null, 1, IID_WBEM_CONTEXT, contextPointer);
        if (COMUtils.FAILED(hCoCreateInstanceResult)) {
            return null;
        }
        Variant.VARIANT value64 = new Variant.VARIANT(64);
        Variant.VARIANT.ByReference byReference64 = new Variant.VARIANT.ByReference(value64);
        try {
            WinNT.HRESULT hResult = (WinNT.HRESULT)WmiComHelper.comInvokerInvokeNativeObject(contextPointer.getValue(), 8, new Object[]{contextPointer.getValue(), new WString(WBEMCONTEXT_NAME_FOR_PROVIDER_ARCHITECTURE), 0, byReference64}, WinNT.HRESULT.class);
            Wbemcli.IWbemContext iWbemContext = COMUtils.FAILED(hResult) ? null : new Wbemcli.IWbemContext(contextPointer.getValue());
            return iWbemContext;
        }
        finally {
            OleAuto.INSTANCE.VariantClear(byReference64);
            OleAuto.INSTANCE.VariantClear(value64);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> processWqlResult(Wbemcli.IEnumWbemClassObject wbemClassObjectQueryResult, CoAuthIdentity authIdent, long timeout, Map<String, Set<String>> properties) throws TimeoutException, WmiComException, WqlQuerySyntaxException {
        Pointer[] pointersOnWbemClassObject = new Pointer[1];
        ArrayList<Map<String, Object>> resultRows = new ArrayList<Map<String, Object>>();
        String[] names = null;
        Map<String, Set<String>> normalizedProperties = null;
        if (wbemClassObjectQueryResult.getPointer() != Pointer.NULL) {
            WmiWbemServices.setProxySecurity(wbemClassObjectQueryResult.getPointer(), authIdent);
        }
        while (wbemClassObjectQueryResult.getPointer() != Pointer.NULL) {
            WinNT.HRESULT hResult = wbemClassObjectQueryResult.Next((int)timeout, pointersOnWbemClassObject.length, pointersOnWbemClassObject, new IntByReference(0));
            if (hResult == null || hResult.intValue() == 1 || hResult.intValue() == 262149) {
                return resultRows;
            }
            if (hResult.intValue() == 262148) {
                throw new TimeoutException("No results after " + timeout + " ms.");
            }
            if (Integer.toUnsignedLong(hResult.intValue()) == 2147749911L) {
                throw new WqlQuerySyntaxException("The query was not syntactically valid.");
            }
            WmiWbemServices.checkHResult(hResult, "Failed to enumerate results");
            Wbemcli.IWbemClassObject wbemClassObject = new Wbemcli.IWbemClassObject(pointersOnWbemClassObject[0]);
            try {
                if (names == null) {
                    try {
                        names = wbemClassObject.GetNames(null, 0, null);
                    }
                    catch (Throwable e) {
                        names = wbemClassObject.GetNames(null, 0, null);
                    }
                }
                if (normalizedProperties == null) {
                    normalizedProperties = WmiWbemServices.normalizeProperties(names, properties);
                }
                HashMap<String, Object> values = WmiWbemServices.getPropertiesValues(normalizedProperties, wbemClassObject);
                resultRows.add(values);
            }
            finally {
                wbemClassObject.Release();
            }
        }
        return resultRows;
    }

    private static HashMap<String, Object> getPropertiesValues(Map<String, Set<String>> properties, Wbemcli.IWbemClassObject wbemClassObject) {
        return properties.entrySet().stream().map(entry -> WmiCimTypeHandler.getPropertyValue(wbemClassObject, entry)).flatMap(map -> map.entrySet().stream()).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), entry.getValue()), HashMap::putAll);
    }

    private static Map<String, Set<String>> normalizeProperties(String[] names, Map<String, Set<String>> properties) {
        Map propertiesNames = Stream.of(names).collect(Collectors.toMap(String::toLowerCase, Function.identity()));
        return properties == null || properties.isEmpty() ? propertiesNames.values().stream().collect(Collectors.toMap(Function.identity(), p -> Collections.emptySet())) : (Map)properties.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)propertiesNames.get(((String)entry.getKey()).toLowerCase()), (Set)entry.getValue()), HashMap::putAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer getObject(String objectPath) throws WmiComException {
        try (AutoCloseableReadWriteLock.AutoCloseableReadLock readLock = this.lock.read();){
            this.checkState();
            Utils.checkNonNull(objectPath, "objectPath");
            Pointer pWbemServices = this.wbemServices.getPointer();
            WTypes.BSTR strObjectPath = OleAuto.INSTANCE.SysAllocString(objectPath);
            boolean lFlags = false;
            Object pCtx = null;
            PointerByReference ppObject = new PointerByReference();
            Object ppCallResult = null;
            try {
                WinNT.HRESULT hResult = (WinNT.HRESULT)WmiComHelper.comInvokerInvokeNativeObject(pWbemServices, 6, new Object[]{pWbemServices, strObjectPath, 0, pCtx, ppObject, ppCallResult}, WinNT.HRESULT.class);
                WmiWbemServices.checkHResult(hResult, "Fail to invoke WbemServices::GetObject method");
                Pointer pointer = ppObject.getValue();
                OleAuto.INSTANCE.SysFreeString(strObjectPath);
                return pointer;
            }
            catch (Throwable throwable) {
                OleAuto.INSTANCE.SysFreeString(strObjectPath);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> executeMethod(String objectPath, String className, String methodName, Map<String, Object> inputMap) throws WmiComException {
        try (AutoCloseableReadWriteLock.AutoCloseableReadLock readLock = this.lock.read();){
            HashMap<String, Object> hashMap;
            Wbemcli.IWbemClassObject methodOutputs;
            Wbemcli.IWbemClassObject methodInputs;
            Wbemcli.IWbemClassObject methodDefinition;
            this.checkState();
            Wbemcli.IWbemClassObject classDefinition = new Wbemcli.IWbemClassObject(this.getObject(className));
            try {
                methodDefinition = new Wbemcli.IWbemClassObject(this.getMethod(classDefinition.getPointer(), methodName));
            }
            finally {
                classDefinition.Release();
            }
            try {
                methodInputs = new Wbemcli.IWbemClassObject(this.spawnInstance(methodDefinition.getPointer()));
            }
            finally {
                methodDefinition.Release();
            }
            HashMap<String, Variant.VARIANT> variantInputMap = new HashMap<String, Variant.VARIANT>();
            inputMap.forEach((name, value) -> {
                Variant.VARIANT variant;
                if (value == null) {
                    variant = new Variant.VARIANT();
                } else if (value instanceof String) {
                    variant = new Variant.VARIANT((String)value);
                } else if (value instanceof Integer) {
                    variant = new Variant.VARIANT((Integer)value);
                } else if (value instanceof Pointer) {
                    variant = new Variant.VARIANT((Pointer)value);
                } else {
                    throw new IllegalArgumentException("Unsupported object type for " + name);
                }
                variantInputMap.put((String)name, variant);
            });
            try {
                for (Map.Entry inputEntry : variantInputMap.entrySet()) {
                    this.objectPut(methodInputs.getPointer(), (String)inputEntry.getKey(), (Variant.VARIANT)inputEntry.getValue());
                }
                methodOutputs = new Wbemcli.IWbemClassObject(this.executeMethod(objectPath, methodName, methodInputs.getPointer()));
            }
            finally {
                variantInputMap.forEach((name, value) -> OleAuto.INSTANCE.VariantClear((Variant.VARIANT)value));
                methodInputs.Release();
            }
            try {
                String[] properties;
                try {
                    properties = methodOutputs.GetNames(null, 0, null);
                }
                catch (Throwable e) {
                    properties = methodOutputs.GetNames(null, 0, null);
                }
                Map<String, Set<String>> normalizedProperties = WmiWbemServices.normalizeProperties(properties, null);
                hashMap = WmiWbemServices.getPropertiesValues(normalizedProperties, methodOutputs);
            }
            catch (Throwable throwable) {
                methodOutputs.Release();
                throw throwable;
            }
            methodOutputs.Release();
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pointer executeMethod(String objectPath, String methodName, Pointer pInParams) throws WmiComException {
        Utils.checkNonNull(objectPath, "objectPath");
        Utils.checkNonNull(methodName, "methodName");
        Pointer pWbemServices = this.wbemServices.getPointer();
        WTypes.BSTR strObjectPath = OleAuto.INSTANCE.SysAllocString(objectPath);
        WTypes.BSTR strMethodName = OleAuto.INSTANCE.SysAllocString(methodName);
        boolean lFlags = false;
        Object pCtx = null;
        PointerByReference ppOutParams = new PointerByReference();
        Object ppCallResult = null;
        try {
            WinNT.HRESULT hResult = (WinNT.HRESULT)WmiComHelper.comInvokerInvokeNativeObject(pWbemServices, 24, new Object[]{pWbemServices, strObjectPath, strMethodName, 0, pCtx, pInParams, ppOutParams, ppCallResult}, WinNT.HRESULT.class);
            WmiWbemServices.checkHResult(hResult, "Failed to invoke WbemServices::ExecMethod method");
            Pointer pointer = ppOutParams.getValue();
            return pointer;
        }
        finally {
            OleAuto.INSTANCE.SysFreeString(strObjectPath);
            OleAuto.INSTANCE.SysFreeString(strMethodName);
        }
    }

    public void objectPut(Pointer pWbemClassObject, String propertyName, Variant.VARIANT pVal) throws WmiComException {
        try (AutoCloseableReadWriteLock.AutoCloseableReadLock readLock = this.lock.read();){
            this.checkState();
            Utils.checkNonNull(pWbemClassObject, "pWbemClassObject");
            Utils.checkNonNull(propertyName, "propertyName");
            WString wszName = new WString(propertyName);
            WinNT.HRESULT hResult = (WinNT.HRESULT)WmiComHelper.comInvokerInvokeNativeObject(pWbemClassObject, 5, new Object[]{pWbemClassObject, wszName, 0, pVal}, WinNT.HRESULT.class);
            WmiWbemServices.checkHResult(hResult, "Fail to invoke IWbemClassObject::Put method");
        }
    }

    public Pointer spawnInstance(Pointer pWbemClassObject) throws WmiComException {
        try (AutoCloseableReadWriteLock.AutoCloseableReadLock readLock = this.lock.read();){
            this.checkState();
            Utils.checkNonNull(pWbemClassObject, "pWbemClassObject");
            boolean lFlags = false;
            PointerByReference ppNewInstance = new PointerByReference();
            WinNT.HRESULT hResult = (WinNT.HRESULT)WmiComHelper.comInvokerInvokeNativeObject(pWbemClassObject, 15, new Object[]{pWbemClassObject, 0, ppNewInstance}, WinNT.HRESULT.class);
            WmiWbemServices.checkHResult(hResult, "Fail to invoke IWbemClassObject::SpawnInstance method");
            Pointer pointer = ppNewInstance.getValue();
            return pointer;
        }
    }

    Pointer getMethod(Pointer pWbemClassObject, String methodName) throws WmiComException {
        Utils.checkNonNull(pWbemClassObject, "pWbemClassObject");
        Utils.checkNonNull(methodName, "methodName");
        WString wszName = new WString(methodName);
        boolean lFlags = false;
        PointerByReference ppInSignature = new PointerByReference();
        Object ppOutSignature = null;
        WinNT.HRESULT hResult = (WinNT.HRESULT)WmiComHelper.comInvokerInvokeNativeObject(pWbemClassObject, 19, new Object[]{pWbemClassObject, wszName, 0, ppInSignature, ppOutSignature}, WinNT.HRESULT.class);
        WmiWbemServices.checkHResult(hResult, "Fail to invoke IWbemClassObject::getMethod method");
        return ppInSignature.getValue();
    }

    public String getNetworkResource() {
        return this.networkResource;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    public Wbemcli.IWbemServices getWbemServices() {
        return this.wbemServices;
    }

    public Wbemcli.IWbemLocator getWbemLocator() {
        return this.wbemLocator;
    }

    public Wbemcli.IWbemContext getContext() {
        return this.context;
    }

    public CoAuthIdentity getAuthIdent() {
        return this.authIdent;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    static {
        HashMap<Long, String> map = new HashMap<Long, String>();
        map.put(2147749889L, "WBEM_E_FAILED: Call failed. (0x80041001)");
        map.put(2147749890L, "WBEM_E_NOT_FOUND: Object cannot be found. (0x80041002)");
        map.put(2147749891L, "WBEM_E_ACCESS_DENIED: Current user does not have permission to perform the action. (0x80041003)");
        map.put(2147749892L, "WBEM_E_PROVIDER_FAILURE: Provider has failed at some time other than during initialization. (0x80041004)");
        map.put(2147749893L, "WBEM_E_TYPE_MISMATCH: Type mismatch occurred. (0x80041005)");
        map.put(2147749894L, "WBEM_E_OUT_OF_MEMORY: Not enough memory for the operation. (0x80041006)");
        map.put(2147749895L, "WBEM_E_INVALID_CONTEXT: The IWbemContext object is not valid. (0x80041007)");
        map.put(2147749896L, "WBEM_E_INVALID_PARAMETER: One of the parameters to the call is not correct. (0x80041008)");
        map.put(2147749897L, "WBEM_E_NOT_AVAILABLE: Resource, typically a remote server, is not currently available. (0x80041009)");
        map.put(2147749898L, "WBEM_E_CRITICAL_ERROR: Internal, critical, and unexpected error occurred. Report the error to Microsoft Technical Support. (0x8004100A)");
        map.put(2147749899L, "WBEM_E_INVALID_STREAM: One or more network packets were corrupted during a remote session. (0x8004100B)");
        map.put(2147749900L, "WBEM_E_NOT_SUPPORTED: Feature or operation is not supported. (0x8004100C)");
        map.put(2147749901L, "WBEM_E_INVALID_SUPERCLASS: Parent class specified is not valid. (0x8004100D)");
        map.put(2147749902L, "WBEM_E_INVALID_NAMESPACE: Namespace specified cannot be found. (0x8004100E)");
        map.put(2147749903L, "WBEM_E_INVALID_OBJECT: Specified instance is not valid. (0x8004100F)");
        map.put(2147749904L, "WBEM_E_INVALID_CLASS: Specified class is not valid. (0x80041010)");
        map.put(2147749905L, "WBEM_E_PROVIDER_NOT_FOUND: Provider referenced in the schema does not have a corresponding registration. (0x80041011)");
        map.put(2147749906L, "WBEM_E_INVALID_PROVIDER_REGISTRATION: Provider referenced in the schema has an incorrect or incomplete registration. (0x80041012)");
        map.put(2147749907L, "WBEM_E_PROVIDER_LOAD_FAILURE: COM cannot locate a provider referenced in the schema. (0x80041013)");
        map.put(2147749908L, "WBEM_E_INITIALIZATION_FAILURE: Component, such as a provider, failed to initialize for internal reasons. (0x80041014)");
        map.put(2147749909L, "WBEM_E_TRANSPORT_FAILURE: Networking error that prevents normal operation has occurred. (0x80041015)");
        map.put(2147749910L, "WBEM_E_INVALID_OPERATION: Requested operation is not valid. This error usually applies to invalid attempts to delete classes or properties. (0x80041016)");
        map.put(2147749911L, "WBEM_E_INVALID_QUERY: Query was not syntactically valid. (0x80041017)");
        map.put(2147749912L, "WBEM_E_INVALID_QUERY_TYPE: Requested query language is not supported. (0x80041018)");
        map.put(2147749913L, "WBEM_E_ALREADY_EXISTS: In a put operation, the wbemChangeFlagCreateOnly flag was specified, but the instance already exists. (0x80041019)");
        map.put(2147749914L, "WBEM_E_OVERRIDE_NOT_ALLOWED: Not possible to perform the add operation on this qualifier because the owning object does not permit overrides. (0x8004101A)");
        map.put(2147749915L, "WBEM_E_PROPAGATED_QUALIFIER: User attempted to delete a qualifier that was not owned. The qualifier was inherited from a parent class. (0x8004101B)");
        map.put(2147749916L, "WBEM_E_PROPAGATED_PROPERTY: User attempted to delete a property that was not owned. The property was inherited from a parent class. (0x8004101C)");
        map.put(2147749917L, "WBEM_E_UNEXPECTED: Client made an unexpected and illegal sequence of calls, such as calling EndEnumeration before calling BeginEnumeration. (0x8004101D)");
        map.put(2147749918L, "WBEM_E_ILLEGAL_OPERATION: User requested an illegal operation, such as spawning a class from an instance. (0x8004101E)");
        map.put(2147749919L, "WBEM_E_CANNOT_BE_KEY: Illegal attempt to specify a key qualifier on a property that cannot be a key. The keys are specified in the class definition for an object and cannot be altered on a per-instance basis. (0x8004101F)");
        map.put(2147749920L, "WBEM_E_INCOMPLETE_CLASS: Current object is not a valid class definition. Either it is incomplete or it has not been registered with WMI using SWbemObject.Put_. (0x80041020)");
        map.put(2147749921L, "WBEM_E_INVALID_SYNTAX: Query is syntactically not valid. (0x80041021)");
        map.put(2147749922L, "WBEM_E_NONDECORATED_OBJECT: Reserved for future use. (0x80041022)");
        map.put(2147749923L, "WBEM_E_READ_ONLY: An attempt was made to modify a read-only property. (0x80041023)");
        map.put(2147749924L, "WBEM_E_PROVIDER_NOT_CAPABLE: Provider cannot perform the requested operation. This can include a query that is too complex, retrieving an instance, creating or updating a class, deleting a class, or enumerating a class. (0x80041024)");
        map.put(2147749925L, "WBEM_E_CLASS_HAS_CHILDREN: Attempt was made to make a change that invalidates a subclass. (0x80041025)");
        map.put(2147749926L, "WBEM_E_CLASS_HAS_INSTANCES: Attempt was made to delete or modify a class that has instances. (0x80041026)");
        map.put(2147749927L, "WBEM_E_QUERY_NOT_IMPLEMENTED: Reserved for future use. (0x80041027)");
        map.put(2147749928L, "WBEM_E_ILLEGAL_NULL: Value of Nothing/NULL was specified for a property that must have a value, such as one that is marked by a Key, Indexed, or Not_Null qualifier. (0x80041028)");
        map.put(2147749929L, "WBEM_E_INVALID_QUALIFIER_TYPE: Variant value for a qualifier was provided that is not a legal qualifier type. (0x80041029)");
        map.put(2147749930L, "WBEM_E_INVALID_PROPERTY_TYPE: CIM type specified for a property is not valid. (0x8004102A)");
        map.put(2147749931L, "WBEM_E_VALUE_OUT_OF_RANGE: Request was made with an out-of-range value or it is incompatible with the type. (0x8004102B)");
        map.put(2147749932L, "WBEM_E_CANNOT_BE_SINGLETON: Illegal attempt was made to make a class singleton, such as when the class is derived from a non-singleton class. (0x8004102C)");
        map.put(2147749933L, "WBEM_E_INVALID_CIM_TYPE: CIM type specified is not valid. (0x8004102D)");
        map.put(2147749934L, "WBEM_E_INVALID_METHOD: Requested method is not available. (0x8004102E)");
        map.put(2147749935L, "WBEM_E_INVALID_METHOD_PARAMETERS: Parameters provided for the method are not valid. (0x8004102F)");
        map.put(2147749936L, "WBEM_E_SYSTEM_PROPERTY: There was an attempt to get qualifiers on a system property. (0x80041030)");
        map.put(2147749937L, "WBEM_E_INVALID_PROPERTY: Property type is not recognized. (0x80041031)");
        map.put(2147749938L, "WBEM_E_CALL_CANCELLED: Asynchronous process has been canceled internally or by the user. Note that due to the timing and nature of the asynchronous operation, the operation may not have been truly canceled. (0x80041032)");
        map.put(2147749939L, "WBEM_E_SHUTTING_DOWN: User has requested an operation while WMI is in the process of shutting down. (0x80041033)");
        map.put(2147749940L, "WBEM_E_PROPAGATED_METHOD: Attempt was made to reuse an existing method name from a parent class and the signatures do not match. (0x80041034)");
        map.put(2147749941L, "WBEM_E_UNSUPPORTED_PARAMETER: One or more parameter values, such as a query text, is too complex or unsupported. WMI is therefore requested to retry the operation with simpler parameters. (0x80041035)");
        map.put(2147749942L, "WBEM_E_MISSING_PARAMETER_ID: Parameter was missing from the method call. (0x80041036)");
        map.put(2147749943L, "WBEM_E_INVALID_PARAMETER_ID: Method parameter has an ID qualifier that is not valid. (0x80041037)");
        map.put(2147749944L, "WBEM_E_NONCONSECUTIVE_PARAMETER_IDS: One or more of the method parameters have ID qualifiers that are out of sequence. (0x80041038)");
        map.put(2147749945L, "WBEM_E_PARAMETER_ID_ON_RETVAL: Return value for a method has an ID qualifier. (0x80041039)");
        map.put(2147749946L, "WBEM_E_INVALID_OBJECT_PATH: Specified object path was not valid. (0x8004103A)");
        map.put(2147749947L, "WBEM_E_OUT_OF_DISK_SPACE: Disk is out of space or the 4 GB limit on WMI repository (CIM repository) size is reached. (0x8004103B)");
        map.put(2147749948L, "WBEM_E_BUFFER_TOO_SMALL: Supplied buffer was too small to hold all of the objects in the enumerator or to read a string property. (0x8004103C)");
        map.put(2147749949L, "WBEM_E_UNSUPPORTED_PUT_EXTENSION: Provider does not support the requested put operation. (0x8004103D)");
        map.put(2147749950L, "WBEM_E_UNKNOWN_OBJECT_TYPE: Object with an incorrect type or version was encountered during marshaling. (0x8004103E)");
        map.put(2147749951L, "WBEM_E_UNKNOWN_PACKET_TYPE: Packet with an incorrect type or version was encountered during marshaling. (0x8004103F)");
        map.put(2147749952L, "WBEM_E_MARSHAL_VERSION_MISMATCH: Packet has an unsupported version. (0x80041040)");
        map.put(2147749953L, "WBEM_E_MARSHAL_INVALID_SIGNATURE: Packet appears to be corrupt. (0x80041041)");
        map.put(2147749954L, "WBEM_E_INVALID_QUALIFIER: Attempt was made to mismatch qualifiers, such as putting [key] on an object instead of a property. (0x80041042)");
        map.put(2147749955L, "WBEM_E_INVALID_DUPLICATE_PARAMETER: Duplicate parameter was declared in a CIM method. (0x80041043)");
        map.put(2147749956L, "WBEM_E_TOO_MUCH_DATA: Reserved for future use. (0x80041044)");
        map.put(2147749957L, "WBEM_E_SERVER_TOO_BUSY: Call to IWbemObjectSink::Indicate has failed. The provider can refire the event. (0x80041045)");
        map.put(2147749958L, "WBEM_E_INVALID_FLAVOR: Specified qualifier flavor was not valid. (0x80041046)");
        map.put(2147749959L, "WBEM_E_CIRCULAR_REFERENCE: Attempt was made to create a reference that is circular (for example, deriving a class from itself). (0x80041047)");
        map.put(2147749960L, "WBEM_E_UNSUPPORTED_CLASS_UPDATE: Specified class is not supported. (0x80041048)");
        map.put(2147749961L, "WBEM_E_CANNOT_CHANGE_KEY_INHERITANCE: Attempt was made to change a key when instances or subclasses are already using the key. (0x80041049)");
        map.put(2147749968L, "WBEM_E_CANNOT_CHANGE_INDEX_INHERITANCE: An attempt was made to change an index when instances or subclasses are already using the index. (0x80041050)");
        map.put(2147749969L, "WBEM_E_TOO_MANY_PROPERTIES: Attempt was made to create more properties than the current version of the class supports. (0x80041051)");
        map.put(2147749970L, "WBEM_E_UPDATE_TYPE_MISMATCH: Property was redefined with a conflicting type in a derived class. (0x80041052)");
        map.put(2147749971L, "WBEM_E_UPDATE_OVERRIDE_NOT_ALLOWED: Attempt was made in a derived class to override a qualifier that cannot be overridden. (0x80041053)");
        map.put(2147749972L, "WBEM_E_UPDATE_PROPAGATED_METHOD: Method was re-declared with a conflicting signature in a derived class. (0x80041054)");
        map.put(2147749973L, "WBEM_E_METHOD_NOT_IMPLEMENTED: Attempt was made to execute a method not marked with [implemented] in any relevant class. (0x80041055)");
        map.put(2147749974L, "WBEM_E_METHOD_DISABLED: Attempt was made to execute a method marked with [disabled]. (0x80041056)");
        map.put(2147749975L, "WBEM_E_REFRESHER_BUSY: Refresher is busy with another operation. (0x80041057)");
        map.put(2147749976L, "WBEM_E_UNPARSABLE_QUERY: Filtering query is syntactically not valid. (0x80041058)");
        map.put(2147749977L, "WBEM_E_NOT_EVENT_CLASS: The FROM clause of a filtering query references a class that is not an event class (not derived from __Event). (0x80041059)");
        map.put(2147749978L, "WBEM_E_MISSING_GROUP_WITHIN: A GROUP BY clause was used without the corresponding GROUP WITHIN clause. (0x8004105A)");
        map.put(2147749979L, "WBEM_E_MISSING_AGGREGATION_LIST: A GROUP BY clause was used. Aggregation on all properties is not supported. (0x8004105B)");
        map.put(2147749980L, "WBEM_E_PROPERTY_NOT_AN_OBJECT: Dot notation was used on a property that is not an embedded object. (0x8004105C)");
        map.put(2147749981L, "WBEM_E_AGGREGATING_BY_OBJECT: A GROUP BY clause references a property that is an embedded object without using dot notation. (0x8004105D)");
        map.put(2147749983L, "WBEM_E_UNINTERPRETABLE_PROVIDER_QUERY: Event provider registration query (__EventProviderRegistration) did not specify the classes for which events were provided. (0x8004105F)");
        map.put(2147749984L, "WBEM_E_BACKUP_RESTORE_WINMGMT_RUNNING: Request was made to back up or restore the repository while it was in use by WinMgmt.exe, or by the SVCHOST process that contains the WMI service. (0x80041060)");
        map.put(2147749985L, "WBEM_E_QUEUE_OVERFLOW: Asynchronous delivery queue overflowed from the event consumer being too slow. (0x80041061)");
        map.put(2147749986L, "WBEM_E_PRIVILEGE_NOT_HELD: Operation failed because the client did not have the necessary security privilege. (0x80041062)");
        map.put(2147749987L, "WBEM_E_INVALID_OPERATOR: Operator is not valid for this property type. (0x80041063)");
        map.put(2147749988L, "WBEM_E_LOCAL_CREDENTIALS: User specified a username/password/authority on a local connection. The user must use a blank username/password and rely on default security. (0x80041064)");
        map.put(2147749989L, "WBEM_E_CANNOT_BE_ABSTRACT: Class was made abstract when its parent class is not abstract. (0x80041065)");
        map.put(2147749990L, "WBEM_E_AMENDED_OBJECT: Amended object was written without the WBEM_FLAG_USE_AMENDED_QUALIFIERS flag being specified. (0x80041066)");
        map.put(2147749991L, "WBEM_E_CLIENT_TOO_SLOW: Client did not retrieve objects quickly enough from an enumeration. This constant is returned when a client creates an enumeration object, but does not retrieve objects from the enumerator in a timely fashion, causing the enumerator's object caches to back up. (0x80041067)");
        map.put(2147749992L, "WBEM_E_NULL_SECURITY_DESCRIPTOR: Null security descriptor was used. (0x80041068)");
        map.put(2147749993L, "WBEM_E_TIMED_OUT: Operation timed out. (0x80041069)");
        map.put(2147749994L, "WBEM_E_INVALID_ASSOCIATION: Association is not valid. (0x8004106A)");
        map.put(2147749995L, "WBEM_E_AMBIGUOUS_OPERATION: Operation was ambiguous. (0x8004106B)");
        map.put(2147749996L, "WBEM_E_QUOTA_VIOLATION: WMI is taking up too much memory. This can be caused by low memory availability or excessive memory consumption by WMI. (0x8004106C)");
        map.put(2147749997L, "WBEM_E_TRANSACTION_CONFLICT: Operation resulted in a transaction conflict. (0x8004106D)");
        map.put(2147749998L, "WBEM_E_FORCED_ROLLBACK: Transaction forced a rollback. (0x8004106E)");
        map.put(2147749999L, "WBEM_E_UNSUPPORTED_LOCALE: Locale used in the call is not supported. (0x8004106F)");
        map.put(2147750000L, "WBEM_E_HANDLE_OUT_OF_DATE: Object handle is out-of-date. (0x80041070)");
        map.put(2147750001L, "WBEM_E_CONNECTION_FAILED: Connection to the SQL database failed. (0x80041071)");
        map.put(2147750002L, "WBEM_E_INVALID_HANDLE_REQUEST: Handle request was not valid. (0x80041072)");
        map.put(2147750003L, "WBEM_E_PROPERTY_NAME_TOO_WIDE: Property name contains more than 255 characters. (0x80041073)");
        map.put(2147750004L, "WBEM_E_CLASS_NAME_TOO_WIDE: Class name contains more than 255 characters. (0x80041074)");
        map.put(2147750005L, "WBEM_E_METHOD_NAME_TOO_WIDE: Method name contains more than 255 characters. (0x80041075)");
        map.put(2147750006L, "WBEM_E_QUALIFIER_NAME_TOO_WIDE: Qualifier name contains more than 255 characters. (0x80041076)");
        map.put(2147750007L, "WBEM_E_RERUN_COMMAND: The SQL command must be rerun because there is a deadlock in SQL. This can be returned only when data is being stored in an SQL database. (0x80041077)");
        map.put(2147750008L, "WBEM_E_DATABASE_VER_MISMATCH: The database version does not match the version that the repository driver processes. (0x80041078)");
        map.put(2147750009L, "WBEM_E_VETO_DELETE: WMI cannot execute the delete operation because the provider does not allow it. (0x80041079)");
        map.put(2147750010L, "WBEM_E_VETO_PUT: WMI cannot execute the put operation because the provider does not allow it. (0x8004107A)");
        map.put(2147750016L, "WBEM_E_INVALID_LOCALE: Specified locale identifier was not valid for the operation. (0x80041080)");
        map.put(2147750017L, "WBEM_E_PROVIDER_SUSPENDED: Provider is suspended. (0x80041081)");
        map.put(2147750018L, "WBEM_E_SYNCHRONIZATION_REQUIRED: Object must be written to the WMI repository and retrieved again before the requested operation can succeed. This constant is returned when an object must be committed and retrieved to see the property value. (0x80041082)");
        map.put(2147750019L, "WBEM_E_NO_SCHEMA: Operation cannot be completed; no schema is available. (0x80041083)");
        map.put(2147750020L, "WBEM_E_PROVIDER_ALREADY_REGISTERED: Provider cannot be registered because it is already registered. (0x119FD010)");
        map.put(2147750021L, "WBEM_E_PROVIDER_NOT_REGISTERED: Provider was not registered. (0x80041085)");
        map.put(2147750022L, "WBEM_E_FATAL_TRANSPORT_ERROR: A fatal transport error occurred. (0x80041086)");
        map.put(2147750023L, "WBEM_E_ENCRYPTED_CONNECTION_REQUIRED: User attempted to set a computer name or domain without an encrypted connection. (0x80041087)");
        map.put(2147750024L, "WBEM_E_PROVIDER_TIMED_OUT: A provider failed to report results within the specified timeout. (0x80041088)");
        map.put(2147750025L, "WBEM_E_NO_KEY: User attempted to put an instance with no defined key. (0x80041089)");
        map.put(2147750026L, "WBEM_E_PROVIDER_DISABLED: User attempted to register a provider instance but the COM server for the provider instance was unloaded. (0x8004108A)");
        map.put(2147753985L, "WBEMESS_E_REGISTRATION_TOO_BROAD: Provider registration overlaps with the system event domain. (0x80042001)");
        map.put(2147753986L, "WBEMESS_E_REGISTRATION_TOO_PRECISE: A WITHIN clause was not used in this query. (0x80042002)");
        map.put(2147753987L, "WBEMESS_E_AUTHZ_NOT_PRIVILEGED: This computer does not have the necessary domain permissions to support the security functions that relate to the created subscription instance. Contact the Domain Administrator to get this computer added to the Windows Authorization Access Group. (0x80042003)");
        map.put(2147758081L, "WBEM_E_RETRY_LATER: Reserved for future use. (0x80043001)");
        map.put(2147758082L, "WBEM_E_RESOURCE_CONTENTION: Reserved for future use. (0x80043002)");
        map.put(2147762177L, "WBEMMOF_E_EXPECTED_QUALIFIER_NAME: Expected a qualifier name. (0x80044001)");
        map.put(2147762178L, "WBEMMOF_E_EXPECTED_SEMI: Expected semicolon or '='. (0x80044002)");
        map.put(2147762179L, "WBEMMOF_E_EXPECTED_OPEN_BRACE: Expected an opening brace. (0x80044003)");
        map.put(0x80044004L, "WBEMMOF_E_EXPECTED_CLOSE_BRACE: Missing closing brace or an illegal array element (0x80044004)");
        map.put(2147762181L, "WBEMMOF_E_EXPECTED_CLOSE_BRACKET: Expected a closing bracket. (0x80044005)");
        map.put(2147762182L, "WBEMMOF_E_EXPECTED_CLOSE_PAREN: Expected closing parenthesis. (0x80044006)");
        map.put(2147762183L, "WBEMMOF_E_ILLEGAL_CONSTANT_VALUE: Numeric value out of range or strings without quotes. (0x80044007)");
        map.put(0x80044008L, "WBEMMOF_E_EXPECTED_TYPE_IDENTIFIER: Expected a type identifiers. (0x80044008)");
        map.put(2147762185L, "WBEMMOF_E_EXPECTED_OPEN_PAREN: Expected an open parenthesis. (0x80044009)");
        map.put(2147762186L, "WBEMMOF_E_UNRECOGNIZED_TOKEN: Unexpected token in the file. (0x8004400A)");
        map.put(2147762187L, "WBEMMOF_E_UNRECOGNIZED_TYPE: Unrecognized or unsupported type identifier. (0x8004400B)");
        map.put(2147762188L, "WBEMMOF_E_EXPECTED_PROPERTY_NAME: Expected property or method name. (0x8004400C)");
        map.put(2147762189L, "WBEMMOF_E_TYPEDEF_NOT_SUPPORTED: Typedefs and enumerated types are not supported. (0x8004400D)");
        map.put(2147762190L, "WBEMMOF_E_UNEXPECTED_ALIAS: Only a reference to a class object can have an alias value. (0x8004400E)");
        map.put(2147762191L, "WBEMMOF_E_UNEXPECTED_ARRAY_INIT: Unexpected array initialization. Arrays must be declared with []. (0x8004400F)");
        map.put(2147762192L, "WBEMMOF_E_INVALID_AMENDMENT_SYNTAX: Namespace path syntax is not valid. (0x80044010)");
        map.put(2147762193L, "WBEMMOF_E_INVALID_DUPLICATE_AMENDMENT: Duplicate amendment specifiers. (0x80044011)");
        map.put(2147762194L, "WBEMMOF_E_INVALID_PRAGMA: #pragma must be followed by a valid keyword. (0x80044012)");
        map.put(2147762195L, "WBEMMOF_E_INVALID_NAMESPACE_SYNTAX: Namespace path syntax is not valid. (0x80044013)");
        map.put(2147762196L, "WBEMMOF_E_EXPECTED_CLASS_NAME: Unexpected character in class name must be an identifier. (0x80044014)");
        map.put(2147762197L, "WBEMMOF_E_TYPE_MISMATCH: The value specified cannot be made into the appropriate type. (0x80044015)");
        map.put(2147762198L, "WBEMMOF_E_EXPECTED_ALIAS_NAME: Dollar sign must be followed by an alias name as an identifier. (0x80044016)");
        map.put(2147762199L, "WBEMMOF_E_INVALID_CLASS_DECLARATION: Class declaration is not valid. (0x80044017)");
        map.put(2147762200L, "WBEMMOF_E_INVALID_INSTANCE_DECLARATION: The instance declaration is not valid. It must start with \"instance of\". (0x80044018)");
        map.put(2147762201L, "WBEMMOF_E_EXPECTED_DOLLAR: Expected dollar sign. An alias in the form \"$name\" must follow the \"as\" keyword. (0x80044019)");
        map.put(2147762202L, "WBEMMOF_E_CIMTYPE_QUALIFIER: \"CIMTYPE\" qualifier cannot be specified directly in a MOF file. Use standard type notation. (0x8004401A)");
        map.put(2147762203L, "WBEMMOF_E_DUPLICATE_PROPERTY: Duplicate property name was found in the MOF. (0x8004401B)");
        map.put(2147762204L, "WBEMMOF_E_INVALID_NAMESPACE_SPECIFICATION: Namespace syntax is not valid. References to other servers are not allowed. (0x8004401C)");
        map.put(2147762205L, "WBEMMOF_E_OUT_OF_RANGE: Value out of range. (0x8004401D)");
        map.put(2147762206L, "WBEMMOF_E_INVALID_FILE: The file is not a valid text MOF file or binary MOF file. (0x8004401E)");
        map.put(2147762207L, "WBEMMOF_E_ALIASES_IN_EMBEDDED: Embedded objects cannot be aliases. (0x8004401F)");
        map.put(2147762208L, "WBEMMOF_E_NULL_ARRAY_ELEM: NULL elements in an array are not supported. (0x80044020)");
        map.put(2147762209L, "WBEMMOF_E_DUPLICATE_QUALIFIER: Qualifier was used more than once on the object. (0x80044021)");
        map.put(2147762210L, "WBEMMOF_E_EXPECTED_FLAVOR_TYPE: Expected a flavor type such as ToInstance, ToSubClass, EnableOverride, or DisableOverride. (0x80044022)");
        map.put(2147762211L, "WBEMMOF_E_INCOMPATIBLE_FLAVOR_TYPES: Combining EnableOverride and DisableOverride on same qualifier is not legal. (0x80044023)");
        map.put(2147762212L, "WBEMMOF_E_MULTIPLE_ALIASES: An alias cannot be used twice. (0x80044024)");
        map.put(2147762213L, "WBEMMOF_E_INCOMPATIBLE_FLAVOR_TYPES2: Combining Restricted, and ToInstance or ToSubClass is not legal. (0x80044025)");
        map.put(2147762214L, "WBEMMOF_E_NO_ARRAYS_RETURNED: Methods cannot return array values. (0x80044026)");
        map.put(2147762215L, "WBEMMOF_E_MUST_BE_IN_OR_OUT: Arguments must have an In or Out qualifier. (0x80044027)");
        map.put(2147762216L, "WBEMMOF_E_INVALID_FLAGS_SYNTAX: Flags syntax is not valid. (0x80044028)");
        map.put(2147762217L, "WBEMMOF_E_EXPECTED_BRACE_OR_BAD_TYPE: The final brace and semi-colon for a class are missing. (0x80044029)");
        map.put(2147762218L, "WBEMMOF_E_UNSUPPORTED_CIMV22_QUAL_VALUE: A CIM version 2.2 feature is not supported for a qualifier value. (0x8004402A)");
        map.put(2147762219L, "WBEMMOF_E_UNSUPPORTED_CIMV22_DATA_TYPE: The CIM version 2.2 data type is not supported. (0x8004402B)");
        map.put(2147762220L, "WBEMMOF_E_INVALID_DELETEINSTANCE_SYNTAX: The delete instance syntax is not valid. It should be #pragma DeleteInstance(\"instancepath\", FAIL|NOFAIL). (0x8004402C)");
        map.put(2147762221L, "WBEMMOF_E_INVALID_QUALIFIER_SYNTAX: The qualifier syntax is not valid. It should be qualifiername:type=value,scope(class|instance), flavorname. (0x8004402D)");
        map.put(2147762222L, "WBEMMOF_E_QUALIFIER_USED_OUTSIDE_SCOPE: The qualifier is used outside of its scope. (0x8004402E)");
        map.put(2147762223L, "WBEMMOF_E_ERROR_CREATING_TEMP_FILE: Error creating temporary file. The temporary file is an intermediate stage in the MOF compilation. (0x8004402F)");
        map.put(2147762224L, "WBEMMOF_E_ERROR_INVALID_INCLUDE_FILE: A file included in the MOF by the preprocessor command #include is not valid. (0x80044030)");
        map.put(2147762225L, "WBEMMOF_E_INVALID_DELETECLASS_SYNTAX: The syntax for the preprocessor commands #pragma deleteinstance or #pragma deleteclass is not valid. (0x80044031)");
        MAP_HRESULT_MESSAGE = Collections.unmodifiableMap(map);
        CLSID_WBEM_CONTEXT = new Guid.CLSID("674B6698-EE92-11D0-AD71-00C04FD8FDFF");
        IID_WBEM_CONTEXT = new Guid.GUID("44ACA674-E8FC-11D0-A07C-00C04FB68820");
    }
}

