/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.wbem;

import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.Wbemcli;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sentrysoftware.wmi.Utils;

public class WmiCimTypeHandler {
    private static final Map<Integer, Function<Variant.VARIANT.ByReference, Object>> CIMTYPE_TO_CONVERTER_MAP;
    private static final String CIM_OBJECT_LABEL = "CIM_OBJECT";

    private WmiCimTypeHandler() {
    }

    static OffsetDateTime convertCimDateTime(Variant.VARIANT.ByReference value) {
        return Utils.convertCimDateTime(value.stringValue());
    }

    static String convertCimReference(Variant.VARIANT.ByReference value) {
        return WmiCimTypeHandler.convertCimReference(value.stringValue());
    }

    static String convertCimReference(String reference) {
        if (reference == null) {
            return null;
        }
        int colonIndex = reference.indexOf(58);
        return colonIndex > -1 ? reference.substring(colonIndex + 1) : reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Object> convertSafeArray(Variant.VARIANT.ByReference array, int cimType, Map.Entry<String, Set<String>> property) {
        OaIdl.SAFEARRAY safeArray = (OaIdl.SAFEARRAY)array.getValue();
        if (safeArray == null) {
            return Collections.singletonMap(property.getKey(), null);
        }
        safeArray.lock();
        int lowerBound = safeArray.getLBound(0);
        int length = safeArray.getUBound(0) - lowerBound + 1;
        Object[] resultArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            resultArray[i] = safeArray.getElement(lowerBound + i);
        }
        safeArray.unlock();
        if (cimType == 102) {
            return Collections.singletonMap(property.getKey(), Stream.of(resultArray).map(String.class::cast).map(WmiCimTypeHandler::convertCimReference).toArray());
        }
        if (cimType == 101) {
            return Collections.singletonMap(property.getKey(), Stream.of(resultArray).map(String.class::cast).map(Utils::convertCimDateTime).toArray());
        }
        if (cimType == 13) {
            if (property.getValue().isEmpty()) {
                return Collections.singletonMap(property.getKey(), new String[]{CIM_OBJECT_LABEL});
            }
            HashMap resulMap = new HashMap();
            for (Object resultValue : resultArray) {
                Optional<Wbemcli.IWbemClassObject> maybeClassObject = WmiCimTypeHandler.getUnknownWbemClassObject(resultValue);
                if (!maybeClassObject.isPresent()) continue;
                Map<String, String> subPropertiesNames = WmiCimTypeHandler.getSubPropertiesNamesFromClass(maybeClassObject.get());
                try {
                    property.getValue().stream().map(subProperty -> (String)subPropertiesNames.get(subProperty.toLowerCase())).forEach(subProperty -> resulMap.computeIfAbsent(WmiCimTypeHandler.buildCimObjectSubPropertyName(property, subProperty), key -> new ArrayList()).add(WmiCimTypeHandler.getPropertyValue((Wbemcli.IWbemClassObject)maybeClassObject.get(), new AbstractMap.SimpleEntry<String, Set<String>>((String)subProperty, Collections.emptySet())).get(subProperty)));
                }
                finally {
                    maybeClassObject.get().Release();
                }
            }
            return resulMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toArray()));
        }
        return Collections.singletonMap(property.getKey(), resultArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Object> convertCimObject(Variant.VARIANT.ByReference value, Map.Entry<String, Set<String>> property) {
        Optional<Wbemcli.IWbemClassObject> maybeClassObject = WmiCimTypeHandler.getUnknownWbemClassObject(value.getValue());
        if (!maybeClassObject.isPresent()) {
            return property.getValue().stream().collect(HashMap::new, (map, subProperty) -> map.put(WmiCimTypeHandler.buildCimObjectSubPropertyName(property, subProperty), null), HashMap::putAll);
        }
        try {
            Map<String, String> subPropertiesNames = WmiCimTypeHandler.getSubPropertiesNamesFromClass(maybeClassObject.get());
            Map map2 = property.getValue().stream().map(subProperty -> (String)subPropertiesNames.get(subProperty.toLowerCase())).collect(HashMap::new, (map, subProperty) -> map.put(WmiCimTypeHandler.buildCimObjectSubPropertyName(property, subProperty), WmiCimTypeHandler.getPropertyValue((Wbemcli.IWbemClassObject)maybeClassObject.get(), new AbstractMap.SimpleEntry<String, Set<String>>((String)subProperty, Collections.emptySet())).get(subProperty)), HashMap::putAll);
            return map2;
        }
        finally {
            maybeClassObject.get().Release();
        }
    }

    static Map<String, String> getSubPropertiesNamesFromClass(Wbemcli.IWbemClassObject wbemClassObject) {
        String[] names;
        try {
            names = wbemClassObject.GetNames(null, 0, null);
        }
        catch (Throwable e) {
            names = wbemClassObject.GetNames(null, 0, null);
        }
        return Stream.of(names).collect(Collectors.toMap(String::toLowerCase, Function.identity()));
    }

    static String buildCimObjectSubPropertyName(Map.Entry<String, Set<String>> property, String subProperty) {
        return property.getKey() + "." + subProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Optional<Wbemcli.IWbemClassObject> getUnknownWbemClassObject(Object value) {
        if (value == null) {
            return Optional.empty();
        }
        Unknown unknown = (Unknown)value;
        try {
            PointerByReference pointerByReference = new PointerByReference();
            WinNT.HRESULT hResult = unknown.QueryInterface(new Guid.REFIID(IUnknown.IID_IUNKNOWN), pointerByReference);
            Optional<Wbemcli.IWbemClassObject> optional = COMUtils.FAILED(hResult) ? Optional.empty() : Optional.of(new Wbemcli.IWbemClassObject(pointerByReference.getValue()));
            return optional;
        }
        finally {
            unknown.Release();
        }
    }

    static Map<String, Object> convert(Variant.VARIANT.ByReference value, int cimType, Map.Entry<String, Set<String>> property) {
        if (value.getValue() == null) {
            return Collections.singletonMap(property.getKey(), null);
        }
        if ((cimType & 0x2000) > 0) {
            return WmiCimTypeHandler.convertSafeArray(value, cimType ^ 0x2000, property);
        }
        if (cimType == 13) {
            return property.getValue().isEmpty() ? Collections.singletonMap(property.getKey(), CIM_OBJECT_LABEL) : WmiCimTypeHandler.convertCimObject(value, property);
        }
        return Collections.singletonMap(property.getKey(), CIMTYPE_TO_CONVERTER_MAP.getOrDefault(cimType, v -> "Unsupported type").apply(value));
    }

    public static Map<String, Object> getPropertyValue(Wbemcli.IWbemClassObject wbemClassObject, Map.Entry<String, Set<String>> property) {
        try {
            return WmiCimTypeHandler.getPropertyValueFromWbemObject(wbemClassObject, property);
        }
        catch (Throwable e) {
            return WmiCimTypeHandler.getPropertyValueFromWbemObject(wbemClassObject, property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> getPropertyValueFromWbemObject(Wbemcli.IWbemClassObject wbemClassObject, Map.Entry<String, Set<String>> property) {
        Variant.VARIANT.ByReference value = new Variant.VARIANT.ByReference();
        IntByReference pType = new IntByReference();
        OleAuto.INSTANCE.VariantInit(value);
        try {
            WinNT.HRESULT hResult = wbemClassObject.Get(property.getKey(), 0, value, pType, new IntByReference());
            if (COMUtils.FAILED(hResult)) {
                Map<String, Object> map = Collections.singletonMap(property.getKey(), null);
                return map;
            }
            if ("__PATH".equalsIgnoreCase(property.getKey())) {
                Map<String, Object> map = Collections.singletonMap(property.getKey(), WmiCimTypeHandler.convertCimReference(value));
                return map;
            }
            Map<String, Object> map = WmiCimTypeHandler.convert(value, pType.getValue(), property);
            return map;
        }
        finally {
            try {
                OleAuto.INSTANCE.VariantClear(value);
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        HashMap<Integer, Function<Variant.VARIANT.ByReference, Object>> map = new HashMap<Integer, Function<Variant.VARIANT.ByReference, Object>>();
        map.put(0, value -> null);
        map.put(11, Variant.VARIANT::booleanValue);
        map.put(17, Variant.VARIANT::byteValue);
        map.put(18, Variant.VARIANT::intValue);
        map.put(19, Variant.VARIANT::intValue);
        map.put(21, Variant.VARIANT::stringValue);
        map.put(16, Variant.VARIANT::shortValue);
        map.put(2, Variant.VARIANT::shortValue);
        map.put(3, Variant.VARIANT::intValue);
        map.put(20, Variant.VARIANT::stringValue);
        map.put(4, Variant.VARIANT::floatValue);
        map.put(5, Variant.VARIANT::doubleValue);
        map.put(103, Variant.VARIANT::shortValue);
        map.put(8, Variant.VARIANT::stringValue);
        map.put(102, WmiCimTypeHandler::convertCimReference);
        map.put(101, WmiCimTypeHandler::convertCimDateTime);
        CIMTYPE_TO_CONVERTER_MAP = Collections.unmodifiableMap(map);
    }
}

