/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sentrysoftware.wmi.Utils;
import org.sentrysoftware.wmi.WqlQuery;
import org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException;

public abstract class WmiHelper {
    public static final String DEFAULT_NAMESPACE = "ROOT\\CIMV2";
    private static final Pattern WQL_SIMPLE_SELECT_PATTERN = Pattern.compile("^\\s*SELECT\\s+(\\*|(?!SELECT|FROM|WHERE)[a-z0-9._]+|((?!SELECT|FROM|WHERE)[a-z0-9._]+\\s*,\\s*)+((?!SELECT|FROM|WHERE)[a-z0-9._]+))\\s+FROM\\s+((?!WHERE|FROM)\\w+)\\s*(WHERE\\s+.*)?$", 2);

    private WmiHelper() {
    }

    public static boolean isValidWql(String wqlQuery) {
        return WQL_SIMPLE_SELECT_PATTERN.matcher(wqlQuery).find();
    }

    public static String createNetworkResource(String hostname, String namespace) {
        Utils.checkNonNull(namespace, "namespace");
        return hostname == null || hostname.isEmpty() ? namespace : String.format("\\\\%s\\%s", hostname, namespace);
    }

    public static boolean isLocalNetworkResource(String networkResource) {
        Utils.checkNonNull(networkResource, "networkResource");
        return !networkResource.startsWith("\\\\") || networkResource.startsWith("\\\\localhost\\") || networkResource.startsWith("\\\\127.0.0.1\\") || networkResource.startsWith("\\\\0:0:0:0:0:0:0:1\\") || networkResource.startsWith("\\\\::1\\") || networkResource.startsWith("\\\\0000:0000:0000:0000:0000:0000:0000:0001\\") || networkResource.toLowerCase().startsWith("\\\\" + Utils.getComputerName().toLowerCase() + "\\");
    }

    public static List<String> extractPropertiesFromResult(List<Map<String, Object>> resultRows, String wql) {
        try {
            return WmiHelper.extractPropertiesFromResult(resultRows, WqlQuery.newInstance(wql));
        }
        catch (WqlQuerySyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<String> extractPropertiesFromResult(List<Map<String, Object>> resultRows, WqlQuery wqlQuery) {
        if (resultRows.isEmpty()) {
            return wqlQuery.getSelectedProperties();
        }
        String[] resultPropertyArray = resultRows.get(0).keySet().toArray(new String[0]);
        if (wqlQuery.getSelectedProperties().isEmpty()) {
            Arrays.sort(resultPropertyArray, String.CASE_INSENSITIVE_ORDER);
            return Arrays.asList(resultPropertyArray);
        }
        List<String> queryProperties = wqlQuery.getSelectedProperties();
        Map<String, String> resultProperties = Arrays.asList(resultPropertyArray).stream().collect(Collectors.toMap(String::toLowerCase, property -> property));
        return queryProperties.stream().map(property -> resultProperties.getOrDefault(property.toLowerCase(), (String)property)).collect(Collectors.toList());
    }
}

