/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi;

import java.util.concurrent.TimeoutException;
import org.sentrysoftware.wmi.Utils;

public class TimeoutHelper {
    private TimeoutHelper() {
    }

    public static long getRemainingTime(long timeout, long start, String message) throws TimeoutException {
        long remaining = start + timeout - Utils.getCurrentTimeMillis();
        if (remaining < 0L) {
            throw new TimeoutException(message);
        }
        return remaining;
    }

    public static void stagedSleep(long timeout, long start, String message) throws TimeoutException {
        TimeoutHelper.getRemainingTime(timeout, start, message);
        long elapsedTime = Utils.getCurrentTimeMillis() - start;
        try {
            if (elapsedTime < 500L) {
                Utils.sleep(50L);
            } else if (elapsedTime < 1000L) {
                Utils.sleep(100L);
            } else if (elapsedTime < 5000L) {
                Utils.sleep(250L);
            } else if (elapsedTime < 10000L) {
                Utils.sleep(500L);
            } else if (elapsedTime < 30000L) {
                Utils.sleep(1000L);
            } else {
                Utils.sleep(3000L);
            }
        }
        catch (InterruptedException e) {
            throw new TimeoutException(message);
        }
    }
}

