/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wmi;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.NetworkHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.IWinRequestExecutor;
import org.sentrysoftware.wmi.WmiHelper;
import org.sentrysoftware.wmi.WmiStringConverter;
import org.sentrysoftware.wmi.exceptions.WmiComException;
import org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wmi.remotecommand.WinRemoteCommandExecutor;
import org.sentrysoftware.wmi.wbem.WmiWbemServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiRequestExecutor
implements IWinRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WmiRequestExecutor.class);
    static final String WBEM_E_INVALID_CLASS = "WBEM_E_INVALID_CLASS";
    static final String WBEM_E_INVALID_NAMESPACE = "WBEM_E_INVALID_NAMESPACE";
    static final String WBEM_E_NOT_FOUND = "WBEM_E_NOT_FOUND";

    @Override
    @WithSpan(value="WMI")
    public List<List<String>> executeWmi(@SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="wmi.config") @NonNull IWinConfiguration wmiConfig, @SpanAttribute(value="wmi.query") @NonNull String wbemQuery, @SpanAttribute(value="wmi.namespace") @NonNull String namespace) throws ClientException {
        if (wmiConfig == null) {
            throw new IllegalArgumentException("wmiConfig is marked non-null but is null");
        }
        if (wbemQuery == null) {
            throw new IllegalArgumentException("wbemQuery is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        String username = wmiConfig.getUsername();
        char[] password = wmiConfig.getPassword();
        if (username == null) {
            password = null;
            log.debug("Hostname {}. Username not provided.", (Object)hostname);
        }
        String networkResource = NetworkHelper.isLocalhost((String)hostname) ? namespace : String.format("\\\\%s\\%s", hostname, namespace);
        LoggingHelper.trace(() -> log.trace("Executing WMI request:\n- Hostname: {}\n- Network-resource: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n", new Object[]{hostname, networkResource, username, wbemQuery, namespace, wmiConfig.getTimeout()}));
        WmiWbemServices wbemServices = WmiWbemServices.getInstance(networkResource, username, password);
        try {
            long startTime = System.currentTimeMillis();
            List<Map<String, Object>> result = wbemServices.executeWql(wbemQuery, wmiConfig.getTimeout() * 1000L);
            long responseTime = System.currentTimeMillis() - startTime;
            List<String> properties = WmiHelper.extractPropertiesFromResult(result, wbemQuery);
            List<List<String>> resultTable = this.buildWmiTable(result, properties);
            LoggingHelper.trace(() -> log.trace("Executed WMI request:\n- Hostname: {}\n- Network-resource: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, networkResource, username, wbemQuery, namespace, wmiConfig.getTimeout(), TextTableHelper.generateTextTable((Collection)properties, (List)resultTable), responseTime}));
            List<List<String>> list = resultTable;
            if (wbemServices != null) {
                wbemServices.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (wbemServices != null) {
                    try {
                        wbemServices.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ClientException("WMI query failed on " + hostname + ".", e);
            }
        }
    }

    @WithSpan(value="Remote Command WMI")
    public String executeWmiRemoteCommand(@SpanAttribute(value="wmi.command") String command, @SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="wmi.username") String username, char[] password, @SpanAttribute(value="wmi.timeout") int timeout, @SpanAttribute(value="wmi.local_files") List<String> localFiles) throws ClientException {
        try {
            LoggingHelper.trace(() -> log.trace("Executing WMI remote command:\n- Command: {}\n- Hostname: {}\n- Username: {}\n- Timeout: {} s\n- Local-files: {}\n", new Object[]{command, hostname, username, timeout, localFiles}));
            long startTime = System.currentTimeMillis();
            WinRemoteCommandExecutor result = WinRemoteCommandExecutor.execute(command, hostname, username, password, null, (long)timeout * 1000L, localFiles, true);
            String resultStdout = result.getStdout();
            long responseTime = System.currentTimeMillis() - startTime;
            LoggingHelper.trace(() -> log.trace("Executed WMI remote command:\n- Command: {}\n- Hostname: {}\n- Username: {}\n- Timeout: {} s\n- Local-files: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{command, hostname, username, timeout, localFiles, resultStdout, responseTime}));
            return resultStdout;
        }
        catch (Exception e) {
            throw new ClientException((Exception)e.getCause());
        }
    }

    List<List<String>> buildWmiTable(List<Map<String, Object>> result, List<String> properties) {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        WmiStringConverter stringConverter = new WmiStringConverter();
        result.forEach(row -> {
            ArrayList line = new ArrayList();
            properties.forEach(property -> line.add(stringConverter.convert(row.get(property))));
            if (!line.isEmpty()) {
                table.add(line);
            }
        });
        return table;
    }

    @Override
    public boolean isAcceptableException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof WmiComException) {
            String message = t.getMessage();
            return IWinRequestExecutor.isAcceptableWmiComError(message);
        }
        if (t instanceof WqlQuerySyntaxException) {
            return true;
        }
        return this.isAcceptableException(t.getCause());
    }

    @Override
    public String executeWinRemoteCommand(String hostname, IWinConfiguration winConfiguration, String command, List<String> embeddedFiles) throws ClientException {
        String username = winConfiguration.getUsername();
        char[] password = winConfiguration.getPassword();
        if (username == null) {
            password = null;
            log.debug("Hostname {}. Username not provided.", (Object)hostname);
        }
        return this.executeWmiRemoteCommand(command, hostname, username, password, winConfiguration.getTimeout().intValue(), embeddedFiles);
    }
}

