/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.wmi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.CommandLineCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.IpmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ProcessCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ServiceCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.WinCommandService;
import org.sentrysoftware.metricshub.extension.win.detection.WinCommandLineCriterionProcessor;
import org.sentrysoftware.metricshub.extension.win.detection.WinIpmiCriterionProcessor;
import org.sentrysoftware.metricshub.extension.win.detection.WinProcessCriterionProcessor;
import org.sentrysoftware.metricshub.extension.win.detection.WinServiceCriterionProcessor;
import org.sentrysoftware.metricshub.extension.win.detection.WmiCriterionProcessor;
import org.sentrysoftware.metricshub.extension.win.detection.WmiDetectionService;
import org.sentrysoftware.metricshub.extension.win.source.WinCommandLineSourceProcessor;
import org.sentrysoftware.metricshub.extension.win.source.WinIpmiSourceProcessor;
import org.sentrysoftware.metricshub.extension.win.source.WmiSourceProcessor;
import org.sentrysoftware.metricshub.extension.wmi.WmiConfiguration;
import org.sentrysoftware.metricshub.extension.wmi.WmiRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiExtension
implements IProtocolExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WmiExtension.class);
    public static final String WMI_TEST_NAMESPACE = "root\\cimv2";
    public static final String WMI_TEST_QUERY = "SELECT Name FROM Win32_ComputerSystem";
    private static final String IDENTIFIER = "wmi";
    private WmiRequestExecutor wmiRequestExecutor = new WmiRequestExecutor();
    private WmiDetectionService wmiDetectionService = new WmiDetectionService(this.wmiRequestExecutor);
    private WinCommandService winCommandService = new WinCommandService(this.wmiRequestExecutor);

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof WmiConfiguration;
    }

    public Set<Class<? extends Source>> getSupportedSources() {
        return Set.of(WmiSource.class, CommandLineSource.class, IpmiSource.class);
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> getConfigurationToSourceMapping() {
        return Map.of(WmiConfiguration.class, Set.of(WmiSource.class));
    }

    public Set<Class<? extends Criterion>> getSupportedCriteria() {
        return Set.of(WmiCriterion.class, ServiceCriterion.class, CommandLineCriterion.class, IpmiCriterion.class);
    }

    public Optional<Boolean> checkProtocol(TelemetryManager telemetryManager) {
        List<List<String>> wmiResult = null;
        WmiConfiguration wmiConfiguration = (WmiConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(WmiConfiguration.class);
        if (wmiConfiguration == null) {
            return Optional.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(WmiConfiguration.class));
        log.info("Hostname {} - Performing {} protocol health check.", (Object)hostname, (Object)this.getIdentifier());
        log.info("Hostname {} - Checking WMI protocol status. Sending a WQL SELECT request on {} namespace.", (Object)hostname, (Object)WMI_TEST_NAMESPACE);
        try {
            wmiResult = this.wmiRequestExecutor.executeWmi(hostname, wmiConfiguration, WMI_TEST_QUERY, WMI_TEST_NAMESPACE);
        }
        catch (Exception e) {
            if (this.wmiRequestExecutor.isAcceptableException(e)) {
                return Optional.of(true);
            }
            log.debug("Hostname {} - Checking WMI protocol status. WMI exception when performing a WQL SELECT request on {} namespace: ", new Object[]{hostname, WMI_TEST_NAMESPACE, e});
        }
        return Optional.of(wmiResult != null);
    }

    public CriterionTestResult processCriterion(Criterion criterion, String connectorId, TelemetryManager telemetryManager) {
        Function<TelemetryManager, IWinConfiguration> configurationRetriever = manager -> (IWinConfiguration)manager.getHostConfiguration().getConfigurations().get(WmiConfiguration.class);
        if (criterion instanceof WmiCriterion) {
            WmiCriterion wmiCriterion = (WmiCriterion)criterion;
            return new WmiCriterionProcessor(this.wmiDetectionService, configurationRetriever, connectorId).process(wmiCriterion, telemetryManager);
        }
        if (criterion instanceof ServiceCriterion) {
            ServiceCriterion serviceCriterion = (ServiceCriterion)criterion;
            return new WinServiceCriterionProcessor(this.wmiDetectionService, configurationRetriever).process(serviceCriterion, telemetryManager);
        }
        if (criterion instanceof CommandLineCriterion) {
            CommandLineCriterion commandLineCriterion = (CommandLineCriterion)criterion;
            return new WinCommandLineCriterionProcessor(this.winCommandService, configurationRetriever, connectorId).process(commandLineCriterion, telemetryManager);
        }
        if (criterion instanceof IpmiCriterion) {
            IpmiCriterion ipmiCriterion = (IpmiCriterion)criterion;
            return new WinIpmiCriterionProcessor(this.wmiDetectionService, configurationRetriever).process(ipmiCriterion, telemetryManager);
        }
        if (criterion instanceof ProcessCriterion) {
            ProcessCriterion processCriterion = (ProcessCriterion)criterion;
            return new WinProcessCriterionProcessor(this.wmiDetectionService).process(processCriterion, WmiConfiguration.builder().username(null).password(null).timeout(30L).build());
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process criterion %s.", telemetryManager.getHostname(), criterion != null ? criterion.getClass().getSimpleName() : "<null>"));
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        Function<TelemetryManager, IWinConfiguration> configurationRetriever = manager -> (IWinConfiguration)manager.getHostConfiguration().getConfigurations().get(WmiConfiguration.class);
        if (source instanceof WmiSource) {
            WmiSource wmiSource = (WmiSource)source;
            return new WmiSourceProcessor(this.wmiRequestExecutor, configurationRetriever, connectorId).process(wmiSource, telemetryManager);
        }
        if (source instanceof IpmiSource) {
            IpmiSource ipmiSource = (IpmiSource)source;
            return new WinIpmiSourceProcessor(this.wmiRequestExecutor, configurationRetriever, connectorId).process(ipmiSource, telemetryManager);
        }
        if (source instanceof CommandLineSource) {
            CommandLineSource commandLineSource = (CommandLineSource)source;
            return new WinCommandLineSourceProcessor(this.winCommandService, configurationRetriever, connectorId).process(commandLineSource, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process source %s.", telemetryManager.getHostname(), source != null ? source.getClass().getSimpleName() : "<null>"));
    }

    public boolean isSupportedConfigurationType(String configurationType) {
        return IDENTIFIER.equalsIgnoreCase(configurationType);
    }

    public IConfiguration buildConfiguration(@NonNull String configurationType, @NonNull JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        if (configurationType == null) {
            throw new IllegalArgumentException("configurationType is marked non-null but is null");
        }
        if (jsonNode == null) {
            throw new IllegalArgumentException("jsonNode is marked non-null but is null");
        }
        try {
            char[] password;
            WmiConfiguration wmiConfiguration = (WmiConfiguration)WmiExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, WmiConfiguration.class);
            if (decrypt != null && (password = wmiConfiguration.getPassword()) != null) {
                wmiConfiguration.setPassword((char[])decrypt.apply(password));
            }
            return wmiConfiguration;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error while reading WMI Configuration. Error: %s", e.getMessage());
            log.error(errorMessage);
            log.debug("Error while reading WMI Configuration. Stack trace:", (Throwable)e);
            throw new InvalidConfigurationException(errorMessage, (Throwable)e);
        }
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String executeQuery(IConfiguration configuration, JsonNode queryNode) throws Exception {
        String query = queryNode.get("query").asText();
        WmiConfiguration wmiConfiguration = (WmiConfiguration)configuration;
        String namespace = wmiConfiguration.getNamespace();
        String hostname = configuration.getHostname();
        List<List<String>> resultList = this.wmiRequestExecutor.executeWmi(hostname, wmiConfiguration, query, namespace);
        String[] columns = StringHelper.extractColumns((String)query);
        if (columns.length == 1 && columns[0].equals("*")) {
            return TextTableHelper.generateTextTable(resultList);
        }
        return TextTableHelper.generateTextTable((String[])columns, resultList);
    }
}

