/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.source;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.IWinRequestExecutor;
import org.sentrysoftware.metricshub.extension.win.source.IpmiThroughWmiHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinIpmiSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WinIpmiSourceProcessor.class);
    @NonNull
    private IWinRequestExecutor winRequestExecutor;
    @NonNull
    private Function<TelemetryManager, IWinConfiguration> configurationRetriever;
    @NonNull
    private String connectorId;

    public SourceTable process(IpmiSource ipmiSource, TelemetryManager telemetryManager) {
        IWinConfiguration winConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (winConfiguration == null) {
            log.warn("Hostname {} - The Windows protocol credentials are not configured. Cannot process Windows IPMI source.", (Object)telemetryManager.getHostname());
            return SourceTable.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(winConfiguration.getClass()));
        String sourceKey = ipmiSource.getKey();
        String nameSpaceRootCimv2 = "root/cimv2";
        String nameSpaceRootHardware = "root/hardware";
        List<List<String>> wmiCollection1 = this.executeIpmiWmiRequest(hostname, winConfiguration, "SELECT IdentifyingNumber,Name,Vendor FROM Win32_ComputerSystemProduct", "root/cimv2", sourceKey);
        List<List<String>> wmiCollection2 = this.executeIpmiWmiRequest(hostname, winConfiguration, "SELECT BaseUnits,CurrentReading,Description,LowerThresholdCritical,LowerThresholdNonCritical,SensorType,UnitModifier,UpperThresholdCritical,UpperThresholdNonCritical FROM NumericSensor", "root/hardware", sourceKey);
        List<List<String>> wmiCollection3 = this.executeIpmiWmiRequest(hostname, winConfiguration, "SELECT CurrentState,Description FROM Sensor", "root/hardware", sourceKey);
        return SourceTable.builder().table(IpmiThroughWmiHelper.ipmiTranslateFromWmi(wmiCollection1, wmiCollection2, wmiCollection3)).build();
    }

    private List<List<String>> executeIpmiWmiRequest(String hostname, IWinConfiguration winConfiguration, String wmiQuery, String namespace, String sourceKey) {
        List<List<String>> result;
        log.info("Hostname {} - Executing IPMI Query for source [{}]:\nWMI Query: {}:\n", new Object[]{hostname, sourceKey, wmiQuery});
        try {
            result = this.winRequestExecutor.executeWmi(hostname, winConfiguration, wmiQuery, namespace);
        }
        catch (Exception exception) {
            LoggingHelper.logSourceError((String)this.connectorId, (String)sourceKey, (String)String.format("IPMI WMI query=%s, Hostname=%s, Username=%s, Timeout=%d, Namespace=%s", wmiQuery, hostname, winConfiguration.getUsername(), winConfiguration.getTimeout(), namespace), (String)hostname, (Throwable)exception);
            result = Collections.emptyList();
        }
        log.info("Hostname {} - IPMI query for [{}] result:\n{}\n", new Object[]{hostname, sourceKey, TextTableHelper.generateTextTable(result)});
        return result;
    }

    @Generated
    public WinIpmiSourceProcessor(@NonNull IWinRequestExecutor winRequestExecutor, @NonNull Function<TelemetryManager, IWinConfiguration> configurationRetriever, @NonNull String connectorId) {
        if (winRequestExecutor == null) {
            throw new IllegalArgumentException("winRequestExecutor is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.winRequestExecutor = winRequestExecutor;
        this.configurationRetriever = configurationRetriever;
        this.connectorId = connectorId;
    }
}

