/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.ArrayHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.ListHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.NumberHelper;

public class IpmiThroughWmiHelper {
    private static final String EQUALS_0 = "=0";
    private static final String EQUALS_1 = "=1";
    private static final String DEASSERTED = "=Deasserted";
    private static final String STATE_DEASSERTED = "=State Deasserted";
    private static final String STATE_ASSERTED = "=State Asserted";

    public static List<List<String>> ipmiTranslateFromWmi(@NonNull List<List<String>> wmiComputerSystem, @NonNull List<List<String>> wmiNumericSensors, @NonNull List<List<String>> wmiDiscreteSensors) {
        List<List<String>> wmiDiscreteSensorsTranslated;
        List<List<String>> wmiNumericSensorsTranslated;
        if (wmiComputerSystem == null) {
            throw new IllegalArgumentException("wmiComputerSystem is marked non-null but is null");
        }
        if (wmiNumericSensors == null) {
            throw new IllegalArgumentException("wmiNumericSensors is marked non-null but is null");
        }
        if (wmiDiscreteSensors == null) {
            throw new IllegalArgumentException("wmiDiscreteSensors is marked non-null but is null");
        }
        ArrayList<List<String>> ipmiTable = new ArrayList<List<String>>();
        List<String> wmiComputerSystemTranslated = IpmiThroughWmiHelper.translateWmiComputerSystem(wmiComputerSystem);
        if (!wmiComputerSystemTranslated.isEmpty()) {
            ipmiTable.add(wmiComputerSystemTranslated);
        }
        if (!(wmiNumericSensorsTranslated = IpmiThroughWmiHelper.translateWmiNumericSensors(wmiNumericSensors)).isEmpty()) {
            ipmiTable.addAll(wmiNumericSensorsTranslated);
        }
        if (!(wmiDiscreteSensorsTranslated = IpmiThroughWmiHelper.translateWmiDiscreteSensors(wmiDiscreteSensors)).isEmpty()) {
            ipmiTable.addAll(wmiDiscreteSensorsTranslated);
        }
        return ipmiTable;
    }

    private static List<String> translateWmiComputerSystem(List<List<String>> wmiComputerSystem) {
        List<String> wmiComputerSystemLine;
        if (!wmiComputerSystem.isEmpty() && (wmiComputerSystemLine = wmiComputerSystem.get(0)).size() > 2) {
            return Arrays.asList("FRU", wmiComputerSystemLine.get(2), wmiComputerSystemLine.get(1), wmiComputerSystemLine.get(0));
        }
        return Collections.emptyList();
    }

    private static List<List<String>> translateWmiNumericSensors(List<List<String>> wmiNumericSensors) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (List<String> line : wmiNumericSensors) {
            String description = (String)ListHelper.getValueAtIndex(line, (int)2, (Object)"");
            if (description.isEmpty()) continue;
            Object[] sensorSplit = description.split("\\(");
            String sensorId = ((String)ArrayHelper.getValueAtIndex((Object[])sensorSplit, (int)1, (Object)"")).split("\\)")[0];
            Object sensorName = sensorSplit[0];
            int lookupIndex = (description = (String)ArrayHelper.getValueAtIndex((Object[])description.split(":"), (int)1, (Object)"")).indexOf(" for ");
            String deviceId = lookupIndex != -1 ? description.substring(lookupIndex + 5) : "";
            String baseUnit = (String)ListHelper.getValueAtIndex(line, (int)0, (Object)"0");
            int unitModifier = NumberHelper.parseInt((String)((String)ListHelper.getValueAtIndex(line, (int)6, (Object)"0")), (Integer)0);
            String sensorType = (String)ListHelper.getValueAtIndex(line, (int)5, (Object)"0");
            double currentValue = NumberHelper.parseDouble((String)((String)ListHelper.getValueAtIndex(line, (int)1, (Object)"0D")), (Double)0.0);
            if (sensorType.equals("2") && currentValue != 0.0 && List.of("2", "3", "4").contains(baseUnit)) {
                List<String> temperatureList = IpmiThroughWmiHelper.temperatureRow(unitModifier, currentValue, baseUnit, line);
                result.add(Arrays.asList("Temperature", sensorId, sensorName, deviceId, temperatureList.get(0), temperatureList.get(1), temperatureList.get(2)));
                continue;
            }
            if (sensorType.equals("5") && baseUnit.equals("19") && currentValue != 0.0) {
                List<String> fanList = IpmiThroughWmiHelper.fanRow(unitModifier, currentValue, line);
                result.add(Arrays.asList("Fan", sensorId, sensorName, deviceId, fanList.get(0), fanList.get(1), fanList.get(2)));
                continue;
            }
            if (sensorType.equals("3") && baseUnit.equals("5") && currentValue != 0.0) {
                List<String> voltageList = IpmiThroughWmiHelper.voltageRow(unitModifier, currentValue, line);
                result.add(Arrays.asList("Voltage", sensorId, sensorName, deviceId, voltageList.get(0), voltageList.get(1), voltageList.get(2)));
                continue;
            }
            if (sensorType.equals("4") && baseUnit.equals("6") && currentValue != 0.0) {
                result.add(Arrays.asList("Current", sensorId, sensorName, deviceId, String.valueOf(currentValue *= Math.pow(10.0, unitModifier))));
                continue;
            }
            if (!sensorType.equals("1") || !baseUnit.equals("7") && (!baseUnit.equals("8") || currentValue == 0.0)) continue;
            if (baseUnit.equals("7")) {
                List<String> powerList = IpmiThroughWmiHelper.powerRow(unitModifier, currentValue, line);
                result.add(Arrays.asList("PowerConsumption", sensorId, sensorName, deviceId, powerList.get(0), powerList.get(1), powerList.get(2)));
                continue;
            }
            result.add(Arrays.asList("EnergyUsage", sensorId, sensorName, deviceId, IpmiThroughWmiHelper.energyRow(unitModifier, currentValue)));
        }
        return result;
    }

    private static List<List<String>> translateWmiDiscreteSensors(List<List<String>> wmiDiscreteSensors) {
        HashMap<String, List<String>> deviceMap = new HashMap<String, List<String>>();
        for (List<String> line2 : wmiDiscreteSensors) {
            String entityId;
            String description = (String)ListHelper.getValueAtIndex(line2, (int)1, (Object)"");
            if (description.isEmpty()) continue;
            String sensorName = description.split("\\(")[0];
            int lookupIndex = (description = (String)ArrayHelper.getValueAtIndex((Object[])description.split(":"), (int)1, (Object)"")).indexOf(" for ");
            if (lookupIndex == -1 || (lookupIndex = (entityId = description.substring(lookupIndex + 5)).lastIndexOf(" ")) == -1) continue;
            String deviceType = entityId.substring(0, lookupIndex);
            String deviceId = entityId.substring(lookupIndex + 1);
            Object state = (String)ListHelper.getValueAtIndex(line2, (int)0, (Object)"0.0");
            if (state == null || ((String)state).isEmpty() || "N/A".equals(state)) continue;
            if (((String)state).length() > 18 && ((String)state).startsWith("OEM State,Value=")) {
                state = "0x" + ((String)state).substring(18, 20) + ((String)state).substring(16, 18);
            }
            state = ((String)state).replace(".,", "|" + sensorName + "=");
            List deviceLine = (List)deviceMap.get(entityId);
            if (deviceLine != null) {
                if (deviceLine.size() < 7) continue;
                deviceLine.set(6, String.format("%s|%s=%s", deviceLine.get(6), sensorName, state));
                deviceMap.put(entityId, deviceLine);
                continue;
            }
            List<String> deviceSensorList = Arrays.asList(deviceType, deviceId, entityId, "", "", "", String.format("%s=%s", sensorName, state));
            deviceMap.put(entityId, deviceSensorList);
        }
        return deviceMap.values().stream().filter(line -> line.size() >= 7 && !((String)ListHelper.getValueAtIndex((List)line, (int)6, (Object)"")).contains("=Device Removed/Device Absent")).map(line -> {
            line.set(6, ((String)line.get(6)).replace(STATE_ASSERTED, EQUALS_1).replace(STATE_DEASSERTED, EQUALS_0).replace(DEASSERTED, EQUALS_0));
            return line;
        }).collect(Collectors.toList());
    }

    public static double convertFromFahrenheitToCelsius(double fahrenheit) {
        return (double)Math.round((fahrenheit - 32.0) * 55.56) / 100.0;
    }

    public static double convertFromKelvinToCelsius(double kelvin) {
        return kelvin - 273.15;
    }

    private static List<String> temperatureRow(int unitModifier, double currentValue, String baseUnit, List<String> line) {
        currentValue *= Math.pow(10.0, unitModifier);
        String threshold1 = (String)ListHelper.getValueAtIndex(line, (int)8, (Object)"0.0");
        String threshold2 = (String)ListHelper.getValueAtIndex(line, (int)7, (Object)"0.0");
        if (baseUnit.equals("4")) {
            currentValue = IpmiThroughWmiHelper.convertFromKelvinToCelsius(currentValue);
        } else if (baseUnit.equals("3")) {
            currentValue = IpmiThroughWmiHelper.convertFromFahrenheitToCelsius(currentValue);
        }
        Double threshold1Double = NumberHelper.parseDouble((String)threshold1, null);
        if (threshold1Double != null) {
            threshold1Double = threshold1Double * Math.pow(10.0, unitModifier);
            if (baseUnit.equals("4")) {
                threshold1Double = IpmiThroughWmiHelper.convertFromKelvinToCelsius(threshold1Double);
            } else if (baseUnit.equals("3")) {
                threshold1Double = IpmiThroughWmiHelper.convertFromFahrenheitToCelsius(threshold1Double);
            }
            threshold1 = String.valueOf(threshold1Double);
        } else {
            threshold1 = "";
        }
        Double threshold2Double = NumberHelper.parseDouble((String)threshold2, null);
        if (threshold2Double != null) {
            threshold2Double = threshold2Double * Math.pow(10.0, unitModifier);
            if (baseUnit.equals("4")) {
                threshold2Double = IpmiThroughWmiHelper.convertFromKelvinToCelsius(threshold2Double);
            } else if (baseUnit.equals("3")) {
                threshold2Double = IpmiThroughWmiHelper.convertFromFahrenheitToCelsius(threshold2Double);
            }
            threshold2 = String.valueOf(threshold2Double);
        } else {
            threshold2 = "";
        }
        return Arrays.asList(String.valueOf(currentValue), threshold1, threshold2);
    }

    private static List<String> fanRow(int unitModifier, double currentValue, List<String> line) {
        String threshold1 = (String)ListHelper.getValueAtIndex(line, (int)4, (Object)"0.0");
        String threshold2 = (String)ListHelper.getValueAtIndex(line, (int)3, (Object)"0.0");
        Double threshold1Double = NumberHelper.parseDouble((String)threshold1, null);
        threshold1 = threshold1Double != null ? String.valueOf(threshold1Double * Math.pow(10.0, unitModifier)) : "";
        Double threshold2Double = NumberHelper.parseDouble((String)threshold2, null);
        threshold2 = threshold2Double != null ? String.valueOf(threshold2Double * Math.pow(10.0, unitModifier)) : "";
        return Arrays.asList(String.valueOf(currentValue *= Math.pow(10.0, unitModifier)), threshold1, threshold2);
    }

    private static List<String> voltageRow(int unitModifier, double currentValue, List<String> line) {
        currentValue = currentValue * Math.pow(10.0, unitModifier) * 1000.0;
        String threshold1 = (String)ListHelper.getValueAtIndex(line, (int)4, (Object)"0.0");
        Double threshold1Double = NumberHelper.parseDouble((String)threshold1, null);
        if (threshold1Double == null) {
            threshold1 = (String)ListHelper.getValueAtIndex(line, (int)3, (Object)"0.0");
            threshold1Double = NumberHelper.parseDouble((String)threshold1, null);
        }
        if (threshold1Double != null) {
            threshold1Double = threshold1Double * Math.pow(10.0, unitModifier) * 1000.0;
            threshold1 = String.valueOf(threshold1Double);
        } else {
            threshold1 = "";
        }
        String threshold2 = (String)ListHelper.getValueAtIndex(line, (int)8, (Object)"0.0");
        Double threshold2Double = NumberHelper.parseDouble((String)threshold2, null);
        if (threshold2Double == null) {
            threshold2 = (String)ListHelper.getValueAtIndex(line, (int)7, (Object)"0.0");
            threshold2Double = NumberHelper.parseDouble((String)threshold2, null);
        }
        if (threshold2Double != null) {
            threshold2Double = threshold2Double * Math.pow(10.0, unitModifier) * 1000.0;
            threshold2 = String.valueOf(threshold2Double);
        } else {
            threshold2 = "";
        }
        return Arrays.asList(String.valueOf(currentValue), threshold1, threshold2);
    }

    private static List<String> powerRow(int unitModifier, double currentValue, List<String> line) {
        String threshold1 = (String)ListHelper.getValueAtIndex(line, (int)8, (Object)"0.0");
        String threshold2 = (String)ListHelper.getValueAtIndex(line, (int)7, (Object)"0.0");
        Double threshold1Double = NumberHelper.parseDouble((String)threshold1, null);
        if (threshold1Double != null) {
            threshold1Double = threshold1Double * Math.pow(10.0, unitModifier);
            threshold1 = String.valueOf(threshold1Double);
        } else {
            threshold1 = "";
        }
        Double threshold2Double = NumberHelper.parseDouble((String)threshold2, null);
        if (threshold2Double != null) {
            threshold2Double = threshold2Double * Math.pow(10.0, unitModifier);
            threshold2 = String.valueOf(threshold2Double);
        } else {
            threshold2 = "";
        }
        return Arrays.asList(String.valueOf(currentValue *= Math.pow(10.0, unitModifier)), threshold1, threshold2);
    }

    private static String energyRow(int unitModifier, double currentValue) {
        return String.valueOf(currentValue * Math.pow(10.0, unitModifier) / 3600000.0);
    }

    @Generated
    private IpmiThroughWmiHelper() {
    }
}

