/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.detection;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.detection.WmiDetectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiCriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WmiCriterionProcessor.class);
    static final String NAMESPACE_WQL = "SELECT Name FROM __NAMESPACE";
    static final String ROOT_NAMESPACE = "root";
    private static final String ROOT_SLASH = "root/";
    private static final Set<String> IGNORED_WMI_NAMESPACES = Set.of("SECURITY", "RSOP", "Cli", "aspnet", "SecurityCenter", "WMI", "Policy", "DEFAULT", "directory", "subscription", "vm", "perform", "MSCluster", "MicrosoftActiveDirectory", "MicrosoftNLB", "Microsoft", "ServiceModel", "nap");
    @NonNull
    private WmiDetectionService wmiDetectionService;
    @NonNull
    private Function<TelemetryManager, IWinConfiguration> configurationRetriever;
    @NonNull
    private String connectorId;

    public CriterionTestResult process(WmiCriterion wmiCriterion, TelemetryManager telemetryManager) {
        if (wmiCriterion == null) {
            return CriterionTestResult.error((Criterion)wmiCriterion, (String)"Malformed criterion. Cannot perform detection.");
        }
        IWinConfiguration winConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (winConfiguration == null) {
            return CriterionTestResult.error((Criterion)wmiCriterion, (String)"Neither WMI nor WinRM credentials are configured for this host.");
        }
        String hostname = telemetryManager.getHostname(List.of(winConfiguration.getClass()));
        if ("automatic".equalsIgnoreCase(wmiCriterion.getNamespace())) {
            String cachedNamespace = telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).getAutomaticWmiNamespace();
            if (cachedNamespace == null) {
                return this.findNamespace(this.connectorId, telemetryManager, hostname, winConfiguration, wmiCriterion);
            }
            WmiCriterion cachedNamespaceCriterion = wmiCriterion.copy();
            cachedNamespaceCriterion.setNamespace(cachedNamespace);
            return this.wmiDetectionService.performDetectionTest(hostname, winConfiguration, cachedNamespaceCriterion);
        }
        return this.wmiDetectionService.performDetectionTest(hostname, winConfiguration, wmiCriterion);
    }

    public NamespaceResult detectNamespace(String hostname, IWinConfiguration configuration, WmiCriterion wmiCriterion, Set<String> possibleNamespaces) {
        TreeMap<String, CriterionTestResult> namespaces = new TreeMap<String, CriterionTestResult>();
        WmiCriterion tentativeCriterion = wmiCriterion.copy();
        for (String namespace : possibleNamespaces) {
            tentativeCriterion.setNamespace(namespace);
            CriterionTestResult testResult = this.wmiDetectionService.performDetectionTest(hostname, configuration, tentativeCriterion);
            if (testResult.isSuccess()) {
                namespaces.put(namespace, testResult);
                continue;
            }
            Throwable e = testResult.getException();
            if (e == null || this.wmiDetectionService.getWinRequestExecutor().isAcceptableException(e)) continue;
            log.debug("Hostname {} - Does not respond to {} requests. {}: {}\nCancelling namespace detection.", new Object[]{hostname, wmiCriterion.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage()});
            return NamespaceResult.builder().result(testResult).build();
        }
        if (namespaces.isEmpty()) {
            String formattedNamespaceList = possibleNamespaces.stream().collect(Collectors.joining("\n- "));
            return NamespaceResult.builder().result(CriterionTestResult.failure((Criterion)wmiCriterion, (String)("None of the possible namespaces match the criterion:" + formattedNamespaceList))).build();
        }
        if (namespaces.size() > 1) {
            namespaces.remove("root/cimv2");
            namespaces.remove("root\\cimv2");
        }
        String detectedNamespace = (String)namespaces.keySet().stream().findFirst().orElseThrow();
        return NamespaceResult.builder().namespace(detectedNamespace).result((CriterionTestResult)namespaces.get(detectedNamespace)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CriterionTestResult findNamespace(String connectorId, TelemetryManager telemetryManager, String hostname, IWinConfiguration winConfiguration, WmiCriterion wqlCriterion) {
        Set possibleWmiNamespaces;
        Set set = possibleWmiNamespaces = telemetryManager.getHostProperties().getPossibleWmiNamespaces();
        synchronized (set) {
            if (possibleWmiNamespaces.isEmpty()) {
                PossibleNamespacesResult possibleWmiNamespacesResult = this.findPossibleNamespaces(hostname, winConfiguration);
                if (!possibleWmiNamespacesResult.isSuccess()) {
                    return CriterionTestResult.error((Criterion)wqlCriterion, (String)possibleWmiNamespacesResult.getErrorMessage());
                }
                possibleWmiNamespaces.clear();
                possibleWmiNamespaces.addAll(possibleWmiNamespacesResult.getPossibleNamespaces());
            }
        }
        NamespaceResult namespaceResult = this.detectNamespace(hostname, winConfiguration, wqlCriterion, Collections.unmodifiableSet(possibleWmiNamespaces));
        if (namespaceResult.getResult().isSuccess()) {
            telemetryManager.getHostProperties().getConnectorNamespace(connectorId).setAutomaticWmiNamespace(namespaceResult.getNamespace());
        }
        return namespaceResult.getResult();
    }

    public PossibleNamespacesResult findPossibleNamespaces(String hostname, IWinConfiguration winConfiguration) {
        if (winConfiguration.getNamespace() != null && !winConfiguration.getNamespace().isBlank()) {
            return PossibleNamespacesResult.builder().possibleNamespaces(Collections.singleton(winConfiguration.getNamespace())).success(true).build();
        }
        TreeSet<String> possibleWmiNamespaces = new TreeSet<String>();
        try {
            this.wmiDetectionService.getWinRequestExecutor().executeWmi(hostname, winConfiguration, NAMESPACE_WQL, ROOT_NAMESPACE).stream().filter(row -> !row.isEmpty()).map(row -> (String)row.get(0)).filter(Objects::nonNull).filter(namespace -> !namespace.isBlank()).filter(namespace -> !namespace.toLowerCase().contains("interop")).filter(namespace -> !IGNORED_WMI_NAMESPACES.contains(namespace)).filter(namespace -> IGNORED_WMI_NAMESPACES.stream().noneMatch(ignoredNamespace -> (ROOT_SLASH + ignoredNamespace).equalsIgnoreCase((String)namespace))).filter(namespace -> IGNORED_WMI_NAMESPACES.stream().noneMatch(ignoredNamespace -> ("root\\" + ignoredNamespace).equalsIgnoreCase((String)namespace))).map(namespace -> ROOT_SLASH + namespace).forEach(possibleWmiNamespaces::add);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = String.format("Hostname %s - Does not respond to WMI requests. %s: %s%nCancelling namespace detection.", hostname, cause != null ? cause.getClass().getSimpleName() : e.getClass().getSimpleName(), cause != null ? cause.getMessage() : e.getMessage());
            log.debug(message);
            return PossibleNamespacesResult.builder().errorMessage(message).success(false).build();
        }
        if (possibleWmiNamespaces.isEmpty()) {
            return PossibleNamespacesResult.builder().errorMessage("No suitable namespace could be found to query host " + hostname + ".").success(false).build();
        }
        return PossibleNamespacesResult.builder().possibleNamespaces(possibleWmiNamespaces).success(true).build();
    }

    @Generated
    public WmiCriterionProcessor(@NonNull WmiDetectionService wmiDetectionService, @NonNull Function<TelemetryManager, IWinConfiguration> configurationRetriever, @NonNull String connectorId) {
        if (wmiDetectionService == null) {
            throw new IllegalArgumentException("wmiDetectionService is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.wmiDetectionService = wmiDetectionService;
        this.configurationRetriever = configurationRetriever;
        this.connectorId = connectorId;
    }

    public static class NamespaceResult {
        private String namespace;
        private CriterionTestResult result;

        @Generated
        NamespaceResult(String namespace, CriterionTestResult result) {
            this.namespace = namespace;
            this.result = result;
        }

        @Generated
        public static NamespaceResultBuilder builder() {
            return new NamespaceResultBuilder();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public CriterionTestResult getResult() {
            return this.result;
        }

        @Generated
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Generated
        public void setResult(CriterionTestResult result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamespaceResult)) {
                return false;
            }
            NamespaceResult other = (NamespaceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            CriterionTestResult this$result = this.getResult();
            CriterionTestResult other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NamespaceResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            CriterionTestResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WmiCriterionProcessor.NamespaceResult(namespace=" + this.getNamespace() + ", result=" + String.valueOf(this.getResult()) + ")";
        }

        @Generated
        public static class NamespaceResultBuilder {
            @Generated
            private String namespace;
            @Generated
            private CriterionTestResult result;

            @Generated
            NamespaceResultBuilder() {
            }

            @Generated
            public NamespaceResultBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public NamespaceResultBuilder result(CriterionTestResult result) {
                this.result = result;
                return this;
            }

            @Generated
            public NamespaceResult build() {
                return new NamespaceResult(this.namespace, this.result);
            }

            @Generated
            public String toString() {
                return "WmiCriterionProcessor.NamespaceResult.NamespaceResultBuilder(namespace=" + this.namespace + ", result=" + String.valueOf(this.result) + ")";
            }
        }
    }

    public static class PossibleNamespacesResult {
        private Set<String> possibleNamespaces;
        private boolean success;
        private String errorMessage;

        @Generated
        PossibleNamespacesResult(Set<String> possibleNamespaces, boolean success, String errorMessage) {
            this.possibleNamespaces = possibleNamespaces;
            this.success = success;
            this.errorMessage = errorMessage;
        }

        @Generated
        public static PossibleNamespacesResultBuilder builder() {
            return new PossibleNamespacesResultBuilder();
        }

        @Generated
        public Set<String> getPossibleNamespaces() {
            return this.possibleNamespaces;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Generated
        public void setPossibleNamespaces(Set<String> possibleNamespaces) {
            this.possibleNamespaces = possibleNamespaces;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PossibleNamespacesResult)) {
                return false;
            }
            PossibleNamespacesResult other = (PossibleNamespacesResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            Set<String> this$possibleNamespaces = this.getPossibleNamespaces();
            Set<String> other$possibleNamespaces = other.getPossibleNamespaces();
            if (this$possibleNamespaces == null ? other$possibleNamespaces != null : !((Object)this$possibleNamespaces).equals(other$possibleNamespaces)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PossibleNamespacesResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            Set<String> $possibleNamespaces = this.getPossibleNamespaces();
            result = result * 59 + ($possibleNamespaces == null ? 43 : ((Object)$possibleNamespaces).hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WmiCriterionProcessor.PossibleNamespacesResult(possibleNamespaces=" + String.valueOf(this.getPossibleNamespaces()) + ", success=" + this.isSuccess() + ", errorMessage=" + this.getErrorMessage() + ")";
        }

        @Generated
        public static class PossibleNamespacesResultBuilder {
            @Generated
            private Set<String> possibleNamespaces;
            @Generated
            private boolean success;
            @Generated
            private String errorMessage;

            @Generated
            PossibleNamespacesResultBuilder() {
            }

            @Generated
            public PossibleNamespacesResultBuilder possibleNamespaces(Set<String> possibleNamespaces) {
                this.possibleNamespaces = possibleNamespaces;
                return this;
            }

            @Generated
            public PossibleNamespacesResultBuilder success(boolean success) {
                this.success = success;
                return this;
            }

            @Generated
            public PossibleNamespacesResultBuilder errorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
                return this;
            }

            @Generated
            public PossibleNamespacesResult build() {
                return new PossibleNamespacesResult(this.possibleNamespaces, this.success, this.errorMessage);
            }

            @Generated
            public String toString() {
                return "WmiCriterionProcessor.PossibleNamespacesResult.PossibleNamespacesResultBuilder(possibleNamespaces=" + String.valueOf(this.possibleNamespaces) + ", success=" + this.success + ", errorMessage=" + this.errorMessage + ")";
            }
        }
    }
}

