/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.detection;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ServiceCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.detection.WmiDetectionService;

public class WinServiceCriterionProcessor {
    @NonNull
    private WmiDetectionService wmiDetectionService;
    @NonNull
    private Function<TelemetryManager, IWinConfiguration> configurationRetriever;

    public CriterionTestResult process(ServiceCriterion serviceCriterion, TelemetryManager telemetryManager) {
        WmiCriterion serviceWmiCriterion;
        if (serviceCriterion == null) {
            return CriterionTestResult.error((Criterion)serviceCriterion, (String)"Malformed Service criterion.");
        }
        IWinConfiguration winConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (winConfiguration == null) {
            return CriterionTestResult.error((Criterion)serviceCriterion, (String)"Neither WMI nor WinRM credentials are configured for this host.");
        }
        if (!DeviceKind.WINDOWS.equals((Object)telemetryManager.getHostConfiguration().getHostType())) {
            return CriterionTestResult.error((Criterion)serviceCriterion, (String)"Host OS is not Windows. Skipping this test.");
        }
        if (!LocalOsHandler.isWindows()) {
            return CriterionTestResult.error((Criterion)serviceCriterion, (String)"Local OS is not Windows. Skipping this test.");
        }
        String serviceName = serviceCriterion.getName();
        if (serviceName.isBlank()) {
            return CriterionTestResult.success((Criterion)serviceCriterion, (String)"Service name is not specified. Skipping this test.");
        }
        String hostname = telemetryManager.getHostname(List.of(winConfiguration.getClass()));
        CriterionTestResult wmiTestResult = this.wmiDetectionService.performDetectionTest(hostname, winConfiguration, serviceWmiCriterion = WmiCriterion.builder().query(String.format("SELECT Name, State FROM Win32_Service WHERE Name = '%s'", serviceName)).namespace("root\\cimv2").build());
        if (!wmiTestResult.isSuccess()) {
            return wmiTestResult;
        }
        String result = wmiTestResult.getResult();
        if (result != null && result.toLowerCase().contains(";running")) {
            return CriterionTestResult.success((Criterion)serviceCriterion, (String)String.format("The %s Windows Service is currently running.", serviceName));
        }
        return CriterionTestResult.failure((Criterion)serviceWmiCriterion, (String)String.format("The %s Windows Service is not reported as running:\n%s", serviceName, result));
    }

    @Generated
    public WinServiceCriterionProcessor(@NonNull WmiDetectionService wmiDetectionService, @NonNull Function<TelemetryManager, IWinConfiguration> configurationRetriever) {
        if (wmiDetectionService == null) {
            throw new IllegalArgumentException("wmiDetectionService is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        this.wmiDetectionService = wmiDetectionService;
        this.configurationRetriever = configurationRetriever;
    }
}

