/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.detection;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.IpmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.detection.WmiDetectionService;

public class WinIpmiCriterionProcessor {
    @NonNull
    private WmiDetectionService wmiDetectionService;
    @NonNull
    private Function<TelemetryManager, IWinConfiguration> configurationRetriever;

    public CriterionTestResult process(IpmiCriterion ipmiCriterion, TelemetryManager telemetryManager) {
        IWinConfiguration winConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (winConfiguration == null) {
            return CriterionTestResult.error((Criterion)ipmiCriterion, (String)"Neither WMI nor WinRM credentials are configured for this host.");
        }
        WmiCriterion ipmiWmiCriterion = WmiCriterion.builder().query("SELECT Description FROM ComputerSystem").namespace("root\\hardware").build();
        return this.wmiDetectionService.performDetectionTest(telemetryManager.getHostname(List.of(winConfiguration.getClass())), winConfiguration, ipmiWmiCriterion);
    }

    @Generated
    public WinIpmiCriterionProcessor(@NonNull WmiDetectionService wmiDetectionService, @NonNull Function<TelemetryManager, IWinConfiguration> configurationRetriever) {
        if (wmiDetectionService == null) {
            throw new IllegalArgumentException("wmiDetectionService is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        this.wmiDetectionService = wmiDetectionService;
        this.configurationRetriever = configurationRetriever;
    }
}

