/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.exception.NoCredentialProvidedException;
import org.sentrysoftware.metricshub.engine.common.helpers.MacrosUpdater;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.strategy.utils.EmbeddedFileHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.IWinRequestExecutor;

public class WinCommandService {
    @NonNull
    private IWinRequestExecutor winRequestExecutor;

    public Optional<String> getUsername(IWinConfiguration configuration) {
        if (configuration == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(configuration.getUsername());
    }

    public Optional<char[]> getPassword(IWinConfiguration configuration) {
        if (configuration == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(configuration.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsCommandResult runOsCommand(@NonNull String commandLine, @NonNull String hostname, IWinConfiguration configuration, @NonNull Map<Integer, EmbeddedFile> connectorEmbeddedFiles) throws IOException, ClientException, NoCredentialProvidedException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (connectorEmbeddedFiles == null) {
            throw new IllegalArgumentException("connectorEmbeddedFiles is marked non-null but is null");
        }
        Optional<String> maybeUsername = this.getUsername(configuration);
        if (maybeUsername.isEmpty() || maybeUsername.get().isBlank()) {
            throw new NoCredentialProvidedException();
        }
        Optional<char[]> maybePassword = this.getPassword(configuration);
        Map embeddedTempFiles = OsCommandHelper.createOsCommandEmbeddedFiles((String)commandLine, null, (Map)EmbeddedFileHelper.findEmbeddedFiles((String)commandLine, connectorEmbeddedFiles), (BiFunction)OsCommandHelper.TEMP_FILE_CREATOR);
        String updatedCommand = MacrosUpdater.update((String)commandLine, (String)maybeUsername.orElse(null), (char[])maybePassword.orElse(null), null, (String)hostname, (boolean)false);
        String updatedCommandNoPassword = MacrosUpdater.update((String)commandLine, (String)maybeUsername.orElse(null), (char[])maybePassword.orElse(null), null, (String)hostname, (boolean)true);
        String updatedSudoCommand = OsCommandHelper.replaceSudo((String)updatedCommand, null);
        String updatedSudoCommandNoPassword = OsCommandHelper.replaceSudo((String)updatedCommandNoPassword, null);
        String command = embeddedTempFiles.entrySet().stream().reduce(updatedSudoCommand, (s, entry) -> s.replaceAll(StringHelper.protectCaseInsensitiveRegex((String)((String)entry.getKey())), Matcher.quoteReplacement(((File)entry.getValue()).getAbsolutePath())), (s1, s2) -> null);
        String commandNoPassword = embeddedTempFiles.entrySet().stream().reduce(updatedSudoCommandNoPassword, (s, entry) -> s.replaceAll(StringHelper.protectCaseInsensitiveRegex((String)((String)entry.getKey())), Matcher.quoteReplacement(((File)entry.getValue()).getAbsolutePath())), (s1, s2) -> null);
        try {
            String commandResult = this.winRequestExecutor.executeWinRemoteCommand(hostname, configuration, command, embeddedTempFiles.values().stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            OsCommandResult osCommandResult = new OsCommandResult(commandResult, commandNoPassword);
            return osCommandResult;
        }
        finally {
            embeddedTempFiles.values().forEach(File::delete);
        }
    }

    @Generated
    public WinCommandService(@NonNull IWinRequestExecutor winRequestExecutor) {
        if (winRequestExecutor == null) {
            throw new IllegalArgumentException("winRequestExecutor is marked non-null but is null");
        }
        this.winRequestExecutor = winRequestExecutor;
    }
}

