/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.shares;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.LMShare;
import com.sun.jna.platform.win32.Netapi32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.sentrysoftware.wmi.Utils;
import org.sentrysoftware.wmi.WmiHelper;
import org.sentrysoftware.wmi.exceptions.WindowsRemoteException;
import org.sentrysoftware.wmi.exceptions.WmiComException;
import org.sentrysoftware.wmi.shares.WindowsScriptHostNetworkInterface;
import org.sentrysoftware.wmi.wbem.WmiWbemServices;
import org.sentrysoftware.wmi.windows.remote.WindowsRemoteExecutor;
import org.sentrysoftware.wmi.windows.remote.share.WindowsTempShare;

public class WinTempShare
extends WindowsTempShare
implements AutoCloseable {
    private static final int CONNECTION_MAX = 10;
    private static final String SHARE_DESCRIPTION = "Share created by Sentry Software to store results of commands";
    private static final int SUCCESS = 0;
    private static final int ALREADY_EXIST = 2118;
    private static final Factory FACTORY = new Factory();
    private static final WindowsScriptHostNetworkInterface WSH = FACTORY.createObject(WindowsScriptHostNetworkInterface.class);
    private static final ConcurrentHashMap<String, WinTempShare> CONNECTIONS_CACHE = new ConcurrentHashMap();
    private final String hostname;
    private final AtomicInteger useCount = new AtomicInteger(1);

    WinTempShare(WmiWbemServices wmiWbemServices, String shareNameOrUnc, String remotePath) {
        super(wmiWbemServices, shareNameOrUnc, remotePath);
        this.hostname = wmiWbemServices.getHostname();
    }

    public static WinTempShare getInstance(String hostname, String username, char[] password, long timeout) throws TimeoutException, WmiComException {
        Utils.checkNonNull(hostname, "hostname");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        try {
            return CONNECTIONS_CACHE.compute(hostname.toLowerCase(), (h, winTempShare) -> {
                if (winTempShare == null) {
                    WmiWbemServices wmiWbemServices = null;
                    try {
                        String networkResource = WmiHelper.createNetworkResource(hostname, "ROOT\\CIMV2");
                        wmiWbemServices = WmiWbemServices.getInstance(networkResource, username, password);
                        WindowsTempShare share = WinTempShare.getOrCreateShare(wmiWbemServices, timeout, (w, r, s, t) -> {
                            try {
                                WinTempShare.shareRemoteDirectory(w, r, s, t);
                            }
                            catch (WindowsRemoteException e) {
                                throw new RuntimeException(e);
                            }
                        });
                        WinTempShare.getWindowsScriptHostNetwork().mapNetworkDrive("", share.getUncSharePath(), false, username, password == null ? null : String.valueOf(password));
                        return new WinTempShare((WmiWbemServices)share.getWindowsRemoteExecutor(), share.getUncSharePath(), share.getRemotePath());
                    }
                    catch (RuntimeException e) {
                        if (wmiWbemServices != null) {
                            wmiWbemServices.close();
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (wmiWbemServices != null) {
                            wmiWbemServices.close();
                        }
                        throw new RuntimeException(e);
                    }
                }
                WinTempShare winTempShare2 = winTempShare;
                synchronized (winTempShare2) {
                    winTempShare.incrementUseCount();
                    return winTempShare;
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof TimeoutException) {
                    throw (TimeoutException)cause;
                }
                if (cause instanceof WmiComException) {
                    throw (WmiComException)cause;
                }
                if (cause instanceof InterruptedException) {
                    throw new TimeoutException(cause.getClass().getSimpleName() + ": " + cause.getMessage());
                }
            }
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        if (this.useCount.decrementAndGet() == 0) {
            CONNECTIONS_CACHE.remove(this.hostname.toLowerCase());
            ((WmiWbemServices)this.getWindowsRemoteExecutor()).close();
            WinTempShare.getWindowsScriptHostNetwork().removeNetworkDrive(this.getUncSharePath(), true, false);
        }
    }

    public boolean isConnected() {
        return this.useCount.get() > 0;
    }

    public void checkConnectedFirst() {
        if (!this.isConnected()) {
            throw new IllegalStateException("This instance has been closed and a new one must be created.");
        }
    }

    private static void shareRemoteDirectory(WindowsRemoteExecutor wmiWbemServices, String remotePath, String shareName, long timeout) throws WmiComException {
        WinNT.SECURITY_DESCRIPTOR securityDescriptor = WinTempShare.initializeSecurityDescriptor();
        LMShare.SHARE_INFO_502 shareInfo502 = new LMShare.SHARE_INFO_502();
        shareInfo502.shi502_netname = shareName;
        shareInfo502.shi502_type = 0;
        shareInfo502.shi502_remark = SHARE_DESCRIPTION;
        shareInfo502.shi502_permissions = 127;
        shareInfo502.shi502_max_uses = 10;
        shareInfo502.shi502_current_uses = 0;
        shareInfo502.shi502_path = remotePath;
        shareInfo502.shi502_passwd = null;
        shareInfo502.shi502_reserved = 0;
        shareInfo502.shi502_security_descriptor = securityDescriptor.getPointer();
        shareInfo502.write();
        IntByReference parmErr = new IntByReference(0);
        int result = Netapi32.INSTANCE.NetShareAdd(wmiWbemServices.getHostname(), 502, shareInfo502.getPointer(), parmErr);
        if (result != 0 && result != 2118) {
            Win32Exception e = new Win32Exception(result);
            throw new WmiComException(e, e.getMessage());
        }
    }

    private static WinNT.SECURITY_DESCRIPTOR initializeSecurityDescriptor() throws WmiComException {
        WinNT.PSID pSidSystem = WinTempShare.createSID(22);
        WinNT.PSID pSidAdministrator = WinTempShare.createSID(26);
        int sidSysLength = Advapi32.INSTANCE.GetLengthSid(pSidSystem);
        int sidAdminLength = Advapi32.INSTANCE.GetLengthSid(pSidAdministrator);
        int cbAcl = Native.getNativeSize(WinNT.ACL.class, null);
        cbAcl += Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null);
        cbAcl += sidSysLength - 4;
        cbAcl += Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null);
        cbAcl += sidAdminLength - 4;
        cbAcl = Advapi32Util.alignOnDWORD(cbAcl);
        WinNT.ACL pAcl = new WinNT.ACL(cbAcl);
        WinTempShare.checkWin32Result(Advapi32.INSTANCE.InitializeAcl(pAcl, cbAcl, 2));
        WinTempShare.checkWin32Result(Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, 0x10000000, pSidSystem));
        WinTempShare.checkWin32Result(Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, 0x10000000, pSidAdministrator));
        WinNT.SECURITY_DESCRIPTOR securityDescriptor = new WinNT.SECURITY_DESCRIPTOR(65536);
        WinTempShare.checkWin32Result(Advapi32.INSTANCE.InitializeSecurityDescriptor(securityDescriptor, 1));
        WinTempShare.checkWin32Result(Advapi32.INSTANCE.SetSecurityDescriptorDacl(securityDescriptor, true, pAcl, false));
        return securityDescriptor;
    }

    private static WinNT.PSID createSID(int wellKnownSidTypeAlias) throws WmiComException {
        WinNT.PSID pSid = new WinNT.PSID(68);
        IntByReference cbSid = new IntByReference(68);
        WinTempShare.checkWin32Result(Advapi32.INSTANCE.CreateWellKnownSid(wellKnownSidTypeAlias, null, pSid, cbSid));
        return pSid;
    }

    private static void checkWin32Result(boolean result) throws WmiComException {
        if (!result) {
            Win32Exception e = new Win32Exception(Kernel32.INSTANCE.GetLastError());
            throw new WmiComException(e, e.getMessage());
        }
    }

    int getUseCount() {
        return this.useCount.get();
    }

    void incrementUseCount() {
        this.useCount.incrementAndGet();
    }

    static WindowsScriptHostNetworkInterface getWindowsScriptHostNetwork() {
        return WSH;
    }
}

