/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.remotecommand;

import com.sun.jna.platform.win32.COM.COMException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.sentrysoftware.wmi.TimeoutHelper;
import org.sentrysoftware.wmi.Utils;
import org.sentrysoftware.wmi.exceptions.WindowsRemoteException;
import org.sentrysoftware.wmi.exceptions.WmiComException;
import org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wmi.remotecommand.RemoteProcess;
import org.sentrysoftware.wmi.shares.WinTempShare;
import org.sentrysoftware.wmi.windows.remote.WindowsRemoteProcessUtils;

public class WinRemoteCommandExecutor {
    private static final String OUT_EXT = ".out";
    private static final String ERR_EXT = ".err";
    private final float executionTime;
    private final String stdout;
    private final String stderr;
    private final int statusCode;

    private WinRemoteCommandExecutor(String stdout, String stderr, float executionTime, int statusCode) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.executionTime = executionTime;
        this.statusCode = statusCode;
    }

    public float getExecutionTime() {
        return this.executionTime;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static WinRemoteCommandExecutor execute(String command, String hostname, String username, char[] password, String workingDirectory, long timeout, List<String> localFileToCopyList, boolean mergeStdoutStderr) throws IOException, TimeoutException, WqlQuerySyntaxException, WindowsRemoteException {
        Utils.checkNonNull(command, "command");
        Utils.checkNonNull(hostname, "hostname");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        long start = Utils.getCurrentTimeMillis();
        WinTempShare tempShare = WinTempShare.getInstance(hostname, username, password, TimeoutHelper.getRemainingTime(timeout, start, "No time left to access the temporary share"));
        try {
            String errContent;
            tempShare.checkConnectedFirst();
            String localFilesUpdatedCommand = WindowsRemoteProcessUtils.copyLocalFilesToShare(command, localFileToCopyList, tempShare.getUncSharePath(), tempShare.getRemotePath());
            String outputFileBaseName = WindowsRemoteProcessUtils.buildNewOutputFileName();
            Path outputFilePath = Paths.get(tempShare.getUncSharePath(), outputFileBaseName + OUT_EXT);
            Path outputFilePathRemote = Paths.get(tempShare.getRemotePath(), outputFileBaseName + OUT_EXT);
            Path errFilePath = Paths.get(tempShare.getUncSharePath(), outputFileBaseName + ERR_EXT);
            Path errFilePathRemote = Paths.get(tempShare.getRemotePath(), outputFileBaseName + ERR_EXT);
            String redirectedCommand = String.format("CMD.EXE /C (%s) > \"%s\" 2>\"%s\"", localFilesUpdatedCommand, outputFilePathRemote.toString(), mergeStdoutStderr ? "&1" : errFilePathRemote.toString());
            long startCommand = Utils.getCurrentTimeMillis();
            int statusCode = RemoteProcess.executeCommand(redirectedCommand, hostname, username, password, workingDirectory, TimeoutHelper.getRemainingTime(timeout, start, "No time left to execute command"));
            float executionTime = (float)(Utils.getCurrentTimeMillis() - startCommand) / 1000.0f;
            while (!Files.exists(outputFilePath, new LinkOption[0])) {
                TimeoutHelper.stagedSleep(timeout, start, "Output files were not created");
            }
            Charset charset = WindowsRemoteProcessUtils.getWindowsEncodingCharset(tempShare.getWindowsRemoteExecutor(), TimeoutHelper.getRemainingTime(timeout, start, "No time left to retrieve the code set"));
            String outContent = Utils.readText(outputFilePath, charset);
            Files.deleteIfExists(outputFilePath);
            if (mergeStdoutStderr) {
                errContent = "";
            } else {
                errContent = Utils.readText(errFilePath, charset);
                Files.deleteIfExists(errFilePath);
            }
            WinRemoteCommandExecutor winRemoteCommandExecutor = new WinRemoteCommandExecutor(outContent, errContent, executionTime, statusCode);
            if (tempShare != null) {
                tempShare.close();
            }
            return winRemoteCommandExecutor;
        }
        catch (Throwable throwable) {
            try {
                if (tempShare != null) {
                    try {
                        tempShare.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (COMException e) {
                throw new WmiComException(e, e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }
}

