/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.detection;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.NoCredentialProvidedException;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.CommandLineCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.WinCommandService;

public class WinCommandLineCriterionProcessor {
    @NonNull
    private WinCommandService winCommandService;
    @NonNull
    private Function<TelemetryManager, IWinConfiguration> configurationRetriever;
    @NonNull
    private String connectorId;

    public CriterionTestResult process(CommandLineCriterion commandLineCriterion, TelemetryManager telemetryManager) {
        if (commandLineCriterion == null) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (String)"Malformed CommandLine criterion.");
        }
        if (commandLineCriterion.getCommandLine().isEmpty() || commandLineCriterion.getExpectedResult() == null || commandLineCriterion.getExpectedResult().isEmpty()) {
            return CriterionTestResult.success((Criterion)commandLineCriterion, (String)"CommandLine or ExpectedResult are empty. Skipping this test.");
        }
        if (Boolean.TRUE.equals(commandLineCriterion.getExecuteLocally())) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (String)"The CommandLine criterion cannot be executed locally through WMI. Skipping this test.");
        }
        boolean isLocalhost = telemetryManager.getHostProperties().isLocalhost();
        DeviceKind hostType = telemetryManager.getHostConfiguration().getHostType();
        if (isLocalhost || hostType != DeviceKind.WINDOWS) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (String)String.format("Cannot process CommandLine criterion for %s host of type %s.", isLocalhost ? "local" : "remote", hostType));
        }
        try {
            OsCommandResult osCommandResult = this.winCommandService.runOsCommand(commandLineCriterion.getCommandLine(), telemetryManager.getHostname(), this.configurationRetriever.apply(telemetryManager), telemetryManager.getEmbeddedFiles(this.connectorId));
            CommandLineCriterion osCommandNoPassword = CommandLineCriterion.builder().commandLine(osCommandResult.getNoPasswordCommand()).executeLocally(commandLineCriterion.getExecuteLocally()).timeout(commandLineCriterion.getTimeout()).expectedResult(commandLineCriterion.getExpectedResult()).build();
            Matcher matcher = Pattern.compile(PslUtils.psl2JavaRegex((String)commandLineCriterion.getExpectedResult()), 10).matcher(osCommandResult.getResult());
            return matcher.find() ? CriterionTestResult.success((Criterion)osCommandNoPassword, (String)osCommandResult.getResult()) : CriterionTestResult.failure((Criterion)osCommandNoPassword, (String)osCommandResult.getResult());
        }
        catch (NoCredentialProvidedException noCredentialProvidedException) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (String)noCredentialProvidedException.getMessage());
        }
        catch (Exception exception) {
            return CriterionTestResult.error((Criterion)commandLineCriterion, (Throwable)exception);
        }
    }

    @Generated
    public WinCommandLineCriterionProcessor(@NonNull WinCommandService winCommandService, @NonNull Function<TelemetryManager, IWinConfiguration> configurationRetriever, @NonNull String connectorId) {
        if (winCommandService == null) {
            throw new IllegalArgumentException("winCommandService is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.winCommandService = winCommandService;
        this.configurationRetriever = configurationRetriever;
        this.connectorId = connectorId;
    }
}

