/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteArrayUtils {
    private static final int WIDTH = 32;

    private ByteArrayUtils() {
    }

    public static String formatHexDump(byte[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        for (int rowOffset = 0; rowOffset < array.length; rowOffset += 32) {
            int index;
            builder.append(String.format("%06d: ", rowOffset));
            for (index = 0; index < 32; ++index) {
                if (rowOffset + index < array.length) {
                    builder.append(String.format("%02x", array[rowOffset + index]));
                } else {
                    builder.append("  ");
                }
                if (index % 4 != 3) continue;
                builder.append(" ");
            }
            if (rowOffset < array.length) {
                builder.append(" | ");
                for (index = 0; index < 32; ++index) {
                    if (rowOffset + index >= array.length) continue;
                    byte c = array[rowOffset + index];
                    builder.append(c >= 20 && c < 127 ? (char)c : (char)'.');
                    if (index % 8 != 7) continue;
                    builder.append(" ");
                }
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static byte[] getLittleEndianUnsignedInt(long x) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt((int)(x & 0xFFFFFFFFFFFFFFFFL));
        return byteBuffer.array();
    }

    public static long readLittleEndianUnsignedInt(byte[] input, int offset) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(input);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return Integer.toUnsignedLong(byteBuffer.getInt(offset));
    }

    public static byte[] concat(byte[] ... sequences) {
        byte[] throwable;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (byte[] s : sequences) {
                out.write(s);
            }
            throwable = out.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return throwable;
    }
}

