/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import java.util.Arrays;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTCredentialsWithEncryption;
import org.sentrysoftware.winrm.service.client.auth.ntlm.Type3Message;
import org.sentrysoftware.winrm.service.client.encryption.ByteArrayUtils;
import org.sentrysoftware.winrm.service.client.encryption.EncryptionUtils;

public class NtlmKeys {
    private static final byte[] CLIENT_SIGNING = "session key to client-to-server signing key magic constant\u0000".getBytes();
    private static final byte[] SERVER_SIGNING = "session key to server-to-client signing key magic constant\u0000".getBytes();
    private static final byte[] CLIENT_SEALING = "session key to client-to-server sealing key magic constant\u0000".getBytes();
    private static final byte[] SERVER_SEALING = "session key to server-to-client sealing key magic constant\u0000".getBytes();
    private final byte[] exportedSessionKey;
    private final long negotiateFlags;

    public NtlmKeys(Type3Message signAndSealData) {
        this.exportedSessionKey = signAndSealData.getExportedSessionKey();
        this.negotiateFlags = signAndSealData.getType2Flags();
    }

    public void apply(NTCredentialsWithEncryption credentials) {
        credentials.setNegotiateFlags(this.negotiateFlags);
        credentials.setClientSigningKey(this.getSignKey(CLIENT_SIGNING));
        credentials.setServerSigningKey(this.getSignKey(SERVER_SIGNING));
        credentials.setClientSealingKey(this.getSealKey(CLIENT_SEALING));
        credentials.setServerSealingKey(this.getSealKey(SERVER_SEALING));
    }

    private byte[] getSignKey(byte[] magicConstant) {
        return EncryptionUtils.md5digest(ByteArrayUtils.concat(this.exportedSessionKey, magicConstant));
    }

    private byte[] getSealKey(byte[] magicConstant) {
        if (this.hasNegotiateFlag(524288L)) {
            if (this.hasNegotiateFlag(0x20000000L)) {
                return EncryptionUtils.md5digest(ByteArrayUtils.concat(this.exportedSessionKey, magicConstant));
            }
            if (this.hasNegotiateFlag(0x80000000L)) {
                return EncryptionUtils.md5digest(ByteArrayUtils.concat(Arrays.copyOfRange(this.exportedSessionKey, 0, 7), magicConstant));
            }
            return EncryptionUtils.md5digest(ByteArrayUtils.concat(Arrays.copyOfRange(this.exportedSessionKey, 0, 5), magicConstant));
        }
        if (this.hasNegotiateFlag(128L)) {
            throw new UnsupportedOperationException("LM KEY negotiate mode not implemented; use extended session security instead");
        }
        return this.exportedSessionKey;
    }

    private boolean hasNegotiateFlag(long flag) {
        return (this.negotiateFlags & flag) == flag;
    }
}

