/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.kerberos;

import java.nio.file.Path;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.http.auth.KerberosCredentials;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.exceptions.KerberosCredentialsException;
import org.sentrysoftware.winrm.service.client.auth.UsernamePasswordCallbackHandler;

public class KerberosUtils {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String DO_NOT_PROMPT = "doNotPrompt";
    private static final String USE_TICKET_CACHE = "useTicketCache";
    private static final String IS_INITIATOR = "isInitiator";
    private static final String CLIENT = "client";
    private static final String REFRESH_KRB5_CONFIG = "refreshKrb5Config";
    private static final String KERBEROS_V5_OID = "1.2.840.113554.1.2.2";
    private static final Configuration JAAS_CONFIG;

    private KerberosUtils() {
    }

    private static AppConfigurationEntry[] createAppConfigurationEntries(Map<String, String> moduleOptions) {
        return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, moduleOptions)};
    }

    public static KerberosCredentials createCredentials(String username, char[] password, Path ticketCache) {
        Utils.checkNonNull(username, "username");
        Utils.checkNonNull(password, "password");
        try {
            String canonizedUsername = username.trim().toUpperCase();
            Configuration configuration = ticketCache != null ? KerberosUtils.createConfigurationWithTicketCache(ticketCache) : JAAS_CONFIG;
            Subject subject = KerberosUtils.authenticate(canonizedUsername, password, configuration);
            PrivilegedAction<GSSCredential> privilegedAction = KerberosUtils.createPrivilegedAction(canonizedUsername);
            GSSCredential gssUserCredential = Subject.doAs(subject, privilegedAction);
            return new KerberosCredentials(gssUserCredential);
        }
        catch (KerberosCredentialsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KerberosCredentialsException(e);
        }
    }

    public static Configuration createConfigurationWithTicketCache(Path ticketCache) {
        final HashMap<String, String> moduleOptions = new HashMap<String, String>();
        moduleOptions.put(REFRESH_KRB5_CONFIG, TRUE);
        moduleOptions.put(CLIENT, TRUE);
        moduleOptions.put(IS_INITIATOR, TRUE);
        moduleOptions.put(USE_TICKET_CACHE, TRUE);
        moduleOptions.put(DO_NOT_PROMPT, TRUE);
        moduleOptions.put("ticketCache", ticketCache.toString());
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return KerberosUtils.createAppConfigurationEntries(moduleOptions);
            }
        };
    }

    public static Subject authenticate(String username, char[] password, Configuration configuration) {
        try {
            UsernamePasswordCallbackHandler callbackHandler = new UsernamePasswordCallbackHandler(username, password);
            LoginContext loginContext = KerberosUtils.createLoginContext(callbackHandler, configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new KerberosCredentialsException("Kerberos Login failure. Make sure Kerberos is properly configured.", e);
        }
    }

    private static PrivilegedAction<GSSCredential> createPrivilegedAction(String username) {
        return () -> {
            try {
                GSSManager gssManager = GSSManager.getInstance();
                GSSName gssUserName = gssManager.createName(username, null);
                return gssManager.createCredential(gssUserName, 0, new Oid(KERBEROS_V5_OID), 1);
            }
            catch (GSSException e) {
                throw new KerberosCredentialsException(String.format("Unable to create credential for user \"%s\" after login", username), e);
            }
        };
    }

    public static LoginContext createLoginContext(CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        return new LoginContext("", null, callbackHandler, configuration);
    }

    static {
        final HashMap<String, String> moduleOptions = new HashMap<String, String>();
        moduleOptions.put(REFRESH_KRB5_CONFIG, TRUE);
        moduleOptions.put(CLIENT, TRUE);
        moduleOptions.put(IS_INITIATOR, TRUE);
        moduleOptions.put(USE_TICKET_CACHE, FALSE);
        moduleOptions.put(DO_NOT_PROMPT, FALSE);
        JAAS_CONFIG = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return KerberosUtils.createAppConfigurationEntries(moduleOptions);
            }
        };
    }
}

