/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.service.wsman.AttributableURI;
import org.sentrysoftware.winrm.service.wsman.ObjectFactory;

public class WSManHeaderInterceptor
extends AbstractSoapInterceptor {
    private static final JAXBDataBinding ATTRIBUTABLE_URI_JAXB_DATA_BINDING;
    private final String resourceUri;

    public WSManHeaderInterceptor(String resourceUri) {
        super("post-logical");
        this.addAfter(SoapPreProtocolOutInterceptor.class.getName());
        Utils.checkNonNull(resourceUri, "resourceUri");
        this.resourceUri = resourceUri;
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        JAXBElement<String> resourceURI = new ObjectFactory().createResourceURI(this.resourceUri);
        List<Header> headers = message.getHeaders();
        headers.add(new Header(resourceURI.getName(), resourceURI, ATTRIBUTABLE_URI_JAXB_DATA_BINDING));
        message.put(Header.HEADER_LIST, (Object)headers);
    }

    static {
        try {
            ATTRIBUTABLE_URI_JAXB_DATA_BINDING = new JAXBDataBinding(AttributableURI.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to create JAXBDataBinding for: AttributableURI" + AttributableURI.class, e);
        }
    }
}

