/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.WinRMHttpProtocolEnum;

public class WinRMEndpoint {
    private static final int DEFAULT_WIN_RM_HTTP_PORT = 5985;
    private static final int DEFAULT_WIN_RM_HTTPS_PORT = 5986;
    private final String hostname;
    private final String endpoint;
    private final String domain;
    private final String username;
    private final char[] password;
    private final String namespace;
    private final String rawUsername;
    private final WinRMHttpProtocolEnum protocol;

    public WinRMEndpoint(WinRMHttpProtocolEnum protocol, String hostname, Integer port, String username, char[] password, String namespace) {
        Utils.checkNonNull(hostname, "hostname");
        Utils.checkNonNull(username, "username");
        Utils.checkNonNull(password, "password");
        this.hostname = hostname.replaceAll("\\s", "");
        this.password = password;
        this.rawUsername = username;
        this.namespace = WinRMEndpoint.buildNamespace(namespace);
        String user = username.replaceAll("\\s", "");
        if (user.contains("\\")) {
            String[] array = user.split("\\\\");
            this.domain = array[0];
            this.username = array[1];
        } else {
            this.domain = null;
            this.username = user;
        }
        this.protocol = protocol != null ? protocol : WinRMHttpProtocolEnum.HTTP;
        String endpointUrl = WinRMEndpoint.buildEndpointUrl(this.protocol, this.hostname, port);
        this.endpoint = WinRMEndpoint.buildWSManEndpoint(endpointUrl);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRawUsername() {
        return this.rawUsername;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public WinRMHttpProtocolEnum getProtocol() {
        return this.protocol;
    }

    public static String buildEndpointUrl(WinRMHttpProtocolEnum protocol, String hostname, Integer port) {
        int endpointPort = WinRMEndpoint.getEndpointPort(protocol, port);
        return String.format("%s://%s:%d", protocol.toString(), hostname, endpointPort);
    }

    public static int getEndpointPort(WinRMHttpProtocolEnum protocol, Integer port) {
        if (port != null) {
            return port;
        }
        return protocol == WinRMHttpProtocolEnum.HTTPS ? 5986 : 5985;
    }

    public static String buildNamespace(String namespace) {
        String cleanNamespace = namespace != null ? namespace.replaceAll("\\s", "") : "";
        String usedNamespace = Utils.isNotBlank(cleanNamespace) ? cleanNamespace : "ROOT\\CIMV2";
        return usedNamespace.replace('\\', '/');
    }

    private static String buildWSManEndpoint(String endpoint) {
        try {
            return new URL(String.format("%s/wsman", endpoint)).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("endpoint %s is invalid.", endpoint), e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.password);
        result = 31 * result + Objects.hash(this.endpoint, this.namespace, this.rawUsername);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WinRMEndpoint)) {
            return false;
        }
        WinRMEndpoint other = (WinRMEndpoint)obj;
        return Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.namespace, other.namespace) && Arrays.equals(this.password, other.password) && Objects.equals(this.rawUsername, other.rawUsername);
    }

    public String toString() {
        return "WinRMEndpoint [" + "endpoint=" + this.endpoint + ", domain=" + this.domain + ", username=" + this.username + ", namespace=" + this.namespace + "]";
    }
}

