/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.command;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.sentrysoftware.winrm.TimeoutHelper;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.WinRMHttpProtocolEnum;
import org.sentrysoftware.winrm.WindowsRemoteCommandResult;
import org.sentrysoftware.winrm.WindowsRemoteProcessUtils;
import org.sentrysoftware.winrm.exceptions.WindowsRemoteException;
import org.sentrysoftware.winrm.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.winrm.service.WinRMEndpoint;
import org.sentrysoftware.winrm.service.WinRMService;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;
import org.sentrysoftware.winrm.shares.SmbTempShare;

public class WinRMCommandExecutor {
    private WinRMCommandExecutor() {
    }

    public static WindowsRemoteCommandResult execute(String command, WinRMHttpProtocolEnum protocol, String hostname, Integer port, String username, char[] password, String workingDirectory, long timeout, List<String> localFileToCopyList, Path ticketCache, List<AuthenticationEnum> authentications) throws IOException, TimeoutException, WindowsRemoteException {
        WindowsRemoteCommandResult windowsRemoteCommandResult;
        block18: {
            Utils.checkNonNull(command, "command");
            Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
            long start = System.currentTimeMillis();
            WinRMEndpoint winRMEndpoint = new WinRMEndpoint(protocol, hostname, port, username, password, null);
            if (localFileToCopyList == null || localFileToCopyList.isEmpty()) {
                WinRMService winRMService = WinRMService.createInstance(winRMEndpoint, timeout, ticketCache, authentications);
                try {
                    Charset charset = WindowsRemoteProcessUtils.getWindowsEncodingCharset(winRMService, TimeoutHelper.getRemainingTime(timeout, start, "No time left to retrieve the code set"));
                    WindowsRemoteCommandResult windowsRemoteCommandResult2 = winRMService.executeCommand(command, workingDirectory, charset, timeout);
                    if (winRMService != null) {
                        winRMService.close();
                    }
                    return windowsRemoteCommandResult2;
                }
                catch (Throwable charset) {
                    try {
                        if (winRMService != null) {
                            try {
                                winRMService.close();
                            }
                            catch (Throwable throwable) {
                                charset.addSuppressed(throwable);
                            }
                        }
                        throw charset;
                    }
                    catch (WqlQuerySyntaxException e) {
                        throw new IOException(e);
                    }
                }
            }
            SmbTempShare smbTempShare = SmbTempShare.createInstance(winRMEndpoint, timeout, ticketCache, authentications);
            try {
                smbTempShare.checkConnectedFirst();
                List<String> localFiles = localFileToCopyList.stream().filter(Utils::isNotBlank).collect(Collectors.toList());
                String localFilesUpdatedCommand = WindowsRemoteProcessUtils.copyLocalFilesToShare(command, localFiles, smbTempShare.getUncSharePath(), smbTempShare.getRemotePath());
                Charset charset = WindowsRemoteProcessUtils.getWindowsEncodingCharset(smbTempShare.getWindowsRemoteExecutor(), TimeoutHelper.getRemainingTime(timeout, start, "No time left to retrieve the code set"));
                windowsRemoteCommandResult = smbTempShare.getWindowsRemoteExecutor().executeCommand(String.format("CMD.EXE /C (%s)", localFilesUpdatedCommand), null, charset, TimeoutHelper.getRemainingTime(timeout, start, "No time left to execute command"));
                if (smbTempShare == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (smbTempShare != null) {
                        try {
                            smbTempShare.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WqlQuerySyntaxException e) {
                    throw new IOException(e);
                }
            }
            smbTempShare.close();
        }
        return windowsRemoteCommandResult;
    }
}

