/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.source;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.FilterResultHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.WinCommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinCommandLineSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WinCommandLineSourceProcessor.class);
    @NonNull
    private WinCommandService winCommandService;
    @NonNull
    private Function<TelemetryManager, IWinConfiguration> configurationRetriever;
    @NonNull
    private String connectorId;

    public SourceTable process(CommandLineSource commandLineSource, TelemetryManager telemetryManager) {
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        if (commandLineSource == null || commandLineSource.getCommandLine().isEmpty()) {
            log.error("Hostname {} - Malformed OS command source.", (Object)hostname);
            return SourceTable.empty();
        }
        try {
            OsCommandResult osCommandResult = this.winCommandService.runOsCommand(commandLineSource.getCommandLine(), hostname, this.configurationRetriever.apply(telemetryManager), telemetryManager.getEmbeddedFiles(this.connectorId));
            List resultLines = SourceTable.lineToList((String)osCommandResult.getResult(), (String)"\n");
            List filteredLines = FilterResultHelper.filterLines((List)resultLines, (Integer)commandLineSource.getBeginAtLineNumber(), (Integer)commandLineSource.getEndAtLineNumber(), (String)commandLineSource.getExclude(), (String)commandLineSource.getKeep());
            List selectedColumnsLines = FilterResultHelper.selectedColumns((List)filteredLines, (String)commandLineSource.getSeparators(), (String)commandLineSource.getSelectColumns());
            return SourceTable.builder().rawData(selectedColumnsLines.stream().collect(Collectors.joining("\n"))).table(selectedColumnsLines.stream().map(line -> Stream.of(line.split(";")).collect(Collectors.toList())).collect(Collectors.toList())).build();
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)this.connectorId, (String)commandLineSource.getKey(), (String)String.format("OS command: %s.", commandLineSource.getCommandLine()), (String)hostname, (Throwable)e);
            return SourceTable.empty();
        }
    }

    @Generated
    public WinCommandLineSourceProcessor(@NonNull WinCommandService winCommandService, @NonNull Function<TelemetryManager, IWinConfiguration> configurationRetriever, @NonNull String connectorId) {
        if (winCommandService == null) {
            throw new IllegalArgumentException("winCommandService is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.winCommandService = winCommandService;
        this.configurationRetriever = configurationRetriever;
        this.connectorId = connectorId;
    }
}

