/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.exception.NoCredentialProvidedException;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.strategy.utils.EmbeddedFileHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.IWinRequestExecutor;

public class WinCommandService {
    @NonNull
    private IWinRequestExecutor winRequestExecutor;

    public Optional<String> getUsername(IWinConfiguration configuration) {
        if (configuration == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(configuration.getUsername());
    }

    public Optional<char[]> getPassword(IWinConfiguration configuration) {
        if (configuration == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(configuration.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsCommandResult runOsCommand(@NonNull String commandLine, @NonNull String hostname, IWinConfiguration configuration, @NonNull Map<Integer, EmbeddedFile> connectorEmbeddedFiles) throws IOException, ClientException, NoCredentialProvidedException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (connectorEmbeddedFiles == null) {
            throw new IllegalArgumentException("connectorEmbeddedFiles is marked non-null but is null");
        }
        Optional<String> maybeUsername = this.getUsername(configuration);
        if (maybeUsername.isEmpty() || maybeUsername.get().isBlank()) {
            throw new NoCredentialProvidedException();
        }
        Optional<char[]> maybePassword = this.getPassword(configuration);
        Map embeddedTempFiles = OsCommandHelper.createOsCommandEmbeddedFiles((String)commandLine, null, (Map)EmbeddedFileHelper.findEmbeddedFiles((String)commandLine, connectorEmbeddedFiles), (BiFunction)OsCommandHelper.TEMP_FILE_CREATOR);
        String updatedUserCommand = maybeUsername.map(username -> commandLine.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{USERNAME}"), (String)username)).orElse(commandLine);
        String updatedHostnameCommand = updatedUserCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{HOSTNAME}"), hostname);
        String updatedSudoCommand = OsCommandHelper.replaceSudo((String)updatedHostnameCommand, null);
        String updatedEmbeddedFilesCommand = embeddedTempFiles.entrySet().stream().reduce(updatedSudoCommand, (s, entry) -> s.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)((String)entry.getKey())), Matcher.quoteReplacement(((File)entry.getValue()).getAbsolutePath())), (s1, s2) -> null);
        String command = maybePassword.map(password -> updatedEmbeddedFilesCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{PASSWORD}"), String.valueOf(password))).orElse(updatedEmbeddedFilesCommand);
        String noPasswordCommand = maybePassword.map(password -> updatedEmbeddedFilesCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{PASSWORD}"), "********")).orElse(updatedEmbeddedFilesCommand);
        try {
            String commandResult = this.winRequestExecutor.executeWinRemoteCommand(hostname, configuration, command, embeddedTempFiles.values().stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            OsCommandResult osCommandResult = new OsCommandResult(commandResult, noPasswordCommand);
            return osCommandResult;
        }
        finally {
            embeddedTempFiles.values().forEach(File::delete);
        }
    }

    @Generated
    public WinCommandService(@NonNull IWinRequestExecutor winRequestExecutor) {
        if (winRequestExecutor == null) {
            throw new IllegalArgumentException("winRequestExecutor is marked non-null but is null");
        }
        this.winRequestExecutor = winRequestExecutor;
    }
}

