/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.validation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ParameterNameProvider;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.spi.ValidationProvider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.validation.ResponseConstraintViolationException;
import org.apache.cxf.validation.ValidationConfiguration;

public class BeanValidationProvider
implements AutoCloseable {
    private static final Logger LOG = LogUtils.getL7dLogger(BeanValidationProvider.class);
    private final Runnable close;
    private final Supplier<Validator> factory;
    private final RuntimeCache runtimeCache;

    public BeanValidationProvider() {
        try {
            ValidatorFactory vf = Validation.buildDefaultValidatorFactory();
            this.factory = () -> ((ValidatorFactory)vf).getValidator();
            this.close = () -> ((ValidatorFactory)vf).close();
            this.runtimeCache = new RuntimeCache();
        }
        catch (ValidationException ex) {
            LOG.severe("Bean Validation provider can not be found, no validation will be performed");
            throw ex;
        }
    }

    public BeanValidationProvider(ParameterNameProvider parameterNameProvider) {
        this(new ValidationConfiguration(parameterNameProvider));
    }

    public BeanValidationProvider(ValidationConfiguration cfg) {
        try {
            Configuration factoryCfg = Validation.byDefaultProvider().configure();
            BeanValidationProvider.initFactoryConfig(factoryCfg, cfg);
            ValidatorFactory vf = factoryCfg.buildValidatorFactory();
            this.factory = () -> ((ValidatorFactory)vf).getValidator();
            this.close = () -> ((ValidatorFactory)vf).close();
            this.runtimeCache = new RuntimeCache();
        }
        catch (ValidationException ex) {
            LOG.severe("Bean Validation provider can not be found, no validation will be performed");
            throw ex;
        }
    }

    public BeanValidationProvider(Validator validator) {
        if (validator == null) {
            throw new NullPointerException("Validator is null");
        }
        this.factory = () -> validator;
        this.close = () -> {};
        this.runtimeCache = new RuntimeCache();
    }

    public BeanValidationProvider(ValidatorFactory factory) {
        if (factory == null) {
            throw new NullPointerException("Factory is null");
        }
        this.factory = () -> ((ValidatorFactory)factory).getValidator();
        this.close = () -> {};
        this.runtimeCache = new RuntimeCache();
    }

    public BeanValidationProvider(ValidationProviderResolver resolver2) {
        this(resolver2, null);
    }

    public <T extends Configuration<T>, U extends ValidationProvider<T>> BeanValidationProvider(ValidationProviderResolver resolver2, Class<U> providerType) {
        this(resolver2, providerType, null);
    }

    public <T extends Configuration<T>, U extends ValidationProvider<T>> BeanValidationProvider(ValidationProviderResolver resolver2, Class<U> providerType, ValidationConfiguration cfg) {
        try {
            Configuration factoryCfg = providerType != null ? Validation.byProvider(providerType).providerResolver(resolver2).configure() : Validation.byDefaultProvider().providerResolver(resolver2).configure();
            BeanValidationProvider.initFactoryConfig(factoryCfg, cfg);
            ValidatorFactory vf = factoryCfg.buildValidatorFactory();
            this.factory = () -> ((ValidatorFactory)vf).getValidator();
            this.close = () -> {};
            this.runtimeCache = new RuntimeCache();
        }
        catch (ValidationException ex) {
            LOG.severe("Bean Validation provider can not be found, no validation will be performed");
            throw ex;
        }
    }

    private static void initFactoryConfig(Configuration<?> factoryCfg, ValidationConfiguration cfg) {
        if (cfg != null) {
            factoryCfg.parameterNameProvider(cfg.getParameterNameProvider());
            factoryCfg.messageInterpolator(cfg.getMessageInterpolator());
            factoryCfg.traversableResolver(cfg.getTraversableResolver());
            factoryCfg.constraintValidatorFactory(cfg.getConstraintValidatorFactory());
            for (Map.Entry<String, String> entry : cfg.getProperties().entrySet()) {
                factoryCfg.addProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public <T> void validateParameters(T instance, Method method, Object[] arguments) {
        Set violations;
        Validator validator = this.factory.get();
        ExecutableValidator methodValidator = validator.forExecutables();
        if ((this.runtimeCache == null || this.runtimeCache.shouldValidateParameters(validator, method)) && !(violations = methodValidator.validateParameters(instance, method, arguments, new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public <T> void validateReturnValue(T instance, Method method, Object returnValue) {
        Set violations;
        Validator validator = this.factory.get();
        ExecutableValidator methodValidator = validator.forExecutables();
        if ((this.runtimeCache == null || this.runtimeCache.shouldValidateReturnedValue(validator, method)) && !(violations = methodValidator.validateReturnValue(instance, method, returnValue, new Class[0])).isEmpty()) {
            throw new ResponseConstraintViolationException(violations);
        }
    }

    public <T> void validateReturnValue(T bean2) {
        Validator validator = this.factory.get();
        if (this.runtimeCache != null && bean2 != null && !this.runtimeCache.shouldValidateBean(validator, bean2.getClass())) {
            return;
        }
        Set<ConstraintViolation<T>> violations = this.doValidateBean(validator, bean2);
        if (!violations.isEmpty()) {
            throw new ResponseConstraintViolationException(violations);
        }
    }

    public <T> void validateBean(T bean2) {
        Set<ConstraintViolation<T>> violations = this.doValidateBean(this.factory.get(), bean2);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    private <T> Set<ConstraintViolation<T>> doValidateBean(Validator validator, T bean2) {
        if (validator.getConstraintsForClass(bean2.getClass()).isBeanConstrained()) {
            return validator.validate(bean2, new Class[0]);
        }
        return Collections.emptySet();
    }

    @Override
    public void close() {
        this.close.run();
    }

    private static class RuntimeCache {
        private final ConcurrentMap<Class<?>, Boolean> types = new ConcurrentHashMap();
        private final ConcurrentMap<Method, Boolean> params = new ConcurrentHashMap<Method, Boolean>();
        private final ConcurrentMap<Method, Boolean> returnedValues = new ConcurrentHashMap<Method, Boolean>();

        private RuntimeCache() {
        }

        public boolean shouldValidateParameters(Validator validator, Method method) {
            return this.params.computeIfAbsent(method, m -> {
                MethodDescriptor constraint = validator.getConstraintsForClass(m.getDeclaringClass()).getConstraintsForMethod(m.getName(), (Class[])m.getParameterTypes());
                return constraint != null && constraint.hasConstrainedParameters();
            });
        }

        public boolean shouldValidateReturnedValue(Validator validator, Method method) {
            return this.returnedValues.computeIfAbsent(method, m -> {
                MethodDescriptor constraint = validator.getConstraintsForClass(m.getDeclaringClass()).getConstraintsForMethod(m.getName(), (Class[])method.getParameterTypes());
                return constraint != null && constraint.hasConstrainedReturnValue();
            });
        }

        public boolean shouldValidateBean(Validator validator, Class<?> clazz) {
            return this.types.computeIfAbsent(clazz, it -> validator.getConstraintsForClass(it).isBeanConstrained());
        }
    }
}

