/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.ping;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.ping.PingConfiguration;
import org.sentrysoftware.metricshub.extension.ping.PingRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingExtension
implements IProtocolExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PingExtension.class);
    private PingRequestExecutor pingRequestExecutor = new PingRequestExecutor();
    public static final Double UP = 1.0;
    public static final Double DOWN = 0.0;
    public static final String PING_UP_METRIC = "metricshub.host.up{protocol=\"ping\"}";

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof PingConfiguration;
    }

    public Set<Class<? extends Source>> getSupportedSources() {
        return Set.of();
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> getConfigurationToSourceMapping() {
        return Map.of();
    }

    public Set<Class<? extends Criterion>> getSupportedCriteria() {
        return Set.of();
    }

    public void checkProtocol(TelemetryManager telemetryManager) {
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        Monitor hostMonitor = telemetryManager.getEndpointHostMonitor();
        boolean pingResult = false;
        PingConfiguration pingConfiguration = (PingConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(PingConfiguration.class);
        if (pingConfiguration == null) {
            return;
        }
        log.info("Hostname {} - Checking Ping protocol status. Sending a ping to '/'.", (Object)hostname);
        try {
            pingResult = this.pingRequestExecutor.ping(hostname, (int)pingConfiguration.getTimeout().longValue());
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking Ping protocol status. Exception when performing a Ping request: ", (Object)hostname, (Object)e);
        }
        new MetricFactory().collectNumberMetric(hostMonitor, PING_UP_METRIC, pingResult ? UP : DOWN, telemetryManager.getStrategyTime());
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        return SourceTable.empty();
    }

    public CriterionTestResult processCriterion(Criterion criterion, String connectorId, TelemetryManager telemetryManager) {
        return CriterionTestResult.empty();
    }

    public boolean isSupportedConfigurationType(String configurationType) {
        return "ping".equalsIgnoreCase(configurationType);
    }

    public IConfiguration buildConfiguration(String configurationType, JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        try {
            return (IConfiguration)PingExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, PingConfiguration.class);
        }
        catch (Exception e) {
            String errorMessage = String.format("Error while reading Ping Configuration: %s. Error: %s", jsonNode, e.getMessage());
            log.error(errorMessage);
            log.debug("Error while reading Ping Configuration: {}. Stack trace:", (Object)jsonNode, (Object)e);
            throw new InvalidConfigurationException(errorMessage, (Throwable)e);
        }
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }
}

