/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand.ipmi;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandConfiguration;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandService;
import org.sentrysoftware.metricshub.extension.oscommand.SshConfiguration;
import org.sentrysoftware.metricshub.extension.oscommand.ipmi.IpmiHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixIpmiSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnixIpmiSourceProcessor.class);

    public SourceTable processUnixIpmiSource(String sourceKey, String connectorId, TelemetryManager telemetryManager) {
        String sensorResult;
        String fruResult;
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        String ipmitoolCommand = telemetryManager.getHostProperties().getIpmitoolCommand();
        if (ipmitoolCommand == null || ipmitoolCommand.isEmpty()) {
            String message = String.format("Hostname %s - IPMI tool command cannot be found. Returning an empty result.", hostname);
            log.error(message);
            return SourceTable.empty();
        }
        boolean isLocalHost = telemetryManager.getHostProperties().isLocalhost();
        SshConfiguration sshConfiguration = (SshConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        OsCommandConfiguration osCommandConfiguration = (OsCommandConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(OsCommandConfiguration.class);
        long defaultTimeout = osCommandConfiguration != null ? osCommandConfiguration.getTimeout() : OsCommandConfiguration.DEFAULT_TIMEOUT;
        String fruCommand = ipmitoolCommand + "fru";
        try {
            if (isLocalHost) {
                fruResult = OsCommandService.runLocalCommand(fruCommand, defaultTimeout, null);
            } else if (sshConfiguration != null) {
                fruResult = OsCommandService.runSshCommand(fruCommand, hostname, sshConfiguration, defaultTimeout, null, null);
            } else {
                log.warn("Hostname {} - Could not process UNIX IPMI Source. SSH protocol credentials are missing.", (Object)hostname);
                return SourceTable.empty();
            }
            log.debug("Hostname {} - IPMI OS command: {}:\n{}", new Object[]{hostname, fruCommand, fruResult});
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)sourceKey, (String)String.format("IPMI OS command: %s.", fruCommand), (String)hostname, (Throwable)e);
            Thread.currentThread().interrupt();
            return SourceTable.empty();
        }
        String sdrCommand = ipmitoolCommand + "-v sdr elist all";
        try {
            sensorResult = isLocalHost ? OsCommandService.runLocalCommand(sdrCommand, defaultTimeout, null) : OsCommandService.runSshCommand(sdrCommand, hostname, sshConfiguration, defaultTimeout, null, null);
            log.debug("Hostname {} - IPMI OS command: {}:\n{}", new Object[]{hostname, sdrCommand, sensorResult});
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)sourceKey, (String)String.format("IPMI OS command: %s.", sdrCommand), (String)hostname, (Throwable)e);
            Thread.currentThread().interrupt();
            return SourceTable.empty();
        }
        return SourceTable.builder().table(IpmiHelper.ipmiTranslateFromIpmitool(fruResult, sensorResult)).build();
    }

    @Generated
    public UnixIpmiSourceProcessor() {
    }
}

