/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.exception.ClientRuntimeException;
import org.sentrysoftware.metricshub.engine.common.exception.ControlledSshException;
import org.sentrysoftware.metricshub.engine.common.exception.NoCredentialProvidedException;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.strategy.utils.EmbeddedFileHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.SudoInformation;
import org.sentrysoftware.metricshub.engine.telemetry.SshSemaphoreFactory;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandConfiguration;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandRequestExecutor;
import org.sentrysoftware.metricshub.extension.oscommand.SshConfiguration;
import org.springframework.util.Assert;

public class OsCommandService {
    private static final String NEGATIVE_TIMEOUT = "timeout mustn't be negative nor zero.";
    private static final String[] LOCAL_SHELL_COMMAND = OsCommandService.buildShellCommand();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WithSpan(value="OS Command")
    public static String runLocalCommand(@NonNull String command, @SpanAttribute(value="OSCommand.timeout") long timeout, @SpanAttribute(value="OSCommand.command") String noPasswordCommand) throws InterruptedException, IOException, TimeoutException {
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)NEGATIVE_TIMEOUT);
        ProcessBuilder builder = OsCommandService.createProcessBuilder(command);
        Process process = builder.start();
        if (process == null) {
            throw new IllegalStateException("Local command Process is null.");
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> future = executor.submit(() -> {
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());){
                String string;
                try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line;
                    StringJoiner stringJoiner = new StringJoiner("\n");
                    while ((line = bufferedReader.readLine()) != null) {
                        stringJoiner.add(line);
                    }
                    process.waitFor();
                    string = stringJoiner.toString();
                }
                return string;
            }
        });
        try {
            String string = future.get(timeout, TimeUnit.SECONDS);
            return string;
        }
        catch (TimeoutException exception) {
            future.cancel(true);
            throw new TimeoutException(String.format("Command \"%s\" execution has timed out after %d s", noPasswordCommand != null ? noPasswordCommand : command, timeout));
        }
        catch (ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            String string = null;
            return string;
        }
        finally {
            executor.shutdownNow();
        }
    }

    static ProcessBuilder createProcessBuilder(String command) {
        return new ProcessBuilder(new String[0]).command(LOCAL_SHELL_COMMAND[0], LOCAL_SHELL_COMMAND[1], command);
    }

    private static String[] buildShellCommand() {
        if (LocalOsHandler.isWindows()) {
            return new String[]{OsCommandService.getComSpecEnvVar(), "/C"};
        }
        return new String[]{OsCommandService.getShellEnvVar(), "-c"};
    }

    private static String getShellEnvVar() {
        String shell = System.getenv("SHELL");
        if (shell == null || shell.isBlank()) {
            String[] commonShells;
            for (String s : commonShells = new String[]{"/bin/bash", "/usr/bin/bash", "/bin/sh", "/usr/bin/sh", "/bin/zsh", "/usr/bin/zsh", "/bin/ksh", "/usr/bin/ksh"}) {
                if (!new File(s).exists()) continue;
                shell = s;
                break;
            }
            if (shell == null || shell.isBlank()) {
                shell = "/bin/sh";
            }
        }
        return shell;
    }

    private static String getComSpecEnvVar() {
        String comSpec = System.getenv("ComSpec");
        if (comSpec == null || comSpec.isBlank()) {
            comSpec = "cmd.exe";
        }
        return comSpec;
    }

    public static String runSshCommand(@NonNull String command, @NonNull String hostname, @NonNull SshConfiguration sshConfiguration, long timeout, List<File> localFiles, String noPasswordCommand) throws ClientException, InterruptedException, ControlledSshException {
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (sshConfiguration == null) {
            throw new IllegalArgumentException("sshConfiguration is marked non-null but is null");
        }
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)NEGATIVE_TIMEOUT);
        try {
            return OsCommandService.runControlledSshCommand(() -> {
                try {
                    return OsCommandRequestExecutor.runRemoteSshCommand(hostname, sshConfiguration.getUsername(), sshConfiguration.getPassword(), sshConfiguration.getPrivateKey() == null ? null : new File(sshConfiguration.getPrivateKey()), command, timeout, localFiles, noPasswordCommand);
                }
                catch (ClientException e) {
                    throw new ClientRuntimeException(e);
                }
            }, hostname, 120);
        }
        catch (ClientRuntimeException e) {
            throw (ClientException)e.getCause();
        }
    }

    static <T> T runControlledSshCommand(Supplier<T> executable, String hostname, int timeout) throws InterruptedException, ControlledSshException {
        Semaphore semaphore = SshSemaphoreFactory.getInstance().createOrGetSempahore(hostname);
        try {
            if (semaphore.tryAcquire(timeout, TimeUnit.SECONDS)) {
                T t = executable.get();
                return t;
            }
            String message = String.format("Failed to run SSH command on %s. Timed out trying to get ssh semaphore permit.", hostname);
            throw new ControlledSshException(message);
        }
        finally {
            semaphore.release();
        }
    }

    public static long getTimeout(Long commandTimeout, OsCommandConfiguration osCommandConfiguration, IConfiguration configuration, long defaultTimeout) {
        if (commandTimeout != null) {
            return commandTimeout.intValue();
        }
        if (osCommandConfiguration != null && osCommandConfiguration.getTimeout() != null) {
            return osCommandConfiguration.getTimeout().intValue();
        }
        if (configuration == null) {
            return defaultTimeout;
        }
        Long timeout = ((SshConfiguration)configuration).getTimeout();
        return timeout != null ? timeout : defaultTimeout;
    }

    public static Optional<String> getUsername(IConfiguration configuration) {
        if (configuration == null) {
            return Optional.empty();
        }
        if (configuration instanceof SshConfiguration) {
            SshConfiguration sshConfiguration = (SshConfiguration)configuration;
            return Optional.ofNullable(sshConfiguration.getUsername());
        }
        return Optional.empty();
    }

    public static Optional<char[]> getPassword(IConfiguration protocolConfiguration) {
        if (protocolConfiguration == null) {
            return Optional.empty();
        }
        if (protocolConfiguration instanceof SshConfiguration) {
            SshConfiguration sshConfiguration = (SshConfiguration)protocolConfiguration;
            return Optional.ofNullable(sshConfiguration.getPassword());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OsCommandResult runOsCommand(@NonNull String commandLine, @NonNull TelemetryManager telemetryManager, Long commandTimeout, boolean isExecuteLocally, boolean isLocalhost, @NonNull Map<Integer, EmbeddedFile> connectorEmbeddedFiles) throws IOException, ClientException, InterruptedException, TimeoutException, NoCredentialProvidedException, ControlledSshException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (connectorEmbeddedFiles == null) {
            throw new IllegalArgumentException("connectorEmbeddedFiles is marked non-null but is null");
        }
        IConfiguration configuration = (IConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        Optional<String> maybeUsername = OsCommandService.getUsername(configuration);
        if ((maybeUsername.isEmpty() || maybeUsername.get().isBlank()) && !isExecuteLocally && !isLocalhost) {
            throw new NoCredentialProvidedException();
        }
        Optional<char[]> maybePassword = OsCommandService.getPassword(configuration);
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        OsCommandConfiguration osCommandConfiguration = (OsCommandConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(OsCommandConfiguration.class);
        SudoInformation sudoInformation = null;
        if (osCommandConfiguration != null) {
            sudoInformation = new SudoInformation(osCommandConfiguration.isUseSudo(), osCommandConfiguration.getUseSudoCommands(), osCommandConfiguration.getSudoCommand());
        }
        Map embeddedTempFiles = OsCommandHelper.createOsCommandEmbeddedFiles((String)commandLine, sudoInformation, (Map)EmbeddedFileHelper.findEmbeddedFiles((String)commandLine, connectorEmbeddedFiles), (BiFunction)OsCommandHelper.TEMP_FILE_CREATOR);
        String updatedUserCommand = maybeUsername.map(username -> commandLine.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{USERNAME}"), (String)username)).orElse(commandLine);
        String updatedHostnameCommand = updatedUserCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{HOSTNAME}"), hostname);
        String updatedSudoCommand = OsCommandHelper.replaceSudo((String)updatedHostnameCommand, (SudoInformation)sudoInformation);
        String updatedEmbeddedFilesCommand = embeddedTempFiles.entrySet().stream().reduce(updatedSudoCommand, (s, entry) -> s.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)((String)entry.getKey())), Matcher.quoteReplacement(((File)entry.getValue()).getAbsolutePath())), (s1, s2) -> null);
        String command = maybePassword.map(password -> updatedEmbeddedFilesCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{PASSWORD}"), String.valueOf(password))).orElse(updatedEmbeddedFilesCommand);
        String noPasswordCommand = maybePassword.map(password -> updatedEmbeddedFilesCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)"%{PASSWORD}"), "********")).orElse(updatedEmbeddedFilesCommand);
        try {
            String localCommandResult;
            long timeout = OsCommandService.getTimeout(commandTimeout, osCommandConfiguration, configuration, telemetryManager.getHostConfiguration().getStrategyTimeout());
            String commandResult = isLocalhost || isExecuteLocally ? ((localCommandResult = OsCommandService.runLocalCommand(command, timeout, noPasswordCommand)) != null ? localCommandResult : "") : OsCommandService.runSshCommand(command, hostname, (SshConfiguration)configuration, timeout, new ArrayList<File>(embeddedTempFiles.values()), noPasswordCommand);
            OsCommandResult osCommandResult = new OsCommandResult(commandResult, noPasswordCommand);
            return osCommandResult;
        }
        finally {
            embeddedTempFiles.values().forEach(File::delete);
        }
    }

    @Generated
    private OsCommandService() {
    }

    static class TempFileCreationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        TempFileCreationException(IOException cause) {
            super(cause);
        }
    }
}

