/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.CommandLineCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.IpmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.oscommand.CommandLineCriterionProcessor;
import org.sentrysoftware.metricshub.extension.oscommand.CommandLineSourceProcessor;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandConfiguration;
import org.sentrysoftware.metricshub.extension.oscommand.OsCommandService;
import org.sentrysoftware.metricshub.extension.oscommand.SshConfiguration;
import org.sentrysoftware.metricshub.extension.oscommand.ipmi.UnixIpmiCriterionProcessor;
import org.sentrysoftware.metricshub.extension.oscommand.ipmi.UnixIpmiSourceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsCommandExtension
implements IProtocolExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsCommandExtension.class);
    private static final Set<String> SUPPORTED_CONFIGURATION_TYPES = Set.of("ssh", "oscommand");
    public static final Double UP = 1.0;
    public static final Double DOWN = 0.0;
    public static final String SSH_TEST_COMMAND = "echo test";

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof SshConfiguration || configuration instanceof OsCommandConfiguration;
    }

    public Set<Class<? extends Source>> getSupportedSources() {
        return Set.of(CommandLineSource.class, IpmiSource.class);
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> getConfigurationToSourceMapping() {
        return Map.ofEntries(Map.entry(SshConfiguration.class, Set.of(CommandLineSource.class)), Map.entry(OsCommandConfiguration.class, Set.of(CommandLineSource.class)));
    }

    public Set<Class<? extends Criterion>> getSupportedCriteria() {
        return Set.of(CommandLineCriterion.class, IpmiCriterion.class);
    }

    public Optional<Boolean> checkProtocol(TelemetryManager telemetryManager) {
        Double sshResult = UP;
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        SshConfiguration sshConfiguration = (SshConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        if (sshConfiguration == null || !telemetryManager.getHostProperties().isMustCheckSshStatus()) {
            return Optional.empty();
        }
        log.info("Hostname {} - Performing {} protocol health check.", (Object)hostname, (Object)this.getIdentifier());
        log.info("Hostname {} - Checking SSH protocol status. Sending an SSH 'echo test' command.", (Object)hostname);
        if (telemetryManager.getHostProperties().isOsCommandExecutesLocally()) {
            sshResult = this.localSshTest(hostname);
        }
        if (telemetryManager.getHostProperties().isOsCommandExecutesRemotely()) {
            sshResult = this.remoteSshTest(hostname, sshResult, sshConfiguration);
        }
        return Optional.of(sshResult == UP);
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        if (source instanceof CommandLineSource) {
            CommandLineSource commandLineSource = (CommandLineSource)source;
            return new CommandLineSourceProcessor().process(commandLineSource, connectorId, telemetryManager);
        }
        if (source instanceof IpmiSource) {
            return new UnixIpmiSourceProcessor().processUnixIpmiSource(connectorId, connectorId, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process source %s.", telemetryManager.getHostname(), source != null ? source.getClass().getSimpleName() : "<null>"));
    }

    public CriterionTestResult processCriterion(Criterion criterion, String connectorId, TelemetryManager telemetryManager) {
        if (criterion instanceof CommandLineCriterion) {
            CommandLineCriterion commandLineCriterion = (CommandLineCriterion)criterion;
            return new CommandLineCriterionProcessor(connectorId).process(commandLineCriterion, telemetryManager);
        }
        if (criterion instanceof IpmiCriterion) {
            DeviceKind hostType = telemetryManager.getHostConfiguration().getHostType();
            return new UnixIpmiCriterionProcessor().processUnixIpmiDetection(hostType, telemetryManager);
        }
        throw new IllegalArgumentException(String.format("Hostname %s - Cannot process criterion %s.", telemetryManager.getHostname(), criterion != null ? criterion.getClass().getSimpleName() : "<null>"));
    }

    public boolean isSupportedConfigurationType(String configurationType) {
        return SUPPORTED_CONFIGURATION_TYPES.contains(configurationType.toLowerCase());
    }

    public IConfiguration buildConfiguration(String configurationType, JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        if (configurationType.equalsIgnoreCase("ssh")) {
            try {
                char[] password;
                SshConfiguration sshConfiguration = (SshConfiguration)OsCommandExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, SshConfiguration.class);
                if (decrypt != null && (password = sshConfiguration.getPassword()) != null) {
                    sshConfiguration.setPassword((char[])decrypt.apply(password));
                }
                return sshConfiguration;
            }
            catch (Exception e) {
                String errorMessage = String.format("Error while reading SSH Configuration: %s. Error: %s", jsonNode, e.getMessage());
                log.error(errorMessage);
                log.debug("Error while reading SSH Configuration: {}. Stack trace:", (Object)jsonNode, (Object)e);
                throw new InvalidConfigurationException(errorMessage, (Throwable)e);
            }
        }
        if (configurationType.equalsIgnoreCase("oscommand")) {
            try {
                return (IConfiguration)OsCommandExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, OsCommandConfiguration.class);
            }
            catch (Exception e) {
                String errorMessage = String.format("Error while reading OsCommand Configuration: %s. Error: %s", jsonNode, e.getMessage());
                log.error(errorMessage);
                log.debug("Error while reading OsCommand Configuration: {}. Stack trace:", (Object)jsonNode, (Object)e);
                throw new InvalidConfigurationException(errorMessage, (Throwable)e);
            }
        }
        String errorMessage = String.format("Unhandled %s configuration in the OsCommandExtension.", configurationType);
        log.error(errorMessage);
        log.debug(errorMessage);
        throw new InvalidConfigurationException(errorMessage);
    }

    private Double localSshTest(String hostname) {
        try {
            if (OsCommandService.runLocalCommand(SSH_TEST_COMMAND, OsCommandConfiguration.DEFAULT_TIMEOUT, null) == null) {
                log.debug("Hostname {} - Checking SSH protocol status. Local OS command has not returned any results.", (Object)hostname);
                return DOWN;
            }
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking SSH protocol status. SSH exception when performing a local OS command test: ", (Object)hostname, (Object)e);
            return DOWN;
        }
        return UP;
    }

    private Double remoteSshTest(String hostname, Double previousSshStatus, SshConfiguration sshConfiguration) {
        try {
            if (OsCommandService.runSshCommand(SSH_TEST_COMMAND, hostname, sshConfiguration, OsCommandConfiguration.DEFAULT_TIMEOUT, null, null) == null) {
                log.debug("Hostname {} - Checking SSH protocol status. Remote SSH command has not returned any results.", (Object)hostname);
                return DOWN;
            }
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking SSH protocol status. SSH exception when performing a remote SSH command test: ", (Object)hostname, (Object)e);
            return DOWN;
        }
        return previousSshStatus;
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }

    public String getIdentifier() {
        return "ssh";
    }
}

