/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.oscommand;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class OsCommandConfiguration
implements IConfiguration {
    public static final Long DEFAULT_TIMEOUT = 30L;
    boolean useSudo;
    @JsonSetter(nulls=Nulls.SKIP)
    Set<String> useSudoCommands = new HashSet<String>();
    @JsonSetter(nulls=Nulls.SKIP)
    String sudoCommand = "sudo";
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    Long timeout = DEFAULT_TIMEOUT;

    public OsCommandConfiguration(boolean useSudo, Set<String> useSudoCommands, String sudoCommand, Long timeout) {
        this.useSudo = useSudo;
        this.useSudoCommands = useSudoCommands == null ? new HashSet() : useSudoCommands;
        this.sudoCommand = sudoCommand == null ? "sudo" : sudoCommand;
        this.timeout = timeout == null ? DEFAULT_TIMEOUT : timeout;
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, "OSCommand", this.timeout));
    }

    public String toString() {
        return "Local Commands";
    }

    @Generated
    public static OsCommandConfigurationBuilder builder() {
        return new OsCommandConfigurationBuilder();
    }

    @Generated
    public boolean isUseSudo() {
        return this.useSudo;
    }

    @Generated
    public Set<String> getUseSudoCommands() {
        return this.useSudoCommands;
    }

    @Generated
    public String getSudoCommand() {
        return this.sudoCommand;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setUseSudo(boolean useSudo) {
        this.useSudo = useSudo;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setUseSudoCommands(Set<String> useSudoCommands) {
        this.useSudoCommands = useSudoCommands;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setSudoCommand(String sudoCommand) {
        this.sudoCommand = sudoCommand;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OsCommandConfiguration)) {
            return false;
        }
        OsCommandConfiguration other = (OsCommandConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSudo() != other.isUseSudo()) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Set<String> this$useSudoCommands = this.getUseSudoCommands();
        Set<String> other$useSudoCommands = other.getUseSudoCommands();
        if (this$useSudoCommands == null ? other$useSudoCommands != null : !((Object)this$useSudoCommands).equals(other$useSudoCommands)) {
            return false;
        }
        String this$sudoCommand = this.getSudoCommand();
        String other$sudoCommand = other.getSudoCommand();
        return !(this$sudoCommand == null ? other$sudoCommand != null : !this$sudoCommand.equals(other$sudoCommand));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OsCommandConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSudo() ? 79 : 97);
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Set<String> $useSudoCommands = this.getUseSudoCommands();
        result = result * 59 + ($useSudoCommands == null ? 43 : ((Object)$useSudoCommands).hashCode());
        String $sudoCommand = this.getSudoCommand();
        result = result * 59 + ($sudoCommand == null ? 43 : $sudoCommand.hashCode());
        return result;
    }

    @Generated
    public OsCommandConfiguration() {
    }

    @Generated
    public static class OsCommandConfigurationBuilder {
        @Generated
        private boolean useSudo;
        @Generated
        private Set<String> useSudoCommands;
        @Generated
        private String sudoCommand;
        @Generated
        private Long timeout;

        @Generated
        OsCommandConfigurationBuilder() {
        }

        @Generated
        public OsCommandConfigurationBuilder useSudo(boolean useSudo) {
            this.useSudo = useSudo;
            return this;
        }

        @Generated
        public OsCommandConfigurationBuilder useSudoCommands(Set<String> useSudoCommands) {
            this.useSudoCommands = useSudoCommands;
            return this;
        }

        @Generated
        public OsCommandConfigurationBuilder sudoCommand(String sudoCommand) {
            this.sudoCommand = sudoCommand;
            return this;
        }

        @Generated
        public OsCommandConfigurationBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public OsCommandConfiguration build() {
            return new OsCommandConfiguration(this.useSudo, this.useSudoCommands, this.sudoCommand, this.timeout);
        }

        @Generated
        public String toString() {
            return "OsCommandConfiguration.OsCommandConfigurationBuilder(useSudo=" + this.useSudo + ", useSudoCommands=" + String.valueOf(this.useSudoCommands) + ", sudoCommand=" + this.sudoCommand + ", timeout=" + this.timeout + ")";
        }
    }
}

